---
title: 数据导入/导出的通用方法
date: '2008-08-22'
slug: data-import-and-export-approach
---

总有人对数据的导入/导出产生疑问，比如SPSS怎样导进LISREL，或是SAS怎样导进Stata，或是Excel怎样导进R，等等。其实一般情况下这种问题并不是什么大问题，我们总是被软件蒙蔽，猜不透数据文件背后究竟是什么，或者根本没有想过文件里面究竟是什么。我对计算机文件的机制了解并不多，我只知道两种基本的格式：ASCII格式（或纯文本格式）以及二进制格式。后者是经过某种规则编码了的，所以用纯文本编辑器打开一般看不到内容，而前者就简单多了，用任何纯文本编辑器（如记事本）都可以打开看。

纯文本格式是几乎任何软件都支持读写的，因此它可以成为软件之间互相“沟通”的桥梁。比如Excel可以另存为CSV文件，然后由R用`read.csv()`读进来或者由SPSS的Read Text Data导进去，等等。所以一般情况下通过纯文本文件行事就足够了。

统计数据的形式一般都是二维表格，行为观测，列为变量；纯文本数据中当然要想办法将行列用一定的标志区分开来。对于行，当然就是换行符（例如回车），这没什么好说的，用编辑器打开看到就是一行一行的；对于列，则稍有不同，这就涉及到分隔符（separator / delimiter）的问题了，它们的作用就像是Excel或者其它表格软件中的网格线一样，将一列一列分隔开来，每一列对应一个变量，分隔符可以是任何字符，但常见的一般是逗号（`,`）或者制表符（`\t`，Tab）。所谓CSV文件，也就是以逗号为分隔符的纯文本文件，我们可以将Excel数据存为CSV格式，然后用记事本打开看看就明白了。Windows下CSV文件（`*.csv`）的图标一般是Excel的图标，其实这是很具有误导性的，CSV与Excel毫无关系，只是纯文本文件的一种而已。

这是关于数据的很基础的知识，但我发现很多人并不明白。怪哉。

纯文本文件之外的统计数据我通常推荐采用专门的数据库作为存储工具（尤其是支持SQL的数据库），而不是Excel或SPSS等软件，用数据库捣腾数据一方面比那些看起来易用的Excel或SPSS更高效，另一方面也比较安全。前面我[刚刚谈过这个问题](/cn/2008/08/missing-value-and-zero-in-excel/)。

从今以后，关于数据导入/导出的邮件我也将不再回复。
