---
title: 从二维数据到三维数据：光滑方法的预测
date: '2007-11-14'
slug: use-smoothing-from-2d-to-3d
---

通常统计所见到的数据都是二维的。注意这里“维”的意思，并不是指有几个变量就叫几维，而是指数据的存放格式。统计数据一般都是行列存放，行为观测，列为变量，这样组织一个二维表格。这种数据并不是可以包打天下的，尤其是到了空间研究的层面，这种数据就很不好办了。

比如，现有一个因变量z，两个自变量分别是经度long、纬度lat，我们想研究z在空间上的分布，而数据格式一般是这样：

    z long lat
    1 2.24 3.1
    2 4.27 6.4
    4 8.24 7.4
    ...

这样的数据能表现的只是一个个离散的点，而且若画到图上去，也只能画散点图，没办法将它连续化。我们最终的目的是找到这样的函数关系：`z = f(long, lat)`，这样的话我们需要的自变量是**网格形**的（Grid），而不是单列的。拿上面三行数据来说，我们得想办法知道 (long = 2.24, lat = 6.4) (long = 2.24, lat = 7.4)等等点对应的z值，这样在一个立体空间中我们才能把z的曲面完整的画出来；类似的，这样也才能把等高线图等图形顺利做出来。

那么如何知道“缝隙”中的点呢？答案之一就是光滑（Smoothing）：无论是样条（Spline）还是局部回归（Local Regression）或是其它办法。用光滑的方法去预测样本数据中本不存在的自变量集合对应的因变量值，这样整个三维空间中的所有点就都能知道了，进而等高线或三维透视图等图形也就可以做出来了。

这种思想用R非常容易实现，区区几行代码。要做的事情首先当然是建立一个光滑模型，比如LOESS（局部多项式回归）：`m = loess(z ~ long + lat, ...)`，然后结合long和lat的网格对m作预测，这个网格可以用`grd = expand.grid(long, lat)`生成，然后`predict(m, grd)`就得到一系列z预测值了。然后万事大吉。

```r
> expand.grid(long = c(2.24, 4.27, 8.24), lat = c(3.1, 6.4, 7.4))
  long lat
1 2.24 3.1
2 4.27 3.1
3 8.24 3.1
4 2.24 6.4
5 4.27 6.4
6 8.24 6.4
7 2.24 7.4
8 4.27 7.4
9 8.24 7.4
```

