---
title: 事件研究方法的基本原理
date: '2006-03-08T12:41:00+08:00'
slug: 12-41-00
---

上午认识了金融实验班的谢磊同学（本家啊），聊天过程中提到一个词：Event Study，我心里琢磨着这是什么研究呢，于是Google一下，发现原来又是一个“冒牌货”，我认为，这种研究实质上和Chow断点检验（Breakpoint Test）很相似，就是看一段时期前后某一项指标是否有显著变化；而且Chow Breakpoint Test比Event Study的外延更广。在统计检验方法上，Event Study只是粗略地使用了正态统计量，Chow Breakpoint Test则使用了F统计量。记得有一次开会我就拿“保先”的事情说过应该做Chow断点检验，看看“保先”前后社会经济政治文化是否有显著变化，今天看来，准确地说，应该是做Event Study。

经济学家们经常要研究一件具体的事情对企业价值的影响，事件研究（**Event Study**）就是分析事件对公司股价影响的一种办法。在理性的金融市场上，一个事件的影响会迅速反映到股票价格中，事件的影响可以通过股票价格在短期内的变化来衡量。

最先采用事件研究方法的是Dolly。1933年，他以美国股票市场1921年~1931年间的95个股票拆分事件作为样本，对股票拆分事件发生引起的股票价格的变化进行了研究。他发现，在95起拆分事件中，有57起引起了股票价格上升，26起引起了股价下降，另外12起没有引起明显反应。

事件研究方法通常包括以下步骤：

1. 对事件的定义。事件研究的首要任务是确定所研究的事件，并且确定要研究的该事件引起的股票价格变化的时间区段。例如，如果要研究宏观政策事件对于股票价格变化的影响，首先应该选取符合要求的宏观经济政策事件，例如重要法律的颁布，然后确定在信息颁布前后的多长时间中研究股票价格的变化。

2. 取样标准。界定事件后，有必要确定取样标准。取样标准可能会受比如股票交易所上市公司数据可获性（data availability）的限制，也可能受特殊行业的会员之类的限制。在此阶段，归纳出一些样本特征（如：公司市场资本化、行业代表、事件发布的时间分布等）并注明通过选样可能导致的任何倾向性是十分有用的。

3. 建立正常收益和非正常收益计算模型。评估事件的影响需要计算非正常收益（abnormal return）。非正常收益即事件期间内该证券事前或事后实际收益与同期正常收益之差，而正常收益是指假设不发生该事件条件下的预期收益。对于公司i、事件发生日t来说，非正常收益为：

    `$$AR_{it} = R_{it} - E( R_{it} | X_{t})$$`

    其中，`$AR_{it}$`、`$R_{it}$`和`$E( R_{it} | X_{t})$`分别为t期的非正常收益、实际收益、正常收益。`$X_{t}$`是正常收益模型的限定内容。正常收益模型通常有两种：固定平均收益模型（the constant mean return model），其中`$X_{t}$`为常数；市场模型（the market model），其中`$X_{t}$`为市场收益。顾名思义，前一模型中假定某一证券的平均收益不变，即为常数，后一模型假定市场收益与证券收益之间存在稳定的线性关系。

4. 确定正常收益模型后，则需要进行估计。在界定估计期时，最常见的是把事件期间之前的时期作为估计期，比如，在运用每日数据及市场模型的事件研究中，市场模型的参数估计期可定为事件发生前的n天（n的大小由研究者根据情况自行选择，一般n≥30）。通常，事件期间本身不包含在估计期中，以免事件影响正常收益模型参数的估计。正常收益模型的参数估定后，便可计算出非正常收益。

5. 检验过程。接下来，需要设计非正常收益的检验框架。此处需要着重考虑的是零假设（the null hypothesis），并且确定综合计算非正常收益的方法。

6. 实证结果。实证的结果跟所采用的计量经济学方法有直接的关系。除了描述出最基本的实证结果以外，诊断性的说明也极为有用。有时，特别是当研究的事件个数非常有限时，一两个事件可能会对整个实证结果产生严重影响。注意到这一点，对于评价实证结果是至关重要的。

7. 解释和结论。比较理想状况的是，实证结果能够导引出有关事件对股票价格产生影响的原因。另外，也可以加上其他的一些说明，将自己的分析与别人做的类似分析进行比较。
