---
title: S-Plus常用函数参考（示例）
date: '2006-02-22T23:37:00+08:00'
slug: 23-37-00
---

以前编S-Plus程序就会经常因为狂用函数而挨骂，其实在S-Plus中不多多使用内置函数真是枉费了AT&T贝尔实验室和MathSoft公司的一片苦心，也忽略了S-Plus语言的核心对象：向量和矩阵。每念及此，夜不能寐，就算挣扎着入睡，也会梦见AT&T和MathSoft哽咽着对我说……


## 基本


一、数据管理


vector：向量　 numeric：数值型向量　 logical：逻辑型向量　 character：字符型向量　 list：列表　 data.frame：数据框　 c：连接为向量或列表　 length：求长度　 subset：求子集　 seq，sequence：等差序列　 rep：重复　 NA：缺失值　 NULL：空对象　 sort，order，unique，rev：排序　 unlist：展平列表　 attr，attributes：对象属性　 mode，typeof：对象存储模式与类型　 names：对象的名字属性


```r
> vector("numeric",10)
 [1] 0 0 0 0 0 0 0 0 0 0
> logical(13)
 [1] F F F F F F F F F F F F F
> seq(10,1)
 [1] 10  9  8  7  6  5  4  3  2  1
> unique(rep(1,10))
[1] 1
> rev(seq(10,1))
 [1]  1  2  3  4  5  6  7  8  9 10
> unlist(list(1:6,"Xie Yihui"))
[1] "1"       "2"       "3"       "4"       "5"       "6"       "Xie Yihui"
```

二、字符串处理


character：字符型向量　 nchar：字符数　 substr：取子串　 format，formatC：把对象用格式转换为字符串　 paste，unpaste：连接或拆分　 charmatch，pmatch：字符串匹配　 grep，sub，gsub：模式匹配与替换


```r
> paste("NO.",1:10)
 [1] "NO. 1"  "NO. 2"  "NO. 3"  "NO. 4"  "NO. 5"  "NO. 6"  "NO. 7"  "NO. 8"
 [9] "NO. 9"  "NO. 10"
> unpaste("Xie|Yihui",sep="|")
[[1]]:
[1] "Xie"

[[2]]:
[1] "Yihui"
```
三、复数


complex，Re，Im，Mod，Arg，Conj：复数函数


四、因子


factor：因子　 codes：因子的编码　 levels：因子的各水平的名字　 nlevels：因子的水平个数　 cut：把数值型对象分区间转换为因子　 table：交叉频数表　 split：按因子分组　 aggregate：计算各数据子集的概括统计量　 tapply：对“不规则”数组应用函数


```r
> factor(c(1,0),labels=c("Male","Female"))
[1] Female Male
> table(rep(1:2,4),c(1:4,rep(8,4)))
  1 2 3 4 8 
1 1 0 1 0 2
2 0 1 0 1 2
```

## 数学


一、计算


+, -, *, /, ^, **%%**, **%/%**：四则运算　 ceiling，floor，round，signif，trunc，zapsmall：舍入　 max，min，pmax，pmin：最大最小值　 range：最大值和最小值　 sum，prod：向量元素和，积　 cumsum，cumprod，cummax，cummin：累加、累乘　 sort：排序　 approx和approxfun：插值　 diff：差分　 sign：符号函数


```
> ceiling(5.21)
[1] 6
> cumprod(1:4)
[1]  1  2  6 24
> 911%%711
[1] 200
```
二、数学函数


abs，sqrt：绝对值，平方根　 log, exp, log10, logb：对数与指数函数　 sin，cos，tan，asin，acos，atan，atan2：三角函数　 sinh，cosh，tanh，asinh，acosh，atanh：双曲函数　 beta，lbeta，gamma，lgamma，digamma，trigamma，tetragamma，pentagamma，choose，lchoose：与贝塔函数、伽玛函数、组合数有关的特殊函数　 fft，mvfft，convolve：富利叶变换及卷积　 polyroot：多项式求根　 poly：正交多项式　 spline，splinefun：样条差值　 besselI，besselK，besselJ，besselY，gammaCody：Bessel函数　 deriv：简单表达式的符号微分或算法微分


```r
> logb(9,base=3)
[1] 2
> deriv(~x^2,"x")
expression({
 .value <- x^2
 .grad <- array(0, c(length(.value), 1), list(NULL, "x"))
 .grad[, "x"] <- 2 * x
 attr(.value, "gradient") <- .grad
 .value
}
) 
> choose(9,7)
[1] 36
```

三、数组


array：建立数组　 matrix：生成矩阵　 data.matrix：把数据框转换为数值型矩阵　 lower.tri：矩阵的下三角部分　 mat.or.vec：生成矩阵或向量　 t：矩阵转置　 cbind：把列合并为矩阵　 rbind：把行合并为矩阵　 diag：矩阵对角元素向量或生成对角矩阵　 aperm：数组转置　 nrow,ncol：计算数组的行数和列数　 dim：对象的维向量　 dimnames：对象的维名　 row/colnames：行名或列名　 %*%：矩阵乘法　 crossprod：矩阵交叉乘积（内积）　 outer：数组外积　 kronecker：数组的Kronecker积　 apply：对数组的某些维应用函数　 tapply：对“不规则”数组应用函数　 sweep：计算数组的概括统计量　 aggregate：计算数据子集的概括统计量　 scale：矩阵标准化　 matplot：对矩阵各列绘图　 cor：相关阵或协差阵　 row：矩阵的行下标集　 col：求列下标集


```r
> diag(matrix(1:16,4,4,byrow=T))
[1]  1  6 11 16
> a<-matrix(1:4,2)
> a
     [,1] [,2] 
[1,]    1    3
[2,]    2    4
> t(a)
     [,1] [,2] 
[1,]    1    2
[2,]    3    4
> crossprod(a,t(a))
     [,1] [,2] 
[1,]    7   10
[2,]   15   22
> apply(a,2,mean)
[1] 1.5 3.5
```

四、线性代数


solve：解线性方程组或求逆　 eigen：矩阵的特征值分解　 svd：矩阵的奇异值分解　 backsolve：解上三角或下三角方程组　 chol：Choleski分解　 qr：矩阵的QR分解　 chol2inv：由Choleski分解求逆


```r
> eigen(matrix(1:16,4))
$values:
[1]  3.620937e+001 -2.209373e+000 -1.031241e-016  0.000000e+000

$vectors:
           [,1]        [,2]       [,3]     [,4] 
[1,] -0.5642946  0.78566010 -0.5460082 -4.60465
[2,] -0.6390124  0.40284883  0.7280110  5.80620
[3,] -0.7137302  0.02003756  0.1820027  2.20155
[4,] -0.7884480 -0.36277371 -0.3640055 -3.40310
```

五、逻辑运算


<，>，<=，>=，==，!=：比较运算符　 !，&amp;，&amp;&amp;，|，||，xor()：逻辑运算符　 logical：生成逻辑向量　 all，any：逻辑向量都为真或存在真　 ifelse()：二者择一　 match，%in%：查找　 unique：找出互不相同的元素　 which：找到真值下标集合　 duplicated：找到重复元素


六、优化及求根


optimize，uniroot，polyroot：一维优化与求根


```r
> f<-function(x) x^2-3*x+2
> uniroot(f,0.001,1.5,2.5)
$root:
[1] 1.999972

$f.root:
[1] -0.00002849252

$nf:
[1] 8

$neg:
[1] 1.999972

$f.neg:
[1] -0.00002849252

$pos:
[1] 2.000033

$f.pos:
[1] 0.00003254289

$message:
[1] "normal termination"

$aux:
list()

$call:
uniroot(f = f, interval = 0.001, lower = 1.5, upper = 2.5)
```

## 程序设计


一、控制结构


if，else，ifelse，switch：分支　 for，while，repeat，break，next：循环　 apply，lapply，sapply，tapply，sweep：替代循环的函数。


```r
> if(1 == 2) {
           print("1 is equal to 2!")
} else {
           print("1 is not equal to 2!")
}
[1] "1 is not equal to 2!"
```

二、函数


function：函数定义　 source：调用文件　 call：函数调用　 .C，.Fortran：调用C或者Fortran子程序的动态链接库。　 Recall：递归调用　 browser，debug，trace，traceback：程序调试　 options：指定系统参数　 missing：判断虚参是否有对应实参　 nargs：参数个数　 stop：终止函数执行　 on.exit：指定退出时执行　 eval，expression：表达式计算　 system.time：表达式计算计时　 invisible：使变量不显示　 menu：选择菜单（字符列表菜单）　 其它与函数有关的还有：delay，delete.response，deparse，do.call，dput，environment，formals，format.info，interactive，is.finite，is.function，is.language，is.recursive，match.arg，match.call，match.fun，model.extract，name，parse，substitute，sys.parent，warning，machine。


三、输入输出


cat，print：显示对象　 sink：输出转向到指定文件　 dump，save，dput，write：输出对象　 scan，read.table，load，dget：读入


四、工作环境


ls，objects：显示对象列表　 rm,remove：删除对象　 q，quit：退出系统　 .First，.Last：初始运行函数与退出运行函数　 options：系统选项　 **?**，help，help.start，apropos：帮助功能　 data：列出数据集


## 统计计算


一、统计分布


每一种分布有四个函数：d―density（密度函数），p―分布函数，q―分位数函数，r―随机数函数。比如，正态分布的这四个函数为dnorm，pnorm，qnorm，rnorm。下面我们列出各分布后缀，前面加前缀d、p、q或r就构成函数名：


norm：正态，t：t分布，f：F分布，chisq：卡方（包括非中心）　 unif：均匀，exp：指数，weibull：威布尔，gamma：伽玛，beta：贝塔　 lnorm：对数正态，logis：逻辑分布，cauchy：柯西，　 binom：二项分布，geom：几何分布，hyper：超几何，nbinom：负二项，pois：泊松　 signrank：符号秩，wilcox：秩和，tukey：学生化极差


```r
> rnorm(10)
 [1] -0.3648305  0.4973082  1.8412667 -0.2787127  0.0257934  0.6441702
 [7]  0.5582823 -0.7876886  0.8104928  1.2928385
> pchisq(3.940,10)
[1] 0.04998691
```

二、简单统计量


sum, mean, var, sd, min, max, range, median, IQR（四分位间距）等为统计量，sort，order，rank与排序有关，其它还有ave，fivenum，mad，quantile，stem等。（注：我在S-Plus 6.2中似乎没找到fivenum函数，但是R中有，大家可以试试看）


三、统计检验


R中已实现的有chisq.test，prop.test，t.test。


```r
> t.test(1:10,mu=2)

 One-sample t-Test

data:  1:10 
t = 3.6556, df = 9, p-value = 0.0053 
alternative hypothesis:  mean is not equal to 2 
95 percent confidence interval:
 3.334149 7.665851 
sample estimates:
 mean of x 
       5.5
```

四、多元分析


cor，cov.wt，var：协方差阵及相关阵计算　 biplot，biplot.princomp：多元数据biplot图　 cancor：典则相关　 princomp：主成分分析　 hclust：谱系聚类　 kmeans：k-均值聚类　 cmdscale：经典多维标度　 其它有dist，mahalanobis，cov.rob


```r
> cancor(matrix(1:80,10),matrix(70:21,10))
$cor:
[1] 1

$xcoef:
          [,1] 
[1,] 0.1100964

$ycoef:
           [,1] 
[1,] -0.1100964

$xcenter:
[1]  5.5 15.5 25.5 35.5 45.5 55.5 65.5 75.5

$ycenter:
[1] 65.5 55.5 45.5 35.5 25.5
```

五、时间序列


ts：时间序列对象　 diff：计算差分　 time：时间序列的采样时间　 window：时间窗


六、统计模型


lm，glm，aov：线性模型、广义线性模型、方差分析


```r
> x<-rnorm(100)
> y<-rchisq(100,9)
> lm(y~x)
Call:
lm(formula = y ~ x)

Coefficients:
 (Intercept)          x 
    8.180136 0.07897231

Degrees of freedom: 100 total; 98 residual
Residual standard error: 3.540729
```

抱歉，肚子饿了，得回去睡觉了。今天先写到这里。还有，本文函数大多来自于[北京大学李东风老师](http://www.math.pku.edu.cn/teachers/lidf/)的教程，在此向原作者的辛苦工作表示致谢。其中有一部分函数我作了小的删改，同时声明一下我所用的版本是S-Plus 6.2。
