---
title: 格兰杰因果检验简要介绍
date: '2005-12-16T18:35:00+08:00'
slug: 18-35-00
---

格兰杰（Granger）因果性检验目前在计量经济学中应用比较多，不过我们当初学习计量并没有学这个检验方法，经济学专业的学生应该会学到吧。上次谭英平师姐给我们讲宏观经济统计分析课时曾经给我们介绍过，不过也只是很肤浅地说了说原理（这种教学有一定的危险性啊）。


要探讨因果关系，首先当然要定义什么是因果关系。这里不再谈伽利略抑或休谟等人在哲学意义上所说的因果关系，只从统计意义上介绍其定义。从统计的角度，因果关系是通过**概率**或者**分布函数**的角度体现出来的：在宇宙中所有其它事件的发生情况固定不变的条件下，如果一个事件A的发生与不发生对于另一个事件B的发生的概率（如果通过事件定义了随机变量那么也可以说分布函数）有影响，并且这两个事件在时间上又先后顺序（A前B后），那么我们便可以说A是B的原因。


早期因果性是简单通过概率来定义的，即如果`$P(B|A)>P(B)$`那么A就是B的原因（Suppes，1970）；然而这种定义有两大缺陷：一、没有考虑时间先后顺序；二、从`$P(B|A)>P(B)$`由条件概率公式马上可以推出`$P(A|B)>P(A)$`，显然上面的定义就自相矛盾了（并且定义中的“>”毫无道理，换成“<”照样讲得通，后来通过改进，把定义中的“>”改为了不等号“≠”，其实按照同样的推理，这样定义一样站不住脚）。


事实上，以上定义还有更大的缺陷，就是**信息集**的问题。严格讲来，要真正确定因果关系，必须考虑到完整的信息集，也就是说，要得出“A是B的原因”这样的结论，必须全面考虑**宇宙中所有的事件**，否则往往就会发生误解。最明显的例子就是若另有一个事件C，它是A和B的共同原因，考虑一个极端情况：若`$P(A|C)=1$`，`$P(B|C)=1$`，那么显然有`$P(B|AC)=P(B|C)$`，此时可以看出A事件是否发生与B事件已经没有关系了。


因此，Granger（1980）提出了因果关系的定义，他的定义是建立在**完整信息集**以及**发生时间先后顺序**基础上的。至于判断准则，也在逐步发展变化：


最初是根据**分布函数**（条件分布）判断，注意`$\Omega_{n}$`是到n期为止宇宙中的所有信息，`$Y_{n}$`为到n期为止所有的`$Y_{t}\,(t=1 \cdots n)$`，`$X_{n+1}$`为第n+1期X的取值，`$\Omega_{n}-Y_{n}$`为除Y之外的所有信息。


`$$F(X_{n+1} | \Omega_{n}) \neq F(X_{n+1} | (\Omega_{n} - Y_{n}))$$`


后来认为宇宙信息集是不可能找到的，于是退而求其次，找一个可获取的信息集**J**来替代**Ω**：


`$$F(X_{n+1} | J_{n}) \neq F(X_{n+1} | (J_{n} - Y_{n}))$$`


再后来，大家又认为验证分布函数是否相等实在是太复杂，于是再次退而求其次，只是验证**期望**是否相等（这种叫做均值因果性，上面用分布函数验证的因果关系叫全面因果性）：


`$$E(X_{n+1} | J_{n}) \neq E(X_{n+1} | (J_{n} - Y_{n}))$$`


也有一种方法是验证Y的出现是否能减小对`$X_{n+1}$`的预测**误差**，即：


`$$\sigma^{2}(X_{n+1} | J_{n}) < \sigma^{2}(X_{n+1} | (J_{n} - Y_{n}))$$`


最后一种方法已经接近我们最常用的格兰杰因果检验方法，统计上通常用**残差平方和**来表示预测误差，于是常常用X和Y建立回归方程，通过假设检验的方法（F检验）检验Y的系数是否为零。


可以看出，我们所使用的Granger因果检验与其最初的定义已经偏离甚远，削减了很多条件（并且由回归分析方法和F检验的使用我们可以知道还增强了若干条件），这很可能会导致虚假的因果关系。因此，在使用这种方法时，务必检查前提条件，使其尽量能够满足。此外，统计方法并非万能的，评判一个对象，往往需要多种角度的观察。正所谓“兼听则明，偏听则暗”。诚然真相永远只有一个，但是也要靠科学的探索方法。
