---
title: 扇贝抽样案例——统计方法误区
date: '2005-08-22T20:26:00+08:00'
slug: 20-26-00
---

今日在薛薇老师的数据库研究室网站上看到袁卫老师给法学院的演讲，其中谈到一个案例——扇贝抽样，事情是这样的：

> Arnold Bennett是美国MIT斯隆商学院的一名教授，在杂志Interfaces（1995年3月）中描述了最近他作为统计学“专家”提供相关服务的一个法律案例。这个案例涉及一艘远离新英格兰海岸捕捞扇贝的渔船。
> 
> 为了保护幼扇贝免遭捕捞，美国渔业和野生动物保护机构规定“每个扇贝肉的重量至少1/36磅才可以捕捞”。这艘船被指控违反了这个重量标准。Bennett教授在文章中描述：
> 
> 这艘船抵达马萨诸塞州的一个港口时装有11000袋扇贝，港务人员随机抽选了其中的18袋来检查。港务人员从每一个袋中随机取出一满勺扇贝，然后算出每个扇贝肉的平均重量。港务人员根据18袋的结果估计这艘船的每个扇贝肉的平均重量为1/39磅，低于标准，于是立即没收了捕获的95%，后来进行了拍卖。
> 
> 
> 船主不服，对联邦政府提起诉讼，认为自己的捕捞符合标准，认为只选了18袋，不足以代表全体。律师问Bennett教授的问题之一就是：“能够从一个容量18的样本中得到所有扇贝的平均重量的可靠估计吗？”
> 
> 
> 于是Bennett教授进行了分析：
> 
> 
> Bennett教授把被抽样的18袋的每袋的平均重量按照1/36磅为1的情况作了比较，0.93就是比1/36磅轻，1.14就代表比1/36磅重，数量低于1的表明是不符合标准的。
> 
> 
> 请看下面的数据，只有两袋超过了1/36磅，其他都没有到“1”，都不符合标准。
> 
> 
> 0.93　0.88　0.85　0.91　0.91　0.84　0.90　0.98　0.88
> 0.89　0.98　0.87　0.91　0.92　0.99　1.14　1.06　0.93
> 
> 
> 那么正如律师所问，从11000袋中只抽出18袋作为样本合不合理呢？
> 
> 
> 结论是不合理：仅用18袋作样本太小了，至少应该在30以上，才能作为推断的基本证据，否则误差很大。当然抽样中也并不是越大越好，只要样本的抽样方法是科学的，适当的样本便是好的。

现在我把数据还原：

0.0258　0.0244　0.0236　0.0253　0.0253　0.0233　0.0250　0.0272　0.0244
0.0247　0.0272　0.0242　0.0253　0.0256　0.0275　0.0317　0.0294　0.0258

经过我的计算，样本均值为 0.0259，样本方差 0.0000043777，总体均值在 95% 置信度下的置信区间为【0.0258791537，0.0258801055】，这个置信区间的长度非常短，原因就是因为样本方差过小；即便是我们把置信度提高为 99.9%，置信区间为【0.0258788307，0.0258804286】，其长度依然非常短。然而，置信区间的长度短，正表明了精确性。

注意我要说的“误区”，不在于 Bennett 教授指出的样本量过小从而抽样结论不可靠的误区（袁卫老师也这样认为），上面计算的数据表明，实际上精确度是非常之高的，精确度高理所当然是可靠的！我要提出我的一个疑问，如果没错的话，那么就是大多数研究抽样问题的人的一个误区——总认为样本量小是导致误差大的主要原因；我认为我们的理解走错了方向。

本案例的精度从何而来？答曰来自于置信区间，而置信区间又直接来自于样本均值的方差，所以我们从样本均值的方差公式来看这个问题，一切自然明了：

`$$V(\bar{y})=\frac{1-f}{n}S^2$$`

显然，样本均值的方差不仅受样本量 n 影响，而且受总体方差影响（样本方差是它的无偏估计），当样本方差非常小的时候，n 对于估计精度能起多大作用呢？例如本例，样本方差极其小，此时 n 根本不起多大作用；或者，若 n 大了，样本方差有可能更大，于是可能导致精确度反而降低。由此看来，样本方差对于精度的影响同样是非常大的！

我上面这段话其实也是看似有理，没有说到本质问题上。为什么样本量小就会导致代表性不够、精度低呢？按常理想想，确实是这个道理，但是（我要说的误区所在）我们的解释往往停留在样本均值的方差公式前面的那个系数 (1-f)/n 上，如果 n 小，那么这个系数就会大，导致方差大，这个解释是不太合理的（虽然有一定道理），上面已经作出了初步说明，下面我说说我认为是本质的看法：

`$$P\left(\left|\frac{\bar{y}-\bar{Y}}{\sqrt{V(\bar{y})}}\right|\leq u_{\alpha/2}\right)=1-\alpha$$`

`$$E(s^2)=S^2$$`

其实，可能多数人都忽略了一种习以为常的替代——用无偏估计值替代真值。影响样本代表性以及精度的真正原因应该在这个替代上！`$E(s^2)=S^2$`

注意，无偏估计并不一定等于真值的！而通常由于无偏估计的良好统计学性质，我们就把它当作真值使用了；用样本量 n 很小的样本求出来的 `$s^2$` 与 n 很大的样本求出来的 `$s^2$`，哪个对 `$S^2$` 更具有代表性？若 n 太小，当然感觉心里不踏实。试想，若抽出所有的样本点，那么样本方差就直接等于总体方差了；若抽取少数一两个样本点，代表性当然差，误差当然大！

真正的代表性与误差的根源，我认为来自于此，而不是样本均值的方差公式前面那个系数 (1-f)/n，不知各位看法如何。

其实今日看袁卫老师的演讲，想到主要是另一个问题，涉及到统计学的根基性的问题：数据的概括性度量（集中趋势、离散趋势、峰度与偏度）。

原始数据经过整理、分析之后，必然造成信息的丢失；但是同时也概括、集成了主要信息。这是一种必然的、普遍的矛盾。

继续看袁卫老师的演讲：

> 另一个问题是，法律规定扇贝平均重量要超过 1/36 磅才可以捕捞，这一规定是否合理？
> 
> 我们认为以平均的扇贝重量作为保护扇贝的标准是有问题的。按照这个标准，如果船上有大扇贝，即使捕捞了小扇贝，由于平均重量符合了标准也不会被罚，这并不利于保护小扇贝。应当更改这种标准，比如规定捕捞到的小扇贝的百分比不能超过5%，或者像捕鱼那样，规定网眼的大小等等，这样比较合理。

这里反映充分出均值的缺点，对原数据作平均的处理，集成了信息，但是也掩盖了信息——有一部分小扇贝并没有受到保护。统计分析往往不可避免会丢失信息，同时，这其实也就体现出统计学的特性——不确定性（抑或称之为模糊性）。统计学总是研究不确定性的科学（个人理解），统计学唯一能确定的就是这个不确定性有多么不确定（用概率或者置信区间等手段体现）。

那统计究竟有什么用呢？似乎很没用的样子。我觉得这取决于当事人的风险爱好类型了。统计的结果，也仅仅是一个客观参考而已，不要去那么严厉地推敲它。仍然引用这篇文章的例子，作为本文结尾：

> 下面这个案例是著名的O.J.Simpson案。
> 
> 这个案子影响很大，是世界上最有名的审判之一，美国人把这个审判称为“世纪审判”。从1994年6月12日案发到1995年10月3日审判，美国共播出了5000小时的有关这个案子的电视节目，可见美国人对这个案件的重视程度。
> 
> 辛普森是美国橄榄球明星，又是播音员，是个家喻户晓的人物，这个案件便是要判定他是否杀了前妻和前妻男友。
> 
> 1994年6月12日（周日）晚11点左右，在洛杉矶市郊富人区，晚上跑步的人顺着狗的叫声，在辛普森前妻住宅的外面发现了其前妻和前妻男友的尸体。警察发现前妻被砍7刀，男友被砍22刀。首先被怀疑的就是辛普森，他已经和前妻离婚好几年了，且有虐待前妻的记录。警察在辛普森在富人区的房子外面的车的旁边发现了血迹，还有一只血手套，现场也有一只血手套，一左一右，是一对。
> 
> 辛普森当晚已经乘航班从洛杉矶飞到了芝加哥，在得知前妻被杀时，表示很惊讶，并且立即飞了回来，但不承认自己有罪。洛杉矶警察作为检方提起诉讼，辛普森则请了美国最好的律师组成律师团。8月到11月选陪审团，最后陪审团确定为9个黑人、2个白人、1个拉美人。洛杉矶虽然黑人较多，但是比例也不是很大，但是这个陪审团却有四分之三都是黑人。
> 
> 95年1月正式开始法庭辩论，检方的证据主要是：有作案动机；曾经虐待前妻；不满意前妻和其男友；经过DNA检验，血手套DNA相似的概率为99.99%。
> 
> 庭辩论中，辛普森的律师指出以下几点：手套是几年前前妻买给辛普森的，但是辛普森戴不进去，最后很困难的戴进去了；警察抽了辛普森7毫升血，最后只剩5.5毫升，有1.5毫升不知去向；没有直接目击者，也一直没有找到凶器；辛两个月前买过一把猎刀，但是上面没有找到任何血迹。
> 
> 最后辛普森的律师认为发现手套的警察仇视黑人，少的1.5毫升血液可能是被这个警察为了栽赃辛普森滴到血手套上了。同时从作案时间到飞机起飞仅有半个小时，杀人后洗清血迹，然后再登机，时间并不很充裕。
> 
> 国有一句话：“一碗面条里只有一条虫。”意思是碗里只要找到一条虫子就不能吃了，再去找第二条在法律上是没意义的。这个案子，检方一开始是很顺利的，他们又提出了许多多余的证据，结果弄巧成拙。
> 
> 95年10月3日，陪审团要做出最后的判决，12位陪审团成员一致认为辛普森无罪，因为已有的证据不足以认定有罪，只能做无罪推定。所有黑人欢呼雀跃，大多白人非常失望，并开始质疑陪审团制度和DNA检测。
> 
> 刑事审判结束之后，在97年，法庭认定辛普森对虐待前妻以及其他一些行为要负民事责任，2月10日，判定辛普森赔偿3350万美金给他的前妻及前妻的男友。
> 
> 这个案例并没有直接运用统计方法，只是我们可以注意一个细节，辛普森的律师曾经问DNA检验专家，99.99%的概率是否就意味着辛普森一定是有罪的，专家只能说“NO”。法庭哗然。
> 
> 这表明，概率在法庭上只是一个可能性，只要不是100%，就不能仅依此一项证据定罪。这个案件没有直接的证人，没有直接的凶器，缺少最最重要的证据，因此只能做无罪推定。
> 
> 李昌钰说：“我只为证据说话，不去判断被告是否有罪。”套用一下，统计专家应当“只对数据说话，而不运用数据判断嫌疑人是否有罪”。
