---
title: "简历"
slug: "cn/vitae"
disable_comments: true
---

<style type="text/css">.cn em {font-style: italic;}</style>

# 谢益辉

## 联系方式

Email：xie@yihui.org；主页：<https://yihui.org>；现居住于美国内布拉斯加州麋鹿角郊区

## 研究兴趣

数据可视化，统计图形，交互式图形；统计计算；动态报告，可重复性研究

## 教育背景

- 2009.09 ~ 2013.12 爱荷华州立大学统计系，统计学博士
- 2006.09 ~ 2009.07 中国人民大学统计学院，经济学硕士
- 2002.09 ~ 2006.07 中国人民大学统计学院，经济学学士

## 获得奖励

- 2012.09 [George W. Snedecor](http://stat.iastate.edu/graduate-financial-support) 奖（杰出博士生），爱荷华州立大学统计系
- 2012.01 Honorable Mention 奖，R 在商业中的应用[竞赛](http://bit.ly/wx4bFb)
- 2011.08 [Vince Sposito](http://stat.iastate.edu/graduate-financial-support) 统计计算奖，爱荷华州立大学统计系
- 2009.04 美国统计学会 [John Chambers 软件奖](https://community.amstat.org/jointscsg-section/awards/john-m-chambers)
- 2007.01 中国人民大学学生媒体先进工作者三等奖

<!--
- 2008.06 中国人民大学2008届院级优秀毕业生
- 2007.12 中国人民大学2006~2007学年优秀研究生奖学金
- 2007.12 中国人民大学2006~2007学年“三好学生”
-->

<!--
- 2006.06 北京地区高等学校优秀毕业生
- 2006.04 美国数学建模大赛成功参与奖（[论文](https://db.yihui.org/docs/MCM-2006-paper-Yihui-Xie.pdf)；[证书](https://db.yihui.org/imgur/c3soC.jpg)）
- 2005.12 中国人民大学2004~2005学年“学习优秀奖学金”
- 2005.06 中国人民大学2004~2005学年度“院系优秀共青团员”
- 2003.12 中国人民大学2002~2003学年“校级三好学生”
-->

## 工作经历

### 工作

1. 2013.01 至 2023.12，Posit 软件工程师
1. 2024.01 至今，Posit、瑞士再保险、默克药厂合同工

### 实习

1. 2012 夏季，AT&T 实验室，Florham，新泽西（指导：Simon Urbanek）
1. 2013 夏季，Fred Hutchinson 癌症研究中心（指导：Raphael Gottardo）

### 网站建设与管理

2003 年 9 月至今

#### 建设网站

- 统计学讨论与研究网站“统计之都”：<https://cosx.org>
- R Views 博客技术支持：<https://rviews.rstudio.com>
- 中国人民大学统计学院网站：<https://stat.ruc.edu.cn>
- 教育部重点研究基地，应用统计科学研究中心
- 中国人民大学风险管理与精算研究中心、中国人民大学数据挖掘中心等
- 远大前程协会（中国人民大学学生社团）

#### 网站工作室

- 中国人民大学英文网站工作室（2006 年 6 月至 2007 年 9 月）
- 中国人民大学统计学院网站俱乐部（创办者；2006 年 7 月 2009 年 7 月）

### 组织会议

2005 年 2 月至今曾主办过以下会议：

- [第一届中国R语言会议](https://cosx.org/2008/12/1st-chinese-r-conference-summary/)，2008 年 12 月 13 日 ~ 14 日

协助组织过如下会议：

- [第三届中国R语言会议（北京）](https://cosx.org/chinar/chinar-2010/)，2010 年 6 月 14 日 ~ 15 日
- [第二届中国R语言会议（北京）](https://cosx.org/chinar/chinar-2009/)，2009 年 12 月 5 日 ~ 6 日
- [第二届“创新推动经济发展的微观实证”国际学术研讨会](http://stat.ruc.edu.cn/cn/54222.html)，2008 年 4 月 21 日 ~ 23 日
- 第 2 届“计量模型与中国·澳大利亚自由贸易区发展国际研讨会”，2006 年 4 月 18 日 ~ 19 日
- 第 15 届投入产出国际会议，2005 年 6 月 27 日 ~ 7 月 1 日
- [2006年数据挖掘与商业智能研讨会](http://stat.ruc.edu.cn/cn/21777.html)，2006 年 4 月 2 日
- [2006 年统计学国际论坛](http://stat.ruc.edu.cn/cn/notice/21904.html)，2006 年 6 月 10 日 ~ 11 日

### 统计咨询

经常在“统计之都”上回答各种统计相关问题；偶尔提供邮件咨询和帮助，一些个人原则如下：

- 模型黑名单（我绝对不用的模型）：结构方程模型、层次分析法、灰色模型。
- 模型灰名单（我尽量避免的模型）：因子分析、[任何与分布有关的假设检验](/cn/2009/02/test-statistical-distributions/)。
- 我的数据观：尽量避免分析调查数据，绝对不做小样本的调查数据；我对自然科学数据的分析兴趣远高于社会科学数据。
- 软件黑名单：AMOS（结构方程模型软件之一）

### 其它工作

2004 年 9 月至今

#### 任职情况

- 美国统计学会统计图形部门会议主席（2015 - 2016）
- 美国统计学会数据共享及可重复研究委员会成员（2013）
- 泛华统计协会[Bulletin](http://icsa.org/bulletin/)专栏编辑（2012 - 2013）
- 应用统计科学研究中心科研秘书，主管中心网站工作以及负责部分日常事务（2004 年 4 月至 2009 年 7 月）
- 历任远大前程协会网络部部长、副主席（2005 年 4 月至 2006 年 7 月）

#### 参与项目

- [2014](https://www.google-melange.com/archive/gsoc/2014/orgs/rproject/projects/kejun.html).05 ~ 08、[2017](https://summerofcode.withgoogle.com/projects/#5106168436359168).05 ~ 08 Google 编程夏令营导师
- 2012.05 ~ 08 Google 编程夏令营 [2012](https://www.google-melange.com/archive/gsoc/2012/orgs/rproject/projects/cloud_wei.html)（指导魏太云完成项目）
- 2008.07 新浪在线调研数据转换
- 2007.06 ~ 2007.11 2005 年全国 1% 人口抽样调查合作课题《中国地区国民素质竞争力研究》（已完成报告）
- 2007.05 ~ 2008.09 与“中国食品发酵工业研究院”合作开发统计质量控制与管理程序；使用[R (D)COM](http://sunsite.univie.ac.at/rcom/)
- 2007.04 ~ 2007.05 教育部哲学社会科学重大课题攻关项目（03JZD0016）“中国产业竞争力研究”——农副食品加工业产业竞争力评价和分析
- 2006.09 ~ 2008.09 中国海关绩效评估，用 R 语言结合 SQL 设计针对 MS Access 数据库的抽样程序
- 2005.11 合作翻译英文文档 "[R for beginners](http://cran.r-project.org/doc/contrib/Paradis-rdebuts_en.pdf)" 

## 演讲和讲座

以下多数幻灯片都是基于 R Markdown 文档输出的 HTML 网页格式（尤其是近年来的幻灯片）；若需要查看 R Markdown 源文档，只需要在浏览器地址栏中将 `.html` 扩展名替换为 `.Rmd` 即可下载相应的 R Markdown 文档。

- 谢益辉，2024，_Reimagining Literate Programming and Automated Report Generation_，[Ihaka 讲座系列](https://www.auckland.ac.nz/en/science/about-the-faculty/department-of-statistics/ihaka-lecture-series.html)，奥克兰大学（[幻灯片](https://slides.yihui.org/2024-ihaka-litedown.html)；[视频](https://www.youtube.com/live/83XxhMIZkiw)）
- 谢益辉，2024，_litedown: R Markdown Reimagined_，[SOCEIO 远程报告](https://eventos.urjc.es/110238/detail/i-seminario-soceio-software-y-computacion-en-estadistica-e-investigacion-operativa.html)，西班牙马德里（[幻灯片](https://slides.yihui.org/2024-soceio-litedown.html)）
- 谢益辉，2024，_Reflections on the 12 Years of R Markdown_，首届伯克利-斯坦福“真实数据科学”联合会议，伯克利大学（[幻灯片](https://slides.yihui.org/2024-berkeley-r-markdown.html)；[视频](https://youtu.be/PiplQeO_qig)）
- 谢益辉，2024，_An Introduction to Building Web Applications and Services Using R_，耶鲁公共卫生学院远程报告（[幻灯片](https://slides.yihui.org/2024-ysph-r-web.html)）
- 谢益辉，2023，谈谈数据科学的最后一环：沟通，华中农业大学，武汉（[幻灯片](https://slides.yihui.org/2023-hzau-rmarkdown.html)）
- 谢益辉，2023，_Introducing a lightweight version of R Markdown_，美国统计学会费城分会报告（[幻灯片](https://slides.yihui.org/2023-philly-markdown.html)）
- 谢益辉，2023，_An anatomy of R Markdown with minimal applications_，美国统计学会计算与图形分会邀请报告（[幻灯片](https://slides.yihui.org/2023-minimal-r-markdown.html)；[视频](https://youtu.be/fiy32LjgGUE)）
- 谢益辉，2022，_A graduate student's random walk_，爱荷华州立大学统计系 75 周年系庆报告
- 谢益辉，2022，_Highlights of the knitr package from the past two years_，RStudio大会报告（[幻灯片](https://slides.yihui.org/2022-rstudio-conf-knitr.html)；[视频](https://www.rstudio.com/conference/2022/talks/highlights-of-knitr-package-past/)）
- 谢益辉，2022，_Creating a blog (or website) with blogdown that will not be down_，useR! 会议报告（[幻灯片](https://slides.yihui.org/2022-useR-blogdown.html)；[视频](https://vimeo.com/722781853)）
- 谢益辉，2022，R Markdown 简史，中国人民大学统计与大数据研究院、统计学院校友论坛（[幻灯片](https://slides.yihui.org/2022-RUC-rmarkdown.html)）
- 谢益辉，2022，_Creating three types of websites with blogdown_，迈阿密大学统计系报告（[幻灯片](https://slides.yihui.org/2022-Miami-U.html)）
- 谢益辉，2021，R Markdown 简史，第三届[巴西 R 会议](http://rday.leg.ufpr.br/)（[幻灯片](https://slides.yihui.org/2021-Brazilian-R-Day.html)）
- 谢益辉，2021，_My journey in writing books and blogging about R_，useR! 2021（[幻灯片](https://slides.yihui.org/2021-useR-journey.html)）
- 谢益辉，2021，TinyTeX 简介，[TeX Hour](https://jfine2358.github.io/contact/)
- 谢益辉，2021，厨房记趣，大数报告（[幻灯片](https://slides.yihui.org/2021-dahshu-kitchen.html)；[视频](https://youtu.be/JoFroYuajlE)）
- 谢益辉，2020，随机漫步十八年的傻瓜，中国人民大学统计学院“统计大讲堂”（[幻灯片](https://slides.yihui.org/2020-random-walk.html)；[视频](https://vimeo.com/492610094)）
- 谢益辉，2020，R Markdown：一分钟学一道菜，台湾 satRdays 会议（[幻灯片](https://slides.yihui.org/2020-taipei-satrday-rmarkdown.html)；[视频](https://vimeo.com/469252441)）
- 谢益辉，2020，_Literate Programming, R Markdown, and Reproducible Research_，新冠数据科学会议讨论（[幻灯片](https://bit.ly/covid-down)）
- 谢益辉，2020，R Markdown 技能杂谈，狗熊会远程报告（[幻灯片](https://slides.yihui.org/2020-bearclub-rmarkdown.html)）
- 谢益辉，2020，_One R Markdown Document，Fourteen Demos_，RStudio 大会报告，旧金山（[详情](/en/2020/02/rstudio-conf-2020/)；[视频](https://rstudio.com/resources/rstudioconf-2020/one-r-markdown-document-fourteen-demos/)）
- 谢益辉，2020，_A Bag of R Markdown Tricks_，Genentech 报告，旧金山（[幻灯片](http://bit.ly/genen-down)）
- 谢益辉，2020，_R Markdown Recipes_，RStudio 大会会前培训课程，旧金山（[幻灯片](http://bit.ly/down-recipes)）
- 谢益辉，2019，_15 Tips on Making Better Use of R Markdown_，大树在线报告（[幻灯片](https://bit.ly/dahshu-down)；[视频](https://www.youtube.com/watch?v=L5yTrtRdeCI)）
- 谢益辉，2019，_My failures and perplexities as a former PhD student at Iowa State and later a software engineer at RStudio_，爱荷华州立大学 STAT-ers 邀请报告（[幻灯片](https://bit.ly/isu-talk)）
- 谢益辉，2019，_The fun with CSS and JavaScript, joined by the simplicity of Markdown_，爱荷华州立大学统计图形小组报告（[幻灯片](https://bit.ly/isu-pagedown)）
- 谢益辉，2019，_R Markdown: a Software Ecosystem for Reproducible Publications_，[JSM 会议](https://ww2.amstat.org/meetings/jsm/2019/onlineprogram/ActivityDetails.cfm?SessionID=218013)，丹佛，科罗拉多（[幻灯片](https://bit.ly/jsm-rmarkdown)）
- 谢益辉，2019，_Quick Demos of the R Markdown Ecosystem_，瑞典 RaukR 暑期学校远程报告（[幻灯片](https://bit.ly/2019-raukr)）
- 谢益辉，2019，_pagedown: Creating beautiful PDFs with R Markdown and CSS_，RStudio 大会，奥斯汀，德州（[幻灯片](https://bit.ly/pagedown)；[视频](https://resources.rstudio.com/rstudio-conf-2019/pagedown-creating-beautiful-pdfs-with-r-markdown-and-css)）
- 谢益辉，2018，_Some Lesser Known Features of knitr_，瑞典 RaukR 暑期学校远程报告（[幻灯片](https://bit.ly/2018-raukr)）
- 谢益辉，2018，_Easy Dashboards with R Markdown_，奥马哈 R 用户小组报告（[幻灯片](https://bit.ly/2018-dashboard)）
- 谢益辉，2018，_Creating Websites with R Markdown and blogdown_，RStudio 大会报告，圣地亚哥，加州（[幻灯片](https://bit.ly/2018-blogdown)）
- 谢益辉，2017，_An R Markdown Tutorial on bookdown, blogdown, and xaringan_，内布拉斯加大学林肯分校自然资源学院讲座（[幻灯片](https://slides.yihui.org/2017-rmarkdown-UNL-Yihui-Xie.html)）
- 谢益辉，2017，用 blogdown 搭建一个静态网站（兼吐槽学术出版传统），北美华人基因组学在线沙龙（[幻灯片](https://slides.yihui.org/2017-blogdown-CGM-Yihui-Xie.html)；[视频](https://www.youtube.com/watch?v=g-UnHlp_IgA)）
- 谢益辉，2017，_DIY Your Personal Academic Website with blogdown_，内布拉斯加大学林肯分校统计系报告（[幻灯片](https://slides.yihui.org/2017-blogdown-UNL-Yihui-Xie.html)）
- 谢益辉，2017，_New Packages in the R Markdown Ecosystem_，美国统计学会统计市场研究分会网络报告（[幻灯片](https://slides.yihui.org/2017-ASA-Marketing-rmarkdown-Yihui-Xie.html)）
- 谢益辉，2017，_Towards An Open-access, Fast, and Reproducible Journal_，WOMBAT MeDaScIn 会议特邀报告，墨尔本 （[幻灯片](https://slides.yihui.org/2017-DSM-Journal-Yihui-Xie.html)）
- 谢益辉，2017，_A Tour Through the R Markdown Ecosystem: Creating Documents, Presentations, Papers, Dashboards, Books, and Websites_，墨尔本数据科学周短期课程，澳大利亚（[幻灯片](https://slides.yihui.org/2017-DSM-rmarkdown-Yihui-Xie.html)）
- 谢益辉，2017，_Making Websites with R Markdown and blogdown_，RStudio 网络报告（[幻灯片](https://slides.yihui.org/2017-rstudio-webinar-blogdown-Yihui-Xie.html)）
- 谢益辉，2017，_The R Markdown Ecosystem: Reproducible Reports, Papers, Books, Websites, and Presentations_，堪萨斯州立大学植物病理学系，曼哈顿，堪萨斯（[幻灯片](https://slides.yihui.org/2017-RMD-KSU.html)）
- 谢益辉，2017，_Customizing & Extending R Markdown_，rstudio::conf 大会报告，Kissimmee，佛罗里达 （[幻灯片](https://slides.yihui.org/2017-rstudio-conf-ext-rmd-Yihui-Xie.html)）
- 谢益辉，2017，_Making Websites with R Markdown_，rstudio::conf 大会报告，Kissimmee，佛罗里达 （[幻灯片](https://slides.yihui.org/2017-rstudio-conf-blogdown-Yihui-Xie.html)）
- 谢益辉，2017，_Advanced R Markdown_，rstudio::conf 大会培训，Kissimmee，佛罗里达 （[幻灯片](https://slides.yihui.org/2017-rstudio-conf-rmarkdown-Yihui-Xie.html)）
- 谢益辉，2016，_bookdown: Authoring Books with R Markdown_，科罗拉多大学统计系（[幻灯片](http://slides.yihui.org/2016-CSU-bookdown-Yihui-Xie.html)）
- 谢益辉，2016，漫谈一些我认为有趣和有用的 R 包，科罗拉多大学统计系
- 谢益辉，2016，_Authoring Books with R Markdown_，RStudio 网络报告（[幻灯片](http://slides.yihui.org/2016-webinar-bookdown-Yihui-Xie.html); [视频](https://www.rstudio.com/resources/webinars/introducing-bookdown/)）
- 谢益辉，2016，_Reproducibility in Statistics and Data Science (Discussion)_，JSM 2016，芝加哥（[幻灯片](http://slides.yihui.org/2016-repro-JSM-Yihui-Xie.html)）
- 谢益辉，2016，_HTML Widgets: Interactive Visualizations from R Made Easy!_，JSM 2016，芝加哥（[幻灯片](http://slides.yihui.org/2016-htmlwidgets-JSM-Yihui-Xie.html)）
- 谢益辉，Hadley Wickham，2016，_Authoring Books with R Markdown_，useR! 2016会议报告，斯坦福大学（[幻灯片](http://slides.yihui.org/2016-useR-bookdown-Yihui-Xie.html)）
- 谢益辉，Karl Broman，Ian Lyttle，2016，_Dynamic Documents with R Markdown_，useR! 2016 会前培训班，斯坦福大学（[幻灯片](http://slides.yihui.org/2016-useR-rmarkdown-Yihui-Xie.html)）
- 谢益辉，2016，用 R Markdown 愉快地写作是怎样一种体验，第 9 届中国 R 语言会议，北京（[幻灯片](http://slides.yihui.org/2016-China-R-bookdown-Yihui-Xie.html)）
- 谢益辉，2016，_CosPlay R_，第 9 届中国 R 语言会议，北京
- [谢益辉](https://db.yihui.org/imgur/uw62CkX.jpg)，2016，R Markdown：便利的学术写作和数据分析工具，[中国海洋大学](http://www2.ouc.edu.cn/math/Ch/NewsView.asp?id=1279&SortID=30)，青岛（[幻灯片](http://slides.yihui.org/2016-OUC-Yihui-Xie.html)）
- 谢益辉，2016，漫谈一些有趣的交互式图形应用，青岛大学经济学院
- 谢益辉，2016，_Shiny and HTML Widgets in R_，大奥马哈地区 Tableau 用户小组聚会，内布拉斯加大学奥马哈分校（[幻灯片](http://slides.yihui.org/2016-UNO-Shiny-Yihui-Xie.html)）
- 谢益辉，2016，用 R Markdown 写书，美国统计学会芝加哥分部会议，芝加哥（[幻灯片](http://slides.yihui.org/2016-ASAChicago-bookdown-Yihui-Xie.html)）
- 谢益辉，2016，准备好写书吧
    - 03/31，芝加哥大学（[幻灯片](http://slides.yihui.org/2016-UChicago-bookdown-Yihui-Xie.html)）
    - 02/17，内布拉斯加大学林肯分校统计系（[幻灯片](http://slides.yihui.org/2016-UNL-bookdown-Yihui-Xie.html)）
- 谢益辉，2016，_Complex Application Layouts with Grid Style Sheets_，Shiny 开发者大会，斯坦福大学（[幻灯片](http://slides.yihui.org/2016-Shiny-GSS-Yihui-Xie.html)）
- 谢益辉，2016，_Interfacing DataTables_，Shiny 开发者大会，斯坦福大学（[slides](http://slides.yihui.org/2016-Shiny-DT-Yihui-Xie.html)）
- 谢益辉，2015，论 R 码农的自我修养，第 9 届中国 R 语言会议（南昌）远程报告（[幻灯片](http://slides.yihui.org/2015-Nanchang-R-Yihui-Xie.html)）
- 谢益辉，2015，_Reproducible Reports with Big Data_，Strata 会议，纽约（[幻灯片](http://conferences.oreilly.com/strata/big-data-conference-ny-2015/public/schedule/detail/44154)）
- 谢益辉，2015，黄粱十载梦，中国人民大学统计学院远程报告（[幻灯片](http://slides.yihui.org/2015-RUC-alumni-sympo-Yihui-Xie.html)）
- 谢益辉，2015，_Escape the Land of LaTeX/Word for Statistical Reporting: The Ecosystem of R Markdown_
    - 03/13，Wright State University，Dayton，俄亥俄州（[幻灯片](http://slides.yihui.org/2015-Wright-State-Yihui-Xie.html)）
    - 07/14，爱荷华 R 用户小组报告
    - 09/03，美国统计学会网络讲座（[幻灯片](https://docs.google.com/presentation/d/1RJeypFW1y9vtG_kCoREN5D16jX3KNrc_qzGMGygQs2E/edit?usp=sharing)）
    - 10/28，RStudio 网络讲座（[幻灯片](https://github.com/rstudio/webinars/blob/master/13-R-Markdown-Ecosystem)；[视频](https://vimeo.com/143893476)）
- 谢益辉，2015，_Boosting R Skills and Automating Statistical Reports_，新英格兰地区统计论坛（NESS），康州大学，康涅狄格
- 谢益辉，2015，用 R 语言编写自动化报告以及交互式应用，58 同城，北京（[幻灯片](http://slides.yihui.org/2015-58-Yihui-Xie.html)）
- 谢益辉，2015，_HTML Widgets_，洛杉矶 R 用户小组，加州（[幻灯片](http://slides.yihui.org/2015-htmlwidgets-LA-Yihui-Xie.html)；[视频](http://datascience.la/yihui-xie-presents-html-widgets/)）
- 谢益辉，Dirk Eddelbuettel，2014，[R语言培训班](http://ditraglia.com/RWorkshop/)，宾州大学 Warren 中心，费城，宾夕法尼亚
- JJ Allaire，谢益辉，2014，基于 Packrat 和 R Markdown 的可重复性 R 报告，[R Day](http://strataconf.com/stratany2014/public/schedule/detail/37037)，纽约 Strata 会议
- 谢益辉，2014，可重复性研究已死/可重复性研究万岁，JSM 2014，波士顿，马萨诸塞（[幻灯片](http://slides.yihui.org/2014-JSM-knitr-Yihui-Xie.html)）
- 谢益辉，2014，卡卡西之雷织！，UseR! 2014 会议演讲，UCLA（[幻灯片](https://github.com/yihui/knitr-talks/tree/master/useR2014)）
- 谢益辉，2014，_Dynamic Documents with R and knitr_，UseR! 2014 会前课程，UCLA（[幻灯片](http://slides.yihui.org/2014-useR-knitr-tutorial-Yihui-Xie.html)；[示例](https://www.dropbox.com/s/0mabfshkbpe9bp1/2014-useR-knitr-tutorial-examples.zip)）
- 谢益辉，2014，_The Next Generation of Dynamic Documents with R Markdown_，Great Plains [R用户小组](http://homepages.dordt.edu/ntintle/gprug/)会议，Sioux Center，爱荷华（[幻灯片](http://slides.yihui.org/2014-Dordt-Yihui-Xie.html)）
- 谢益辉，2014，_How I Managed to Find Time to Play Badminton Three Times A Week_，爱荷华州立大学动物科学系（[幻灯片](http://slides.yihui.org/2014-ISU-ANS-Yihui-Xie.html)）
- 谢益辉，2014，_New developments in knitr and R Markdown v2_，洛杉矶 R 用户小组，加州（[幻灯片](http://slides.yihui.org/LARUG-2014-Yihui-Xie.html)）
- 谢益辉，2014，_Dynamic and Interactive Statistical Reporting_，加州大学洛杉矶分校统计系（[幻灯片](http://slides.yihui.org/UCLA-2014-Yihui-Xie.html)）
- 谢益辉，2014，_How to Save More Time from Your Homework and Projects_，爱荷华州立大学 Stat416 客串讲堂（[幻灯片](http://slides.yihui.org/2014-STAT416-Yihui-Xie.html)）
- 谢益辉，2014，_An Introduction to knitr_，桔子郡 R 用户小组，远程报告，加州（[幻灯片](http://slides.yihui.org/2014-OC-RUG-Yihui-Xie.html)）
- 谢益辉，2014，西雅图 R 用户聚会，_R Markdown v2_，Fred Hutchinson癌症研究中心，西雅图，华盛顿（[幻灯片](http://slides.yihui.org/Seattle-useR-2014-Yihui-Xie.html)）
- 谢益辉，2013，怎样从你的作业/项目中省下时间去喝啤酒，美国统计协会爱荷华分会聚会（[海报](http://slides.yihui.org/2013-ASA-Iowa-knitr-poster.pdf)）
- 谢益辉，2013，忍者神织，纽约 R 用户小组，远程报告（[幻灯片](https://slides.yihui.org/2013-NYCR-knitr-Yihui-Xie.html)）
- 谢益辉，2013，_A tour through knitr_，Raphael Gottardo 实验室，Fred Hutchinson 癌症研究中心，西雅图，华盛顿（[幻灯片](http://slides.yihui.org/FHCRC-rglab-2013-Yihui-Xie.html)）
- 谢益辉，2013，_An Introduction to knitr_，Bioconductor 2013，西雅图，华盛顿（[幻灯片](http://slides.yihui.org/BioC-2013-Yihui-Xie.html)，[源文件](http://slides.yihui.org/BioC-2013-Yihui-Xie.Rpres)）
- 谢益辉，2013，_The Development of R in China, and One Sentence Summaries of My R Projects_，Revolution Analytics，西雅图，华盛顿（[幻灯片](https://bitbucket.org/stat/www/downloads/2013-RevoR-Yihui-Xie.pdf)）
- 谢益辉，2013，_Doing Reproducible Research Unconsciously: Higher Standard But Less Work_，The 36th annual Midwest Biopharmaceutical Statistics Workshop，Muncie，印第安纳（[幻灯片](http://slides.yihui.org/knitr-MBSW-Yihui-Xie-2013.html)）
- 谢益辉，2013，R包那些事儿，第 6 届中国 R 语言会议，北京（[幻灯片](http://slides.yihui.org/ChinaR-2013-Yihui-Xie.html)）
- 谢益辉，2013，_knitr: A General-purpose Tool for Dynamic Report Generation in R_，[ENAR](http://enar.org) 2013，奥兰多，佛罗里达（[幻灯片](http://slides.yihui.org/knitr-ENAR-Yihui-Xie-2013.html)）
- 谢益辉，2013，_Reproducible Research on the Web: From Homework, Blogging to Open Journals_，SIAM [CSE13](http://www.siam.org/meetings/cse13/)，波士顿，马萨诸塞（[幻灯片](http://slides.yihui.org/2013-SIAM-CSE13-Yihui-Xie.html)）
- 谢益辉，2012，_knitr: Starting From Reproducible Homework_，计算与实验数学中的可重复性研讨会，[ICERM](http://icerm.brown.edu/tw12-5-rcem)，布朗大学（[幻灯片](https://bitbucket.org/stat/www/downloads/ICERMRR-Yihui-Xie-2012.pdf)）
- 谢益辉，2012，_Can You Reproduce Your Homework?_，Department of Biostatistics，Johns Hopkins Bloomberg School of Public Health，巴尔的摩，马里兰（[幻灯片](http://yihui.org/slides/2012-reproduce-homework.html)）
- 谢益辉，2012，_I web, therefore I am_，爱荷华州立大学统计计算组（[幻灯片](http://yihui.org/slides/2012-stats-web.html)）
- 谢益辉，2012，_Dynamic Report Generation and Interactive Graphics on the Web_，AT&T实验室暑期实习报告，Florham Park，新泽西州
- 谢益辉，2012，_cranvas: A New Package for Interactive Statistical Graphics in R_，Joint Statistical Meetings，圣地亚哥，加州
- [谢益辉](https://db.yihui.org/imgur/6oGl4.jpg)，2012，_cranvas: Interactive statistical graphics in R based on Qt_，[useR! 2012](http://biostat.mc.vanderbilt.edu/wiki/Main/UseR-2012)，纳什维尔，田纳西（[R 代码](http://yihui.org/slides/2012-useR-cranvas-demo.R)）
- [谢益辉](https://db.yihui.org/imgur/cs0lG.jpg)，JJ Allaire，2012，_New Tools for Reproducible Research with R_（[幻灯片](http://yihui.org/slides/2012-knitr-RStudio.html)）
    - 05/30 爱荷华州立大学
    - 05/30 Minneapolis R 用户组
    - 06/05 纽约 R 用户组
    - 06/14 useR! 2012 会议[邀请报告](https://db.yihui.org/imgur/GPFxG.jpg)
- 谢益辉，2012，_Go social coding! Make open source more open!_，useR! 2012 会议 5 分钟演讲（[幻灯片](https://db.yihui.org/docs/social-coding-Yihui-Xie-2012.pdf)）
- 谢益辉，2012，_cranvas: Building from Plumbing and Painting_，[Interface 2012](http://www.interfacesymposia.org/Interface2012/Interface2012.html)，休斯顿，德州（[幻灯片](https://db.yihui.org/docs/cranvas-Houston-2012.pdf)）
- 谢益辉，2012，_Generating beautiful statistical reports quickly and faithfully_，爱荷华州立大学图形工作组（[幻灯片](https://db.yihui.org/docs/knitr-ISU-2012-Yihui-Xie.pdf)）
- 谢益辉，2011，_How I See Bootstrap，Tests and KDE_，Stat546 课程报告（[幻灯片](http://yihui.org/slides/2011-nonparametric.html)）
- 谢益辉，2011，_An Introduction to R_，爱荷华州立大学经济系 R 语言培训（[幻灯片](http://yihui.org/slides/2011-r-intro-econ.html)）
- 谢益辉，2011，_Lessons Learned in Developing R Packages_，爱荷华州立大学统计计算讨论组（[幻灯片](http://yihui.org/slides/2011-r-dev-lessons.html)）
- 谢益辉，2011，_`cranvas`: Interactive Statistical Graphics in R via Qt_，AT&T 实验室，新泽西（[幻灯片](https://db.yihui.org/docs/cranvas-ATT-2011-Yihui-Xie.pdf)）
- 谢益辉，2011，_Interactive Parallel Coordinates Plot Based on Qt_，Joint Statistical Meetings，迈阿密，佛罗里达（[幻灯片](https://db.yihui.org/docs/cranvas-JSM-2011-Yihui-Xie.pdf)）
- 谢益辉，2011，_New Features and Enhancements of the `animation` Package_，图形工作组报告，爱荷华州立大学（[幻灯片](https://db.yihui.org/docs/animation-2011-Yihui-Xie.pdf)）
- 谢益辉，2010，_LaTeX and Sweave without Tears_，图形工作组报告，爱荷华州立大学（[幻灯片](https://db.yihui.org/docs/LaTeX-Sweave-2011-Yihui-Xie.pdf)）
- 谢益辉，2010，_Creating Animations with R_，useR! 2010 会议，马里兰 NIST（[摘要](http://user2010.org/abstracts/Xie.pdf)；PDF[幻灯片](https://db.yihui.org/docs/animation-useR2010-Yihui-Xie.pdf)；[R 代码](https://gist.github.com/2166508)）
- 谢益辉，2010，用 gWidgets 包创建图形用户界面，第 3 届中国R语言会议，北京，2010 年 6 月 15 日（[幻灯片](https://db.yihui.org/docs/ChinaR-gWidgets-2010-Yihui-Xie.pdf)；[代码](https://gist.github.com/1756480)）
- 谢益辉，2010，现代统计图形，第 3 届中国 R 语言会议培训（[幻灯片](https://db.yihui.org/docs/ChinaR-MSG-2010-Yihui-Xie.pdf)）
- 谢益辉，2010，统计图形和模拟视角下的模型理论解析，中国人民大学统计学院硕士论文答辩（[幻灯片](https://db.yihui.org/docs/GSM-master-defense-Yihui-Xie2010.pdf)）
- 谢益辉，2009，_Creating R Packages_，统计计算和密集型计算工作组讲座，爱荷华州立大学 （[幻灯片](https://db.yihui.org/docs/Creating-R-packages-2009-Yihui-Xie.pdf)；[R包示例](https://github.com/yihui/rmini)）
- 谢益辉，2009，_R in Stat500: Demonstration, Computing, and Graphics (with An Introduction to the R Package ISU.Stat500)_，RTG 讲座，爱荷华州立大学 （[幻灯片](https://db.yihui.org/docs/ISU-Stat500-2009-Yihui-Xie.pdf)）
- 谢益辉，2009，_Turning Statistical Ideas into Animations_，VIGRE统计图形讲座，爱荷华州立大学（[幻灯片](https://db.yihui.org/docs/animation-2009-Yihui-Xie.pdf)；[R 代码](https://db.yihui.org/docs/animation-2009-Yihui-Xie.zip)）
- 谢益辉，2009，可重复的科学研究与 Sweave 的应用，统计 08 博士班报告（[幻灯片](https://db.yihui.org/docs/Sweave-2008-Yihui-Xie.pdf)）
- [谢益辉](https://db.yihui.org/imgur/SDtSv.jpg)，2008，（1）R 语言的历史背景、发展历程及现状（[幻灯片](https://db.yihui.org/docs/R-History-2008-Yihui-Xie.ppt)）（2）统计动画程序包 animation 介绍及其在教学和数据分析中的应用（[幻灯片](https://db.yihui.org/docs/ChinaR-animations-2008-Yihui-Xie.ppt)）（3）无处不在的数据及 R 的探索方法（[幻灯片](https://db.yihui.org/docs/Irregular-Data-2008-Yihui-Xie.ppt)，[R代码](https://gist.github.com/1756790#file_china_r_conference_intro_2008_yihui_xie.r)），[第 1 届中国R语言会议](https://cosx.org/2008/12/1st-chinese-r-conference-summary/)，北京，2008 年 12 月 13 日 ~ 14 日（[会议介绍](https://db.yihui.org/docs/ChinaR-Conference-Intro-2008-Yihui-Xie.pdf)，[R 代码](https://gist.github.com/1756790#file_irregular_data_2008_yihui_xie.r)）
- [谢益辉](https://db.yihui.org/imgur/4PXVg.jpg)，2008，R 语言基础，中国科学院植物研究所和中国科学院生物多样性委员会“生物统计和生物多样性数据分析培训班”系列课程（[幻灯片1](https://db.yihui.org/docs/CAS-R-tutorial1-2008-Yihui-Xie.pdf)；[幻灯片2](https://db.yihui.org/docs/CAS-R-tutorial2-2008-Yihui-Xie.pdf)；[幻灯片3](https://db.yihui.org/docs/CAS-R-tutorial3-2008-Yihui-Xie.pdf)；[幻灯片4](https://db.yihui.org/docs/CAS-R-tutorial4-2008-Yihui-Xie.pdf)）
- 谢益辉，2008，_See? (escaping the math world via animations...)_，中国人民大学统计学院演讲（[幻灯片](https://db.yihui.org/docs/animation-RUC-2008-Yihui-Xie.pps)）
- [谢益辉](https://db.yihui.org/imgur/Kujko.jpg)，2008，_Statistical Animations Using R_，德国多特蒙德大学 [useR! 2008](http://www.statistik.uni-dortmund.de/useR-2008/) 会议（[摘要](http://www.statistik.uni-dortmund.de/useR-2008/abstracts/Xie.pdf)；[PPT](https://db.yihui.org/docs/animation-useR-2008-Yihui-Xie.ppt)；[PDF 幻灯片](http://www.statistik.uni-dortmund.de/useR-2008/slides/Xie.pdf)）
- 谢益辉，2008，_Computer Animations for Demonstrating Statistical Procedures: Methods and Implementations_，第六届数据可视化会议（Statistical Graphics: Data and Information Visualization in Today's Multimedia Society [(Data Viz VI)](http://www.jacobs-university.de/schools/shss/awilhelm/)）邀请演讲，德国不莱梅 Jacobs 大学（[幻灯片](https://db.yihui.org/docs/animation-DataViz-2008-Yihui-Xie.pdf)）
- [谢益辉](https://db.yihui.org/imgur/1Sj0J.jpg)，2008，_The Influence of Population Quality Competitiveness to Regional Innovation: the China Case_，第二届“创新推动经济发展的微观实证”国际学术[研讨会](http://stat.ruc.edu.cn/cn/54222.html)演讲（[幻灯片](https://db.yihui.org/docs/MEIDE-2008-Yihui-Xie.pdf)）
- 谢益辉，2008，EViews 软件入门培训及宏观经济统计分析应用示例，国家发改委EViews培训（[幻灯片](https://db.yihui.org/docs/Intro-EViews-2008-Yihui-Xie.pdf)）
- [谢益辉](https://db.yihui.org/imgur/hf7Gl.jpg)，2007，_[Animation](http://cran.r-project.org/package=animation) in Statistics: Dynamic Graphics for Statistical Models and Practical Applications_，第二届“首都高校统计学研究生论坛”报告（[幻灯片](https://db.yihui.org/docs/2nd-Stat-Forum-2007-Yihui-Xie.pdf)）
- 谢益辉，2007，集成分类树及其在脑梗塞预后分析中的应用，临床医学研究中的统计方法学术[研讨会](http://stat.ruc.edu.cn/cn/notice/52039.html)报告（[幻灯片](https://db.yihui.org/docs/Medicine-2007-Yihui-Xie.pdf)）
- [谢益辉](https://db.yihui.org/imgur/BE3yw.jpg)，2007，_Jokes in Statistics_，首都经贸大学统计学院邀请讲座（[幻灯片](https://db.yihui.org/docs/Jokes-2007-Yihui-Xie.pdf)）
- 谢益辉，2007，略谈统计的工具，首都经贸大学统计学院邀请讲座（[幻灯片](https://db.yihui.org/docs/Stat-tools-2007-Yihui-Xie.pdf)；[R代码](https://gist.github.com/1756901)）
- 谢益辉，2007，_Bootstrap Methods: A Review_，统计前沿课堂[报告](https://db.yihui.org/docs/Bootstrap-2007-Yihui-Xie.pdf)
- 谢益辉，2007，_An Introduction to Support Vector Machine and Implementation in R_，数据挖掘与机器学习课堂[报告](https://db.yihui.org/docs/SVM-2007-Yihui-Xie.pdf)
- 谢益辉，2007，统计编程的框架与 R 语言统计分析基础，“统计之都”北京地区第一次沙龙活动演讲（[幻灯片](https://db.yihui.org/docs/R-Programming-2007-Yihui-Xie.pdf)）
- 谢益辉，2007，_A Brief Introduction to Java_，统计学院报告（[幻灯片](https://db.yihui.org/docs/Java-2007-Yihui-Xie.pdf)）
- 谢益辉，2007，Stata 统计分析入门，中国人民银行 Stata 介绍与培训（[幻灯片](https://db.yihui.org/docs/Stata-2007-Yihui-Xie.pdf)）
- [谢益辉](https://db.yihui.org/imgur/lB9hL.jpg)，2007，_Visualization of Data and Statistical Models Using R_，第 3 届“计量模型与中国·澳大利亚自由贸易区发展国际研讨会” （[论文](https://db.yihui.org/docs/R-visualization-paper-2007-Yihui-Xie.pdf)；[幻灯片](https://db.yihui.org/docs/R-visualization-2007-Yihui-Xie.pdf)）
- 谢益辉，2006，_Thoughts of Statistics_，第一届“首都高校统计学研究生论坛”报告（[幻灯片](https://db.yihui.org/docs/Thoughts-2006-Yihui-Xie.pdf)）
- 谢益辉，2006，_Typesetting and LATEX_，统计学院讲座系列（[幻灯片](https://db.yihui.org/docs/LaTeX-2006-Yihui-Xie.pdf)）
- 谢益辉，2006，_Statistical Programming & R Basics_，统计学院讲座系列（[幻灯片](https://db.yihui.org/docs/R-Programming-2006-Yihui-Xie.pdf)）
- 谢益辉，2006，_An Introduction to Structural Equation Modeling_，结构方程模型小型研讨会（[幻灯片](https://db.yihui.org/docs/SEM-2006-Yihui-Xie.pdf)）
- 赵彦云，李桂荣，[谢益辉](https://db.yihui.org/imgur/0ZURF.jpg)，2006，_The Industrial Structure and Foreign Investment Introduction Policy in Shanghai and Its Adjacency_，第2届“[计量模型与中国·澳大利亚自由贸易区发展国际研讨会](http://stat.ruc.edu.cn/cn/22068.html)”（[幻灯片](https://db.yihui.org/docs/ACFTA-2006-Yihui-Xie.pdf)）

## 计算机水平

擅长使用网页制作软件，以及统计建模、统计编程和统计计算软件

- 统计软件：熟悉 [R 语言](http://www.r-project.org/)；~~已弃用S-Plus、SPSS、Eviews、SAS、STATA，MatLab（已忘光）、AMOS（已列入黑名单），OpenBUGS、LISREL（已忘光）~~
- 语言：统计计算语言 [R](http://www.r-project.org/)，网页语言 HTML、JavaScript、PHP，数据库语言 SQL，脚本工具 Awk 以及 Bash 脚本
- 应用程序：专业排版软件 LaTeX / LyX，常用数据库如 MySQL，小工具如 Pandoc，若干零杂 Ruby 程序如 Jekyll，不使用微软 Office
- 操作系统：日常使用 macOS，间或使用 Ubuntu 与 Windows 测试软件
- 计算机等级：无任何等级证书，但在本科和研究生期间修理过若干台个人电脑，追求在实际工作中大量使用计算机编程来提高工作效率

## 英语水平

口语大致够用（谈技术），听力水平欠缺（在饭店），阅读基本无碍（查字典），写作略有自信（靠瞎编）。

## 发表成果

### 书籍

1. 赵鹏，谢益辉，黄湘云（2021），《[现代统计图形](https://bookdown.org/xiangyun/msg/)》，[人民邮电出版社](https://www.ituring.com.cn/book/2951)，书号 978-7-115-56690-4
1. Yihui Xie, Christophe Dervieux, Emily Riederer (2020). [_R Markdown Cookbook_](https://bookdown.org/yihui/rmarkdown-cookbook). Chapman & Hall/[CRC](https://www.routledge.com/p/book/9780367563837). ISBN 9780367563837.
1. Yihui Xie, J. J. Allaire, Garrett Grolemund (2018). [_R Markdown: The Definitive Guide_](https://bookdown.org/yihui/rmarkdown). Chapman & Hall/[CRC](https://www.crcpress.com/p/book/9781138359338). ISBN 9781138359338.
1. Yihui Xie, Amber Thomas, Alison Presmanes Hill (2017). [_blogdown: Creating Websites with R Markdown_](https://bookdown.org/yihui/blogdown). [Chapman & Hall/CRC](https://www.crcpress.com/p/book/9780815363729). ISBN 9780815363729.
1. Yihui Xie (2016). [_bookdown: Authoring Books and Technical Documents with R Markdown_](https://bookdown.org/yihui/bookdown). Chapman and Hall/CRC. ISBN 9781138700109.
1. Yihui Xie (2015). [_Dynamic Documents with R and knitr_](http://www.crcpress.com/product/isbn/9781498716963). 2nd edition. Chapman and Hall/CRC. ISBN 978-1498716963
1. Yihui Xie (2014) knitr: [_A Comprehensive Tool for Reproducible Research in R_](http://www.crcpress.com/product/isbn/9781466561595). In Victoria Stodden, Friedrich Leisch and Roger D. Peng, editors, Implementing Reproducible Computational Research. Chapman and Hall/CRC. ISBN 978-1466561595
1. Yihui Xie (2013) [_Dynamic Documents with R and knitr_](http://www.crcpress.com/product/isbn/9781482203530). Chapman and Hall/CRC. ISBN 978-1482203530

### 中文论文

<!--
1. 赵彦云、冯乃林、赵云城、谢益辉、肖宁，2008，中国地区国民素质竞争力研究，统计研究，25(3)，12-19
-->
1. 谢益辉，2008，统计图形在数据分析中的应用，统计学评论，张波主编，中国财政经济出版社
1. 谢益辉、朱钰，2008，Bootstrap 方法的历史发展和前沿研究，统计与信息论坛，89，90-96
1. 谢益辉，2007，基于 R 软件 rpart 包的分类与回归树应用，统计与信息论坛，86，67-70
1. 谢益辉，2007，国际竞争力系列之中国金融体系有多弱，中国统计，7，35
1. 赵彦云，谢益辉，前100大扩张能力强于经营实力 企业成长不均衡，英才杂志，2006.9
1. 赵彦云，谢益辉，哪些企业扩张能力强 哪些企业综合效率高 谁是真正的增长冠军，英才杂志，2005.9

### 英文论文

1. Yihui Xie, Heike Hofmann, and Xiaoyue Cheng (2014). _Reactive Programming for Interactive Graphics_. Statistical Science, 29(**2**), 201-213. ([PDF](https://bitbucket.org/stat/www/downloads/STS477.pdf))
1. Yihui Xie (2013) _animation: An R Package for Creating Animations and Demonstrating Statistical Methods_, [Journal of Statistical Software, 53(1)](https://www.jstatsoft.org/article/view/v053i01)
1. Yihui Xie, Xiaoyue Cheng. _animation: A Package for Statistical Animations_. [R News, 8(2), 2008](http://www.r-project.org/doc/Rnews/Rnews_2008-2.pdf)
1. 谢益辉，_Visualization of Data and Statistical Models Using R_，第 3 届“计量模型与中国·澳大利亚自由贸易区发展国际研讨会”论文集，2007 年 3 月（[PDF](https://db.yihui.org/docs/R-visualization-paper-2007-Yihui-Xie.pdf)）

### 非出版论文

1. 谢益辉，2010-04-25，统计图形和模拟视角下的模型理论解析（硕士论文；[PDF](https://db.yihui.org/docs/master-thesis-Yihui-Xie.pdf)）
1. 谢益辉，2008-09-14，论优化方法的可视化及教学（[PDF](https://db.yihui.org/docs/Visual-Operations-Research-Yihui-Xie-2008.pdf)）
1. 谢益辉，2006-12-04，Spurious Regression: Simulation and Theoretical Analysis（[PDF](https://db.yihui.org/docs/Spurious-Regression-Yihui-Xie-2006.pdf)）
1. 谢益辉，2006-05-10，结构方程模型的理论、应用以及若干误区（本科毕业论文；[PDF](https://db.yihui.org/docs/SEM-theory-2006-Yihui-Xie.pdf)）

### 网络文章

统计之都文章参见[这里](https://cosx.org/members/#yihui)。

## 软件包

### R 包

作为主要作者：

- [knitr](https://github.com/yihui/knitr)：自动化生成报告，思想源于文学化编程和 Sweave，昌盛于 Markdown
- [bookdown](https://github.com/rstudio/bookdown): 用 R Markdown 进行书籍和技术文档写作
- [xaringan](https://github.com/yihui/xaringan)：幻灯忍者（基于 R Markdown 和 remark.js 的幻灯片包）
- [blogdown](https://github.com/rstudio/blogdown)：用 R Markdown 和 Hugo 创建网站
- [pagedown](https://github.com/rstudio/pagedown)：用 CSS 排版网页并打印 PDF
- [tufte](https://github.com/rstudio/tufte)：R Markdown 的 Tufte 样式
- [servr](https://github.com/yihui/servr)：用 R 创建一个本地网站服务器，在浏览器中显示本地文件
- [animation](https://github.com/yihui/animation)：用动画展示统计学各学科的模型方法以及数据分析
- [testit](https://github.com/yihui/testit)：用于 R 包的单元测试
- [formatR](https://github.com/yihui/formatR)：格式化 R 代码的包，自动添加空格和缩进
- [tinytex](https://github.com/rstudio/tinytex)：安装精简版的 TeX Live以及编译 LaTeX 文档
- [DT](https://github.com/rstudio/DT)：JavaScript 库 DataTables 的 R 接口
- [mime](https://github.com/yihui/mime)：从文件名猜测 MIME 类型
- [highr](https://github.com/yihui/highr)：R 代码高亮
- [printr](https://github.com/yihui/printr)：为 knitr 提供一些自动打印方法，如将数据框自动输出为表格
- [Rd2roxygen](https://github.com/yihui/Rd2roxygen)：将R文档转化为 roxygen 注释，实现在源代码中以注释的形式写文档，方便 R 包的长期开发，同时包含一个改善 roxygen 功能的小工具 `rab()`，让包的编译更加方便高效
- [xfun](https://github.com/yihui/xfun)：我的若干零杂 R 函数
- [R2SWF](https://github.com/yihui/R2SWF)，[MSG](https://github.com/yihui/MSG)，[iBUGS](https://github.com/yihui/iBUGS)，[fun](https://github.com/yihui/fun)，[等等](http://depsy.org/person/329908)

作为贡献者：

- [rmarkdown](https://github.com/rstudio/rmarkdown): R Markdown 文档工具
- [shiny](https://github.com/rstudio/shiny)：基于 R 的网络应用
- [evaluate](https://github.com/hadley/evaluate)：解析、运行 R 代码
- [htmlwidgets](https://github.com/ramnathv/htmlwidgets)：基于 R 的 HTML 控件
- [leaflet](https://github.com/rstudio/leaflet)：交互式地图
- [htmltools](https://github.com/rstudio/htmltools)：HTML 工具
- [roxygen2](https://github.com/klutometis/roxygen)：在源文件中直接写 R 文档
- [tikzDevice](https://github.com/yihui/tikzDevice)：将 R 图形输出为 LaTeX / TikZ 格式
- [cranvas](https://github.com/ggobi/cranvas/)：基于 Qt 和 R 的交互式统计图形包（基本已经停止维护）

### PHP 程序

- 维基系统 Dokuwiki 插件 [animation](http://www.dokuwiki.org/plugin:animation)：在维基页面中嵌入动画
- Wordpress 插件 [UTF-8 DB Converter](http://wordpress.org/extend/plugins/utf-8-db-converter/)

### 其它

- LyX 中的 Sweave 和 knitr 模块
- Hugo 主题 [XMin](https://xmin.yihui.org)、[XMag](https://xmag.yihui.org)、[Ivy](https://ivy.yihui.org)、[Paged](https://paged.yihui.org)
- [TinyTeX](/tinytex/)，精简版的 TeX Live
