# 4.0.1

## Bugfix

- Together too long input error inappropriate handling fixed (now it suggests to truncate input to proceed).

## 4.0.0 Features

Well, you know all of them:

1. Dedicated history and assistant settings instances for projects.
2. Multiple files selection to send to a server as a context of a request.
3. Tokens [approximate] calculation.
4. Tab presentation of a chat and all the features coming along with it for free:
    - a text search, 
    - symbols fast navigation panel 
    - a `super+s` chat saving saving
    - view presentation setup options (see in Default Settings for details).
5. Ability to seamlessly mix different service providers within a single session, e.g. seamlessly switching from `gpt-4-turbo` to `llama-3-8b` running locally for a one request and back for another.

## Claim

This is a really huge update. So is you're happy with it, this is the place and time to [donate me](https://github.com/sponsors/yaroslavyaroslav). 

## Breaking changes

`output.OpenAI Chat` renamed to `output.AI Chat`, please update your output panel binding to handle this change.

## Details

### Dedicated history and settings

This is it, you can set up to treat a given project separately, thus give it an abilities of a dedicated chat history and settings/model. To make it even more exiting — you can use entirely different llm providers for a different projects.

To set things up you, please follow the manual in [Readme](https://github.com/yaroslavyaroslav/OpenAI-sublime-text?tab=readme-ov-file#chat-history-management)

### Multiple files selection

Now you can send whole files to a server. UX for that is not that straightforward and I wanted to, but this is what we're working with 💁🏻‍♂️.

So basically you have to make active all the tabs that you want to append to a request and run `[New Message|Chat Model] with Sheets` command. It looks quite wired with more than 4 tabs selected in the meantime, but it's still convenient in some way, means you're able to preview the content of each file to be sent beforehand.

Pay attention, it should be exact Tab, and all of those tabs should be places within a single Group.

To see detailed example, please follow the manual in [Readme](https://github.com/yaroslavyaroslav/OpenAI-sublime-text?tab=readme-ov-file#additional-request-context-management)

### Tokens [approximate] calculation

Finally! The author have studied calculus and now he's able to divide a number by 4. Such a science!

Jokes aside, this implementation is quite raw, but it's still brings the knowledge of how much you've sent to a server already during the session, and to estimate how much you will send there with a very next request (hint: it's a left value).

This feature comes really useful when you're working with expensive models like GPT-4, believe me, I've implemented this when I spent 40$ for a few days on it by blindingly selecting bunch of big files and sending them to a server.

The tokens amounts shows automatically when `AI Chat` tab is active and hidden otherwise.

### Tab representation of chat

Output panel capabilities is limited in ST, it has lack of navigation within its content. So now you can switch to a tab, to get for free all the power that ordinary ST tab has. Full text search, heading navigation, one keystroke chat saving. 

To achieve that type "Open in Tab" in command palette and that's it. I strictly recommend you to use it in a separate view group (as it's on the main screenshot in repo) to get the best of it, but you're not forced to.

There are new bunch of presentation settings have appeared because of this, to maximize the content space and to reduce all unnecessary stuff. In short you can toggle of lines number display and the whole gutter itself. For more details please look into default settings documentation.

### Hot model with a chat switching

It's as simple as powerful. You are able to change models and even services on the fly. You can start your chat with `gpt-4-turbo` model, then to switch to your local llama3 instance, then to whatever third-party service, than back to `gpt-4-turbo`.

And you can achieve that in a straightforward and convenient way: simply by picking another predefined model from the `"OpenAI: Chat Model Select"` over and over again.

> [!IMPORTANT] 
> If have so much time to read that far, you certainly too reach and careless, thus have to [donate me](https://github.com/sponsors/yaroslavyaroslav).
