# 3.1.0

> Give it a star on GitHub, share a tweet or post on Reddit about this plugin if you find it useful. It really matters to me. https://github.com/yaroslavyaroslav/OpenAI-sublime-text

## Features

- Cancellation of a pending task handler implemented
- Multi-selection within a single view is now supported
- File scope where selection has been performed now reflected in dialog history by wrapping selected text with appropriate language name (e.g. ```python)
- Tests added

## Bugfixes

- Due to suboptimal message order in a request, OpenAI occasionally responded incorrectly to requests that included complex system instructions.

> I've started to deploy beta releases of this plugin. You're welcome to join pre-release chanel by adding the following code to the `Package Control.sublime-settings` `"install_prereleases": ["OpenAI Completion"],`

### Pending task cancelation

It is what it is. You're hitting `ctrl+c` while OpenAI is prompting a thing you don't want to follow, and it stops. Pure magic. One of those features that make you wonder how you ever managed without it? 

### Multiselection support

Previously, the plugin was capable of sending only a single selected bunch to OpenAI, now it will join all of your selection within a single view (e.g. file). Multi-tab selection support is not so far in the future.

### File scope extraction support

Each selection that is now performed is wrapped in an appropriate scope in both the chat history and the output panel. This means that each selected code is now formatted as the output has long been. For example, if you're selecting code within a `*.py` file, your selection would look as follows:

```python
# code_that_has_been_selected
```

The scope is automatically extracted from ST for any supported language by the editor.

### Tests added

> It's just my whining down below; you could skip it with no harm.

This is a big deal for this project for many reasons:

1. The more I work on this, the more I hate Python as a language from the depths of my heart for its implicitness rather than explicitness and its fail-silently nature. Testing helps to lessen this a bit.
2. ST adds an additional layer of difficulty, as it is poorly documented and uses solutions that are far from straightforward, with a relatively small community on top of that. As a result, it is not that easy to understand how things work and their limits, and therefore to make tests work at all.
3. The bigger the project appears, the more things you'd break occasionally. So it was close to impossible to enhance this plugin further without tests.
