# 2.5.2

Nothing special, just a highlight that OpanAI just released new a way cheaper[^1] GPT-4 model with 128k context window capacity. 

It could be reached by the `gpt-4-1106-preview` name by any paid developer (I believe the wast majority of you are among them).

[^1]: They claimed 3x drop on input tokens and 2x on generated one. Full release is here to explore: https://openai.com/blog/new-models-and-developer-products-announced-at-devday

Please spread a word about this plug-in in any way you want, if you find it useful. It really drives me a lot to pushing it even further.

# 2.5.0

## Features

- The user selected text capture as an input for a chat request,
- Selection Panel for Assistants,
- Settings for multi-assistant,
- Status bar state of a currently used assistant,
- Manipulating the content of the main buffer (an editor view) - including appending, replacing, and editing, and passing to general GPT chat - in an instructive manner.

> This is a substantial release, folks, which required a significant amount of effort to implement. So give me a star on gh, shot a tweet and whatever other promotion to help spread the word are really appreciated.

## The user selected text capture as an input for a chat request

This scenario is straightforward. 

1. If a user selects text in a view AND
2. The assistant's `prompt_mode` setting is set to `panel` AND
3. The user triggers either the `OpenAI: New Message` or `OpenAI: Chat Model Select` command,

This thing is a killer — I can't imagine how I lived without it.

> Tip: You can skip the message via the Sublime Text input panel to pass only the selected text to the assistant system prompt (e.g., "You are the best English corrector").

## Selection Panel for Assistants

The new `openai_panel` command is a feature that users can either bind to a hotkey or access from the command palette by typing `OpenAI: Chat Model Select`.

Upon activation, it displays all predefined assistant setups for the user to choose from. Although this feature is quite useful in itself, significantly improving user workflows, it also serves as a foundation for a future release that will enable users to manage multiple chat history instances.

## Settings for multi-assistant

This point directly follows from the prior one: assistant settings (like the model used, its output style, its "role", etc.) are now contained within an array of objects. These all appear within the list displayed by the command mentioned earlier. This design has flexibility and usability in mind, meaning there are as few **required** fields as possible. Any fields that are not included in a preset will be fetched from the default settings. The complete list of assistant settings can be found in the default plugin settings.

## Status bar state of a currently used assistant

It's quite simple and straightforward. What is presented in the status bar is the information about the last used model and its setup. There are three items to be displayed:

- The name of the assistant,
- The method of prompting (whether it will append, insert, replace, or use a panel),
- The name of the model (e.g., gpt-4). 

Further details can be found in the plugin settings.

## Manipulating the content of the main buffer (an editor view)

Over the summer, OpenAI announced that all APIs, except for `/chat/completion`, will become obsolete by 04.01.2024[^1]. They further assured that these capabilities would be integrated into the `gpt-3.5-turbo`[^2] and `gpt-4` models before that deadline. The deprecated APIs are currently responsible for features like `OpenAI: Complete`, `OpenAI: Insert`, and `OpenAI: Edit`, which were the only commands that interacts with a user's open document.

Currently, we're in a transitional phase since until 04.01.2024, both the deprecated commands and their newer equivalents based on chat models are available. The former will become obsolete on 04.01.2024, or slightly earlier, depending on my personal schedule.  Meanwhile, the latter will continue to live long and prosper.

> Please consider transitioning to the new plugin mechanics sooner rather than later to avoid being unpleasantly surprised when the old ones are removed.

Let's finally focus on the three modes:

- **Append** (formerly known as **Complete**) — This mode adds text starting from a newline to a block of text selected by the user in the same view.
- **Replace** (formerly known as **Edit**) — This mode replaces the text selected by the user with a model's output in the same view.
- **Insert** (formerly known as **Insert**) — In this mode, it replaces a predefined placeholder in the user-selected text with the model's prompt.

The user flow should be straightforward, but let's mention a few general aspects:

- All these aspects are designed to work with a user-selected text. Thus, if there's none - magic wouldn't happen.
- Instructions (i.e., commands) to the model regarding what to do are passed by setting the `assistant_role` field, NOT by typing into the ST input panel.
- User input into the ST input panel can be bypassed. However, it can provide additional context to the model (e.g., (1) selecting a function, (2) setting `assistant_role` to "best ever Python assistant", (3) prompting "Provide me with a docstring for this function").
- None of these use chat history in any way, which should make it more cost-effective, especially with `gpt-4`.


[^1]: [source](https://openai.com/blog/gpt-4-api-general-availability), USA folks, behold, it's 4th January.
[^2]: Currently, it's far from being perfect at following instructions — it's quite verbose and operates more like a chat interface rather than a tool. However, `gpt-4` performs quite well in this regard.