# Libraries

Take a look at some of the libraries that our community has built. Edit this page on GitHub to list your libraries or plugins.

## General

 * [fumble](https://github.com/yahoo/fumble) - Simple error objects in node. Created specifically to be used with the [fetchr](https://github.com/yahoo/fetchr) library and based on [hapi.js](http://hapijs.com/)' [Boom](https://github.com/hapijs/boom).

 * [fluxible-plugin-service-proxy](https://github.com/benbria/node-fluxible-plugin-service-proxy) - Fluxible plugin for registering services with different implementations on the server and the client.

 * [fluxible-plugin-facebook](https://github.com/Hairfie/fluxible-plugin-facebook) - Fluxible plugin for integrating the facebook's official SDK in fluxible applications.

 * [fluxible-plugin-cookie](https://github.com/Hairfie/fluxible-plugin-cookie) - Fluxible plugin for writing and reading cookies.
 
 * [fluxible-plugin-middleware](https://github.com/geekyme/fluxible-plugin-middleware) - Fluxible plugin for adding middlewares in Redux style!
 
## Data Services

 * [fluxible-plugin-fetchr](https://github.com/yahoo/fluxible/blob/master/packages/fluxible-plugin-fetchr) - Isomorphic data fetching services.
 
## Routing

 * [fluxible-router](https://github.com/yahoo/blob/master/packages/fluxible-router) - Flux-based routing using Fluxible.
 * [react-router](https://github.com/rackt/react-router) - React-centric routing.

## Actions

 * [fluxible-action-utils](https://github.com/yahoo/fluxible-action-utils) - utility methods to aid in writing [actions](https://github.com/yahoo/fluxible/blob/main/packages/fluxible/docs/api/Actions.md#action-context) for Fluxible based applications.
 * [fluxible-plugin-actions](https://github.com/gingur/fluxible-plugin-actions) - component context utility to get actions by key instead of path, useful for cross library components.

## Immutable.js

 * [fluxible-immutable-store](https://www.npmjs.com/packages/fluxible-immutable-store) - A helper for creating Fluxible/Dispatchr BaseStores that manage immutable data structures.
 * [fluxible-immutable-utils](https://github.com/yahoo/fluxible-immutable-utils) - A mixin that provides a convenient interface for using Immutable.js inside react components.
