/****************************************************************************
 ** @license
 ** This demo file is part of yFiles for HTML 2.6.
 ** Copyright (c) 2000-2024 by yWorks GmbH, Vor dem Kreuzberg 28,
 ** 72070 Tuebingen, Germany. All rights reserved.
 **
 ** yFiles demo files exhibit yFiles for HTML functionalities. Any redistribution
 ** of demo files in source code or binary form, with or without
 ** modification, is not permitted.
 **
 ** Owners of a valid software license for a yFiles for HTML version that this
 ** demo is shipped with are allowed to use the demo source code as basis
 ** for their own yFiles for HTML powered applications. Use of such programs is
 ** governed by the rights and conditions as set out in the yFiles for HTML
 ** license agreement.
 **
 ** THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESS OR IMPLIED
 ** WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 ** MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 ** NO EVENT SHALL yWorks BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 ** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 ** TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 ** PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 ** LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 ***************************************************************************/
export const SampleCircle = {
  nodes: [
    {
      id: 0,
      layout: {
        x: 10.272357263965546,
        y: 322.45904280880467,
        width: 30,
        height: 30
      }
    },
    {
      id: 1,
      layout: {
        x: 419.6635052746882,
        y: 442.66712983920524,
        width: 30,
        height: 30
      }
    },
    {
      id: 2,
      layout: {
        x: 466.9316854507497,
        y: 388.1167419523914,
        width: 30,
        height: 30
      }
    },
    {
      id: 3,
      layout: {
        x: 289.6847084009096,
        y: 502.02645742337427,
        width: 30,
        height: 30
      }
    },
    {
      id: 4,
      layout: {
        x: 217.50420081223666,
        y: 502.02645742337427,
        width: 30,
        height: 30
      }
    },
    {
      id: 5,
      layout: {
        x: 0,
        y: 251.01322871168693,
        width: 30,
        height: 30
      }
    },
    {
      id: 6,
      layout: {
        x: 358.94139826416915,
        y: 481.6908584663053,
        width: 30,
        height: 30
      }
    },
    {
      id: 7,
      layout: {
        x: 87.52540393845817,
        y: 442.667129839205,
        width: 30,
        height: 30
      }
    },
    {
      id: 8,
      layout: {
        x: 87.52540393845848,
        y: 59.35932758416905,
        width: 30,
        height: 30
      }
    },
    {
      id: 9,
      layout: {
        x: 148.24751094897738,
        y: 20.33559895706898,
        width: 30,
        height: 30
      }
    },
    {
      id: 10,
      layout: {
        x: 148.2475109489771,
        y: 481.69085846630514,
        width: 30,
        height: 30
      }
    },
    {
      id: 11,
      layout: {
        x: 358.94139826416915,
        y: 20.335598957068953,
        width: 30,
        height: 30
      }
    },
    {
      id: 12,
      layout: {
        x: 419.6635052746881,
        y: 59.359327584168966,
        width: 30,
        height: 30
      }
    },
    {
      id: 13,
      layout: {
        x: 496.916551949181,
        y: 179.56741461456912,
        width: 30,
        height: 30
      }
    },
    {
      id: 14,
      layout: {
        x: 217.50420081223686,
        y: 0,
        width: 30,
        height: 30
      }
    },
    {
      id: 15,
      layout: {
        x: 289.6847084009097,
        y: 0,
        width: 30,
        height: 30
      }
    },
    {
      id: 16,
      layout: {
        x: 466.9316854507496,
        y: 113.90971547098275,
        width: 30,
        height: 30
      }
    },
    {
      id: 17,
      layout: {
        x: 507.18890921314664,
        y: 251.01322871168713,
        width: 30,
        height: 30
      }
    },
    {
      id: 18,
      layout: {
        x: 496.91655194918104,
        y: 322.45904280880495,
        width: 30,
        height: 30
      }
    },
    {
      id: 19,
      layout: {
        x: 40.25722376239696,
        y: 113.90971547098283,
        width: 30,
        height: 30
      }
    },
    {
      id: 20,
      layout: {
        x: 10.27235726396566,
        y: 179.5674146145692,
        width: 30,
        height: 30
      }
    },
    {
      id: 21,
      layout: {
        x: 40.25722376239676,
        y: 388.1167419523911,
        width: 30,
        height: 30
      }
    }
  ],
  edges: [
    {
      id: 0,
      source: 3,
      target: 6,
      sourcePort: {
        x: 304.6847084009096,
        y: 517.0264574233743
      },
      targetPort: {
        x: 373.94139826416915,
        y: 496.6908584663053
      },
      bends: [
        {
          x: 323.12200386803585,
          y: 496.0371812758011
        },
        {
          x: 371.9695754214566,
          y: 425.2615584370815
        }
      ]
    },
    {
      id: 1,
      source: 1,
      target: 2,
      sourcePort: {
        x: 434.6635052746882,
        y: 457.66712983920524
      },
      targetPort: {
        x: 481.9316854507497,
        y: 403.1167419523914
      },
      bends: [
        {
          x: 389.000242024879,
          y: 418.4542489021803
        },
        {
          x: 450.31646846773793,
          y: 411.23353157742423
        }
      ]
    },
    {
      id: 2,
      source: 5,
      target: 7,
      sourcePort: {
        x: 15,
        y: 266.0132287116869
      },
      targetPort: {
        x: 102.52540393845817,
        y: 457.667129839205
      },
      bends: [
        {
          x: 30.050531702067502,
          y: 278.87822454165143
        },
        {
          x: 56.03893483334261,
          y: 302.3359027238381
        },
        {
          x: 73.84272172352323,
          y: 313.2218592029702
        },
        {
          x: 98.82705902166305,
          y: 328.49829506266434
        },
        {
          x: 125.32394622371606,
          y: 341.1986303751962
        },
        {
          x: 150.34921191554025,
          y: 356.4079262121565
        },
        {
          x: 161.66630376749046,
          y: 363.28597498534486
        },
        {
          x: 169.6349289265898,
          y: 376.85298924911615
        },
        {
          x: 171.7442885464156,
          y: 389.6776235932855
        },
        {
          x: 178.8256837052674,
          y: 432.7315925349813
        },
        {
          x: 133.7798182039453,
          y: 445.96710137479056
        }
      ]
    },
    {
      id: 3,
      source: 8,
      target: 9,
      sourcePort: {
        x: 102.52540393845848,
        y: 74.35932758416905
      },
      targetPort: {
        x: 163.24751094897738,
        y: 35.33559895706898
      },
      bends: [
        {
          x: 142.37531545707287,
          y: 96.20730650973135
        },
        {
          x: 157.1955152234769,
          y: 75.57748985673891
        }
      ]
    },
    {
      id: 4,
      source: 10,
      target: 11,
      sourcePort: {
        x: 163.2475109489771,
        y: 496.69085846630514
      },
      targetPort: {
        x: 373.94139826416915,
        y: 35.33559895706895
      },
      bends: [
        {
          x: 176.54896641662228,
          y: 475.1486121515982
        },
        {
          x: 188.37534452280258,
          y: 456.1782798192804
        },
        {
          x: 191.0179898719045,
          y: 430.4539252789619
        },
        {
          x: 192.87771293369366,
          y: 412.35078654166216
        },
        {
          x: 190.62824250816539,
          y: 388.96219763275104
        },
        {
          x: 198.52013166841567,
          y: 371.052230018025
        },
        {
          x: 211.54473720030893,
          y: 341.4940014957946
        },
        {
          x: 244.7458576012991,
          y: 328.98380140837395
        },
        {
          x: 260.2852362463164,
          y: 301.70325955298676
        },
        {
          x: 273.39712802489817,
          y: 278.6843525142808
        },
        {
          x: 272.2296422572775,
          y: 251.82704520778236
        },
        {
          x: 283.80487430475796,
          y: 228.45599692143242
        },
        {
          x: 294.5520363081117,
          y: 206.75686889606573
        },
        {
          x: 314.02460563721934,
          y: 191.11166139416804
        },
        {
          x: 324.61094172053475,
          y: 169.23436009550818
        },
        {
          x: 338.00265505920186,
          y: 141.55957768641338
        },
        {
          x: 318.47954534665655,
          y: 110.29298435599452
        },
        {
          x: 326.84084720964745,
          y: 81.03748823015792
        },
        {
          x: 332.6712844148544,
          y: 60.63727593500565
        },
        {
          x: 360.4194147974724,
          y: 45.49677090320915
        }
      ]
    },
    {
      id: 5,
      source: 12,
      target: 13,
      sourcePort: {
        x: 434.6635052746881,
        y: 74.35932758416897
      },
      targetPort: {
        x: 511.916551949181,
        y: 194.56741461456912
      },
      bends: [
        {
          x: 432.0244930051382,
          y: 133.97551475411626
        },
        {
          x: 461.1684759430493,
          y: 167.24896714897832
        }
      ]
    },
    {
      id: 6,
      source: 14,
      target: 15,
      sourcePort: {
        x: 232.50420081223686,
        y: 15
      },
      targetPort: {
        x: 304.6847084009097,
        y: 15
      },
      bends: [
        {
          x: 260.2320271342854,
          y: 43.06984149708805
        },
        {
          x: 285.8679085679116,
          y: 57.93239166089214
        }
      ]
    },
    {
      id: 7,
      source: 15,
      target: 11,
      sourcePort: {
        x: 304.6847084009097,
        y: 15
      },
      targetPort: {
        x: 373.94139826416915,
        y: 35.33559895706895
      },
      bends: [
        {
          x: 293.9264671439063,
          y: 71.44792600711779
        },
        {
          x: 341.51908115046535,
          y: 46.99372892448994
        }
      ]
    },
    {
      id: 8,
      source: 19,
      target: 5,
      sourcePort: {
        x: 55.25722376239696,
        y: 128.90971547098283
      },
      targetPort: {
        x: 15,
        y: 266.0132287116869
      },
      bends: [
        {
          x: 65.1183878587413,
          y: 146.0903961533678
        },
        {
          x: 75.93224508816436,
          y: 172.17363469177934
        },
        {
          x: 95.35732316309546,
          y: 182.70349278044426
        },
        {
          x: 136.15279851353517,
          y: 204.81771875383367
        },
        {
          x: 200.32138600208813,
          y: 189.52293167304762
        },
        {
          x: 232.12104290279697,
          y: 231.70067807875625
        },
        {
          x: 268.90147764987904,
          y: 280.4847217021817
        },
        {
          x: 223.70217243845826,
          y: 313.90484417943424
        },
        {
          x: 178.26045739785326,
          y: 322.15433716384155
        },
        {
          x: 118.79372851124492,
          y: 332.94993240749324
        },
        {
          x: 62.9449716918775,
          y: 294.9665130165145
        }
      ]
    },
    {
      id: 9,
      source: 4,
      target: 5,
      sourcePort: {
        x: 232.50420081223666,
        y: 517.0264574233743
      },
      targetPort: {
        x: 15,
        y: 266.0132287116869
      },
      bends: [
        {
          x: 211.0755863919772,
          y: 469.4532967249032
        },
        {
          x: 199.71726262577738,
          y: 404.66132325888816
        },
        {
          x: 166.1333054779069,
          y: 365.9033706073011
        },
        {
          x: 127.58168761664496,
          y: 321.41243187932537
        },
        {
          x: 63.768306416668224,
          y: 297.48129878560866
        }
      ]
    },
    {
      id: 10,
      source: 21,
      target: 5,
      sourcePort: {
        x: 55.25722376239676,
        y: 403.1167419523911
      },
      targetPort: {
        x: 15,
        y: 266.0132287116869
      },
      bends: [
        {
          x: 74.6579590953059,
          y: 346.44627043037315
        },
        {
          x: 55.9353131010638,
          y: 306.8188334681097
        }
      ]
    },
    {
      id: 11,
      source: 20,
      target: 19,
      sourcePort: {
        x: 25.27235726396566,
        y: 194.5674146145692
      },
      targetPort: {
        x: 55.25722376239696,
        y: 128.90971547098283
      },
      bends: [
        {
          x: 70.7113189803712,
          y: 191.39541298675476
        },
        {
          x: 71.92285017113625,
          y: 166.03637448345498
        }
      ]
    },
    {
      id: 12,
      source: 10,
      target: 21,
      sourcePort: {
        x: 163.2475109489771,
        y: 496.69085846630514
      },
      targetPort: {
        x: 55.25722376239676,
        y: 403.1167419523911
      },
      bends: [
        {
          x: 176.10006162026065,
          y: 474.8453563360631
        },
        {
          x: 190.07588074259783,
          y: 452.4012752703045
        },
        {
          x: 187.82380826786306,
          y: 425.75503859890614
        },
        {
          x: 184.51046045779515,
          y: 386.5519263935016
        },
        {
          x: 137.20174100752016,
          y: 313.71545217989177
        },
        {
          x: 88.76092037120796,
          y: 340.8821625769709
        },
        {
          x: 68.05402092795995,
          y: 352.4950612233343
        },
        {
          x: 61.8704245411991,
          y: 383.02844823762626
        }
      ]
    },
    {
      id: 13,
      source: 11,
      target: 16,
      sourcePort: {
        x: 373.94139826416915,
        y: 35.33559895706895
      },
      targetPort: {
        x: 481.9316854507496,
        y: 128.90971547098275
      },
      bends: [
        {
          x: 351.7194009229802,
          y: 47.28317485738165
        },
        {
          x: 334.30070240126344,
          y: 52.705849197599605
        },
        {
          x: 318.28085503354094,
          y: 70.51207684564648
        },
        {
          x: 294.68718257073147,
          y: 96.73669018201977
        },
        {
          x: 324.42305150639663,
          y: 132.6431725455073
        },
        {
          x: 349.01767170749633,
          y: 144.53157307643062
        },
        {
          x: 397.7457166034176,
          y: 168.0854442106401
        },
        {
          x: 441.0469488518484,
          y: 162.02594282027854
        }
      ]
    },
    {
      id: 14,
      source: 20,
      target: 1,
      sourcePort: {
        x: 25.27235726396566,
        y: 194.5674146145692
      },
      targetPort: {
        x: 434.6635052746882,
        y: 457.66712983920524
      },
      bends: [
        {
          x: 93.22472571438539,
          y: 197.63760969071092
        },
        {
          x: 160.71188812430628,
          y: 190.38716728691907
        },
        {
          x: 221.97820716630443,
          y: 222.86343760477078
        },
        {
          x: 253.1807738460589,
          y: 239.40340615433962
        },
        {
          x: 257.65597121858656,
          y: 277.6256920888291
        },
        {
          x: 279.5197916813612,
          y: 302.7947304729382
        },
        {
          x: 298.51170495349373,
          y: 324.65770702581614
        },
        {
          x: 329.57152118722445,
          y: 332.32928496939275
        },
        {
          x: 348.05813594613306,
          y: 354.89592688210223
        },
        {
          x: 365.0817046307629,
          y: 375.67662597669056
        },
        {
          x: 363.80878990957433,
          y: 404.6389372188064
        },
        {
          x: 379.4823635275477,
          y: 426.4729284427858
        },
        {
          x: 391.4674066552736,
          y: 443.16863121281034
        },
        {
          x: 418.47183735011845,
          y: 450.71023193819934
        }
      ]
    },
    {
      id: 15,
      source: 2,
      target: 3,
      sourcePort: {
        x: 481.9316854507497,
        y: 403.1167419523914
      },
      targetPort: {
        x: 304.6847084009096,
        y: 517.0264574233743
      },
      bends: [
        {
          x: 407.64652480598124,
          y: 421.0946669426397
        },
        {
          x: 354.2266911145731,
          y: 459.54664622625785
        }
      ]
    },
    {
      id: 16,
      source: 12,
      target: 16,
      sourcePort: {
        x: 434.6635052746881,
        y: 74.35932758416897
      },
      targetPort: {
        x: 481.9316854507496,
        y: 128.90971547098275
      },
      bends: [
        {
          x: 433.5396716019763,
          y: 114.24275174448525
        },
        {
          x: 436.09012277747786,
          y: 143.48602036897475
        }
      ]
    },
    {
      id: 17,
      source: 12,
      target: 17,
      sourcePort: {
        x: 434.6635052746881,
        y: 74.35932758416897
      },
      targetPort: {
        x: 522.1889092131466,
        y: 266.01322871168713
      },
      bends: [
        {
          x: 430.31563061350096,
          y: 98.06727790697437
        },
        {
          x: 431.4572427037131,
          y: 111.52291248578803
        },
        {
          x: 419.3346712706971,
          y: 130.09839201929242
        },
        {
          x: 392.92468626115635,
          y: 170.56655001164552
        },
        {
          x: 317.3306782230506,
          y: 143.03095100495563
        },
        {
          x: 282.50479882045585,
          y: 216.2395394166352
        },
        {
          x: 238.39480415505432,
          y: 308.96456171887655
        },
        {
          x: 356.884013964501,
          y: 340.7427311420033
        },
        {
          x: 423.48448121450605,
          y: 314.6470617788114
        },
        {
          x: 450.3637976301142,
          y: 304.11509732190626
        },
        {
          x: 505.12083092136,
          y: 274.74260936268035
        }
      ]
    },
    {
      id: 18,
      source: 17,
      target: 18,
      sourcePort: {
        x: 522.1889092131466,
        y: 266.01322871168713
      },
      targetPort: {
        x: 511.91655194918104,
        y: 337.45904280880495
      },
      bends: [
        {
          x: 479.52197828699644,
          y: 281.8443599151141
        },
        {
          x: 485.6144520960744,
          y: 306.4121489915111
        }
      ]
    },
    {
      id: 19,
      source: 18,
      target: 13,
      sourcePort: {
        x: 511.91655194918104,
        y: 337.45904280880495
      },
      targetPort: {
        x: 511.916551949181,
        y: 194.56741461456912
      },
      bends: [
        {
          x: 497.76940627758654,
          y: 324.1423487863358
        },
        {
          x: 479.6414736712685,
          y: 301.3238151891963
        },
        {
          x: 457.1828595823331,
          y: 299.78557920424845
        },
        {
          x: 407.13465469512414,
          y: 296.3576762430647
        },
        {
          x: 358.913176502951,
          y: 332.4509272692985
        },
        {
          x: 310.631495175573,
          y: 299.4331310486504
        },
        {
          x: 265.1195413452453,
          y: 268.30943411307584
        },
        {
          x: 298.04706382651284,
          y: 211.33710516581226
        },
        {
          x: 334.4458115119136,
          y: 190.4045679382133
        },
        {
          x: 389.69311375153507,
          y: 158.63242509278408
        },
        {
          x: 455.04593065318386,
          y: 179.90524972802282
        }
      ]
    },
    {
      id: 20,
      source: 8,
      target: 3,
      sourcePort: {
        x: 102.52540393845848,
        y: 74.35932758416905
      },
      targetPort: {
        x: 304.6847084009096,
        y: 517.0264574233743
      },
      bends: [
        {
          x: 125.48711198345345,
          y: 92.17143990914377
        },
        {
          x: 129.82506266920763,
          y: 92.46123067950978
        },
        {
          x: 145.3339210801201,
          y: 114.2082715286285
        },
        {
          x: 160.76303854632923,
          y: 135.84349695356414
        },
        {
          x: 161.3177290507966,
          y: 164.3328252939409
        },
        {
          x: 177.76258996457096,
          y: 185.9573609251634
        },
        {
          x: 192.23699062600997,
          y: 204.99079601987464
        },
        {
          x: 216.30762107696418,
          y: 214.34768179570594
        },
        {
          x: 234.4013434750829,
          y: 229.98088798612855
        },
        {
          x: 260.5167981357045,
          y: 252.54497283737942
        },
        {
          x: 261.22805472751054,
          y: 291.6519270605553
        },
        {
          x: 289.85904404924236,
          y: 313.17795848414806
        },
        {
          x: 322.93934297077664,
          y: 338.0491756846761
        },
        {
          x: 358.8723307219529,
          y: 352.8141285880448
        },
        {
          x: 356.80537595935846,
          y: 398.91835191061585
        },
        {
          x: 354.8443643944991,
          y: 442.6594713393434
        },
        {
          x: 326.5380160373151,
          y: 481.3067866683516
        }
      ]
    },
    {
      id: 21,
      source: 4,
      target: 12,
      sourcePort: {
        x: 232.50420081223666,
        y: 517.0264574233743
      },
      targetPort: {
        x: 434.6635052746881,
        y: 74.35932758416897
      },
      bends: [
        {
          x: 217.23590696842882,
          y: 478.3038242757161
        },
        {
          x: 182.96847625697336,
          y: 417.1581125503613
        },
        {
          x: 201.87810532256742,
          y: 372.32585438599705
        },
        {
          x: 214.408450538864,
          y: 342.61804416523813
        },
        {
          x: 248.06632723322562,
          y: 330.3193837589672
        },
        {
          x: 263.5651868212064,
          y: 303.1204994223409
        },
        {
          x: 280.67438957864306,
          y: 273.0956305440988
        },
        {
          x: 276.5691517144366,
          y: 236.6965121969822
        },
        {
          x: 300.8012525892292,
          y: 210.3878305937387
        },
        {
          x: 333.0912482527722,
          y: 175.3307293018748
        },
        {
          x: 377.3625966243078,
          y: 182.28871001813235
        },
        {
          x: 414.2592369442867,
          y: 158.11638250807601
        },
        {
          x: 437.79169045445065,
          y: 142.6994185669217
        },
        {
          x: 433.4690072894068,
          y: 94.17960909619126
        }
      ]
    },
    {
      id: 22,
      source: 9,
      target: 20,
      sourcePort: {
        x: 163.24751094897738,
        y: 35.33559895706898
      },
      targetPort: {
        x: 25.27235726396566,
        y: 194.5674146145692
      },
      bends: [
        {
          x: 160.7715831653358,
          y: 65.40123984970558
        },
        {
          x: 168.24872282644256,
          y: 152.76703417293936
        },
        {
          x: 149.7374911288793,
          y: 174.13013437276817
        },
        {
          x: 136.8707381195291,
          y: 188.97915891506162
        },
        {
          x: 86.94942439730983,
          y: 182.4741477447311
        },
        {
          x: 82.697191451261,
          y: 182.98978632495164
        },
        {
          x: 63.31242413445992,
          y: 185.34044162158318
        },
        {
          x: 44.413968659730784,
          y: 190.70820518469668
        }
      ]
    },
    {
      id: 23,
      source: 7,
      target: 0,
      sourcePort: {
        x: 102.52540393845817,
        y: 457.667129839205
      },
      targetPort: {
        x: 25.272357263965546,
        y: 337.45904280880467
      },
      bends: [
        {
          x: 127.21327535346123,
          y: 452.4641748401856
        },
        {
          x: 145.4541381013462,
          y: 452.1685713839199
        },
        {
          x: 165.84166313203758,
          y: 439.59693362815665
        },
        {
          x: 195.86795344929942,
          y: 421.08170706437613
        },
        {
          x: 177.45262122465522,
          y: 378.2521271442504
        },
        {
          x: 157.20360543131477,
          y: 359.91618513351466
        },
        {
          x: 117.08528107386039,
          y: 323.58813460040676
        },
        {
          x: 73.83089416275055,
          y: 317.2028167323321
        }
      ]
    },
    {
      id: 24,
      source: 14,
      target: 13,
      sourcePort: {
        x: 232.50420081223686,
        y: 15
      },
      targetPort: {
        x: 511.916551949181,
        y: 194.56741461456912
      },
      bends: [
        {
          x: 266.4677139833792,
          y: 54.60897509262725
        },
        {
          x: 295.6199541764693,
          y: 113.57640878380079
        },
        {
          x: 338.76290218449236,
          y: 141.3026979085592
        },
        {
          x: 388.28745456795235,
          y: 173.13019513713755
        },
        {
          x: 456.258124766518,
          y: 178.1136421450262
        }
      ]
    },
    {
      id: 25,
      source: 2,
      target: 19,
      sourcePort: {
        x: 481.9316854507497,
        y: 403.1167419523914
      },
      targetPort: {
        x: 55.25722376239696,
        y: 128.90971547098283
      },
      bends: [
        {
          x: 460.7226651999492,
          y: 405.3463550792375
        },
        {
          x: 419.8582372728205,
          y: 416.41901119292964
        },
        {
          x: 398.26166000718814,
          y: 399.43497844863055
        },
        {
          x: 378.6170435115241,
          y: 383.9860114337275
        },
        {
          x: 380.7189573307305,
          y: 354.16676770058297
        },
        {
          x: 363.9912244216138,
          y: 336.032983064754
        },
        {
          x: 345.22094630313734,
          y: 315.684966821049
        },
        {
          x: 313.69004625380563,
          y: 314.4514803131614
        },
        {
          x: 294.2080170957871,
          y: 295.40295936042037
        },
        {
          x: 269.1276696636213,
          y: 270.880692214187
        },
        {
          x: 265.4558184051762,
          y: 234.9859399057447
        },
        {
          x: 237.642544699312,
          y: 211.98482525251075
        },
        {
          x: 173.2287555660538,
          y: 158.71569322685764
        },
        {
          x: 127.33435931629731,
          y: 200.48424215979458
        }
      ]
    }
  ]
}

export const SampleLabels = {
  nodes: [
    { id: 0, layout: { x: -15, y: -15, width: 30, height: 30 } },
    { id: 1, layout: { x: 585, y: -15, width: 30, height: 30 } },
    { id: 2, layout: { x: -15, y: 285, width: 30, height: 30 } },
    { id: 3, layout: { x: 585, y: 285, width: 30, height: 30 } }
  ],
  edges: [
    {
      id: 0,
      source: 0,
      target: 1,
      sourcePort: { x: 0, y: 0 },
      targetPort: { x: 600, y: 0 },
      bends: [
        { x: 100, y: 100 },
        { x: 200, y: 100 },
        { x: 300, y: 0 },
        { x: 400, y: -100 },
        { x: 500, y: -100 }
      ],
      labels: [
        {
          text: 'First from Source\nRight of Edge',
          model: 'segment',
          fromSource: true,
          segmentIndex: 0,
          segmentRatio: 0.2,
          distance: 20
        },
        {
          text: 'Second From Source\nOn Edge',
          model: 'segment',
          fromSource: true,
          segmentIndex: 1,
          segmentRatio: 0.2,
          distance: 0
        },
        {
          text: 'First From Target\nLeft of Edge',
          model: 'segment',
          fromSource: false,
          segmentIndex: 0,
          segmentRatio: 0.2,
          distance: -20
        },
        {
          text: 'Second From Target\nOn Edge',
          model: 'segment',
          fromSource: false,
          segmentIndex: 1,
          segmentRatio: 0.2,
          distance: 0
        }
      ]
    },
    {
      id: 1,
      source: 2,
      target: 3,
      sourcePort: { x: 0, y: 300 },
      targetPort: { x: 600, y: 300 },
      bends: [
        { x: 100, y: 400 },
        { x: 200, y: 400 },
        { x: 300, y: 300 },
        { x: 400, y: 200 },
        { x: 500, y: 200 }
      ],
      labels: [
        {
          text: 'Bezier Ratio 0.5',
          model: 'path',
          ratio: 0.5,
          distance: 20
        },
        {
          text: 'Bezier Ratio 0.9',
          model: 'path',
          ratio: 0.9,
          distance: 0
        },
        {
          text: 'Bezier Ratio 0.1',
          model: 'path',
          ratio: 0.1,
          distance: 0
        }
      ]
    }
  ]
}
