/****************************************************************************
 ** @license
 ** This demo file is part of yFiles for HTML 2.6.
 ** Copyright (c) 2000-2024 by yWorks GmbH, Vor dem Kreuzberg 28,
 ** 72070 Tuebingen, Germany. All rights reserved.
 **
 ** yFiles demo files exhibit yFiles for HTML functionalities. Any redistribution
 ** of demo files in source code or binary form, with or without
 ** modification, is not permitted.
 **
 ** Owners of a valid software license for a yFiles for HTML version that this
 ** demo is shipped with are allowed to use the demo source code as basis
 ** for their own yFiles for HTML powered applications. Use of such programs is
 ** governed by the rights and conditions as set out in the yFiles for HTML
 ** license agreement.
 **
 ** THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESS OR IMPLIED
 ** WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 ** MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 ** NO EVENT SHALL yWorks BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 ** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 ** TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 ** PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 ** LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 ***************************************************************************/
/**
 * @typedef {number} NodeId
 */

/**
 * @typedef {Object} NodeObject
 * @property {Array.<number>} loadHistory
 * @property {string} name
 * @property {string} ip
 * @property {boolean} enabled
 * @property {number} type
 * @property {number} load
 * @property {NodeId} id
 */

/**
 * @typedef {Object} EdgeObject
 * @property {NodeId} source
 * @property {NodeId} target
 */

/**
 * @typedef {Object} NetworkData
 * @property {Array.<NodeObject>} nodeList
 * @property {Array.<EdgeObject>} edgeList
 */

export const networkData = {
  nodeList: [
    {
      loadHistory: [
        0.75, 0.717, 0.685, 0.685, 0.685, 0.641, 0.63, 0.652, 0.663, 0.674, 0.652, 0.63, 0.641,
        0.641, 0.62
      ],
      name: 'Switch 660',
      ip: '126.135.166.10',
      enabled: true,
      type: 4,
      load: 0.62,
      id: 0
    },
    {
      loadHistory: [
        0.617, 0.609, 0.583, 0.565, 0.548, 0.522, 0.504, 0.496, 0.487, 0.478, 0.452, 0.435, 0.435,
        0.417, 0.4
      ],
      name: 'Switch 185',
      ip: '87.113.9.193',
      enabled: true,
      type: 4,
      load: 0.4,
      id: 1
    },
    {
      loadHistory: [
        0.638, 0.638, 0.638, 0.623, 0.623, 0.652, 0.638, 0.638, 0.681, 0.696, 0.681, 0.667, 0.667,
        0.667, 0.667
      ],
      name: 'Switch 381',
      ip: '116.244.172.206',
      enabled: true,
      type: 4,
      load: 0.667,
      id: 2
    },
    {
      loadHistory: [
        1, 1, 1, 1, 0.971, 0.928, 0.942, 0.942, 0.928, 0.899, 0.87, 0.87, 0.884, 0.899, 0.899
      ],
      name: 'Switch 610',
      ip: '210.185.188.168',
      enabled: true,
      type: 4,
      load: 0.899,
      id: 3
    },
    {
      loadHistory: [0.939, 0.983, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
      name: 'Switch 570',
      ip: '175.134.47.248',
      enabled: true,
      type: 4,
      load: 1,
      id: 4
    },
    {
      loadHistory: [
        0.536, 0.536, 0.522, 0.464, 0.406, 0.377, 0.377, 0.377, 0.377, 0.377, 0.391, 0.391, 0.362,
        0.348, 0.348
      ],
      name: 'Switch 191',
      ip: '248.211.164.103',
      enabled: true,
      type: 4,
      load: 0.348,
      id: 5
    },
    {
      loadHistory: [
        0.593, 0.597, 0.589, 0.597, 0.613, 0.621, 0.636, 0.652, 0.66, 0.656, 0.652, 0.652, 0.668,
        0.676, 0.672
      ],
      name: 'Switch 752',
      ip: '158.213.12.149',
      enabled: true,
      type: 4,
      load: 0.672,
      id: 6
    },
    {
      loadHistory: [
        0.598, 0.576, 0.576, 0.576, 0.576, 0.587, 0.587, 0.609, 0.62, 0.609, 0.62, 0.62, 0.587,
        0.576, 0.565
      ],
      name: 'Switch 937',
      ip: '235.8.77.84',
      enabled: true,
      type: 4,
      load: 0.565,
      id: 7
    },
    {
      loadHistory: [
        0.88, 0.935, 0.935, 0.88, 0.859, 0.902, 0.957, 0.978, 0.967, 0.957, 0.957, 0.935, 0.913,
        0.913, 0.957
      ],
      name: 'Switch 779',
      ip: '253.85.74.217',
      enabled: true,
      type: 4,
      load: 0.957,
      id: 8
    },
    {
      loadHistory: [
        0.87, 0.793, 0.75, 0.761, 0.793, 0.772, 0.75, 0.739, 0.728, 0.75, 0.761, 0.761, 0.761,
        0.717, 0.674
      ],
      name: 'Switch 383',
      ip: '159.233.198.146',
      enabled: true,
      type: 4,
      load: 0.674,
      id: 9
    },
    {
      loadHistory: [
        0.478, 0.457, 0.457, 0.457, 0.449, 0.457, 0.449, 0.42, 0.413, 0.42, 0.449, 0.471, 0.464,
        0.471, 0.486
      ],
      name: 'Switch 845',
      ip: '249.7.47.126',
      enabled: true,
      type: 4,
      load: 0.486,
      id: 10
    },
    {
      loadHistory: [
        0.13, 0.137, 0.124, 0.118, 0.118, 0.106, 0.106, 0.099, 0.093, 0.087, 0.087, 0.081, 0.087,
        0.087, 0.099
      ],
      name: 'Switch 644',
      ip: '214.192.5.41',
      enabled: true,
      type: 4,
      load: 0.099,
      id: 11
    },
    {
      loadHistory: [
        0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.087, 0.087
      ],
      name: 'PC 382',
      ip: '80.22.97.136',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 12
    },
    {
      loadHistory: [
        0.087, 0.087, 0.043, 0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.13, 0.087, 0.087,
        0.087, 0.087
      ],
      name: 'PC 285',
      ip: '193.202.112.62',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 13
    },
    {
      loadHistory: [0.13, 0.13, 0.13, 0.13, 0.13, 0.087, 0.087, 0.087, 0.087, 0.043, 0, 0, 0, 0, 0],
      name: 'PC 256',
      ip: '56.204.180.137',
      enabled: true,
      type: 1,
      load: 0,
      id: 14
    },
    {
      loadHistory: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      name: 'PC 421',
      ip: '171.106.43.136',
      enabled: true,
      type: 1,
      load: 0,
      id: 15
    },
    {
      loadHistory: [
        0.106, 0.106, 0.099, 0.099, 0.093, 0.093, 0.093, 0.106, 0.093, 0.087, 0.093, 0.106, 0.112,
        0.124, 0.124
      ],
      name: 'Switch 265',
      ip: '26.181.123.54',
      enabled: true,
      type: 4,
      load: 0.124,
      id: 16
    },
    {
      loadHistory: [
        0.087, 0.087, 0.043, 0.043, 0, 0, 0, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087
      ],
      name: 'PC 534',
      ip: '224.112.167.32',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 17
    },
    {
      loadHistory: [
        0.087, 0.087, 0.087, 0.087, 0.087, 0.13, 0.13, 0.13, 0.087, 0.087, 0.087, 0.13, 0.13, 0.13,
        0.13
      ],
      name: 'PC 504',
      ip: '172.164.44.74',
      enabled: true,
      type: 1,
      load: 0.13,
      id: 18
    },
    {
      loadHistory: [0.043, 0.043, 0.043, 0.043, 0.043, 0, 0, 0, 0, 0, 0, 0, 0, 0.043, 0.043],
      name: 'PC 768',
      ip: '207.228.232.9',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 19
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.087,
        0.087, 0.087
      ],
      name: 'PC 526',
      ip: '154.139.131.212',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 20
    },
    {
      loadHistory: [
        0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.043, 0.043
      ],
      name: 'PC 772',
      ip: '48.16.215.69',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 21
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.043, 0.043
      ],
      name: 'PC 723',
      ip: '142.70.165.85',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 22
    },
    {
      loadHistory: [
        0.104, 0.096, 0.096, 0.096, 0.096, 0.096, 0.1, 0.078, 0.061, 0.065, 0.074, 0.07, 0.07,
        0.065, 0.061
      ],
      name: 'W-LAN 693',
      ip: '177.54.64.205',
      enabled: true,
      type: 5,
      load: 0.061,
      id: 23
    },
    {
      loadHistory: [
        0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.087, 0.043
      ],
      name: 'Tablet 873',
      ip: '111.50.124.210',
      enabled: true,
      type: 3,
      load: 0.043,
      id: 24
    },
    {
      loadHistory: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      name: 'Tablet 404',
      ip: '194.51.30.41',
      enabled: true,
      type: 3,
      load: 0,
      id: 25
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.087, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13,
        0.13
      ],
      name: 'Tablet 875',
      ip: '115.137.130.127',
      enabled: true,
      type: 3,
      load: 0.13,
      id: 26
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0, 0, 0, 0, 0.043, 0.087, 0.087, 0.087, 0.087
      ],
      name: 'Tablet 709',
      ip: '3.147.20.158',
      enabled: true,
      type: 3,
      load: 0.087,
      id: 27
    },
    {
      loadHistory: [0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0, 0, 0, 0, 0, 0, 0],
      name: 'Tablet 482',
      ip: '119.206.72.4',
      enabled: true,
      type: 3,
      load: 0,
      id: 28
    },
    {
      loadHistory: [
        0.13, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.043, 0.043, 0.043, 0.043, 0, 0, 0, 0
      ],
      name: 'Tablet 952',
      ip: '19.16.237.160',
      enabled: true,
      type: 3,
      load: 0,
      id: 29
    },
    {
      loadHistory: [0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      name: 'Tablet 674',
      ip: '231.201.178.177',
      enabled: true,
      type: 3,
      load: 0,
      id: 30
    },
    {
      loadHistory: [
        0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.043, 0.043
      ],
      name: 'Tablet 766',
      ip: '212.52.196.143',
      enabled: true,
      type: 3,
      load: 0.043,
      id: 31
    },
    {
      loadHistory: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      name: 'Tablet 172',
      ip: '217.31.158.17',
      enabled: true,
      type: 3,
      load: 0,
      id: 32
    },
    {
      loadHistory: [
        0.137, 0.137, 0.137, 0.137, 0.137, 0.149, 0.149, 0.155, 0.155, 0.149, 0.149, 0.149, 0.161,
        0.174, 0.18
      ],
      name: 'Switch 155',
      ip: '21.53.191.110',
      enabled: true,
      type: 4,
      load: 0.18,
      id: 33
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.087, 0.087
      ],
      name: 'PC 621',
      ip: '178.156.225.134',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 34
    },
    {
      loadHistory: [
        0.174, 0.174, 0.174, 0.174, 0.174, 0.217, 0.217, 0.174, 0.217, 0.217, 0.174, 0.174, 0.174,
        0.217, 0.217
      ],
      name: 'PC 661',
      ip: '250.59.28.21',
      enabled: true,
      type: 1,
      load: 0.217,
      id: 35
    },
    {
      loadHistory: [0, 0, 0, 0, 0, 0, 0, 0.043, 0.043, 0.043, 0.087, 0.087, 0.087, 0.13, 0.13],
      name: 'PC 740',
      ip: '203.168.108.91',
      enabled: true,
      type: 1,
      load: 0.13,
      id: 36
    },
    {
      loadHistory: [0.087, 0.087, 0.087, 0.087, 0.043, 0.043, 0.043, 0.043, 0, 0, 0, 0, 0, 0, 0],
      name: 'PC 603',
      ip: '117.49.114.91',
      enabled: true,
      type: 1,
      load: 0,
      id: 37
    },
    {
      loadHistory: [
        0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.043, 0.087
      ],
      name: 'PC 576',
      ip: '113.98.248.206',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 38
    },
    {
      loadHistory: [
        0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.13,
        0.13, 0.13
      ],
      name: 'PC 615',
      ip: '120.14.119.109',
      enabled: true,
      type: 1,
      load: 0.13,
      id: 39
    },
    {
      loadHistory: [
        0.143, 0.143, 0.13, 0.124, 0.118, 0.106, 0.093, 0.087, 0.106, 0.13, 0.137, 0.155, 0.155,
        0.149, 0.143
      ],
      name: 'W-LAN 585',
      ip: '187.159.98.76',
      enabled: true,
      type: 5,
      load: 0.143,
      id: 40
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0, 0, 0, 0.043, 0.043, 0.043, 0.087, 0.087, 0.087, 0.087
      ],
      name: 'Laptop 627',
      ip: '108.73.184.227',
      enabled: true,
      type: 2,
      load: 0.087,
      id: 41
    },
    {
      loadHistory: [
        0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.13, 0.13, 0.13, 0.13, 0.13,
        0.087
      ],
      name: 'Laptop 42',
      ip: '79.147.122.64',
      enabled: true,
      type: 2,
      load: 0.087,
      id: 42
    },
    {
      loadHistory: [
        0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.043, 0.043
      ],
      name: 'Laptop 718',
      ip: '15.143.19.79',
      enabled: true,
      type: 2,
      load: 0.043,
      id: 43
    },
    {
      loadHistory: [
        0.043, 0.087, 0.087, 0.087, 0.087, 0.043, 0.043, 0.043, 0.043, 0.043, 0.087, 0.087, 0.13,
        0.13, 0.13
      ],
      name: 'Laptop 766',
      ip: '95.68.251.214',
      enabled: true,
      type: 2,
      load: 0.13,
      id: 44
    },
    {
      loadHistory: [
        0.087, 0.087, 0.043, 0.043, 0.043, 0.043, 0.043, 0, 0, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.043
      ],
      name: 'Laptop 284',
      ip: '112.57.179.69',
      enabled: true,
      type: 2,
      load: 0.043,
      id: 45
    },
    {
      loadHistory: [
        0.13, 0.13, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.087, 0.087
      ],
      name: 'Laptop 438',
      ip: '169.76.45.134',
      enabled: true,
      type: 2,
      load: 0.087,
      id: 46
    },
    {
      loadHistory: [
        0.143, 0.136, 0.125, 0.12, 0.123, 0.123, 0.115, 0.107, 0.11, 0.113, 0.115, 0.115, 0.105,
        0.1, 0.102
      ],
      name: 'Switch 58',
      ip: '94.147.254.220',
      enabled: true,
      type: 4,
      load: 0.102,
      id: 47
    },
    {
      loadHistory: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      name: 'PC 786',
      ip: '0.175.250.84',
      enabled: true,
      type: 1,
      load: 0,
      id: 48
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.043, 0.043,
        0.043, 0.043
      ],
      name: 'PC 228',
      ip: '171.132.255.134',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 49
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.043, 0.043
      ],
      name: 'PC 547',
      ip: '245.150.167.232',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 50
    },
    {
      loadHistory: [0.13, 0.13, 0.087, 0.087, 0.087, 0.087, 0.043, 0.043, 0, 0, 0, 0, 0, 0, 0],
      name: 'PC 968',
      ip: '187.209.64.55',
      enabled: true,
      type: 1,
      load: 0,
      id: 51
    },
    {
      loadHistory: [
        0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.087, 0.087, 0.087
      ],
      name: 'PC 123',
      ip: '12.118.59.238',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 52
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.043, 0.043
      ],
      name: 'PC 699',
      ip: '90.11.188.234',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 53
    },
    {
      loadHistory: [
        0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.087, 0.087, 0.087, 0.087, 0.043, 0.043, 0.043, 0.043,
        0.043
      ],
      name: 'PC 812',
      ip: '183.154.39.225',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 54
    },
    {
      loadHistory: [
        0.13, 0.13, 0.13, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.043, 0.043
      ],
      name: 'PC 56',
      ip: '191.152.110.86',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 55
    },
    {
      loadHistory: [
        0.087, 0.065, 0.065, 0.065, 0.065, 0.065, 0.065, 0.065, 0.065, 0.065, 0.065, 0.043, 0.022,
        0.022, 0.022
      ],
      name: 'PC 659',
      ip: '45.99.145.12',
      enabled: true,
      type: 1,
      load: 0.022,
      id: 56
    },
    {
      loadHistory: [
        0.13, 0.13, 0.13, 0.087, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.043, 0.043
      ],
      name: 'PC 47',
      ip: '219.112.135.26',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 57
    },
    {
      loadHistory: [
        0.087, 0.087, 0.087, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.174, 0.217, 0.217, 0.217,
        0.217
      ],
      name: 'Tablet 196',
      ip: '26.146.216.39',
      enabled: true,
      type: 3,
      load: 0.217,
      id: 58
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.087, 0.087, 0.087, 0.13, 0.087,
        0.087, 0.087
      ],
      name: 'Tablet 988',
      ip: '7.42.121.94',
      enabled: true,
      type: 3,
      load: 0.087,
      id: 59
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.043, 0.087
      ],
      name: 'Laptop 501',
      ip: '236.224.43.15',
      enabled: true,
      type: 2,
      load: 0.087,
      id: 60
    },
    {
      loadHistory: [
        0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.043, 0.043, 0.087, 0.087, 0.087, 0.087,
        0.087, 0.087
      ],
      name: 'Laptop 921',
      ip: '34.193.177.128',
      enabled: true,
      type: 2,
      load: 0.087,
      id: 61
    },
    {
      loadHistory: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      name: 'Laptop 213',
      ip: '107.241.155.121',
      enabled: true,
      type: 2,
      load: 0,
      id: 62
    },
    {
      loadHistory: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      name: 'Laptop 407',
      ip: '120.50.208.45',
      enabled: true,
      type: 2,
      load: 0,
      id: 63
    },
    {
      loadHistory: [
        0.337, 0.342, 0.342, 0.326, 0.315, 0.315, 0.31, 0.315, 0.332, 0.353, 0.37, 0.37, 0.364,
        0.364, 0.364
      ],
      name: 'Switch 516',
      ip: '232.86.86.51',
      enabled: true,
      type: 4,
      load: 0.364,
      id: 64
    },
    {
      loadHistory: [
        0.087, 0.07, 0.07, 0.061, 0.043, 0.026, 0.017, 0.017, 0.017, 0.017, 0.017, 0.017, 0.017,
        0.017, 0.017
      ],
      name: 'W-LAN 27',
      ip: '221.246.248.52',
      enabled: true,
      type: 5,
      load: 0.017,
      id: 65
    },
    {
      loadHistory: [
        0.087, 0.087, 0.087, 0.087, 0.087, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.043, 0.043
      ],
      name: 'Laptop 392',
      ip: '201.181.59.36',
      enabled: true,
      type: 2,
      load: 0.043,
      id: 66
    },
    {
      loadHistory: [0.043, 0.043, 0.043, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      name: 'Laptop 84',
      ip: '11.215.72.154',
      enabled: true,
      type: 2,
      load: 0,
      id: 67
    },
    {
      loadHistory: [0.087, 0.043, 0.043, 0.043, 0.043, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      name: 'Tablet 619',
      ip: '45.129.50.91',
      enabled: true,
      type: 3,
      load: 0,
      id: 68
    },
    {
      loadHistory: [0.043, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      name: 'Tablet 418',
      ip: '53.71.139.100',
      enabled: true,
      type: 3,
      load: 0,
      id: 69
    },
    {
      loadHistory: [
        0.232, 0.246, 0.232, 0.232, 0.232, 0.217, 0.217, 0.217, 0.203, 0.246, 0.261, 0.261, 0.261,
        0.261, 0.261
      ],
      name: 'W-LAN 437',
      ip: '25.204.61.210',
      enabled: true,
      type: 5,
      load: 0.261,
      id: 70
    },
    {
      loadHistory: [
        0.217, 0.217, 0.217, 0.217, 0.217, 0.217, 0.174, 0.174, 0.13, 0.174, 0.174, 0.174, 0.174,
        0.174, 0.174
      ],
      name: 'PC 865',
      ip: '74.160.155.78',
      enabled: true,
      type: 1,
      load: 0.174,
      id: 71
    },
    {
      loadHistory: [
        0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.174, 0.174, 0.174, 0.217, 0.217, 0.217, 0.217,
        0.217
      ],
      name: 'PC 471',
      ip: '114.48.54.131',
      enabled: true,
      type: 1,
      load: 0.217,
      id: 72
    },
    {
      loadHistory: [
        0.348, 0.348, 0.348, 0.348, 0.391, 0.435, 0.435, 0.435, 0.435, 0.435, 0.435, 0.435, 0.435,
        0.391, 0.348
      ],
      name: 'DB 138',
      ip: '213.100.160.168',
      enabled: true,
      type: 7,
      load: 0.348,
      id: 73
    },
    {
      loadHistory: [
        0.435, 0.435, 0.478, 0.565, 0.609, 0.609, 0.609, 0.609, 0.652, 0.696, 0.696, 0.696, 0.696,
        0.739, 0.783
      ],
      name: 'Server 630',
      ip: '49.140.250.199',
      enabled: true,
      type: 6,
      load: 0.783,
      id: 74
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.087, 0.087
      ],
      name: 'PC 126',
      ip: '188.237.209.168',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 75
    },
    {
      loadHistory: [
        0.174, 0.174, 0.13, 0.13, 0.13, 0.13, 0.13, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.087
      ],
      name: 'PC 910',
      ip: '112.183.11.240',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 76
    },
    {
      loadHistory: [
        0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.13, 0.13, 0.13, 0.087, 0.087,
        0.087, 0.087
      ],
      name: 'Laptop 329',
      ip: '249.167.226.74',
      enabled: true,
      type: 2,
      load: 0.087,
      id: 77
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.087, 0.13, 0.13, 0.13, 0.13, 0.174, 0.174,
        0.174, 0.174
      ],
      name: 'Tablet 652',
      ip: '164.239.204.99',
      enabled: true,
      type: 3,
      load: 0.174,
      id: 78
    },
    {
      loadHistory: [
        0.139, 0.139, 0.13, 0.122, 0.122, 0.148, 0.148, 0.157, 0.174, 0.174, 0.183, 0.183, 0.174,
        0.183, 0.174
      ],
      name: 'W-LAN 79',
      ip: '152.205.162.149',
      enabled: true,
      type: 5,
      load: 0.174,
      id: 79
    },
    {
      loadHistory: [
        0.207, 0.217, 0.217, 0.196, 0.174, 0.152, 0.152, 0.152, 0.163, 0.163, 0.163, 0.163, 0.152,
        0.141, 0.152
      ],
      name: 'W-LAN 971',
      ip: '43.90.193.125',
      enabled: true,
      type: 5,
      load: 0.152,
      id: 80
    },
    {
      loadHistory: [
        0.087, 0.109, 0.109, 0.109, 0.087, 0.065, 0.065, 0.065, 0.065, 0.065, 0.065, 0.065, 0.065,
        0.065, 0.065
      ],
      name: 'PC 499',
      ip: '100.134.26.18',
      enabled: true,
      type: 1,
      load: 0.065,
      id: 81
    },
    {
      loadHistory: [
        0.174, 0.174, 0.174, 0.174, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.087, 0.13, 0.13, 0.13,
        0.087
      ],
      name: 'PC 557',
      ip: '51.225.223.169',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 82
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.087, 0.087, 0.043, 0.043,
        0.043, 0.087
      ],
      name: 'PC 345',
      ip: '70.221.196.69',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 83
    },
    {
      loadHistory: [
        0.087, 0.087, 0.087, 0.174, 0.261, 0.261, 0.304, 0.348, 0.348, 0.348, 0.348, 0.348, 0.348,
        0.391, 0.435
      ],
      name: 'Server 243',
      ip: '106.199.128.182',
      enabled: true,
      type: 6,
      load: 0.435,
      id: 84
    },
    {
      loadHistory: [
        0.053, 0.053, 0.058, 0.077, 0.087, 0.097, 0.106, 0.111, 0.116, 0.121, 0.126, 0.126, 0.135,
        0.14, 0.14
      ],
      name: 'W-LAN 813',
      ip: '91.182.176.83',
      enabled: true,
      type: 5,
      load: 0.14,
      id: 85
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.087, 0.087
      ],
      name: 'PC 901',
      ip: '4.213.211.48',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 86
    },
    {
      loadHistory: [
        0.087, 0.087, 0.043, 0.043, 0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.13,
        0.13, 0.13
      ],
      name: 'PC 805',
      ip: '40.211.230.60',
      enabled: true,
      type: 1,
      load: 0.13,
      id: 87
    },
    {
      loadHistory: [
        0.022, 0.022, 0.022, 0.043, 0.043, 0.043, 0.043, 0.043, 0.065, 0.065, 0.065, 0.065, 0.065,
        0.043, 0.043
      ],
      name: 'PC 659',
      ip: '219.113.69.178',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 88
    },
    {
      loadHistory: [
        0, 0.043, 0.087, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13
      ],
      name: 'PC 127',
      ip: '147.190.38.110',
      enabled: true,
      type: 1,
      load: 0.13,
      id: 89
    },
    {
      loadHistory: [
        0, 0, 0, 0, 0, 0, 0.043, 0.043, 0.043, 0.043, 0.087, 0.087, 0.087, 0.087, 0.087
      ],
      name: 'Laptop 970',
      ip: '250.237.63.244',
      enabled: true,
      type: 2,
      load: 0.087,
      id: 90
    },
    {
      loadHistory: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      name: 'Laptop 636',
      ip: '189.40.223.176',
      enabled: true,
      type: 2,
      load: 0,
      id: 91
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.087, 0.087
      ],
      name: 'Tablet 200',
      ip: '27.120.237.151',
      enabled: true,
      type: 3,
      load: 0.087,
      id: 92
    },
    {
      loadHistory: [
        0.359, 0.348, 0.353, 0.375, 0.391, 0.386, 0.38, 0.397, 0.402, 0.397, 0.391, 0.391, 0.408,
        0.408, 0.402
      ],
      name: 'Switch 594',
      ip: '129.193.230.191',
      enabled: true,
      type: 4,
      load: 0.402,
      id: 93
    },
    {
      loadHistory: [
        0.113, 0.104, 0.139, 0.13, 0.122, 0.13, 0.139, 0.157, 0.157, 0.157, 0.157, 0.157, 0.157,
        0.148, 0.139
      ],
      name: 'W-LAN 643',
      ip: '252.188.34.94',
      enabled: true,
      type: 5,
      load: 0.139,
      id: 94
    },
    {
      loadHistory: [
        0.043, 0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.087, 0.087
      ],
      name: 'Laptop 475',
      ip: '232.115.18.251',
      enabled: true,
      type: 2,
      load: 0.087,
      id: 95
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.087, 0.087
      ],
      name: 'Laptop 930',
      ip: '204.96.133.53',
      enabled: true,
      type: 2,
      load: 0.087,
      id: 96
    },
    {
      loadHistory: [
        0.043, 0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.13, 0.13, 0.13, 0.13, 0.13, 0.087, 0.13,
        0.13
      ],
      name: 'Tablet 412',
      ip: '121.54.190.204',
      enabled: true,
      type: 3,
      load: 0.13,
      id: 97
    },
    {
      loadHistory: [
        0.174, 0.13, 0.13, 0.13, 0.087, 0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.087, 0.043
      ],
      name: 'Tablet 26',
      ip: '94.153.21.198',
      enabled: true,
      type: 3,
      load: 0.043,
      id: 98
    },
    {
      loadHistory: [
        0.232, 0.217, 0.203, 0.203, 0.203, 0.188, 0.174, 0.188, 0.203, 0.159, 0.101, 0.116, 0.116,
        0.13, 0.145
      ],
      name: 'W-LAN 699',
      ip: '48.69.37.29',
      enabled: true,
      type: 5,
      load: 0.145,
      id: 99
    },
    {
      loadHistory: [
        0.217, 0.217, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.13, 0, 0, 0, 0, 0
      ],
      name: 'PC 647',
      ip: '224.136.132.206',
      enabled: true,
      type: 1,
      load: 0,
      id: 100
    },
    {
      loadHistory: [
        0.348, 0.348, 0.348, 0.391, 0.391, 0.348, 0.348, 0.348, 0.391, 0.435, 0.435, 0.478, 0.522,
        0.522, 0.522
      ],
      name: 'DB 86',
      ip: '121.69.35.57',
      enabled: true,
      type: 7,
      load: 0.522,
      id: 101
    },
    {
      loadHistory: [
        0.261, 0.261, 0.304, 0.348, 0.391, 0.478, 0.522, 0.478, 0.435, 0.435, 0.478, 0.478, 0.435,
        0.435, 0.435
      ],
      name: 'Server 221',
      ip: '237.130.242.167',
      enabled: true,
      type: 6,
      load: 0.435,
      id: 102
    },
    {
      loadHistory: [
        0.174, 0.13, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.13,
        0.13, 0.087
      ],
      name: 'PC 494',
      ip: '24.215.93.106',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 103
    },
    {
      loadHistory: [
        0, 0, 0, 0, 0.043, 0.043, 0.043, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13
      ],
      name: 'PC 989',
      ip: '96.255.241.62',
      enabled: true,
      type: 1,
      load: 0.13,
      id: 104
    },
    {
      loadHistory: [
        0.087, 0.087, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.043, 0.043
      ],
      name: 'Laptop 608',
      ip: '237.43.105.20',
      enabled: true,
      type: 2,
      load: 0.043,
      id: 105
    },
    {
      loadHistory: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      name: 'Tablet 5',
      ip: '243.100.228.228',
      enabled: true,
      type: 3,
      load: 0,
      id: 106
    },
    {
      loadHistory: [
        0.113, 0.096, 0.096, 0.096, 0.104, 0.104, 0.113, 0.139, 0.139, 0.139, 0.139, 0.13, 0.122,
        0.122, 0.113
      ],
      name: 'W-LAN 832',
      ip: '118.26.25.140',
      enabled: true,
      type: 5,
      load: 0.113,
      id: 107
    },
    {
      loadHistory: [
        0.196, 0.196, 0.196, 0.217, 0.239, 0.261, 0.261, 0.25, 0.239, 0.228, 0.217, 0.217, 0.217,
        0.207, 0.207
      ],
      name: 'W-LAN 508',
      ip: '21.12.175.66',
      enabled: true,
      type: 5,
      load: 0.207,
      id: 108
    },
    {
      loadHistory: [
        0.13, 0.13, 0.13, 0.087, 0.087, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174,
        0.174, 0.174
      ],
      name: 'PC 810',
      ip: '119.143.175.116',
      enabled: true,
      type: 1,
      load: 0.174,
      id: 109
    },
    {
      loadHistory: [
        0.217, 0.217, 0.217, 0.217, 0.217, 0.261, 0.261, 0.217, 0.217, 0.217, 0.217, 0.217, 0.217,
        0.174, 0.174
      ],
      name: 'PC 997',
      ip: '36.26.90.180',
      enabled: true,
      type: 1,
      load: 0.174,
      id: 110
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.043, 0.043, 0.043, 0.043,
        0.043, 0.087
      ],
      name: 'PC 529',
      ip: '30.120.243.154',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 111
    },
    {
      loadHistory: [
        0.609, 0.652, 0.696, 0.696, 0.696, 0.696, 0.696, 0.696, 0.696, 0.783, 0.87, 0.87, 0.87,
        0.87, 0.826
      ],
      name: 'Server 632',
      ip: '141.31.226.246',
      enabled: true,
      type: 6,
      load: 0.826,
      id: 112
    },
    {
      loadHistory: [
        0.213, 0.222, 0.217, 0.232, 0.232, 0.227, 0.213, 0.203, 0.208, 0.227, 0.242, 0.251, 0.256,
        0.261, 0.256
      ],
      name: 'W-LAN 552',
      ip: '85.142.83.11',
      enabled: true,
      type: 5,
      load: 0.256,
      id: 113
    },
    {
      loadHistory: [
        0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.174
      ],
      name: 'PC 829',
      ip: '192.9.137.243',
      enabled: true,
      type: 1,
      load: 0.174,
      id: 114
    },
    {
      loadHistory: [
        0.174, 0.217, 0.217, 0.217, 0.217, 0.217, 0.217, 0.217, 0.217, 0.217, 0.261, 0.261, 0.261,
        0.261, 0.261
      ],
      name: 'PC 156',
      ip: '200.32.42.211',
      enabled: true,
      type: 1,
      load: 0.261,
      id: 115
    },
    {
      loadHistory: [
        0.13, 0.174, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.174, 0.174
      ],
      name: 'PC 356',
      ip: '245.105.58.215',
      enabled: true,
      type: 1,
      load: 0.174,
      id: 116
    },
    {
      loadHistory: [
        0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.13, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.087, 0.087
      ],
      name: 'PC 835',
      ip: '58.93.65.43',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 117
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.043, 0
      ],
      name: 'Laptop 369',
      ip: '22.150.52.13',
      enabled: true,
      type: 2,
      load: 0,
      id: 118
    },
    {
      loadHistory: [
        0.217, 0.217, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.217, 0.217,
        0.174, 0.174
      ],
      name: 'Laptop 71',
      ip: '73.218.184.7',
      enabled: true,
      type: 2,
      load: 0.174,
      id: 119
    },
    {
      loadHistory: [
        0.087, 0.087, 0.087, 0.13, 0.13, 0.13, 0.13, 0.087, 0.087, 0.174, 0.174, 0.174, 0.174,
        0.174, 0.174
      ],
      name: 'Tablet 768',
      ip: '56.89.190.246',
      enabled: true,
      type: 3,
      load: 0.174,
      id: 120
    },
    {
      loadHistory: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
      name: 'Server 665',
      ip: '68.157.251.208',
      enabled: true,
      type: 6,
      load: 1,
      id: 121
    },
    {
      loadHistory: [1, 0.957, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
      name: 'Server 834',
      ip: '22.198.239.176',
      enabled: true,
      type: 6,
      load: 1,
      id: 122
    },
    {
      loadHistory: [
        0.913, 0.87, 0.913, 0.913, 0.913, 0.957, 0.957, 0.913, 0.913, 0.957, 0.913, 0.87, 0.913,
        0.957, 0.957
      ],
      name: 'Server 940',
      ip: '42.16.36.54',
      enabled: true,
      type: 6,
      load: 0.957,
      id: 123
    },
    {
      loadHistory: [
        0.522, 0.522, 0.522, 0.478, 0.435, 0.435, 0.391, 0.348, 0.435, 0.609, 0.652, 0.609, 0.609,
        0.609, 0.609
      ],
      name: 'Server 257',
      ip: '14.130.27.119',
      enabled: true,
      type: 6,
      load: 0.609,
      id: 124
    },
    {
      loadHistory: [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1],
      name: 'DB 375',
      ip: '17.43.127.73',
      enabled: true,
      type: 7,
      load: 1,
      id: 125
    },
    {
      loadHistory: [
        0.545, 0.545, 0.538, 0.534, 0.522, 0.51, 0.502, 0.502, 0.51, 0.514, 0.53, 0.534, 0.534,
        0.534, 0.545
      ],
      name: 'Switch 752',
      ip: '128.130.96.102',
      enabled: true,
      type: 4,
      load: 0.545,
      id: 126
    },
    {
      loadHistory: [
        0.084, 0.092, 0.092, 0.092, 0.102, 0.1, 0.11, 0.113, 0.118, 0.118, 0.115, 0.113, 0.115,
        0.113, 0.115
      ],
      name: 'Switch 787',
      ip: '109.187.207.208',
      enabled: true,
      type: 4,
      load: 0.115,
      id: 127
    },
    {
      loadHistory: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.043, 0.043, 0.043],
      name: 'PC 78',
      ip: '123.191.212.167',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 128
    },
    {
      loadHistory: [
        0.043, 0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.043, 0.043,
        0.043, 0.043
      ],
      name: 'PC 963',
      ip: '219.93.217.173',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 129
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.043, 0.043
      ],
      name: 'PC 926',
      ip: '79.102.227.137',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 130
    },
    {
      loadHistory: [
        0, 0.043, 0.043, 0.043, 0.087, 0.087, 0.087, 0.087, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13
      ],
      name: 'PC 218',
      ip: '51.110.32.193',
      enabled: true,
      type: 1,
      load: 0.13,
      id: 131
    },
    {
      loadHistory: [
        0, 0.022, 0.022, 0.022, 0.022, 0.022, 0.022, 0.022, 0.022, 0.022, 0.022, 0.022, 0.022,
        0.022, 0.022
      ],
      name: 'PC 499',
      ip: '165.248.205.31',
      enabled: true,
      type: 1,
      load: 0.022,
      id: 132
    },
    {
      loadHistory: [
        0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.043, 0.043, 0.043,
        0.043, 0
      ],
      name: 'PC 940',
      ip: '78.125.54.184',
      enabled: true,
      type: 1,
      load: 0,
      id: 133
    },
    {
      loadHistory: [
        0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.043,
        0.043, 0.043
      ],
      name: 'PC 958',
      ip: '63.125.63.180',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 134
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.087,
        0.087, 0.13
      ],
      name: 'PC 475',
      ip: '247.185.167.102',
      enabled: true,
      type: 1,
      load: 0.13,
      id: 135
    },
    {
      loadHistory: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      name: 'PC 379',
      ip: '158.221.234.137',
      enabled: true,
      type: 1,
      load: 0,
      id: 136
    },
    {
      loadHistory: [
        0, 0, 0, 0, 0, 0, 0.043, 0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087
      ],
      name: 'PC 982',
      ip: '213.89.119.227',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 137
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.043, 0.043
      ],
      name: 'Tablet 260',
      ip: '216.3.208.238',
      enabled: true,
      type: 3,
      load: 0.043,
      id: 138
    },
    {
      loadHistory: [
        0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.087, 0.087
      ],
      name: 'Tablet 357',
      ip: '202.0.153.30',
      enabled: true,
      type: 3,
      load: 0.087,
      id: 139
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.087, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13,
        0.13
      ],
      name: 'Laptop 203',
      ip: '238.255.61.77',
      enabled: true,
      type: 2,
      load: 0.13,
      id: 140
    },
    {
      loadHistory: [0.043, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      name: 'Laptop 473',
      ip: '59.129.114.160',
      enabled: true,
      type: 2,
      load: 0,
      id: 141
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.087, 0.087
      ],
      name: 'Laptop 306',
      ip: '127.79.243.205',
      enabled: true,
      type: 2,
      load: 0.087,
      id: 142
    },
    {
      loadHistory: [
        0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.087, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.043
      ],
      name: 'Laptop 51',
      ip: '73.150.158.104',
      enabled: true,
      type: 2,
      load: 0.043,
      id: 143
    },
    {
      loadHistory: [
        0.174, 0.217, 0.304, 0.348, 0.348, 0.348, 0.391, 0.478, 0.478, 0.435, 0.435, 0.435, 0.435,
        0.435, 0.522
      ],
      name: 'Server 64',
      ip: '146.207.120.44',
      enabled: true,
      type: 6,
      load: 0.522,
      id: 144
    },
    {
      loadHistory: [
        0.348, 0.391, 0.435, 0.478, 0.565, 0.652, 0.652, 0.652, 0.652, 0.652, 0.739, 0.783, 0.783,
        0.783, 0.783
      ],
      name: 'Server 278',
      ip: '80.21.135.104',
      enabled: true,
      type: 6,
      load: 0.783,
      id: 145
    },
    {
      loadHistory: [
        0.174, 0.174, 0.13, 0.087, 0.13, 0.174, 0.174, 0.174, 0.217, 0.304, 0.348, 0.348, 0.391,
        0.478, 0.522
      ],
      name: 'Server 310',
      ip: '51.6.235.106',
      enabled: true,
      type: 6,
      load: 0.522,
      id: 146
    },
    {
      loadHistory: [
        0.609, 0.609, 0.609, 0.696, 0.783, 0.826, 0.913, 0.957, 0.913, 0.87, 0.826, 0.826, 0.826,
        0.739, 0.696
      ],
      name: 'Server 838',
      ip: '82.154.150.206',
      enabled: true,
      type: 6,
      load: 0.696,
      id: 147
    },
    {
      loadHistory: [
        0.696, 0.696, 0.696, 0.696, 0.652, 0.609, 0.609, 0.609, 0.609, 0.609, 0.565, 0.522, 0.522,
        0.522, 0.478
      ],
      name: 'DB 992',
      ip: '97.115.56.223',
      enabled: true,
      type: 7,
      load: 0.478,
      id: 148
    },
    {
      loadHistory: [
        0.435, 0.449, 0.471, 0.5, 0.529, 0.558, 0.58, 0.587, 0.601, 0.609, 0.609, 0.616, 0.609,
        0.616, 0.623
      ],
      name: 'Switch 76',
      ip: '170.52.242.167',
      enabled: true,
      type: 4,
      load: 0.623,
      id: 149
    },
    {
      loadHistory: [
        0.37, 0.38, 0.413, 0.424, 0.402, 0.391, 0.391, 0.38, 0.391, 0.38, 0.348, 0.348, 0.348,
        0.348, 0.337
      ],
      name: 'Switch 704',
      ip: '90.106.14.70',
      enabled: true,
      type: 4,
      load: 0.337,
      id: 150
    },
    {
      loadHistory: [
        0.174, 0.174, 0.217, 0.217, 0.261, 0.261, 0.217, 0.217, 0.217, 0.217, 0.261, 0.261, 0.261,
        0.261, 0.261
      ],
      name: 'Tablet 957',
      ip: '56.156.86.37',
      enabled: true,
      type: 3,
      load: 0.261,
      id: 151
    },
    {
      loadHistory: [
        0.348, 0.348, 0.348, 0.348, 0.348, 0.304, 0.304, 0.261, 0.261, 0.261, 0.304, 0.174, 0.174,
        0.174, 0.174
      ],
      name: 'Laptop 331',
      ip: '132.163.23.179',
      enabled: true,
      type: 2,
      load: 0.174,
      id: 152
    },
    {
      loadHistory: [
        0.348, 0.348, 0.377, 0.391, 0.391, 0.362, 0.333, 0.319, 0.319, 0.333, 0.333, 0.29, 0.29,
        0.29, 0.29
      ],
      name: 'W-LAN 986',
      ip: '105.248.116.4',
      enabled: true,
      type: 5,
      load: 0.29,
      id: 153
    },
    {
      loadHistory: [0.043, 0.043, 0.043, 0.043, 0.043, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      name: 'PC 147',
      ip: '221.162.197.28',
      enabled: true,
      type: 1,
      load: 0,
      id: 154
    },
    {
      loadHistory: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      name: 'Tablet 249',
      ip: '171.208.104.237',
      enabled: true,
      type: 3,
      load: 0,
      id: 155
    },
    {
      loadHistory: [
        0.087, 0.087, 0.043, 0.043, 0.043, 0.043, 0.043, 0.087, 0.13, 0.087, 0.087, 0.087, 0.087,
        0.087, 0.13
      ],
      name: 'Laptop 906',
      ip: '196.248.227.209',
      enabled: true,
      type: 2,
      load: 0.13,
      id: 156
    },
    {
      loadHistory: [
        0.114, 0.12, 0.12, 0.12, 0.114, 0.103, 0.103, 0.109, 0.098, 0.082, 0.076, 0.071, 0.076,
        0.092, 0.103
      ],
      name: 'Switch 571',
      ip: '156.54.225.40',
      enabled: true,
      type: 4,
      load: 0.103,
      id: 157
    },
    {
      loadHistory: [
        0.217, 0.217, 0.217, 0.217, 0.217, 0.217, 0.217, 0.217, 0.13, 0.087, 0.087, 0.087, 0.087,
        0.13, 0.13
      ],
      name: 'PC 741',
      ip: '156.28.215.203',
      enabled: true,
      type: 1,
      load: 0.13,
      id: 158
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.087, 0.087, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.043, 0.043
      ],
      name: 'PC 41',
      ip: '237.78.143.5',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 159
    },
    {
      loadHistory: [
        0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.087, 0.087
      ],
      name: 'PC 545',
      ip: '22.228.184.200',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 160
    },
    {
      loadHistory: [
        0.035, 0.035, 0.035, 0.026, 0.017, 0.017, 0.017, 0.017, 0.017, 0.017, 0.009, 0, 0.009,
        0.026, 0.035
      ],
      name: 'Server 258',
      ip: '131.126.93.90',
      enabled: true,
      type: 6,
      load: 0.035,
      id: 161
    },
    {
      loadHistory: [
        0.13, 0.13, 0.13, 0.13, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.13, 0.13, 0.13, 0.087,
        0.087
      ],
      name: 'PC 329',
      ip: '255.142.171.192',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 162
    },
    {
      loadHistory: [
        0.467, 0.467, 0.435, 0.424, 0.413, 0.413, 0.435, 0.446, 0.457, 0.446, 0.424, 0.424, 0.435,
        0.435, 0.435
      ],
      name: 'Switch 809',
      ip: '147.237.187.148',
      enabled: true,
      type: 4,
      load: 0.435,
      id: 163
    },
    {
      loadHistory: [
        0.188, 0.181, 0.167, 0.152, 0.145, 0.145, 0.13, 0.13, 0.13, 0.138, 0.145, 0.138, 0.123,
        0.123, 0.13
      ],
      name: 'Switch 452',
      ip: '239.33.177.104',
      enabled: true,
      type: 4,
      load: 0.13,
      id: 164
    },
    {
      loadHistory: [
        0.13, 0.13, 0.13, 0.087, 0.087, 0.087, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.043, 0.043
      ],
      name: 'PC 265',
      ip: '249.134.69.109',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 165
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.087, 0.13
      ],
      name: 'PC 322',
      ip: '99.94.79.67',
      enabled: true,
      type: 1,
      load: 0.13,
      id: 166
    },
    {
      loadHistory: [
        0.217, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.174, 0.13,
        0.13, 0.13
      ],
      name: 'PC 173',
      ip: '240.93.48.24',
      enabled: true,
      type: 1,
      load: 0.13,
      id: 167
    },
    {
      loadHistory: [0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0, 0, 0, 0, 0, 0, 0, 0, 0],
      name: 'PC 679',
      ip: '180.69.30.78',
      enabled: true,
      type: 1,
      load: 0,
      id: 168
    },
    {
      loadHistory: [
        0.087, 0.087, 0.087, 0.087, 0.087, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13,
        0.13
      ],
      name: 'PC 37',
      ip: '90.9.151.127',
      enabled: true,
      type: 1,
      load: 0.13,
      id: 169
    },
    {
      loadHistory: [
        0.138, 0.138, 0.152, 0.145, 0.13, 0.145, 0.145, 0.145, 0.159, 0.159, 0.152, 0.167, 0.159,
        0.152, 0.138
      ],
      name: 'Switch 774',
      ip: '141.159.216.211',
      enabled: true,
      type: 4,
      load: 0.138,
      id: 170
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.13, 0.13,
        0.13, 0.13
      ],
      name: 'PC 509',
      ip: '204.196.89.194',
      enabled: true,
      type: 1,
      load: 0.13,
      id: 171
    },
    {
      loadHistory: [
        0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043,
        0.043, 0
      ],
      name: 'PC 338',
      ip: '185.54.130.221',
      enabled: true,
      type: 1,
      load: 0,
      id: 172
    },
    {
      loadHistory: [
        0.13, 0.087, 0.087, 0.087, 0.043, 0.043, 0.043, 0.043, 0.087, 0.087, 0.087, 0.043, 0.043,
        0.043, 0.043
      ],
      name: 'PC 779',
      ip: '6.21.43.63',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 173
    },
    {
      loadHistory: [
        0.087, 0.13, 0.174, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.087, 0.087
      ],
      name: 'PC 886',
      ip: '241.9.247.27',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 174
    },
    {
      loadHistory: [
        0.174, 0.174, 0.174, 0.087, 0.087, 0.087, 0.087, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.174,
        0.13
      ],
      name: 'PC 104',
      ip: '206.182.124.25',
      enabled: true,
      type: 1,
      load: 0.13,
      id: 175
    },
    {
      loadHistory: [
        0.217, 0.203, 0.181, 0.159, 0.167, 0.174, 0.174, 0.181, 0.167, 0.152, 0.145, 0.145, 0.174,
        0.181, 0.188
      ],
      name: 'Switch 914',
      ip: '19.40.121.254',
      enabled: true,
      type: 4,
      load: 0.188,
      id: 176
    },
    {
      loadHistory: [
        0.13, 0.13, 0.087, 0.087, 0.087, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.174, 0.174,
        0.174
      ],
      name: 'PC 236',
      ip: '119.53.127.26',
      enabled: true,
      type: 1,
      load: 0.174,
      id: 177
    },
    {
      loadHistory: [
        0, 0, 0, 0, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.043, 0.087, 0.087
      ],
      name: 'PC 477',
      ip: '70.137.145.196',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 178
    },
    {
      loadHistory: [
        0.217, 0.217, 0.217, 0.174, 0.174, 0.174, 0.174, 0.13, 0.087, 0.043, 0.043, 0.043, 0.043,
        0.043, 0.043
      ],
      name: 'PC 430',
      ip: '109.251.140.169',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 179
    },
    {
      loadHistory: [
        0.13, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.087, 0.13
      ],
      name: 'PC 415',
      ip: '220.152.192.190',
      enabled: true,
      type: 1,
      load: 0.13,
      id: 180
    },
    {
      loadHistory: [
        0.852, 0.809, 0.791, 0.774, 0.791, 0.8, 0.765, 0.748, 0.73, 0.713, 0.704, 0.713, 0.722,
        0.722, 0.713
      ],
      name: 'Server 258',
      ip: '131.126.93.90',
      enabled: true,
      type: 6,
      load: 0.713,
      id: 181
    },
    {
      loadHistory: [
        0.13, 0.13, 0.13, 0.13, 0.13, 0.13, 0.087, 0.087, 0.13, 0.13, 0.13, 0.174, 0.174, 0.174,
        0.217
      ],
      name: 'PC 855',
      ip: '113.99.150.117',
      enabled: true,
      type: 1,
      load: 0.217,
      id: 182
    },
    {
      loadHistory: [0.087, 0.087, 0.087, 0.043, 0.043, 0, 0, 0, 0, 0, 0, 0, 0.043, 0.043, 0.043],
      name: 'PC 130',
      ip: '49.211.126.113',
      enabled: true,
      type: 1,
      load: 0.043,
      id: 183
    },
    {
      loadHistory: [
        0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087, 0.087,
        0.087, 0.087
      ],
      name: 'PC 72',
      ip: '24.228.86.75',
      enabled: true,
      type: 1,
      load: 0.087,
      id: 184
    }
  ],
  edgeList: [
    { source: 4, target: 6 },
    { source: 6, target: 7 },
    { source: 7, target: 5 },
    { source: 5, target: 1 },
    { source: 3, target: 0 },
    { source: 0, target: 7 },
    { source: 3, target: 6 },
    { source: 126, target: 124 },
    { source: 123, target: 126 },
    { source: 122, target: 126 },
    { source: 121, target: 126 },
    { source: 125, target: 126 },
    { source: 112, target: 113 },
    { source: 113, target: 117 },
    { source: 113, target: 116 },
    { source: 113, target: 93 },
    { source: 114, target: 113 },
    { source: 115, target: 113 },
    { source: 118, target: 113 },
    { source: 119, target: 113 },
    { source: 120, target: 113 },
    { source: 108, target: 93 },
    { source: 109, target: 108 },
    { source: 110, target: 108 },
    { source: 111, target: 108 },
    { source: 101, target: 93 },
    { source: 102, target: 93 },
    { source: 103, target: 107 },
    { source: 105, target: 107 },
    { source: 106, target: 107 },
    { source: 107, target: 104 },
    { source: 107, target: 93 },
    { source: 99, target: 93 },
    { source: 100, target: 99 },
    { source: 182, target: 99 },
    { source: 94, target: 93 },
    { source: 95, target: 94 },
    { source: 96, target: 94 },
    { source: 97, target: 94 },
    { source: 98, target: 94 },
    { source: 84, target: 85 },
    { source: 85, target: 89 },
    { source: 85, target: 88 },
    { source: 85, target: 64 },
    { source: 86, target: 85 },
    { source: 87, target: 85 },
    { source: 90, target: 85 },
    { source: 91, target: 85 },
    { source: 92, target: 85 },
    { source: 80, target: 64 },
    { source: 81, target: 80 },
    { source: 82, target: 80 },
    { source: 83, target: 80 },
    { source: 73, target: 64 },
    { source: 75, target: 79 },
    { source: 77, target: 79 },
    { source: 78, target: 79 },
    { source: 79, target: 76 },
    { source: 79, target: 64 },
    { source: 70, target: 64 },
    { source: 71, target: 70 },
    { source: 72, target: 70 },
    { source: 65, target: 64 },
    { source: 66, target: 65 },
    { source: 67, target: 65 },
    { source: 68, target: 65 },
    { source: 69, target: 65 },
    { source: 74, target: 64 },
    { source: 129, target: 127 },
    { source: 131, target: 127 },
    { source: 128, target: 127 },
    { source: 130, target: 127 },
    { source: 135, target: 127 },
    { source: 134, target: 127 },
    { source: 133, target: 127 },
    { source: 132, target: 127 },
    { source: 139, target: 127 },
    { source: 138, target: 127 },
    { source: 140, target: 127 },
    { source: 141, target: 127 },
    { source: 142, target: 127 },
    { source: 143, target: 127 },
    { source: 137, target: 127 },
    { source: 136, target: 127 },
    { source: 150, target: 1 },
    { source: 149, target: 147 },
    { source: 146, target: 149 },
    { source: 145, target: 149 },
    { source: 144, target: 149 },
    { source: 148, target: 149 },
    { source: 49, target: 47 },
    { source: 51, target: 47 },
    { source: 48, target: 47 },
    { source: 50, target: 47 },
    { source: 55, target: 47 },
    { source: 54, target: 47 },
    { source: 53, target: 47 },
    { source: 52, target: 47 },
    { source: 59, target: 47 },
    { source: 58, target: 47 },
    { source: 60, target: 47 },
    { source: 61, target: 47 },
    { source: 62, target: 47 },
    { source: 63, target: 47 },
    { source: 57, target: 47 },
    { source: 56, target: 47 },
    { source: 45, target: 40 },
    { source: 41, target: 40 },
    { source: 42, target: 40 },
    { source: 46, target: 40 },
    { source: 43, target: 40 },
    { source: 44, target: 40 },
    { source: 37, target: 33 },
    { source: 35, target: 33 },
    { source: 38, target: 33 },
    { source: 34, target: 33 },
    { source: 36, target: 33 },
    { source: 39, target: 33 },
    { source: 20, target: 16 },
    { source: 18, target: 16 },
    { source: 21, target: 16 },
    { source: 17, target: 16 },
    { source: 22, target: 16 },
    { source: 19, target: 16 },
    { source: 24, target: 23 },
    { source: 25, target: 23 },
    { source: 26, target: 23 },
    { source: 27, target: 23 },
    { source: 28, target: 23 },
    { source: 29, target: 23 },
    { source: 30, target: 23 },
    { source: 31, target: 23 },
    { source: 32, target: 23 },
    { source: 11, target: 10 },
    { source: 40, target: 10 },
    { source: 33, target: 10 },
    { source: 23, target: 10 },
    { source: 16, target: 10 },
    { source: 12, target: 11 },
    { source: 184, target: 11 },
    { source: 13, target: 11 },
    { source: 183, target: 11 },
    { source: 14, target: 11 },
    { source: 15, target: 11 },
    { source: 157, target: 150 },
    { source: 163, target: 150 },
    { source: 153, target: 150 },
    { source: 151, target: 153 },
    { source: 152, target: 153 },
    { source: 154, target: 157 },
    { source: 155, target: 157 },
    { source: 156, target: 157 },
    { source: 158, target: 157 },
    { source: 159, target: 157 },
    { source: 160, target: 157 },
    { source: 161, target: 157 },
    { source: 162, target: 164 },
    { source: 164, target: 163 },
    { source: 165, target: 164 },
    { source: 166, target: 164 },
    { source: 167, target: 164 },
    { source: 168, target: 164 },
    { source: 169, target: 170 },
    { source: 170, target: 163 },
    { source: 171, target: 170 },
    { source: 172, target: 170 },
    { source: 173, target: 170 },
    { source: 174, target: 170 },
    { source: 175, target: 176 },
    { source: 176, target: 163 },
    { source: 177, target: 176 },
    { source: 178, target: 176 },
    { source: 179, target: 176 },
    { source: 180, target: 176 },
    { source: 64, target: 5 },
    { source: 47, target: 9 },
    { source: 93, target: 0 },
    { source: 6, target: 1 },
    { source: 126, target: 4 },
    { source: 127, target: 8 },
    { source: 149, target: 2 },
    { source: 8, target: 4 },
    { source: 8, target: 2 },
    { source: 8, target: 3 },
    { source: 2, target: 0 },
    { source: 9, target: 4 },
    { source: 9, target: 1 },
    { source: 10, target: 7 },
    { source: 9, target: 181 },
    { source: 181, target: 4 },
    { source: 181, target: 6 },
    { source: 181, target: 1 }
  ]
}
