/****************************************************************************
 ** @license
 ** This demo file is part of yFiles for HTML 2.6.
 ** Copyright (c) 2000-2024 by yWorks GmbH, Vor dem Kreuzberg 28,
 ** 72070 Tuebingen, Germany. All rights reserved.
 **
 ** yFiles demo files exhibit yFiles for HTML functionalities. Any redistribution
 ** of demo files in source code or binary form, with or without
 ** modification, is not permitted.
 **
 ** Owners of a valid software license for a yFiles for HTML version that this
 ** demo is shipped with are allowed to use the demo source code as basis
 ** for their own yFiles for HTML powered applications. Use of such programs is
 ** governed by the rights and conditions as set out in the yFiles for HTML
 ** license agreement.
 **
 ** THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESS OR IMPLIED
 ** WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 ** MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 ** NO EVENT SHALL yWorks BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 ** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 ** TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 ** PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 ** LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 ***************************************************************************/
/**
 * A set of colors for the fill and outline color of a node style as well as the text and background
 * fill of its labels.
 * @typedef {Object} ColorSet
 * @property {string} fill
 * @property {string} outline
 * @property {string} labelFill
 * @property {string} labelText
 */

/**
 * Themes of {@link ColorSet color sets} suiting each other.
 */
export const ColorThemes = [
  [
    { fill: '#111D4A', outline: '#1B1F2C', labelFill: '#9FA4B6', labelText: '#101423' },
    { fill: '#0B7189', outline: '#2C4B52', labelFill: '#9CC5CF', labelText: '#0C313A' },
    { fill: '#FF6C00', outline: '#662b00', labelFill: '#FFC398', labelText: '#662b00' },
    { fill: '#AB2346', outline: '#673E49', labelFill: '#DCA6B4', labelText: '#461622' },
    { fill: '#621B00', outline: '#3B621D', labelFill: '#BFA398', labelText: '#2B1301' }
  ],
  [
    { fill: '#17BEBB', outline: '#407271', labelFill: '#A1E5E3', labelText: '#114D4C' },
    { fill: '#FFC914', outline: '#998953', labelFill: '#FFE8A0', labelText: '#665111' },
    { fill: '#FF6C00', outline: '#662b00', labelFill: '#FFC398', labelText: '#662b00' },
    { fill: '#2E282A', outline: '#1C1A1A', labelFill: '#AAA8A9', labelText: '#191718' },
    { fill: '#76B041', outline: '#586a48', labelFill: '#C7DEB2', labelText: '#324820' }
  ],
  [
    { fill: '#67B7DC', outline: '#617984', labelFill: '#C1E1F1', labelText: '#2D4A59' },
    { fill: '#6771DC', outline: '#616484', labelFill: '#C1C5F1', labelText: '#2D3159' },
    { fill: '#242265', outline: '#29283D', labelFill: '#A6A6C0', labelText: '#16162C' },
    { fill: '#DC67CE', outline: '#846180', labelFill: '#F1C1EA', labelText: '#592D53' },
    { fill: '#A367DC', outline: '#736184', labelFill: '#D9C1F1', labelText: '#432D59' }
  ],
  [
    { fill: '#363020', outline: '#201F1A', labelFill: '#AEABA5', labelText: '#1C1A15' },
    { fill: '#605C4E', outline: '#3A3834', labelFill: '#BEBDB7', labelText: '#2A2A24' },
    { fill: '#A49966', outline: '#625F50', labelFill: '#DAD5C1', labelText: '#443F2D' },
    { fill: '#C7C7A6', outline: '#77776E', labelFill: '#E8E8DA', labelText: '#515144' },
    { fill: '#EAFFDA', outline: '#92998E', labelFill: '#5E6658', labelText: '#F7FFF0' },
    { fill: '#A4778B', outline: '#62555B', labelFill: '#DAC8D0', labelText: '#44333B' },
    { fill: '#AA4586', outline: '#66485B', labelFill: '#DCB4CE', labelText: '#462239' },
    { fill: '#177E89', outline: '#304F52', labelFill: '#A1CACF', labelText: '#11353A' }
  ]
]
