/****************************************************************************
 ** @license
 ** This demo file is part of yFiles for HTML 2.6.
 ** Copyright (c) 2000-2024 by yWorks GmbH, Vor dem Kreuzberg 28,
 ** 72070 Tuebingen, Germany. All rights reserved.
 **
 ** yFiles demo files exhibit yFiles for HTML functionalities. Any redistribution
 ** of demo files in source code or binary form, with or without
 ** modification, is not permitted.
 **
 ** Owners of a valid software license for a yFiles for HTML version that this
 ** demo is shipped with are allowed to use the demo source code as basis
 ** for their own yFiles for HTML powered applications. Use of such programs is
 ** governed by the rights and conditions as set out in the yFiles for HTML
 ** license agreement.
 **
 ** THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESS OR IMPLIED
 ** WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 ** MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 ** NO EVENT SHALL yWorks BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 ** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 ** TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 ** PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 ** LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 ***************************************************************************/
/**
 * @typedef {Object} NodeData
 * @property {number} id
 * @property {object} layout
 * @property {object} tag
 */

/**
 * @typedef {Object} SampleData
 * @property {Array.<NodeData>} nodeList
 * @property {Array.<object>} edgeList
 */

export const HierarchicSampleData = {
  nodeList: [
    { id: 0, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 1, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 2, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 3, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 4, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 5, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 6, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 7, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 8, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 9, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 10, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 11, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 12, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 13, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 14, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 15, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 16, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 17, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 18, layout: { width: 80, height: 60 }, tag: { type: 0 } },
    { id: 19, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 20, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 21, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 22, layout: { width: 80, height: 55 }, tag: { type: 0 } },
    { id: 23, layout: { width: 80, height: 55 }, tag: { type: 0 } },
    { id: 24, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 25, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 26, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 27, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 28, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 29, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 30, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 31, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 32, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 33, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 34, layout: { width: 40, height: 40 }, tag: { type: 1 } }
  ],
  edgeList: [
    { source: 0, target: 1 },
    { source: 0, target: 2 },
    { source: 0, target: 3 },
    { source: 0, target: 4 },
    { source: 1, target: 5 },
    { source: 4, target: 6 },
    { source: 4, target: 7 },
    { source: 4, target: 8 },
    { source: 4, target: 9 },
    { source: 2, target: 10 },
    { source: 2, target: 11 },
    { source: 2, target: 12 },
    { source: 11, target: 13 },
    { source: 10, target: 14 },
    { source: 2, target: 15 },
    { source: 15, target: 16 },
    { source: 16, target: 17 },
    { source: 3, target: 18 },
    { source: 12, target: 19 },
    { source: 7, target: 20 },
    { source: 20, target: 21 },
    { source: 21, target: 22 },
    { source: 21, target: 23 },
    { source: 23, target: 19 },
    { source: 6, target: 24 },
    { source: 6, target: 25 },
    { source: 6, target: 26 },
    { source: 6, target: 27 },
    { source: 5, target: 28 },
    { source: 8, target: 28 },
    { source: 22, target: 9 },
    { source: 9, target: 19 },
    { source: 9, target: 29 },
    { source: 9, target: 30 },
    { source: 9, target: 31 },
    { source: 9, target: 32 },
    { source: 9, target: 33 },
    { source: 9, target: 34 }
  ]
}

export const OrganicSampleData = {
  nodeList: [
    { id: 0, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 1, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 2, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 3, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 4, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 5, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 6, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 7, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 8, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 9, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 10, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 11, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 12, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 13, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 14, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 15, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 16, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 17, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 18, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 19, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 20, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 21, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 22, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 23, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 24, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 25, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 26, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 27, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 28, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 29, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 30, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 31, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 32, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 33, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 34, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 35, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 36, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 37, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 38, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 39, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 40, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 41, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 42, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 43, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 44, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 45, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 46, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 47, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 48, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 49, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 50, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 51, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 52, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 53, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 54, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 55, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 56, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 57, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 58, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 59, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 60, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 61, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 62, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 63, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 64, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 65, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 66, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 67, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 68, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 69, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 70, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 71, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 72, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 73, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 74, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 75, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 76, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 77, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 78, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 79, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 80, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 81, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 82, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 83, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 84, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 85, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 86, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 87, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 88, layout: { width: 40, height: 40 }, tag: { type: 1 } }
  ],
  edgeList: [
    { source: 3, target: 4 },
    { source: 4, target: 5 },
    { source: 0, target: 5 },
    { source: 41, target: 45 },
    { source: 41, target: 44 },
    { source: 41, target: 38 },
    { source: 42, target: 41 },
    { source: 43, target: 41 },
    { source: 46, target: 41 },
    { source: 47, target: 41 },
    { source: 48, target: 41 },
    { source: 39, target: 38 },
    { source: 29, target: 30 },
    { source: 30, target: 34 },
    { source: 30, target: 33 },
    { source: 30, target: 26 },
    { source: 31, target: 30 },
    { source: 32, target: 30 },
    { source: 35, target: 30 },
    { source: 36, target: 30 },
    { source: 37, target: 30 },
    { source: 27, target: 26 },
    { source: 28, target: 26 },
    { source: 52, target: 50 },
    { source: 54, target: 50 },
    { source: 51, target: 50 },
    { source: 53, target: 50 },
    { source: 58, target: 50 },
    { source: 57, target: 50 },
    { source: 56, target: 50 },
    { source: 55, target: 50 },
    { source: 62, target: 50 },
    { source: 61, target: 50 },
    { source: 63, target: 50 },
    { source: 64, target: 50 },
    { source: 65, target: 50 },
    { source: 66, target: 50 },
    { source: 60, target: 50 },
    { source: 59, target: 50 },
    { source: 73, target: 1 },
    { source: 72, target: 70 },
    { source: 69, target: 72 },
    { source: 68, target: 72 },
    { source: 67, target: 72 },
    { source: 71, target: 72 },
    { source: 11, target: 9 },
    { source: 13, target: 9 },
    { source: 10, target: 9 },
    { source: 12, target: 9 },
    { source: 17, target: 9 },
    { source: 16, target: 9 },
    { source: 15, target: 9 },
    { source: 14, target: 9 },
    { source: 21, target: 9 },
    { source: 20, target: 9 },
    { source: 22, target: 9 },
    { source: 23, target: 9 },
    { source: 24, target: 9 },
    { source: 25, target: 9 },
    { source: 19, target: 9 },
    { source: 18, target: 9 },
    { source: 77, target: 73 },
    { source: 82, target: 73 },
    { source: 74, target: 77 },
    { source: 75, target: 77 },
    { source: 76, target: 77 },
    { source: 78, target: 77 },
    { source: 79, target: 77 },
    { source: 80, target: 77 },
    { source: 81, target: 77 },
    { source: 9, target: 7 },
    { source: 4, target: 1 },
    { source: 49, target: 3 },
    { source: 50, target: 6 },
    { source: 6, target: 3 },
    { source: 6, target: 2 },
    { source: 2, target: 0 },
    { source: 7, target: 1 },
    { source: 8, target: 5 },
    { source: 83, target: 4 },
    { source: 83, target: 1 },
    { source: 4, target: 26 },
    { source: 72, target: 6 },
    { source: 38, target: 0 },
    { source: 84, target: 40 },
    { source: 85, target: 84 },
    { source: 86, target: 40 },
    { source: 85, target: 86 },
    { source: 87, target: 40 },
    { source: 85, target: 87 },
    { source: 88, target: 40 },
    { source: 85, target: 88 },
    { source: 85, target: 8 },
    { source: 40, target: 38 }
  ]
}

export const TreeSampleData = {
  nodeList: [
    { id: 0, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 1, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 2, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 3, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 4, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 5, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 6, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 7, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 8, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 9, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 10, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 11, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 12, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 13, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 14, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 15, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 16, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 17, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 18, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 19, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 20, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 21, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 22, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 23, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 24, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 25, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 26, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 27, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 28, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 29, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 30, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 31, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 32, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 33, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 34, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 35, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 36, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 37, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 38, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 39, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 40, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 41, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 42, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 43, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 44, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 45, layout: { width: 40, height: 40 }, tag: { type: 0 } }
  ],
  edgeList: [
    { source: 0, target: 1 },
    { source: 0, target: 2 },
    { source: 1, target: 3 },
    { source: 1, target: 4 },
    { source: 2, target: 5 },
    { source: 2, target: 6 },
    { source: 2, target: 7 },
    { source: 0, target: 8 },
    { source: 8, target: 9 },
    { source: 5, target: 10 },
    { source: 10, target: 11 },
    { source: 6, target: 12 },
    { source: 12, target: 13 },
    { source: 7, target: 14 },
    { source: 14, target: 15 },
    { source: 9, target: 16 },
    { source: 16, target: 17 },
    { source: 5, target: 18 },
    { source: 6, target: 19 },
    { source: 7, target: 20 },
    { source: 9, target: 21 },
    { source: 3, target: 22 },
    { source: 4, target: 23 },
    { source: 23, target: 24 },
    { source: 22, target: 25 },
    { source: 23, target: 26 },
    { source: 26, target: 27 },
    { source: 13, target: 28 },
    { source: 11, target: 29 },
    { source: 29, target: 30 },
    { source: 17, target: 31 },
    { source: 22, target: 32 },
    { source: 22, target: 33 },
    { source: 22, target: 34 },
    { source: 15, target: 35 },
    { source: 15, target: 36 },
    { source: 15, target: 37 },
    { source: 15, target: 38 },
    { source: 15, target: 39 },
    { source: 15, target: 40 },
    { source: 15, target: 41 },
    { source: 15, target: 42 },
    { source: 15, target: 43 },
    { source: 15, target: 44 },
    { source: 15, target: 45 }
  ]
}

export const CircularSampleData = {
  nodeList: [
    { id: 0, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 1, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 2, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 3, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 4, layout: { width: 68, height: 50 }, tag: { type: 0 } },
    { id: 5, layout: { width: 68, height: 50 }, tag: { type: 0 } },
    { id: 6, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 7, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 8, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 9, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 10, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 11, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 12, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 13, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 14, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 15, layout: { width: 64, height: 40 }, tag: { type: 0 } },
    { id: 16, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 17, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 18, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 19, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 20, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 21, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 22, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 23, layout: { width: 68, height: 50 }, tag: { type: 0 } },
    { id: 24, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 25, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 26, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 27, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 28, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 29, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 30, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 31, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 32, layout: { width: 40, height: 40 }, tag: { type: 0 } }
  ],
  edgeList: [
    { source: 9, target: 8 },
    { source: 6, target: 7 },
    { source: 5, target: 6 },
    { source: 1, target: 0 },
    { source: 2, target: 1 },
    { source: 3, target: 2 },
    { source: 0, target: 4 },
    { source: 0, target: 5 },
    { source: 9, target: 3 },
    { source: 9, target: 7 },
    { source: 9, target: 6 },
    { source: 8, target: 1 },
    { source: 15, target: 10 },
    { source: 16, target: 23 },
    { source: 17, target: 12 },
    { source: 11, target: 12 },
    { source: 10, target: 11 },
    { source: 14, target: 13 },
    { source: 15, target: 14 },
    { source: 15, target: 16 },
    { source: 13, target: 22 },
    { source: 21, target: 13 },
    { source: 11, target: 23 },
    { source: 22, target: 17 },
    { source: 15, target: 17 },
    { source: 22, target: 18 },
    { source: 20, target: 18 },
    { source: 19, target: 20 },
    { source: 19, target: 21 },
    { source: 18, target: 19 },
    { source: 23, target: 22 },
    { source: 14, target: 22 },
    { source: 14, target: 21 },
    { source: 14, target: 20 },
    { source: 10, target: 2 },
    { source: 4, target: 10 },
    { source: 5, target: 10 },
    { source: 25, target: 24 },
    { source: 26, target: 25 },
    { source: 26, target: 27 },
    { source: 27, target: 28 },
    { source: 29, target: 30 },
    { source: 30, target: 31 },
    { source: 30, target: 32 },
    { source: 32, target: 27 },
    { source: 26, target: 32 },
    { source: 26, target: 31 },
    { source: 26, target: 30 },
    { source: 26, target: 29 },
    { source: 27, target: 29 },
    { source: 28, target: 31 },
    { source: 31, target: 25 },
    { source: 31, target: 24 },
    { source: 26, target: 24 },
    { source: 22, target: 26 },
    { source: 27, target: 22 }
  ]
}

export const ComponentSampleData = {
  nodeList: [
    { id: 0, layout: { x: 62, y: 215, width: 40, height: 40 }, tag: { type: 0 } },
    { id: 1, layout: { x: 110, y: 116, width: 40, height: 40 }, tag: { type: 0 } },
    { id: 2, layout: { x: 107, y: 0, width: 40, height: 40 }, tag: { type: 0 } },
    { id: 3, layout: { x: 0, y: 123, width: 40, height: 70 }, tag: { type: 0 } },
    { id: 4, layout: { x: 239, y: 111, width: 40, height: 40 }, tag: { type: 0 } },
    { id: 5, layout: { x: 233, y: 216, width: 40, height: 40 }, tag: { type: 0 } },
    { id: 6, layout: { x: 233, y: 293, width: 40, height: 40 }, tag: { type: 0 } },
    { id: 7, layout: { x: 155, y: 208, width: 40, height: 40 }, tag: { type: 0 } },
    { id: 8, layout: { x: 0, y: 624, width: 40, height: 40 }, tag: { type: 1 } },
    { id: 9, layout: { x: 1, y: 546, width: 40, height: 40 }, tag: { type: 1 } },
    { id: 10, layout: { x: 1, y: 467, width: 40, height: 40 }, tag: { type: 1 } },
    { id: 11, layout: { x: 98, y: 470, width: 55, height: 82 }, tag: { type: 1 } },
    { id: 12, layout: { x: 98, y: 587, width: 40, height: 40 }, tag: { type: 1 } },
    { id: 13, layout: { x: 110, y: 378, width: 40, height: 40 }, tag: { type: 1 } },
    { id: 14, layout: { x: 0, y: 792, width: 132, height: 49 }, tag: { type: 2 } },
    { id: 15, layout: { x: 6, y: 709, width: 132, height: 49 }, tag: { type: 2 } },
    { id: 16, layout: { x: 491.75, y: 461, width: 132, height: 49 }, tag: { type: 1 } },
    { id: 17, layout: { x: 497.75, y: 378, width: 132, height: 49 }, tag: { type: 1 } },
    { id: 18, layout: { x: 198, y: 378, width: 248.75, height: 169.5 }, tag: { type: 1 } },
    { id: 19, layout: { x: 758.75, y: 378, width: 40, height: 40 }, tag: { type: 2 } },
    { id: 20, layout: { x: 862.75, y: 450, width: 40, height: 40 }, tag: { type: 2 } },
    { id: 21, layout: { x: 674.75, y: 458, width: 40, height: 40 }, tag: { type: 2 } },
    { id: 22, layout: { x: 763.75, y: 524, width: 40, height: 40 }, tag: { type: 2 } },
    { id: 23, layout: { x: 766.75, y: 599, width: 40, height: 40 }, tag: { type: 2 } },
    { id: 24, layout: { x: 183, y: 792, width: 132, height: 49 }, tag: { type: 2 } },
    { id: 25, layout: { x: 189, y: 709, width: 132, height: 49 }, tag: { type: 2 } },
    { id: 26, layout: { x: 366, y: 792, width: 132, height: 49 }, tag: { type: 2 } },
    { id: 27, layout: { x: 372, y: 709, width: 132, height: 49 }, tag: { type: 2 } },
    { id: 28, layout: { x: 549, y: 792, width: 132, height: 49 }, tag: { type: 2 } },
    { id: 29, layout: { x: 555, y: 709, width: 132, height: 49 }, tag: { type: 2 } },
    { id: 30, layout: { x: 648, y: 0, width: 195, height: 179 }, tag: { type: 0 } },
    { id: 31, layout: { x: 386, y: 215, width: 40, height: 40 }, tag: { type: 0 } },
    { id: 32, layout: { x: 434, y: 116, width: 40, height: 40 }, tag: { type: 0 } },
    { id: 33, layout: { x: 431, y: 0, width: 40, height: 40 }, tag: { type: 0 } },
    { id: 34, layout: { x: 324, y: 123, width: 40, height: 70 }, tag: { type: 0 } },
    { id: 35, layout: { x: 563, y: 111, width: 40, height: 40 }, tag: { type: 0 } },
    { id: 36, layout: { x: 479, y: 208, width: 40, height: 40 }, tag: { type: 0 } }
  ],
  edgeList: [
    { source: 5, target: 6 },
    { source: 4, target: 5 },
    { source: 1, target: 2 },
    { source: 3, target: 2 },
    { source: 2, target: 4 },
    { source: 0, target: 1 },
    { source: 1, target: 7 },
    { source: 11, target: 13 },
    { source: 11, target: 12 },
    { source: 10, target: 11 },
    { source: 9, target: 10 },
    { source: 8, target: 9 },
    { source: 12, target: 9 },
    { source: 14, target: 15 },
    { source: 16, target: 17 },
    { source: 19, target: 21 },
    { source: 21, target: 22 },
    { source: 22, target: 20 },
    { source: 20, target: 19 },
    { source: 23, target: 22 },
    { source: 24, target: 25 },
    { source: 26, target: 27 },
    { source: 28, target: 29 },
    { source: 32, target: 33 },
    { source: 34, target: 33 },
    { source: 33, target: 35 },
    { source: 31, target: 32 },
    { source: 32, target: 36 }
  ]
}

export const CompactDiskSampleData = {
  nodeList: [
    { id: 0, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 1, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 2, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 3, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 4, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 5, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 6, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 7, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 8, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 9, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 10, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 11, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 12, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 13, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 14, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 15, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 16, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 17, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 18, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 19, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 20, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 21, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 22, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 23, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 24, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 25, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 26, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 27, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 28, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 29, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 30, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 31, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 32, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 33, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 34, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 35, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 36, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 37, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 38, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 39, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 40, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 41, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 42, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 43, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 44, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 45, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 46, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 47, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 48, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 49, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 50, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 51, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 52, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 53, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 54, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 55, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 56, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 57, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 58, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 59, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 60, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 61, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 62, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 63, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 64, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 65, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 66, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 67, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 68, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 69, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 70, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 71, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 72, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 73, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 74, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 75, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 76, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 77, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 78, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 79, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 80, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 81, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 82, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 83, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 84, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 85, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 86, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 87, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 88, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 89, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 90, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 91, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 92, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 93, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 94, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 95, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 96, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 97, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 98, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 99, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 100, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 101, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 102, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 103, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 104, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 105, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 106, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 107, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 108, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 109, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 110, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 111, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 112, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 113, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 114, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 115, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 116, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 117, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 118, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 119, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 120, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 121, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 122, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 123, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 124, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 125, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 126, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 127, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 128, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 129, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 130, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 131, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 132, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 133, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 134, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 135, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 136, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 137, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 138, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 139, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 140, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 141, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 142, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 143, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 144, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 145, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 146, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 147, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 148, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 149, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 150, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 151, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 152, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 153, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 154, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 155, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 156, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 157, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 158, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 159, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 160, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 161, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 162, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 163, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 164, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 165, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 166, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 167, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 168, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 169, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 170, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 171, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 172, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 173, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 174, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 175, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 176, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 177, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 178, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 179, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 180, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 181, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 182, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 183, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 184, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 185, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 186, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 187, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 188, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 189, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 190, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 191, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 192, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 193, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 194, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 195, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 196, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 197, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 198, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 199, layout: { width: 40, height: 40 }, tag: { type: 2 } }
  ],
  edgeList: []
}

export const BalloonSampleData = {
  nodeList: [
    { id: 0, layout: { width: 40, height: 40 }, tag: null },
    { id: 1, layout: { width: 40, height: 40 }, tag: null },
    { id: 2, layout: { width: 68.75, height: 67.5 }, tag: { type: 1 } },
    { id: 3, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 4, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 5, layout: { width: 85.25, height: 79.25 }, tag: { type: 2 } },
    { id: 6, layout: { width: 40, height: 40 }, tag: null },
    { id: 7, layout: { width: 40, height: 40 }, tag: null },
    { id: 8, layout: { width: 40, height: 40 }, tag: null },
    { id: 9, layout: { width: 68.75, height: 67.5 }, tag: { type: 1 } },
    { id: 10, layout: { width: 40, height: 40 }, tag: null },
    { id: 11, layout: { width: 40, height: 40 }, tag: null },
    { id: 12, layout: { width: 40, height: 40 }, tag: null },
    { id: 13, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 14, layout: { width: 40, height: 40 }, tag: null },
    { id: 15, layout: { width: 40, height: 40 }, tag: null },
    { id: 16, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 17, layout: { width: 40, height: 40 }, tag: null },
    { id: 18, layout: { width: 40, height: 40 }, tag: null },
    { id: 19, layout: { width: 40, height: 40 }, tag: null },
    { id: 20, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 21, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 22, layout: { width: 40, height: 40 }, tag: null },
    { id: 23, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 24, layout: { width: 40, height: 40 }, tag: null },
    { id: 25, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 26, layout: { width: 40, height: 40 }, tag: null },
    { id: 27, layout: { width: 40, height: 40 }, tag: null },
    { id: 28, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 29, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 30, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 31, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 32, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 33, layout: { width: 40, height: 40 }, tag: null },
    { id: 34, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 35, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 36, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 37, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 38, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 39, layout: { width: 40, height: 40 }, tag: null },
    { id: 40, layout: { width: 40, height: 40 }, tag: null },
    { id: 41, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 42, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 43, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 44, layout: { width: 40, height: 40 }, tag: { type: 0 } },
    { id: 45, layout: { width: 40, height: 40 }, tag: null },
    { id: 46, layout: { width: 40, height: 40 }, tag: null },
    { id: 47, layout: { width: 40, height: 40 }, tag: null },
    { id: 48, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 49, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 50, layout: { width: 40, height: 40 }, tag: { type: 1 } },
    { id: 51, layout: { width: 85.25, height: 79.25 }, tag: { type: 2 } },
    { id: 52, layout: { width: 85.25, height: 79.25 }, tag: null },
    { id: 53, layout: { width: 85.25, height: 79.25 }, tag: null },
    { id: 54, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 55, layout: { width: 40, height: 40 }, tag: { type: 2 } },
    { id: 56, layout: { width: 40, height: 40 }, tag: null }
  ],
  edgeList: [
    { source: 0, target: 1 },
    { source: 3, target: 6 },
    { source: 0, target: 2 },
    { source: 0, target: 3 },
    { source: 0, target: 4 },
    { source: 0, target: 8 },
    { source: 0, target: 9 },
    { source: 8, target: 14 },
    { source: 8, target: 13 },
    { source: 8, target: 12 },
    { source: 8, target: 11 },
    { source: 8, target: 10 },
    { source: 9, target: 16 },
    { source: 9, target: 15 },
    { source: 15, target: 19 },
    { source: 15, target: 18 },
    { source: 15, target: 17 },
    { source: 16, target: 20 },
    { source: 16, target: 21 },
    { source: 22, target: 26 },
    { source: 22, target: 25 },
    { source: 22, target: 24 },
    { source: 22, target: 23 },
    { source: 2, target: 22 },
    { source: 3, target: 27 },
    { source: 4, target: 5 },
    { source: 7, target: 32 },
    { source: 7, target: 31 },
    { source: 7, target: 30 },
    { source: 7, target: 29 },
    { source: 7, target: 28 },
    { source: 8, target: 33 },
    { source: 8, target: 34 },
    { source: 8, target: 35 },
    { source: 8, target: 36 },
    { source: 22, target: 37 },
    { source: 22, target: 38 },
    { source: 7, target: 41 },
    { source: 7, target: 40 },
    { source: 7, target: 39 },
    { source: 9, target: 42 },
    { source: 42, target: 43 },
    { source: 42, target: 44 },
    { source: 9, target: 45 },
    { source: 45, target: 46 },
    { source: 45, target: 47 },
    { source: 9, target: 48 },
    { source: 48, target: 49 },
    { source: 48, target: 50 },
    { source: 4, target: 51 },
    { source: 4, target: 52 },
    { source: 4, target: 53 },
    { source: 2, target: 7 },
    { source: 7, target: 54 },
    { source: 7, target: 55 },
    { source: 7, target: 56 }
  ]
}

export const RadialSampleData = {
  nodeList: [
    { id: 0, layout: { width: 40, height: 40 }, tag: null },
    {
      id: 1,
      layout: { width: 40, height: 40 },
      tag: null
    },
    {
      id: 2,
      layout: { width: 40, height: 40 },
      tag: { type: 1 }
    },
    {
      id: 3,
      layout: { width: 40, height: 40 },
      tag: { type: 2 }
    },
    {
      id: 4,
      layout: { width: 40, height: 40 },
      tag: { type: 0 }
    },
    {
      id: 5,
      layout: { width: 40, height: 40 },
      tag: null
    },
    {
      id: 6,
      layout: { width: 40, height: 40 },
      tag: null
    },
    {
      id: 7,
      layout: { width: 40, height: 40 },
      tag: { type: 1 }
    },
    {
      id: 8,
      layout: { width: 40, height: 40 },
      tag: { type: 1 }
    },
    {
      id: 9,
      layout: { width: 40, height: 40 },
      tag: null
    },
    {
      id: 10,
      layout: { width: 40, height: 40 },
      tag: { type: 0 }
    },
    {
      id: 11,
      layout: { width: 40, height: 40 },
      tag: null
    },
    {
      id: 12,
      layout: { width: 40, height: 40 },
      tag: { type: 0 }
    },
    {
      id: 13,
      layout: { width: 40, height: 40 },
      tag: null
    },
    {
      id: 14,
      layout: { width: 40, height: 40 },
      tag: null
    },
    {
      id: 15,
      layout: { width: 40, height: 40 },
      tag: { type: 1 }
    },
    {
      id: 16,
      layout: { width: 40, height: 40 },
      tag: null
    },
    {
      id: 17,
      layout: { width: 40, height: 40 },
      tag: { type: 2 }
    },
    {
      id: 18,
      layout: { width: 40, height: 40 },
      tag: { type: 1 }
    },
    {
      id: 19,
      layout: { width: 40, height: 40 },
      tag: { type: 1 }
    },
    {
      id: 20,
      layout: { width: 40, height: 40 },
      tag: { type: 1 }
    },
    {
      id: 21,
      layout: { width: 40, height: 40 },
      tag: null
    },
    {
      id: 22,
      layout: { width: 40, height: 40 },
      tag: { type: 0 }
    },
    {
      id: 23,
      layout: { width: 40, height: 40 },
      tag: { type: 1 }
    },
    {
      id: 24,
      layout: { width: 40, height: 40 },
      tag: null
    },
    {
      id: 25,
      layout: { width: 40, height: 40 },
      tag: { type: 0 }
    },
    {
      id: 26,
      layout: { width: 40, height: 40 },
      tag: null
    },
    {
      id: 27,
      layout: { width: 40, height: 40 },
      tag: { type: 0 }
    },
    {
      id: 28,
      layout: { width: 40, height: 40 },
      tag: { type: 0 }
    },
    {
      id: 29,
      layout: { width: 40, height: 40 },
      tag: { type: 0 }
    },
    {
      id: 30,
      layout: { width: 40, height: 40 },
      tag: null
    },
    {
      id: 31,
      layout: { width: 40, height: 40 },
      tag: null
    },
    {
      id: 32,
      layout: { width: 40, height: 40 },
      tag: { type: 1 }
    },
    {
      id: 33,
      layout: { width: 40, height: 40 },
      tag: { type: 1 }
    },
    {
      id: 34,
      layout: { width: 40, height: 40 },
      tag: { type: 1 }
    },
    {
      id: 35,
      layout: { width: 40, height: 40 },
      tag: null
    },
    {
      id: 36,
      layout: { width: 40, height: 40 },
      tag: { type: 1 }
    },
    {
      id: 37,
      layout: { width: 40, height: 40 },
      tag: { type: 1 }
    },
    {
      id: 38,
      layout: { width: 40, height: 40 },
      tag: null
    },
    {
      id: 39,
      layout: { width: 40, height: 40 },
      tag: null
    },
    {
      id: 40,
      layout: { width: 40, height: 40 },
      tag: { type: 1 }
    },
    {
      id: 41,
      layout: { width: 40, height: 40 },
      tag: { type: 1 }
    },
    {
      id: 42,
      layout: { width: 40, height: 40 },
      tag: { type: 1 }
    },
    {
      id: 43,
      layout: { width: 55, height: 44 },
      tag: { type: 1 }
    },
    {
      id: 44,
      layout: { width: 40, height: 40 },
      tag: { type: 0 }
    },
    {
      id: 45,
      layout: { width: 40, height: 40 },
      tag: { type: 0 }
    },
    {
      id: 46,
      layout: { width: 55, height: 44 },
      tag: { type: 1 }
    },
    {
      id: 47,
      layout: { width: 55, height: 44 },
      tag: { type: 1 }
    },
    {
      id: 48,
      layout: { width: 55, height: 44 },
      tag: { type: 1 }
    }
  ],
  edgeList: [
    { source: 0, target: 1 },
    { source: 3, target: 4 },
    { source: 0, target: 2 },
    { source: 0, target: 3 },
    { source: 0, target: 6 },
    { source: 0, target: 7 },
    { source: 6, target: 10 },
    { source: 6, target: 9 },
    { source: 6, target: 8 },
    { source: 7, target: 11 },
    { source: 11, target: 14 },
    { source: 11, target: 13 },
    { source: 12, target: 15 },
    { source: 16, target: 20 },
    { source: 16, target: 19 },
    { source: 16, target: 18 },
    { source: 16, target: 17 },
    { source: 2, target: 16 },
    { source: 3, target: 21 },
    { source: 5, target: 23 },
    { source: 5, target: 22 },
    { source: 6, target: 24 },
    { source: 6, target: 25 },
    { source: 5, target: 26 },
    { source: 7, target: 27 },
    { source: 27, target: 28 },
    { source: 27, target: 29 },
    { source: 7, target: 30 },
    { source: 30, target: 31 },
    { source: 30, target: 32 },
    { source: 7, target: 33 },
    { source: 33, target: 34 },
    { source: 2, target: 5 },
    { source: 5, target: 35 },
    { source: 24, target: 36 },
    { source: 24, target: 37 },
    { source: 24, target: 38 },
    { source: 9, target: 40 },
    { source: 9, target: 39 },
    { source: 9, target: 41 },
    { source: 9, target: 42 },
    { source: 1, target: 43 },
    { source: 27, target: 45 },
    { source: 11, target: 44 },
    { source: 1, target: 46 },
    { source: 43, target: 47 },
    { source: 43, target: 48 },
    { source: 46, target: 48 },
    { source: 24, target: 48 },
    { source: 3, target: 12 },
    { source: 47, target: 15 },
    { source: 24, target: 39 }
  ]
}
