/****************************************************************************
 ** @license
 ** This demo file is part of yFiles for HTML 2.6.
 ** Copyright (c) 2000-2024 by yWorks GmbH, Vor dem Kreuzberg 28,
 ** 72070 Tuebingen, Germany. All rights reserved.
 **
 ** yFiles demo files exhibit yFiles for HTML functionalities. Any redistribution
 ** of demo files in source code or binary form, with or without
 ** modification, is not permitted.
 **
 ** Owners of a valid software license for a yFiles for HTML version that this
 ** demo is shipped with are allowed to use the demo source code as basis
 ** for their own yFiles for HTML powered applications. Use of such programs is
 ** governed by the rights and conditions as set out in the yFiles for HTML
 ** license agreement.
 **
 ** THIS SOFTWARE IS PROVIDED ''AS IS'' AND ANY EXPRESS OR IMPLIED
 ** WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 ** MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 ** NO EVENT SHALL yWorks BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 ** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 ** TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 ** PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 ** LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 ***************************************************************************/
/**
 * The type of the nodes used for the layout
 * @typedef {Object} NodeType
 * @property {number} type
 */

/**
 * The type of the input data for nodes and edges
 * @typedef {Object} DataType
 * @property {Array.<object>} nodes
 * @property {Array.<object>} edges
 */

// sample 1
export const singleStar = {
  nodes: [
    { id: 0, tag: { type: 1 } },
    { id: 1, tag: { type: 1 } },
    { id: 2, tag: { type: 1 } },
    { id: 3, tag: { type: 1 } },
    { id: 4, tag: { type: 1 } },
    { id: 5, tag: { type: 1 } },
    { id: 6, tag: { type: 1 } },
    { id: 7, tag: { type: 1 } },
    { id: 8, tag: { type: 1 } },
    { id: 9, tag: { type: 1 } },
    { id: 10, tag: { type: 1 } },
    { id: 11, tag: { type: 1 } },
    { id: 12, tag: { type: 1 } },
    { id: 13, tag: { type: 1 } },
    { id: 14, tag: { type: 1 } },
    { id: 15, tag: { type: 1 } },
    { id: 16, tag: { type: 1 } },
    { id: 17, tag: { type: 1 } },
    { id: 18, tag: { type: 1 } },
    { id: 19, tag: { type: 1 } },
    { id: 20, tag: { type: 1 } },
    { id: 21, tag: { type: 1 } },
    { id: 22, tag: { type: 1 } },
    { id: 23, tag: { type: 1 } },
    { id: 24, tag: { type: 1 } },
    { id: 25, tag: { type: 1 } },
    { id: 26, tag: { type: 1 } },
    { id: 27, tag: { type: 1 } },
    { id: 28, tag: { type: 2 } },
    { id: 29, tag: { type: 2 } },
    { id: 30, tag: { type: 2 } },
    { id: 31, tag: { type: 1 } },
    { id: 32, tag: { type: 1 } },
    { id: 33, tag: { type: 1 } },
    { id: 34, tag: { type: 1 } },
    { id: 35, tag: { type: 1 } },
    { id: 36, tag: { type: 2 } },
    { id: 37, tag: { type: 1 } },
    { id: 38, tag: { type: 1 } },
    { id: 39, tag: { type: 1 } },
    { id: 40, tag: { type: 1 } },
    { id: 41, tag: { type: 1 } },
    { id: 42, tag: { type: 1 } },
    { id: 43, tag: { type: 1 } },
    { id: 44, tag: { type: 1 } },
    { id: 45, tag: { type: 2 } },
    { id: 46, tag: { type: 2 } },
    { id: 47, tag: { type: 2 } },
    { id: 48, tag: { type: 2 } },
    { id: 49, tag: { type: 1 } }
  ],
  edges: [
    { source: 0, target: 1 },
    { source: 1, target: 2 },
    { source: 0, target: 3 },
    { source: 3, target: 2 },
    { source: 1, target: 4 },
    { source: 3, target: 4 },
    { source: 2, target: 5 },
    { source: 2, target: 6 },
    { source: 2, target: 7 },
    { source: 2, target: 8 },
    { source: 2, target: 9 },
    { source: 10, target: 1 },
    { source: 10, target: 3 },
    { source: 11, target: 1 },
    { source: 11, target: 3 },
    { source: 12, target: 1 },
    { source: 12, target: 3 },
    { source: 13, target: 1 },
    { source: 13, target: 3 },
    { source: 2, target: 14 },
    { source: 2, target: 15 },
    { source: 16, target: 1 },
    { source: 17, target: 1 },
    { source: 16, target: 3 },
    { source: 17, target: 3 },
    { source: 18, target: 1 },
    { source: 18, target: 3 },
    { source: 19, target: 1 },
    { source: 19, target: 3 },
    { source: 20, target: 1 },
    { source: 20, target: 3 },
    { source: 21, target: 1 },
    { source: 21, target: 3 },
    { source: 22, target: 1 },
    { source: 22, target: 3 },
    { source: 23, target: 1 },
    { source: 23, target: 3 },
    { source: 2, target: 24 },
    { source: 2, target: 25 },
    { source: 2, target: 26 },
    { source: 2, target: 27 },
    { source: 2, target: 28 },
    { source: 2, target: 29 },
    { source: 2, target: 30 },
    { source: 2, target: 31 },
    { source: 2, target: 32 },
    { source: 2, target: 33 },
    { source: 2, target: 34 },
    { source: 2, target: 35 },
    { source: 2, target: 36 },
    { source: 37, target: 1 },
    { source: 37, target: 3 },
    { source: 38, target: 1 },
    { source: 38, target: 3 },
    { source: 39, target: 1 },
    { source: 39, target: 3 },
    { source: 40, target: 1 },
    { source: 40, target: 3 },
    { source: 41, target: 1 },
    { source: 41, target: 3 },
    { source: 42, target: 1 },
    { source: 42, target: 3 },
    { source: 43, target: 1 },
    { source: 43, target: 3 },
    { source: 44, target: 1 },
    { source: 44, target: 3 },
    { source: 2, target: 45 },
    { source: 2, target: 46 },
    { source: 2, target: 47 },
    { source: 2, target: 48 },
    { source: 2, target: 49 },
    { source: 21, target: 22 },
    { source: 22, target: 39 },
    { source: 39, target: 43 },
    { source: 20, target: 18 },
    { source: 16, target: 40 },
    { source: 42, target: 23 },
    { source: 23, target: 13 }
  ]
}

// sample 2
export const multipleStars = {
  nodes: [
    { id: 0, tag: { type: 1 } },
    { id: 1, tag: { type: 1 } },
    { id: 2, tag: { type: 1 } },
    { id: 3, tag: { type: 1 } },
    { id: 4, tag: { type: 1 } },
    { id: 5, tag: { type: 1 } },
    { id: 6, tag: { type: 1 } },
    { id: 7, tag: { type: 1 } },
    { id: 8, tag: { type: 1 } },
    { id: 9, tag: { type: 1 } },
    { id: 10, tag: { type: 1 } },
    { id: 11, tag: { type: 2 } },
    { id: 12, tag: { type: 2 } },
    { id: 13, tag: { type: 2 } },
    { id: 14, tag: { type: 2 } },
    { id: 15, tag: { type: 2 } },
    { id: 16, tag: { type: 1 } },
    { id: 17, tag: { type: 1 } },
    { id: 18, tag: { type: 1 } },
    { id: 19, tag: { type: 2 } },
    { id: 20, tag: { type: 1 } },
    { id: 21, tag: { type: 2 } },
    { id: 22, tag: { type: 1 } },
    { id: 23, tag: { type: 1 } },
    { id: 24, tag: { type: 1 } },
    { id: 25, tag: { type: 1 } },
    { id: 26, tag: { type: 1 } },
    { id: 27, tag: { type: 1 } },
    { id: 28, tag: { type: 1 } },
    { id: 29, tag: { type: 1 } },
    { id: 30, tag: { type: 1 } },
    { id: 31, tag: { type: 1 } },
    { id: 32, tag: { type: 1 } },
    { id: 33, tag: { type: 1 } },
    { id: 34, tag: { type: 1 } },
    { id: 35, tag: { type: 1 } },
    { id: 36, tag: { type: 1 } },
    { id: 37, tag: { type: 1 } },
    { id: 38, tag: { type: 1 } },
    { id: 39, tag: { type: 1 } },
    { id: 40, tag: { type: 1 } },
    { id: 41, tag: { type: 1 } },
    { id: 42, tag: { type: 2 } },
    { id: 43, tag: { type: 2 } },
    { id: 44, tag: { type: 1 } },
    { id: 45, tag: { type: 1 } },
    { id: 46, tag: { type: 1 } },
    { id: 47, tag: { type: 1 } },
    { id: 48, tag: { type: 1 } },
    { id: 49, tag: { type: 1 } },
    { id: 50, tag: { type: 1 } },
    { id: 51, tag: { type: 1 } },
    { id: 52, tag: { type: 1 } },
    { id: 53, tag: { type: 1 } },
    { id: 54, tag: { type: 1 } },
    { id: 55, tag: { type: 1 } }
  ],
  edges: [
    { source: 1, target: 2 },
    { source: 2, target: 3 },
    { source: 3, target: 4 },
    { source: 4, target: 1 },
    { source: 1, target: 3 },
    { source: 5, target: 0 },
    { source: 6, target: 0 },
    { source: 7, target: 0 },
    { source: 8, target: 0 },
    { source: 9, target: 0 },
    { source: 10, target: 0 },
    { source: 0, target: 11 },
    { source: 0, target: 12 },
    { source: 0, target: 13 },
    { source: 0, target: 14 },
    { source: 0, target: 15 },
    { source: 1, target: 16 },
    { source: 16, target: 3 },
    { source: 2, target: 17 },
    { source: 17, target: 4 },
    { source: 1, target: 17 },
    { source: 16, target: 17 },
    { source: 3, target: 18 },
    { source: 18, target: 1 },
    { source: 17, target: 18 },
    { source: 4, target: 19 },
    { source: 4, target: 20 },
    { source: 4, target: 21 },
    { source: 4, target: 22 },
    { source: 4, target: 23 },
    { source: 1, target: 24 },
    { source: 24, target: 3 },
    { source: 24, target: 17 },
    { source: 1, target: 25 },
    { source: 25, target: 3 },
    { source: 25, target: 17 },
    { source: 1, target: 26 },
    { source: 26, target: 3 },
    { source: 26, target: 17 },
    { source: 1, target: 27 },
    { source: 27, target: 3 },
    { source: 27, target: 17 },
    { source: 28, target: 0 },
    { source: 29, target: 0 },
    { source: 30, target: 0 },
    { source: 31, target: 0 },
    { source: 32, target: 0 },
    { source: 33, target: 0 },
    { source: 34, target: 0 },
    { source: 35, target: 0 },
    { source: 0, target: 36 },
    { source: 0, target: 37 },
    { source: 38, target: 0 },
    { source: 39, target: 0 },
    { source: 0, target: 40 },
    { source: 0, target: 41 },
    { source: 4, target: 42 },
    { source: 4, target: 43 },
    { source: 1, target: 44 },
    { source: 44, target: 3 },
    { source: 1, target: 45 },
    { source: 45, target: 3 },
    { source: 44, target: 17 },
    { source: 45, target: 17 },
    { source: 1, target: 46 },
    { source: 46, target: 3 },
    { source: 46, target: 17 },
    { source: 1, target: 47 },
    { source: 47, target: 3 },
    { source: 47, target: 17 },
    { source: 48, target: 0 },
    { source: 49, target: 0 },
    { source: 0, target: 2 },
    { source: 50, target: 0 },
    { source: 51, target: 0 },
    { source: 1, target: 52 },
    { source: 52, target: 3 },
    { source: 52, target: 17 },
    { source: 1, target: 53 },
    { source: 53, target: 3 },
    { source: 53, target: 17 },
    { source: 1, target: 54 },
    { source: 54, target: 3 },
    { source: 54, target: 17 },
    { source: 1, target: 55 },
    { source: 55, target: 3 },
    { source: 55, target: 17 }
  ]
}
