<!--
 //////////////////////////////////////////////////////////////////////////////
 // @license
 // This file is part of yFiles for HTML 2.6.
 // Use is subject to license terms.
 //
 // Copyright (c) 2000-2024 by yWorks GmbH, Vor dem Kreuzberg 28,
 // 72070 Tuebingen, Germany. All rights reserved.
 //
 //////////////////////////////////////////////////////////////////////////////
-->
# Organic Layout with Constraints - Layout Features

# Organic Layout with Constraints

This demo shows how to use supplemental layout data to enforce [placement constraints](https://docs.yworks.com/yfileshtml/#/api/OrganicConstraintData) when using the [Organic Layout](https://docs.yworks.com/yfileshtml/#/api/OrganicLayout) algorithm.

The [placement constraints](https://docs.yworks.com/yfileshtml/#/api/OrganicConstraintData) used in this demo force the turquoise nodes onto a perfect circle. Without constraints, the turquoise nodes are placed on an irregular path.

Click the button in the toolbar to toggle between [Organic Layout](https://docs.yworks.com/yfileshtml/#/api/OrganicLayout) with and without constraints.

### Code Snippet

You can copy the code snippet to configure the layout from [GitHub](https://github.com/yWorks/yfiles-for-html-demos/blob/master/demos/layout-features/organic-constraints/OrganicConstraints.ts).

### Documentation

See the [Constraints](https://docs.yworks.com/yfileshtml/#/dguide/organic_layout-constraints) section in the Developer's Guide for an in-depth discussion of the relevant concepts.

See the [OrganicConstraintData](https://docs.yworks.com/yfileshtml/#/api/OrganicConstraintData) API documentation for detailed information on all available placement constraints.
