/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.fmt;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;

public class LocaleSupport {
    private static final String UNDEFINED_KEY = "???";
    private static final char HYPHEN = '-';
    private static final char UNDERSCORE = '_';
    private static final String REQUEST_CHAR_SET = "javax.servlet.jsp.jstl.fmt.request.charset";
    private static final Locale EMPTY_LOCALE = new Locale("", "");

    public static String getLocalizedMessage(PageContext pageContext, String string) {
        return LocaleSupport.getLocalizedMessage(pageContext, string, null, null);
    }

    public static String getLocalizedMessage(PageContext pageContext, String string, String string2) {
        return LocaleSupport.getLocalizedMessage(pageContext, string, null, string2);
    }

    public static String getLocalizedMessage(PageContext pageContext, String string, Object[] objectArray) {
        return LocaleSupport.getLocalizedMessage(pageContext, string, objectArray, null);
    }

    public static String getLocalizedMessage(PageContext pageContext, String string, Object[] objectArray, String string2) {
        ResourceBundle resourceBundle;
        LocalizationContext localizationContext = null;
        String string3 = UNDEFINED_KEY + string + UNDEFINED_KEY;
        localizationContext = string2 != null ? LocaleSupport.getLocalizationContext(pageContext, string2) : LocaleSupport.getLocalizationContext(pageContext);
        if (localizationContext != null && (resourceBundle = localizationContext.getResourceBundle()) != null) {
            try {
                string3 = resourceBundle.getString(string);
                if (objectArray != null) {
                    MessageFormat messageFormat = new MessageFormat("");
                    if (localizationContext.getLocale() != null) {
                        messageFormat.setLocale(localizationContext.getLocale());
                    }
                    messageFormat.applyPattern(string3);
                    string3 = messageFormat.format(objectArray);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string3;
    }

    private static LocalizationContext getLocalizationContext(PageContext pageContext) {
        LocalizationContext localizationContext = null;
        Object object = Config.find(pageContext, "javax.servlet.jsp.jstl.fmt.localizationContext");
        if (object == null) {
            return null;
        }
        localizationContext = object instanceof LocalizationContext ? (LocalizationContext)object : LocaleSupport.getLocalizationContext(pageContext, (String)object);
        return localizationContext;
    }

    private static LocalizationContext getLocalizationContext(PageContext pageContext, String string) {
        LocalizationContext localizationContext = null;
        ResourceBundle resourceBundle = null;
        if (string == null || string.equals("")) {
            return new LocalizationContext();
        }
        Locale locale = LocaleSupport.getLocale(pageContext, "javax.servlet.jsp.jstl.fmt.locale");
        if (locale != null) {
            resourceBundle = LocaleSupport.findMatch(string, locale);
            if (resourceBundle != null) {
                localizationContext = new LocalizationContext(resourceBundle, locale);
            }
        } else {
            localizationContext = LocaleSupport.findMatch(pageContext, string);
        }
        if (localizationContext == null && (locale = LocaleSupport.getLocale(pageContext, "javax.servlet.jsp.jstl.fmt.fallbackLocale")) != null && (resourceBundle = LocaleSupport.findMatch(string, locale)) != null) {
            localizationContext = new LocalizationContext(resourceBundle, locale);
        }
        if (localizationContext == null) {
            try {
                resourceBundle = ResourceBundle.getBundle(string, EMPTY_LOCALE, Thread.currentThread().getContextClassLoader());
                if (resourceBundle != null) {
                    localizationContext = new LocalizationContext(resourceBundle, null);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (localizationContext != null) {
            if (localizationContext.getLocale() != null) {
                LocaleSupport.setResponseLocale(pageContext, localizationContext.getLocale());
            }
        } else {
            localizationContext = new LocalizationContext();
        }
        return localizationContext;
    }

    private static LocalizationContext findMatch(PageContext pageContext, String string) {
        LocalizationContext localizationContext = null;
        Enumeration enumeration = LocaleSupport.getRequestLocales((HttpServletRequest)pageContext.getRequest());
        while (enumeration.hasMoreElements()) {
            Locale locale = (Locale)enumeration.nextElement();
            ResourceBundle resourceBundle = LocaleSupport.findMatch(string, locale);
            if (resourceBundle == null) continue;
            localizationContext = new LocalizationContext(resourceBundle, locale);
            break;
        }
        return localizationContext;
    }

    private static ResourceBundle findMatch(String string, Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle(string, locale, Thread.currentThread().getContextClassLoader());
            Locale locale2 = resourceBundle2.getLocale();
            if (locale.equals(locale2)) {
                resourceBundle = resourceBundle2;
            } else if (locale.getLanguage().equals(locale2.getLanguage()) && ("".equals(locale2.getCountry()) || locale.getCountry().equals(locale2.getCountry()))) {
                resourceBundle = resourceBundle2;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return resourceBundle;
    }

    private static Locale getLocale(PageContext pageContext, String string) {
        Locale locale = null;
        Object object = Config.find(pageContext, string);
        if (object != null) {
            locale = object instanceof Locale ? (Locale)object : LocaleSupport.parseLocale((String)object);
        }
        return locale;
    }

    private static void setResponseLocale(PageContext pageContext, Locale locale) {
        ServletResponse servletResponse = pageContext.getResponse();
        servletResponse.setLocale(locale);
        if (pageContext.getSession() != null) {
            try {
                pageContext.setAttribute(REQUEST_CHAR_SET, servletResponse.getCharacterEncoding(), 3);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private static Locale parseLocale(String string) {
        return LocaleSupport.parseLocale(string, null);
    }

    private static Locale parseLocale(String string, String string2) {
        Locale locale = null;
        String string3 = string;
        String string4 = null;
        int n = -1;
        n = string.indexOf(45);
        if (n > -1 || (n = string.indexOf(95)) > -1) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        if (string3 == null || string3.length() == 0) {
            throw new IllegalArgumentException("Missing language component in 'value' attribute in setLocale");
        }
        if (string4 == null) {
            locale = string2 != null ? new Locale(string3, "", string2) : new Locale(string3, "");
        } else if (string4.length() > 0) {
            locale = string2 != null ? new Locale(string3, string4, string2) : new Locale(string3, string4);
        } else {
            throw new IllegalArgumentException("Empty country component in 'value' attribute in setLocale");
        }
        return locale;
    }

    private static Enumeration getRequestLocales(HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getHeaders("accept-language");
        if (enumeration.hasMoreElements()) {
            return httpServletRequest.getLocales();
        }
        return enumeration;
    }
}

