/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.util.HashMap;
import javax.security.jacc.HttpMethodSpec;
import javax.security.jacc.URLPatternSpec;
import javax.servlet.http.HttpServletRequest;

public final class WebUserDataPermission
extends Permission
implements Serializable {
    private static String[] transportKeys = new String[]{"NONE", "INTEGRAL", "CONFIDENTIAL"};
    private static HashMap transportHash = new HashMap();
    private static int TT_NONE;
    private static int TT_CONFIDENTIAL;
    private transient URLPatternSpec urlPatternSpec = null;
    private transient HttpMethodSpec methodSpec;
    private transient int transportType;
    private transient int hashCodeValue = 0;
    private static final transient String EMPTY_STRING = "";
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields;

    public WebUserDataPermission(String string, String string2) {
        super(string);
        this.urlPatternSpec = new URLPatternSpec(string);
        this.parseActions(string2);
    }

    public WebUserDataPermission(String string, String[] stringArray, String string2) {
        super(string);
        this.urlPatternSpec = new URLPatternSpec(string);
        this.transportType = TT_NONE;
        if (string2 != null) {
            Integer n = (Integer)transportHash.get(string2);
            if (n == null) {
                throw new IllegalArgumentException("illegal transport value");
            }
            this.transportType = n;
        }
        this.methodSpec = HttpMethodSpec.getSpec(stringArray);
    }

    public WebUserDataPermission(HttpServletRequest httpServletRequest) {
        super(WebUserDataPermission.getUriMinusContextPath(httpServletRequest));
        this.urlPatternSpec = new URLPatternSpec(super.getName());
        this.transportType = httpServletRequest.isSecure() ? TT_CONFIDENTIAL : TT_NONE;
        this.methodSpec = HttpMethodSpec.getSpec(httpServletRequest.getMethod());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof WebUserDataPermission)) {
            return false;
        }
        WebUserDataPermission webUserDataPermission = (WebUserDataPermission)object;
        if (this.transportType != webUserDataPermission.transportType) {
            return false;
        }
        if (!this.methodSpec.equals(webUserDataPermission.methodSpec)) {
            return false;
        }
        return this.urlPatternSpec.equals(webUserDataPermission.urlPatternSpec);
    }

    public String getActions() {
        String string = this.methodSpec.getActions();
        String string2 = this.transportType == TT_NONE && string == null ? null : (this.transportType == TT_NONE ? string : (string == null ? ":" + transportKeys[this.transportType] : string + ":" + transportKeys[this.transportType]));
        return string2;
    }

    public int hashCode() {
        if (this.hashCodeValue == 0) {
            String string = new String(this.urlPatternSpec.toString() + " " + this.methodSpec.hashCode() + ":" + this.transportType);
            this.hashCodeValue = string.hashCode();
        }
        return this.hashCodeValue;
    }

    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof WebUserDataPermission)) {
            return false;
        }
        WebUserDataPermission webUserDataPermission = (WebUserDataPermission)permission;
        if (this.transportType != TT_NONE && this.transportType != webUserDataPermission.transportType) {
            return false;
        }
        if (!this.methodSpec.implies(webUserDataPermission.methodSpec)) {
            return false;
        }
        return this.urlPatternSpec.implies(webUserDataPermission.urlPatternSpec);
    }

    private static String getUriMinusContextPath(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getRequestURI();
        if (string != null) {
            int n;
            String string2 = httpServletRequest.getContextPath();
            int n2 = n = string2 == null ? 0 : string2.length();
            if (n > 0) {
                string = string.substring(n);
            }
            if (string.equals("/")) {
                string = EMPTY_STRING;
            }
        } else {
            string = EMPTY_STRING;
        }
        return string;
    }

    private void parseActions(String string) {
        this.transportType = TT_NONE;
        if (string == null || string.equals(EMPTY_STRING)) {
            this.methodSpec = HttpMethodSpec.getSpec((String)null);
        } else {
            int n = string.indexOf(58);
            if (n < 0) {
                this.methodSpec = HttpMethodSpec.getSpec(string);
            } else {
                this.methodSpec = n == 0 ? HttpMethodSpec.getSpec((String)null) : HttpMethodSpec.getSpec(string.substring(0, n));
                Integer n2 = (Integer)transportHash.get(string.substring(n + 1));
                if (n2 == null) {
                    throw new IllegalArgumentException("illegal transport value");
                }
                this.transportType = n2;
            }
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.parseActions((String)objectInputStream.readFields().get("actions", null));
        this.urlPatternSpec = new URLPatternSpec(super.getName());
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.putFields().put("actions", this.getActions());
        objectOutputStream.writeFields();
    }

    static {
        for (int i = 0; i < transportKeys.length; ++i) {
            transportHash.put(transportKeys[i], new Integer(i));
        }
        TT_NONE = (Integer)transportHash.get("NONE");
        TT_CONFIDENTIAL = (Integer)transportHash.get("CONFIDENTIAL");
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("actions", String.class)};
    }
}

