/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import javax.security.jacc.HttpMethodSpec;
import javax.security.jacc.URLPatternSpec;
import javax.servlet.http.HttpServletRequest;

public final class WebResourcePermission
extends Permission
implements Serializable {
    private transient HttpMethodSpec methodSpec;
    private transient URLPatternSpec urlPatternSpec = null;
    private transient int hashCodeValue = 0;
    private static final transient String EMPTY_STRING = "";
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("actions", String.class)};

    public WebResourcePermission(String string, String string2) {
        super(string);
        this.urlPatternSpec = new URLPatternSpec(string);
        this.methodSpec = HttpMethodSpec.getSpec(string2);
    }

    public WebResourcePermission(String string, String[] stringArray) {
        super(string);
        this.urlPatternSpec = new URLPatternSpec(string);
        this.methodSpec = HttpMethodSpec.getSpec(stringArray);
    }

    public WebResourcePermission(HttpServletRequest httpServletRequest) {
        super(WebResourcePermission.getUriMinusContextPath(httpServletRequest));
        this.urlPatternSpec = new URLPatternSpec(super.getName());
        this.methodSpec = HttpMethodSpec.getSpec(httpServletRequest.getMethod());
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof WebResourcePermission)) {
            return false;
        }
        WebResourcePermission webResourcePermission = (WebResourcePermission)object;
        if (!this.methodSpec.equals(webResourcePermission.methodSpec)) {
            return false;
        }
        return this.urlPatternSpec.equals(webResourcePermission.urlPatternSpec);
    }

    public String getActions() {
        return this.methodSpec.getActions();
    }

    public int hashCode() {
        if (this.hashCodeValue == 0) {
            String string = new String(this.urlPatternSpec.toString() + " " + this.methodSpec.hashCode());
            this.hashCodeValue = string.hashCode();
        }
        return this.hashCodeValue;
    }

    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof WebResourcePermission)) {
            return false;
        }
        WebResourcePermission webResourcePermission = (WebResourcePermission)permission;
        if (!this.methodSpec.implies(webResourcePermission.methodSpec)) {
            return false;
        }
        return this.urlPatternSpec.implies(webResourcePermission.urlPatternSpec);
    }

    private static String getUriMinusContextPath(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getRequestURI();
        if (string != null) {
            int n;
            String string2 = httpServletRequest.getContextPath();
            int n2 = n = string2 == null ? 0 : string2.length();
            if (n > 0) {
                string = string.substring(n);
            }
            if (string.equals("/")) {
                string = EMPTY_STRING;
            }
        } else {
            string = EMPTY_STRING;
        }
        return string;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.methodSpec = HttpMethodSpec.getSpec((String)objectInputStream.readFields().get("actions", null));
        this.urlPatternSpec = new URLPatternSpec(super.getName());
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.putFields().put("actions", this.getActions());
        objectOutputStream.writeFields();
    }
}

