/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.util.Arrays;
import javax.security.jacc.URLPattern;

class URLPatternSpec
extends URLPattern {
    private static String DEFAULT_PATTERN = "/";
    private static String EMPTY_STRING = "";
    private transient int hashCodeValue = 0;
    private String canonicalSpec = null;
    private final String urlPatternList;
    private URLPattern[] urlPatternArray = null;

    public URLPatternSpec(String string) {
        super(URLPatternSpec.getFirstPattern(string));
        int n = string.indexOf(":");
        if (n >= 0) {
            this.urlPatternList = string.substring(n + 1);
            this.setURLPatternArray();
        } else {
            this.urlPatternList = null;
        }
    }

    public String getURLPattern() {
        return super.toString();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof URLPatternSpec)) {
            return false;
        }
        URLPatternSpec uRLPatternSpec = (URLPatternSpec)object;
        return this.toString().equals(uRLPatternSpec.toString());
    }

    public int hashCode() {
        if (this.hashCodeValue == 0) {
            this.hashCodeValue = this.toString().hashCode();
        }
        return this.hashCodeValue;
    }

    public boolean implies(URLPatternSpec uRLPatternSpec) {
        if (uRLPatternSpec == null) {
            return false;
        }
        if (!super.implies(uRLPatternSpec)) {
            return false;
        }
        for (int i = 0; this.urlPatternArray != null && i < this.urlPatternArray.length; ++i) {
            if (this.urlPatternArray[i] == null || !this.urlPatternArray[i].implies(uRLPatternSpec)) continue;
            return false;
        }
        if (this.urlPatternArray != null && uRLPatternSpec.implies((URLPattern)this)) {
            int n;
            if (uRLPatternSpec.urlPatternArray == null) {
                return false;
            }
            boolean[] blArray = new boolean[this.urlPatternArray.length];
            for (n = 0; n < blArray.length; ++n) {
                blArray[n] = false;
            }
            n = 0;
            for (int i = 0; i < uRLPatternSpec.urlPatternArray.length; ++i) {
                for (int j = 0; j < blArray.length; ++j) {
                    if (blArray[j] || this.urlPatternArray[j] != null && (uRLPatternSpec.urlPatternArray[i] == null || !uRLPatternSpec.urlPatternArray[i].implies(this.urlPatternArray[j]))) continue;
                    blArray[j] = true;
                    if (++n != blArray.length) continue;
                    return true;
                }
            }
            return n == blArray.length;
        }
        return true;
    }

    public String toString() {
        if (this.canonicalSpec == null) {
            if (this.urlPatternList == null) {
                this.canonicalSpec = new String(super.toString());
            } else {
                StringBuffer stringBuffer = null;
                for (int i = 0; i < this.urlPatternArray.length; ++i) {
                    if (this.urlPatternArray[i] == null) continue;
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(this.urlPatternArray[i].toString());
                        continue;
                    }
                    stringBuffer.append(":" + this.urlPatternArray[i].toString());
                }
                this.canonicalSpec = stringBuffer == null ? new String(super.toString()) : new String(super.toString() + ":" + stringBuffer.toString());
            }
        }
        return this.canonicalSpec;
    }

    private static String getFirstPattern(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Invalid URLPatternSpec");
        }
        int n = string.indexOf(":");
        if (n < 0) {
            return string;
        }
        if (n > 0) {
            return string.substring(0, n);
        }
        if (n == 0) {
            return EMPTY_STRING;
        }
        throw new IllegalArgumentException("Invalid URLPatternSpec");
    }

    private void setURLPatternArray() {
        if (this.urlPatternArray == null && this.urlPatternList != null) {
            int n;
            String[] stringArray = this.urlPatternList.split(":", -1);
            int n2 = stringArray.length;
            if (n2 == 0) {
                throw new IllegalArgumentException("colon followed by empty URLPatternList");
            }
            this.urlPatternArray = new URLPattern[n2];
            int n3 = this.patternType();
            block12: for (n = 0; n < n2; ++n) {
                this.urlPatternArray[n] = new URLPattern(stringArray[n]);
                if (this.urlPatternArray[n].implies(this)) {
                    throw new IllegalArgumentException("pattern in URLPatternList implies first pattern");
                }
                switch (n3) {
                    case 1: 
                    case 2: {
                        switch (this.urlPatternArray[n].patternType()) {
                            case 2: {
                                if (n3 != 2 || !super.equals(this.urlPatternArray[n]) && super.implies(this.urlPatternArray[n])) break;
                                throw new IllegalArgumentException("Invalid prefix pattern in URLPatternList");
                            }
                            case 3: {
                                if (super.implies(this.urlPatternArray[n])) break;
                                throw new IllegalArgumentException("Invalid exact pattern in URLPatternList");
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid pattern type in URLPatternList");
                            }
                        }
                    }
                    case 0: {
                        if (!super.equals(this.urlPatternArray[n])) continue block12;
                        throw new IllegalArgumentException("Invalid default pattern in URLPatternList");
                    }
                    case 3: {
                        throw new IllegalArgumentException("invalid URLPatternSpec");
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid pattern type in URLPatternList");
                    }
                }
            }
            Arrays.sort(this.urlPatternArray);
            block13: for (n = 0; n < this.urlPatternArray.length; ++n) {
                if (this.urlPatternArray[n] == null) continue;
                switch (this.urlPatternArray[n].patternType()) {
                    case 2: {
                        for (int i = n + 1; i < this.urlPatternArray.length; ++i) {
                            if (!this.urlPatternArray[n].implies(this.urlPatternArray[i])) continue;
                            this.urlPatternArray[i] = null;
                        }
                        continue block13;
                    }
                }
            }
        }
    }
}

