/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

class URLPattern
implements Comparable {
    private static String DEFAULT_PATTERN = "/";
    private int patternType = -1;
    private final String pattern;
    public static final int PT_DEFAULT = 0;
    public static final int PT_EXTENSION = 1;
    public static final int PT_PREFIX = 2;
    public static final int PT_EXACT = 3;

    public URLPattern() {
        this.pattern = DEFAULT_PATTERN;
        this.patternType = 0;
    }

    public URLPattern(String string) {
        if (string == null) {
            this.pattern = DEFAULT_PATTERN;
            this.patternType = 0;
        } else {
            this.pattern = string;
        }
    }

    public int patternType() {
        if (this.patternType < 0) {
            this.patternType = this.pattern.startsWith("*.") ? 1 : (this.pattern.startsWith("/") && this.pattern.endsWith("/*") ? 2 : (this.pattern.equals(DEFAULT_PATTERN) ? 0 : 3));
        }
        return this.patternType;
    }

    public int compareTo(Object object) {
        int n;
        int n2;
        if (!(object instanceof URLPattern)) {
            throw new ClassCastException("argument must be URLPattern");
        }
        URLPattern uRLPattern = (URLPattern)object;
        if (uRLPattern == null) {
            uRLPattern = new URLPattern(null);
        }
        if ((n2 = (n = this.patternType()) - uRLPattern.patternType()) == 0) {
            if (n == 2 || n == 3) {
                n2 = this.getPatternDepth() - uRLPattern.getPatternDepth();
                if (n2 == 0) {
                    n2 = this.pattern.compareTo(uRLPattern.pattern);
                }
            } else {
                n2 = this.pattern.compareTo(uRLPattern.pattern);
            }
        }
        return n2 > 0 ? 1 : (n2 < 0 ? -1 : 0);
    }

    public boolean implies(URLPattern uRLPattern) {
        String string;
        String string2;
        if (uRLPattern == null) {
            uRLPattern = new URLPattern(null);
        }
        if ((string2 = this.pattern).equals(string = uRLPattern.pattern)) {
            return true;
        }
        if (string2.startsWith("/") && string2.endsWith("/*")) {
            int n = (string2 = string2.substring(0, string2.length() - 2)).length();
            if (n == 0) {
                return true;
            }
            return string.startsWith(string2) && (string.length() == n || string.substring(n).startsWith("/"));
        }
        if (string2.startsWith("*.")) {
            int n = string.lastIndexOf(47);
            int n2 = string.lastIndexOf(46);
            return n >= 0 && n2 > n && string.endsWith(string2.substring(1));
        }
        return string2.equals(DEFAULT_PATTERN);
    }

    public boolean equals(Object object) {
        if (!(object instanceof URLPattern)) {
            return false;
        }
        return this.pattern.equals(((URLPattern)object).pattern);
    }

    public String toString() {
        return this.pattern;
    }

    public int getPatternDepth() {
        int n = 0;
        int n2 = 1;
        while (n >= 0) {
            if ((n = this.pattern.indexOf("/", n)) < 0) continue;
            if (n == 0 && n2 != 1) {
                throw new IllegalArgumentException("// in pattern");
            }
            ++n;
        }
        return n2;
    }
}

