/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.security.SecurityPermission;
import java.util.Hashtable;
import java.util.Set;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;

public final class PolicyContext {
    private static ThreadLocal thisContextID = new ThreadLocal();
    private static ThreadLocal thisHandlerData = new ThreadLocal();
    private static Hashtable handlerTable = new Hashtable();

    private PolicyContext() {
    }

    public static void setContextID(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        thisContextID.set(string);
    }

    public static String getContextID() {
        return (String)thisContextID.get();
    }

    public static void setHandlerData(Object object) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        thisHandlerData.set(object);
    }

    public static void registerHandler(String string, PolicyContextHandler policyContextHandler, boolean bl) throws PolicyContextException {
        if (policyContextHandler == null || string == null) {
            throw new IllegalArgumentException("invalid (null) key or handler");
        }
        if (!policyContextHandler.supports(string)) {
            throw new IllegalArgumentException("handler does not support key");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        if (handlerTable.containsKey(string) && !bl) {
            throw new IllegalArgumentException("handler exists");
        }
        handlerTable.put(string, policyContextHandler);
    }

    public static Set getHandlerKeys() {
        return handlerTable.keySet();
    }

    public static Object getContext(String string) throws PolicyContextException {
        if (string == null) {
            throw new IllegalArgumentException("invalid key");
        }
        PolicyContextHandler policyContextHandler = (PolicyContextHandler)handlerTable.get(string);
        if (policyContextHandler == null || !policyContextHandler.supports(string)) {
            throw new IllegalArgumentException("unknown handler key");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        return policyContextHandler.getContext(string, thisHandlerData.get());
    }
}

