/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;

final class HttpMethodSpec {
    private static final String comma = ",";
    private static final String emptyString = "";
    private static final String exclaimationPoint = "!";
    private static final char exclaimationPointChar = '!';
    private static Object[] methodKeys = new Object[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"};
    private static int mapSize = methodKeys.length;
    private static HashMap methodHash = new HashMap();
    private static int allSet;
    private static HttpMethodSpec[] specArray;
    private static HttpMethodSpec[] exceptionSpecArray;
    private static HttpMethodSpec allSpec;
    private static ArrayList extensionMethods;
    HttpMethodSpec standardSpec;
    boolean exceptionList;
    int standardMap;
    BitSet extensionSet;
    String actions;

    static HttpMethodSpec getSpec(String string) {
        HttpMethodSpec httpMethodSpec;
        if (string == null || string.equals(emptyString)) {
            httpMethodSpec = allSpec;
        } else {
            BitSet bitSet = new BitSet();
            httpMethodSpec = HttpMethodSpec.getStandardSpec(string, bitSet);
            if (!bitSet.isEmpty()) {
                httpMethodSpec = new HttpMethodSpec(httpMethodSpec, bitSet);
            }
        }
        return httpMethodSpec;
    }

    static HttpMethodSpec getSpec(String[] stringArray) {
        HttpMethodSpec httpMethodSpec;
        if (stringArray == null || stringArray.length == 0) {
            httpMethodSpec = allSpec;
        } else {
            int n = 0;
            BitSet bitSet = new BitSet();
            for (int i = 0; i < stringArray.length; ++i) {
                Integer n2 = (Integer)methodHash.get(stringArray[i]);
                if (n2 != null) {
                    n |= n2.intValue();
                    continue;
                }
                HttpMethodSpec.setExtensionBit(stringArray[i], bitSet);
            }
            httpMethodSpec = bitSet.isEmpty() ? specArray[n] : new HttpMethodSpec(specArray[n], bitSet);
        }
        return httpMethodSpec;
    }

    public String toString() {
        return this.getActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getActions() {
        if (this.standardMap == 0 && this.extensionSet == null) {
            return null;
        }
        HttpMethodSpec httpMethodSpec = this;
        synchronized (httpMethodSpec) {
            if (this.actions != null) {
                return this.actions;
            }
            this.actions = this.standardSpec != null ? this.getExtensionActions(this.standardSpec.getActions(), this.standardMap, this.extensionSet) : this.getStandardActions(this.exceptionList, this.standardMap);
        }
        return this.actions;
    }

    public int hashCode() {
        return (this.exceptionList ? 1 : 0) + (this.standardMap << 1) + ((this.extensionSet == null ? 0 : this.extensionSet.hashCode()) << mapSize + 1);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof HttpMethodSpec) {
            bl = object == this ? true : this.hashCode() == ((HttpMethodSpec)object).hashCode();
        }
        return bl;
    }

    boolean implies(HttpMethodSpec httpMethodSpec) {
        boolean bl;
        if (this.standardMap == 0 && this.extensionSet == null) {
            bl = true;
        } else if (httpMethodSpec.standardMap == 0 && httpMethodSpec.extensionSet == null) {
            bl = false;
        } else if (this.exceptionList && httpMethodSpec.exceptionList) {
            boolean bl2 = bl = (this.standardMap & httpMethodSpec.standardMap) == this.standardMap;
            if (bl && this.extensionSet != null) {
                if (httpMethodSpec.extensionSet == null) {
                    bl = false;
                } else {
                    BitSet bitSet = (BitSet)httpMethodSpec.extensionSet.clone();
                    bitSet.and(this.extensionSet);
                    bl = bitSet.equals(this.extensionSet);
                }
            }
        } else if (this.exceptionList == httpMethodSpec.exceptionList) {
            boolean bl3 = bl = (this.standardMap & httpMethodSpec.standardMap) == httpMethodSpec.standardMap;
            if (bl && httpMethodSpec.extensionSet != null) {
                if (this.extensionSet == null) {
                    bl = false;
                } else {
                    BitSet bitSet = (BitSet)httpMethodSpec.extensionSet.clone();
                    bitSet.and(this.extensionSet);
                    bl = bitSet.equals(httpMethodSpec.extensionSet);
                }
            }
        } else if (this.exceptionList) {
            boolean bl4 = bl = (this.standardMap & httpMethodSpec.standardMap) == 0;
            if (bl && httpMethodSpec.extensionSet != null) {
                bl = this.extensionSet == null ? true : !this.extensionSet.intersects(httpMethodSpec.extensionSet);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private HttpMethodSpec(boolean bl, int n) {
        this.standardSpec = null;
        this.exceptionList = bl;
        this.standardMap = n;
        this.extensionSet = null;
        this.actions = null;
    }

    private HttpMethodSpec(HttpMethodSpec httpMethodSpec, BitSet bitSet) {
        this.standardSpec = httpMethodSpec;
        this.exceptionList = httpMethodSpec.exceptionList;
        this.standardMap = httpMethodSpec.standardMap;
        this.extensionSet = bitSet.isEmpty() ? null : bitSet;
        this.actions = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setExtensionBit(String string, BitSet bitSet) {
        int n;
        ArrayList arrayList = extensionMethods;
        synchronized (arrayList) {
            n = extensionMethods.indexOf(string);
            if (n < 0) {
                n = extensionMethods.size();
                extensionMethods.add(string);
            }
        }
        bitSet.set(n);
    }

    private static String getExtensionMethod(int n) {
        ArrayList arrayList = extensionMethods;
        synchronized (arrayList) {
            if (n >= 0 && n < extensionMethods.size()) {
                return (String)extensionMethods.get(n);
            }
            throw new RuntimeException("invalid (extensionMethods) bit position: '" + n + "' size: '" + extensionMethods.size() + " '");
        }
    }

    private static HttpMethodSpec getStandardSpec(String string, BitSet bitSet) {
        boolean bl = false;
        if (string.charAt(0) == '!') {
            bl = true;
            if (string.length() < 2) {
                throw new IllegalArgumentException("illegal HTTP method Spec actions: '" + string + "'");
            }
            string = string.substring(1);
        }
        int n = HttpMethodSpec.makeMethodSet(string, bitSet);
        HttpMethodSpec httpMethodSpec = bl ? exceptionSpecArray[n] : specArray[n];
        return httpMethodSpec;
    }

    private static int makeMethodSet(String string, BitSet bitSet) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 >= 0 && n < string.length()) {
            n3 = string.indexOf(comma, n);
            if (n3 != 0) {
                String string2 = n3 < 0 ? string.substring(n) : string.substring(n, n3);
                Integer n4 = (Integer)methodHash.get(string2);
                if (n4 != null) {
                    n2 |= n4.intValue();
                } else {
                    HttpMethodSpec.setExtensionBit(string2, bitSet);
                }
                n = n3 + 1;
                continue;
            }
            throw new IllegalArgumentException("illegal HTTP method Spec actions: '" + string + "'");
        }
        return n2;
    }

    private String getExtensionActions(String string, int n, BitSet bitSet) {
        String string2;
        ArrayList<String> arrayList = null;
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(HttpMethodSpec.getExtensionMethod(n2));
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        if (arrayList == null) {
            string2 = string;
        } else {
            Collections.sort(arrayList);
            StringBuffer stringBuffer = new StringBuffer(string == null ? (this.exceptionList ? exclaimationPoint : emptyString) : string);
            for (int i = 0; i < arrayList.size(); ++i) {
                if (i > 0 || n > 0) {
                    stringBuffer.append(comma);
                }
                stringBuffer.append(arrayList.get(i));
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    private String getStandardActions(boolean bl, int n) {
        int n2 = 1;
        StringBuffer stringBuffer = null;
        for (int i = 0; i < mapSize; ++i) {
            if ((n & n2) == n2) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(bl ? exclaimationPoint : emptyString);
                } else {
                    stringBuffer.append(comma);
                }
                stringBuffer.append((String)methodKeys[i]);
            }
            n2 *= 2;
        }
        if (stringBuffer == null) {
            return bl ? exclaimationPoint : emptyString;
        }
        return stringBuffer.toString();
    }

    static {
        int n = 1;
        for (int i = 0; i < mapSize; ++i) {
            methodHash.put(methodKeys[i], new Integer(n));
            n <<= 1;
        }
        allSet = 0;
        for (n = 0; n < mapSize; ++n) {
            allSet <<= 1;
            ++allSet;
        }
        specArray = new HttpMethodSpec[allSet + 1];
        for (n = 0; n < allSet + 1; ++n) {
            HttpMethodSpec.specArray[n] = new HttpMethodSpec(false, n);
        }
        exceptionSpecArray = new HttpMethodSpec[allSet + 1];
        for (n = 0; n < allSet + 1; ++n) {
            HttpMethodSpec.exceptionSpecArray[n] = new HttpMethodSpec(true, n);
        }
        allSpec = new HttpMethodSpec(false, 0);
        extensionMethods = new ArrayList();
    }
}

