/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.HashMap;

public final class EJBMethodPermission
extends Permission
implements Serializable {
    private static final String[] interfaceKeys = new String[]{"Local", "LocalHome", "Remote", "Home", "ServiceEndpoint"};
    private static HashMap interfaceHash = new HashMap();
    private transient int methodInterface;
    private transient String otherMethodInterface = null;
    private transient String methodName;
    private transient String methodParams;
    private transient String actions;
    private transient int hashCodeValue = 0;
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields;

    public EJBMethodPermission(String string, String string2) {
        super(string);
        this.setMethodSpec(string2);
    }

    public EJBMethodPermission(String string, String string2, String string3, String[] stringArray) {
        super(string);
        this.setMethodSpec(string2, string3, stringArray);
    }

    public EJBMethodPermission(String string, String string2, Method method) {
        super(string);
        this.setMethodSpec(string2, method);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof EJBMethodPermission)) {
            return false;
        }
        EJBMethodPermission eJBMethodPermission = (EJBMethodPermission)object;
        if (!this.getName().equals(eJBMethodPermission.getName())) {
            return false;
        }
        if (this.methodName != null ? eJBMethodPermission.methodName == null || !this.methodName.equals(eJBMethodPermission.methodName) : eJBMethodPermission.methodName != null) {
            return false;
        }
        if (this.methodInterface != eJBMethodPermission.methodInterface) {
            return false;
        }
        if (this.methodInterface == -2 && !this.otherMethodInterface.equals(eJBMethodPermission.otherMethodInterface)) {
            return false;
        }
        return !(this.methodParams != null ? eJBMethodPermission.methodParams == null || !this.methodParams.equals(eJBMethodPermission.methodParams) : eJBMethodPermission.methodParams != null);
    }

    public String getActions() {
        if (this.actions == null) {
            String string;
            String string2 = this.methodInterface == -1 ? null : (string = this.methodInterface < 0 ? this.otherMethodInterface : interfaceKeys[this.methodInterface]);
            if (this.methodName == null) {
                if (string == null) {
                    if (this.methodParams != null) {
                        this.actions = "," + this.methodParams;
                    }
                } else {
                    this.actions = this.methodParams == null ? "," + string : "," + string + this.methodParams;
                }
            } else {
                this.actions = string == null ? (this.methodParams == null ? this.methodName : this.methodName + "," + this.methodParams) : (this.methodParams == null ? this.methodName + "," + string : this.methodName + "," + string + this.methodParams);
            }
        }
        return this.actions;
    }

    public int hashCode() {
        if (this.hashCodeValue == 0) {
            String string = this.getActions();
            String string2 = string == null ? this.getName() : new String(this.getName() + " " + string);
            this.hashCodeValue = string2.hashCode();
        }
        return this.hashCodeValue;
    }

    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof EJBMethodPermission)) {
            return false;
        }
        EJBMethodPermission eJBMethodPermission = (EJBMethodPermission)permission;
        if (!this.getName().equals(eJBMethodPermission.getName())) {
            return false;
        }
        if (!(this.methodName == null || eJBMethodPermission.methodName != null && this.methodName.equals(eJBMethodPermission.methodName))) {
            return false;
        }
        if (this.methodInterface != -1 && (eJBMethodPermission.methodInterface == -1 || this.methodInterface != eJBMethodPermission.methodInterface)) {
            return false;
        }
        if (this.methodInterface == -2 && !this.otherMethodInterface.equals(eJBMethodPermission.otherMethodInterface)) {
            return false;
        }
        return this.methodParams == null || eJBMethodPermission.methodParams != null && this.methodParams.equals(eJBMethodPermission.methodParams);
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.setMethodSpec((String)objectInputStream.readFields().get("actions", null));
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.putFields().put("actions", this.getActions());
        objectOutputStream.writeFields();
    }

    private void setMethodSpec(String string) {
        String string2 = null;
        this.methodName = null;
        this.methodParams = null;
        if (string != null) {
            if (string.length() > 0) {
                int n = string.indexOf(44);
                if (n < 0) {
                    this.methodName = string;
                } else if (n >= 0) {
                    if (n != 0) {
                        this.methodName = string.substring(0, n);
                    }
                    if (string.length() == n + 1) {
                        throw new IllegalArgumentException("illegal actions spec");
                    }
                    int n2 = string.substring(n + 1).indexOf(44);
                    if (n2 < 0) {
                        string2 = string.substring(n + 1);
                    } else {
                        if (n2 > 0) {
                            string2 = string.substring(n + 1, n + n2 + 1);
                        }
                        this.methodParams = string.substring(n + n2 + 1);
                        if (this.methodParams.length() > 1 && this.methodParams.endsWith(",")) {
                            throw new IllegalArgumentException("illegal methodParam");
                        }
                    }
                }
            } else {
                string = null;
            }
        }
        this.methodInterface = EJBMethodPermission.validateInterface(string2);
        if (this.methodInterface < -1) {
            this.otherMethodInterface = string2;
        }
        this.actions = string;
    }

    private void setMethodSpec(String string, String string2, String[] stringArray) {
        if (string != null && string.indexOf(44) >= 0) {
            throw new IllegalArgumentException("illegal methodName");
        }
        this.methodInterface = EJBMethodPermission.validateInterface(string2);
        if (this.methodInterface < -1) {
            this.otherMethodInterface = string2;
        }
        if (stringArray != null) {
            StringBuffer stringBuffer = new StringBuffer(",");
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].indexOf(44) >= 0) {
                    throw new IllegalArgumentException("illegal methodParam");
                }
                if (i == 0) {
                    stringBuffer.append(stringArray[i]);
                    continue;
                }
                stringBuffer.append("," + stringArray[i]);
            }
            this.methodParams = stringBuffer.toString();
        } else {
            this.methodParams = null;
        }
        this.methodName = string;
    }

    private void setMethodSpec(String string, Method method) {
        this.methodInterface = EJBMethodPermission.validateInterface(string);
        if (this.methodInterface < -1) {
            this.otherMethodInterface = string;
        }
        this.methodName = method.getName();
        Class<?>[] classArray = method.getParameterTypes();
        StringBuffer stringBuffer = new StringBuffer(",");
        for (int i = 0; i < classArray.length; ++i) {
            String string2 = classArray[i].getName();
            Class<?> clazz = classArray[i].getComponentType();
            if (clazz != null) {
                String string3 = "[]";
                while (clazz.getComponentType() != null) {
                    clazz = clazz.getComponentType();
                    string3 = string3 + "[]";
                }
                string2 = clazz.getName() + string3;
            }
            if (i == 0) {
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append("," + string2);
        }
        this.methodParams = stringBuffer.toString();
    }

    private static int validateInterface(String string) {
        int n = -1;
        if (string != null && string.length() > 0) {
            Integer n2 = (Integer)interfaceHash.get(string);
            n = n2 != null ? n2 : -2;
        }
        return n;
    }

    static {
        for (int i = 0; i < interfaceKeys.length; ++i) {
            interfaceHash.put(interfaceKeys[i], new Integer(i));
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("actions", String.class)};
    }
}

