/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.search.AddressTerm;

public final class RecipientTerm
extends AddressTerm {
    protected Message.RecipientType type;
    private static final long serialVersionUID = 6548700653122680468L;

    public RecipientTerm(Message.RecipientType recipientType, Address address) {
        super(address);
        this.type = recipientType;
    }

    public Message.RecipientType getRecipientType() {
        return this.type;
    }

    public boolean match(Message message) {
        Address[] addressArray;
        try {
            addressArray = message.getRecipients(this.type);
        }
        catch (Exception exception) {
            return false;
        }
        if (addressArray == null) {
            return false;
        }
        for (int i = 0; i < addressArray.length; ++i) {
            if (!super.match(addressArray[i])) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RecipientTerm)) {
            return false;
        }
        RecipientTerm recipientTerm = (RecipientTerm)object;
        return recipientTerm.type.equals(this.type) && super.equals(object);
    }

    public int hashCode() {
        return this.type.hashCode() + super.hashCode();
    }
}

