/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Message;
import javax.mail.search.SearchTerm;

public final class AndTerm
extends SearchTerm {
    protected SearchTerm[] terms;
    private static final long serialVersionUID = -3583274505380989582L;

    public AndTerm(SearchTerm searchTerm, SearchTerm searchTerm2) {
        this.terms = new SearchTerm[2];
        this.terms[0] = searchTerm;
        this.terms[1] = searchTerm2;
    }

    public AndTerm(SearchTerm[] searchTermArray) {
        this.terms = new SearchTerm[searchTermArray.length];
        for (int i = 0; i < searchTermArray.length; ++i) {
            this.terms[i] = searchTermArray[i];
        }
    }

    public SearchTerm[] getTerms() {
        return (SearchTerm[])this.terms.clone();
    }

    public boolean match(Message message) {
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i].match(message)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AndTerm)) {
            return false;
        }
        AndTerm andTerm = (AndTerm)object;
        if (andTerm.terms.length != this.terms.length) {
            return false;
        }
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i].equals(andTerm.terms[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.terms.length; ++i) {
            n += this.terms[i].hashCode();
        }
        return n;
    }
}

