/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.LineOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessageAware;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.MultipartDataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.SharedInputStream;
import javax.mail.internet.UniqueValue;

public class MimeMultipart
extends Multipart {
    private static boolean ignoreMissingEndBoundary = true;
    private static boolean ignoreMissingBoundaryParameter = true;
    private static boolean bmparse = true;
    protected DataSource ds = null;
    protected boolean parsed = true;
    private boolean complete = true;
    private String preamble = null;

    public MimeMultipart() {
        this("mixed");
    }

    public MimeMultipart(String string) {
        String string2 = UniqueValue.getUniqueBoundaryValue();
        ContentType contentType = new ContentType("multipart", string, null);
        contentType.setParameter("boundary", string2);
        this.contentType = contentType.toString();
    }

    public MimeMultipart(DataSource dataSource) throws MessagingException {
        if (dataSource instanceof MessageAware) {
            MessageContext messageContext = ((MessageAware)((Object)dataSource)).getMessageContext();
            this.setParent(messageContext.getPart());
        }
        if (dataSource instanceof MultipartDataSource) {
            this.setMultipartDataSource((MultipartDataSource)dataSource);
            return;
        }
        this.parsed = false;
        this.ds = dataSource;
        this.contentType = dataSource.getContentType();
    }

    public synchronized void setSubType(String string) throws MessagingException {
        ContentType contentType = new ContentType(this.contentType);
        contentType.setSubType(string);
        this.contentType = contentType.toString();
    }

    public synchronized int getCount() throws MessagingException {
        this.parse();
        return super.getCount();
    }

    public synchronized BodyPart getBodyPart(int n) throws MessagingException {
        this.parse();
        return super.getBodyPart(n);
    }

    public synchronized BodyPart getBodyPart(String string) throws MessagingException {
        this.parse();
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            MimeBodyPart mimeBodyPart = (MimeBodyPart)this.getBodyPart(i);
            String string2 = mimeBodyPart.getContentID();
            if (string2 == null || !string2.equals(string)) continue;
            return mimeBodyPart;
        }
        return null;
    }

    public boolean isComplete() throws MessagingException {
        this.parse();
        return this.complete;
    }

    public String getPreamble() throws MessagingException {
        this.parse();
        return this.preamble;
    }

    public void setPreamble(String string) throws MessagingException {
        this.preamble = string;
    }

    protected void updateHeaders() throws MessagingException {
        for (int i = 0; i < this.parts.size(); ++i) {
            ((MimeBodyPart)this.parts.elementAt(i)).updateHeaders();
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        this.parse();
        String string = "--" + new ContentType(this.contentType).getParameter("boundary");
        LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
        if (this.preamble != null) {
            byte[] byArray = ASCIIUtility.getBytes((String)this.preamble);
            lineOutputStream.write(byArray);
            if (byArray.length > 0 && byArray[byArray.length - 1] != 13 && byArray[byArray.length - 1] != 10) {
                lineOutputStream.writeln();
            }
        }
        for (int i = 0; i < this.parts.size(); ++i) {
            lineOutputStream.writeln(string);
            ((MimeBodyPart)this.parts.elementAt(i)).writeTo(outputStream);
            lineOutputStream.writeln();
        }
        lineOutputStream.writeln(string + "--");
    }

    protected synchronized void parse() throws MessagingException {
        if (this.parsed) {
            return;
        }
        if (bmparse) {
            this.parsebm();
            return;
        }
        InputStream inputStream = null;
        SharedInputStream sharedInputStream = null;
        long l = 0L;
        long l2 = 0L;
        try {
            inputStream = this.ds.getInputStream();
            if (!(inputStream instanceof ByteArrayInputStream || inputStream instanceof BufferedInputStream || inputStream instanceof SharedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
        }
        catch (Exception exception) {
            throw new MessagingException("No inputstream from datasource");
        }
        if (inputStream instanceof SharedInputStream) {
            sharedInputStream = (SharedInputStream)((Object)inputStream);
        }
        ContentType contentType = new ContentType(this.contentType);
        String string = null;
        String string2 = contentType.getParameter("boundary");
        if (string2 != null) {
            string = "--" + string2;
        } else if (!ignoreMissingBoundaryParameter) {
            throw new MessagingException("Missing boundary parameter");
        }
        try {
            int n;
            String string3;
            LineInputStream lineInputStream = new LineInputStream(inputStream);
            String string4 = null;
            while ((string3 = lineInputStream.readLine()) != null) {
                int n2;
                for (n2 = string3.length() - 1; n2 >= 0 && ((n = (int)string3.charAt(n2)) == 32 || n == 9); --n2) {
                }
                string3 = string3.substring(0, n2 + 1);
                if (string != null) {
                    if (string3.equals(string)) {
                        break;
                    }
                } else if (string3.startsWith("--")) {
                    string = string3;
                    break;
                }
                if (string3.length() <= 0) continue;
                if (string4 == null) {
                    try {
                        string4 = System.getProperty("line.separator", "\n");
                    }
                    catch (SecurityException securityException) {
                        string4 = "\n";
                    }
                }
                if (this.preamble == null) {
                    this.preamble = string3 + string4;
                    continue;
                }
                this.preamble = this.preamble + string3 + string4;
            }
            if (string3 == null) {
                throw new MessagingException("Missing start boundary");
            }
            byte[] byArray = ASCIIUtility.getBytes((String)string);
            n = byArray.length;
            boolean bl = false;
            while (!bl) {
                InternetHeaders internetHeaders = null;
                if (sharedInputStream != null) {
                    l = sharedInputStream.getPosition();
                    while ((string3 = lineInputStream.readLine()) != null && string3.length() > 0) {
                    }
                    if (string3 == null) {
                        if (!ignoreMissingEndBoundary) {
                            throw new MessagingException("missing multipart end boundary");
                        }
                        this.complete = false;
                        break;
                    }
                } else {
                    internetHeaders = this.createInternetHeaders(inputStream);
                }
                if (!inputStream.markSupported()) {
                    throw new MessagingException("Stream doesn't support mark");
                }
                ByteArrayOutputStream byteArrayOutputStream = null;
                if (sharedInputStream == null) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                } else {
                    l2 = sharedInputStream.getPosition();
                }
                boolean bl2 = true;
                int n3 = -1;
                int n4 = -1;
                while (true) {
                    int n5;
                    if (bl2) {
                        int n6;
                        inputStream.mark(n + 4 + 1000);
                        for (n6 = 0; n6 < n && inputStream.read() == (byArray[n6] & 0xFF); ++n6) {
                        }
                        if (n6 == n) {
                            int n7 = inputStream.read();
                            if (n7 == 45 && inputStream.read() == 45) {
                                this.complete = true;
                                bl = true;
                                break;
                            }
                            while (n7 == 32 || n7 == 9) {
                                n7 = inputStream.read();
                            }
                            if (n7 == 10) break;
                            if (n7 == 13) {
                                inputStream.mark(1);
                                if (inputStream.read() == 10) break;
                                inputStream.reset();
                                break;
                            }
                        }
                        inputStream.reset();
                        if (byteArrayOutputStream != null && n3 != -1) {
                            byteArrayOutputStream.write(n3);
                            if (n4 != -1) {
                                byteArrayOutputStream.write(n4);
                            }
                            n4 = -1;
                            n3 = -1;
                        }
                    }
                    if ((n5 = inputStream.read()) < 0) {
                        if (!ignoreMissingEndBoundary) {
                            throw new MessagingException("missing multipart end boundary");
                        }
                        this.complete = false;
                        bl = true;
                        break;
                    }
                    if (n5 == 13 || n5 == 10) {
                        bl2 = true;
                        if (sharedInputStream != null) {
                            l2 = sharedInputStream.getPosition() - 1L;
                        }
                        n3 = n5;
                        if (n5 != 13) continue;
                        inputStream.mark(1);
                        n5 = inputStream.read();
                        if (n5 == 10) {
                            n4 = n5;
                            continue;
                        }
                        inputStream.reset();
                        continue;
                    }
                    bl2 = false;
                    if (byteArrayOutputStream == null) continue;
                    byteArrayOutputStream.write(n5);
                }
                MimeBodyPart mimeBodyPart = sharedInputStream != null ? this.createMimeBodyPart(sharedInputStream.newStream(l, l2)) : this.createMimeBodyPart(internetHeaders, byteArrayOutputStream.toByteArray());
                this.addBodyPart(mimeBodyPart);
            }
        }
        catch (IOException iOException) {
            throw new MessagingException("IO Error", iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.parsed = true;
    }

    private synchronized void parsebm() throws MessagingException {
        if (this.parsed) {
            return;
        }
        InputStream inputStream = null;
        SharedInputStream sharedInputStream = null;
        long l = 0L;
        long l2 = 0L;
        try {
            inputStream = this.ds.getInputStream();
            if (!(inputStream instanceof ByteArrayInputStream || inputStream instanceof BufferedInputStream || inputStream instanceof SharedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
        }
        catch (Exception exception) {
            throw new MessagingException("No inputstream from datasource");
        }
        if (inputStream instanceof SharedInputStream) {
            sharedInputStream = (SharedInputStream)((Object)inputStream);
        }
        ContentType contentType = new ContentType(this.contentType);
        String string = null;
        String string2 = contentType.getParameter("boundary");
        if (string2 != null) {
            string = "--" + string2;
        } else if (!ignoreMissingBoundaryParameter) {
            throw new MessagingException("Missing boundary parameter");
        }
        try {
            int n;
            int n2;
            String string3;
            LineInputStream lineInputStream = new LineInputStream(inputStream);
            String string4 = null;
            while ((string3 = lineInputStream.readLine()) != null) {
                int n3;
                for (n3 = string3.length() - 1; n3 >= 0 && ((n2 = (int)string3.charAt(n3)) == 32 || n2 == 9); --n3) {
                }
                string3 = string3.substring(0, n3 + 1);
                if (string != null) {
                    if (string3.equals(string)) {
                        break;
                    }
                } else if (string3.startsWith("--")) {
                    string = string3;
                    break;
                }
                if (string3.length() <= 0) continue;
                if (string4 == null) {
                    try {
                        string4 = System.getProperty("line.separator", "\n");
                    }
                    catch (SecurityException securityException) {
                        string4 = "\n";
                    }
                }
                if (this.preamble == null) {
                    this.preamble = string3 + string4;
                    continue;
                }
                this.preamble = this.preamble + string3 + string4;
            }
            if (string3 == null) {
                throw new MessagingException("Missing start boundary");
            }
            byte[] byArray = ASCIIUtility.getBytes((String)string);
            n2 = byArray.length;
            int[] nArray = new int[256];
            for (int i = 0; i < n2; ++i) {
                nArray[byArray[i]] = i + 1;
            }
            int[] nArray2 = new int[n2];
            block16: for (n = n2; n > 0; --n) {
                int n4;
                for (n4 = n2 - 1; n4 >= n; --n4) {
                    if (byArray[n4] != byArray[n4 - n]) continue block16;
                    nArray2[n4 - 1] = n;
                }
                while (n4 > 0) {
                    nArray2[--n4] = n;
                }
            }
            nArray2[n2 - 1] = 1;
            n = 0;
            while (n == 0) {
                MimeBodyPart mimeBodyPart;
                int n5;
                InternetHeaders internetHeaders = null;
                if (sharedInputStream != null) {
                    l = sharedInputStream.getPosition();
                    while ((string3 = lineInputStream.readLine()) != null && string3.length() > 0) {
                    }
                    if (string3 == null) {
                        if (!ignoreMissingEndBoundary) {
                            throw new MessagingException("missing multipart end boundary");
                        }
                        this.complete = false;
                        break;
                    }
                } else {
                    internetHeaders = this.createInternetHeaders(inputStream);
                }
                if (!inputStream.markSupported()) {
                    throw new MessagingException("Stream doesn't support mark");
                }
                ByteArrayOutputStream byteArrayOutputStream = null;
                if (sharedInputStream == null) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                } else {
                    l2 = sharedInputStream.getPosition();
                }
                byte[] byArray2 = new byte[n2];
                byte[] byArray3 = new byte[n2];
                int n6 = 0;
                int n7 = 0;
                boolean bl = true;
                while (true) {
                    int n8;
                    int n9;
                    inputStream.mark(n2 + 4 + 1000);
                    n5 = 0;
                    n6 = inputStream.read(byArray2, 0, n2);
                    if (n6 < n2) {
                        if (!ignoreMissingEndBoundary) {
                            throw new MessagingException("missing multipart end boundary");
                        }
                        if (sharedInputStream != null) {
                            l2 = sharedInputStream.getPosition();
                        }
                        this.complete = false;
                        n = 1;
                        break;
                    }
                    for (n9 = n2 - 1; n9 >= 0 && byArray2[n9] == byArray[n9]; --n9) {
                    }
                    if (n9 < 0) {
                        byte by;
                        n5 = 0;
                        if (!(bl || (by = byArray3[n7 - 1]) != 13 && by != 10)) {
                            n5 = 1;
                            if (by == 10 && n7 >= 2 && (by = byArray3[n7 - 2]) == 13) {
                                n5 = 2;
                            }
                        }
                        if (bl || n5 > 0) {
                            if (sharedInputStream != null) {
                                l2 = sharedInputStream.getPosition() - (long)n2 - (long)n5;
                            }
                            if ((n8 = inputStream.read()) == 45 && inputStream.read() == 45) {
                                this.complete = true;
                                n = 1;
                                break;
                            }
                            while (n8 == 32 || n8 == 9) {
                                n8 = inputStream.read();
                            }
                            if (n8 == 10) break;
                            if (n8 == 13) {
                                inputStream.mark(1);
                                if (inputStream.read() == 10) break;
                                inputStream.reset();
                                break;
                            }
                        }
                        n9 = 0;
                    }
                    if ((n8 = Math.max(n9 + 1 - nArray[byArray2[n9] & 0x7F], nArray2[n9])) < 2) {
                        if (sharedInputStream == null && n7 > 1) {
                            byteArrayOutputStream.write(byArray3, 0, n7 - 1);
                        }
                        inputStream.reset();
                        inputStream.skip(1L);
                        if (n7 >= 1) {
                            byArray3[0] = byArray3[n7 - 1];
                            byArray3[1] = byArray2[0];
                            n7 = 2;
                        } else {
                            byArray3[0] = byArray2[0];
                            n7 = 1;
                        }
                    } else {
                        if (n7 > 0 && sharedInputStream == null) {
                            byteArrayOutputStream.write(byArray3, 0, n7);
                        }
                        n7 = n8;
                        inputStream.reset();
                        inputStream.skip(n7);
                        byte[] byArray4 = byArray2;
                        byArray2 = byArray3;
                        byArray3 = byArray4;
                    }
                    bl = false;
                }
                if (sharedInputStream != null) {
                    mimeBodyPart = this.createMimeBodyPart(sharedInputStream.newStream(l, l2));
                } else {
                    if (n7 - n5 > 0) {
                        byteArrayOutputStream.write(byArray3, 0, n7 - n5);
                    }
                    if (!this.complete && n6 > 0) {
                        byteArrayOutputStream.write(byArray2, 0, n6);
                    }
                    mimeBodyPart = this.createMimeBodyPart(internetHeaders, byteArrayOutputStream.toByteArray());
                }
                this.addBodyPart(mimeBodyPart);
            }
        }
        catch (IOException iOException) {
            throw new MessagingException("IO Error", iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        this.parsed = true;
    }

    protected InternetHeaders createInternetHeaders(InputStream inputStream) throws MessagingException {
        return new InternetHeaders(inputStream);
    }

    protected MimeBodyPart createMimeBodyPart(InternetHeaders internetHeaders, byte[] byArray) throws MessagingException {
        return new MimeBodyPart(internetHeaders, byArray);
    }

    protected MimeBodyPart createMimeBodyPart(InputStream inputStream) throws MessagingException {
        return new MimeBodyPart(inputStream);
    }

    static {
        try {
            String string = System.getProperty("mail.mime.multipart.ignoremissingendboundary");
            ignoreMissingEndBoundary = string == null || !string.equalsIgnoreCase("false");
            string = System.getProperty("mail.mime.multipart.ignoremissingboundaryparameter");
            ignoreMissingBoundaryParameter = string == null || !string.equalsIgnoreCase("false");
            string = System.getProperty("mail.mime.multipart.bmparse");
            bmparse = string == null || !string.equalsIgnoreCase("false");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

