/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.LineInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.mail.Header;
import javax.mail.MessagingException;

public class InternetHeaders {
    protected List headers = new ArrayList(40);

    public InternetHeaders() {
        this.headers.add(new InternetHeader("Return-Path", null));
        this.headers.add(new InternetHeader("Received", null));
        this.headers.add(new InternetHeader("Resent-Date", null));
        this.headers.add(new InternetHeader("Resent-From", null));
        this.headers.add(new InternetHeader("Resent-Sender", null));
        this.headers.add(new InternetHeader("Resent-To", null));
        this.headers.add(new InternetHeader("Resent-Cc", null));
        this.headers.add(new InternetHeader("Resent-Bcc", null));
        this.headers.add(new InternetHeader("Resent-Message-Id", null));
        this.headers.add(new InternetHeader("Date", null));
        this.headers.add(new InternetHeader("From", null));
        this.headers.add(new InternetHeader("Sender", null));
        this.headers.add(new InternetHeader("Reply-To", null));
        this.headers.add(new InternetHeader("To", null));
        this.headers.add(new InternetHeader("Cc", null));
        this.headers.add(new InternetHeader("Bcc", null));
        this.headers.add(new InternetHeader("Message-Id", null));
        this.headers.add(new InternetHeader("In-Reply-To", null));
        this.headers.add(new InternetHeader("References", null));
        this.headers.add(new InternetHeader("Subject", null));
        this.headers.add(new InternetHeader("Comments", null));
        this.headers.add(new InternetHeader("Keywords", null));
        this.headers.add(new InternetHeader("Errors-To", null));
        this.headers.add(new InternetHeader("MIME-Version", null));
        this.headers.add(new InternetHeader("Content-Type", null));
        this.headers.add(new InternetHeader("Content-Transfer-Encoding", null));
        this.headers.add(new InternetHeader("Content-MD5", null));
        this.headers.add(new InternetHeader(":", null));
        this.headers.add(new InternetHeader("Content-Length", null));
        this.headers.add(new InternetHeader("Status", null));
    }

    public InternetHeaders(InputStream inputStream) throws MessagingException {
        this.load(inputStream);
    }

    public void load(InputStream inputStream) throws MessagingException {
        LineInputStream lineInputStream = new LineInputStream(inputStream);
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            do {
                if ((string2 = lineInputStream.readLine()) != null && (string2.startsWith(" ") || string2.startsWith("\t"))) {
                    if (string != null) {
                        stringBuffer.append(string);
                        string = null;
                    }
                    stringBuffer.append("\r\n");
                    stringBuffer.append(string2);
                    continue;
                }
                if (string != null) {
                    this.addHeaderLine(string);
                } else if (stringBuffer.length() > 0) {
                    this.addHeaderLine(stringBuffer.toString());
                    stringBuffer.setLength(0);
                }
                string = string2;
            } while (string2 != null && string2.length() > 0);
        }
        catch (IOException iOException) {
            throw new MessagingException("Error in input stream", iOException);
        }
    }

    public String[] getHeader(String string) {
        String[] stringArray;
        Iterator iterator = this.headers.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            if (!string.equalsIgnoreCase(stringArray.getName()) || stringArray.line == null) continue;
            arrayList.add(stringArray.getValue());
        }
        if (arrayList.size() == 0) {
            return null;
        }
        stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    public String getHeader(String string, String string2) {
        String[] stringArray = this.getHeader(string);
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 1 || string2 == null) {
            return stringArray[0];
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(string2);
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public void setHeader(String string, String string2) {
        boolean bl = false;
        for (int i = 0; i < this.headers.size(); ++i) {
            InternetHeader internetHeader = (InternetHeader)this.headers.get(i);
            if (!string.equalsIgnoreCase(internetHeader.getName())) continue;
            if (!bl) {
                int n;
                internetHeader.line = internetHeader.line != null && (n = internetHeader.line.indexOf(58)) >= 0 ? internetHeader.line.substring(0, n + 1) + " " + string2 : string + ": " + string2;
                bl = true;
                continue;
            }
            this.headers.remove(i);
            --i;
        }
        if (!bl) {
            this.addHeader(string, string2);
        }
    }

    public void addHeader(String string, String string2) {
        boolean bl;
        int n = this.headers.size();
        boolean bl2 = bl = string.equalsIgnoreCase("Received") || string.equalsIgnoreCase("Return-Path");
        if (bl) {
            n = 0;
        }
        for (int i = this.headers.size() - 1; i >= 0; --i) {
            InternetHeader internetHeader = (InternetHeader)this.headers.get(i);
            if (string.equalsIgnoreCase(internetHeader.getName())) {
                if (bl) {
                    n = i;
                } else {
                    this.headers.add(i + 1, new InternetHeader(string, string2));
                    return;
                }
            }
            if (!internetHeader.getName().equals(":")) continue;
            n = i;
        }
        this.headers.add(n, new InternetHeader(string, string2));
    }

    public void removeHeader(String string) {
        for (int i = 0; i < this.headers.size(); ++i) {
            InternetHeader internetHeader = (InternetHeader)this.headers.get(i);
            if (!string.equalsIgnoreCase(internetHeader.getName())) continue;
            internetHeader.line = null;
        }
    }

    public Enumeration getAllHeaders() {
        return new matchEnum(this.headers, null, false, false);
    }

    public Enumeration getMatchingHeaders(String[] stringArray) {
        return new matchEnum(this.headers, stringArray, true, false);
    }

    public Enumeration getNonMatchingHeaders(String[] stringArray) {
        return new matchEnum(this.headers, stringArray, false, false);
    }

    public void addHeaderLine(String string) {
        try {
            char c = string.charAt(0);
            if (c == ' ' || c == '\t') {
                InternetHeader internetHeader = (InternetHeader)this.headers.get(this.headers.size() - 1);
                internetHeader.line = internetHeader.line + "\r\n" + string;
            } else {
                this.headers.add(new InternetHeader(string));
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public Enumeration getAllHeaderLines() {
        return this.getNonMatchingHeaderLines(null);
    }

    public Enumeration getMatchingHeaderLines(String[] stringArray) {
        return new matchEnum(this.headers, stringArray, true, true);
    }

    public Enumeration getNonMatchingHeaderLines(String[] stringArray) {
        return new matchEnum(this.headers, stringArray, false, true);
    }

    protected static final class InternetHeader
    extends Header {
        String line;

        public InternetHeader(String string) {
            super("", "");
            int n = string.indexOf(58);
            this.name = n < 0 ? string.trim() : string.substring(0, n).trim();
            this.line = string;
        }

        public InternetHeader(String string, String string2) {
            super(string, "");
            this.line = string2 != null ? string + ": " + string2 : null;
        }

        public String getValue() {
            char c;
            int n;
            int n2 = this.line.indexOf(58);
            if (n2 < 0) {
                return this.line;
            }
            for (n = n2 + 1; n < this.line.length() && ((c = this.line.charAt(n)) == ' ' || c == '\t' || c == '\r' || c == '\n'); ++n) {
            }
            return this.line.substring(n);
        }
    }

    static class matchEnum
    implements Enumeration {
        private Iterator e;
        private String[] names;
        private boolean match;
        private boolean want_line;
        private InternetHeader next_header;

        matchEnum(List list, String[] stringArray, boolean bl, boolean bl2) {
            this.e = list.iterator();
            this.names = stringArray;
            this.match = bl;
            this.want_line = bl2;
            this.next_header = null;
        }

        public boolean hasMoreElements() {
            if (this.next_header == null) {
                this.next_header = this.nextMatch();
            }
            return this.next_header != null;
        }

        public Object nextElement() {
            if (this.next_header == null) {
                this.next_header = this.nextMatch();
            }
            if (this.next_header == null) {
                throw new NoSuchElementException("No more headers");
            }
            InternetHeader internetHeader = this.next_header;
            this.next_header = null;
            if (this.want_line) {
                return internetHeader.line;
            }
            return new Header(internetHeader.getName(), internetHeader.getValue());
        }

        private InternetHeader nextMatch() {
            block0: while (this.e.hasNext()) {
                InternetHeader internetHeader = (InternetHeader)this.e.next();
                if (internetHeader.line == null) continue;
                if (this.names == null) {
                    return this.match ? null : internetHeader;
                }
                for (int i = 0; i < this.names.length; ++i) {
                    if (!this.names[i].equalsIgnoreCase(internetHeader.getName())) continue;
                    if (!this.match) continue block0;
                    return internetHeader;
                }
                if (this.match) continue;
                return internetHeader;
            }
            return null;
        }
    }
}

