/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.MessageFactory;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class LongRangeValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "javax.faces.LongRange";
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.MINIMUM";
    public static final String NOT_IN_RANGE_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.NOT_IN_RANGE";
    public static final String TYPE_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.TYPE";
    private long maximum = 0L;
    private boolean maximumSet = false;
    private long minimum = 0L;
    private boolean minimumSet = false;
    private boolean transientValue = false;

    public LongRangeValidator() {
    }

    public LongRangeValidator(long l) {
        this.setMaximum(l);
    }

    public LongRangeValidator(long l, long l2) {
        this.setMaximum(l);
        this.setMinimum(l2);
    }

    public long getMaximum() {
        return this.maximum;
    }

    public void setMaximum(long l) {
        this.maximum = l;
        this.maximumSet = true;
    }

    public long getMinimum() {
        return this.minimum;
    }

    public void setMinimum(long l) {
        this.minimum = l;
        this.minimumSet = true;
    }

    public void validate(FacesContext facesContext, UIComponent uIComponent, Object object) throws ValidatorException {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        if (object != null) {
            try {
                long l = this.longValue(object);
                if (this.maximumSet && l > this.maximum) {
                    if (this.minimumSet) {
                        throw new ValidatorException(MessageFactory.getMessage(facesContext, NOT_IN_RANGE_MESSAGE_ID, this.stringValue(uIComponent, new Long(this.minimum)), this.stringValue(uIComponent, new Long(this.maximum)), MessageFactory.getLabel(facesContext, uIComponent)));
                    }
                    throw new ValidatorException(MessageFactory.getMessage(facesContext, MAXIMUM_MESSAGE_ID, this.stringValue(uIComponent, new Long(this.maximum)), MessageFactory.getLabel(facesContext, uIComponent)));
                }
                if (this.minimumSet && l < this.minimum) {
                    if (this.maximumSet) {
                        throw new ValidatorException(MessageFactory.getMessage(facesContext, NOT_IN_RANGE_MESSAGE_ID, this.stringValue(uIComponent, new Long(this.minimum)), this.stringValue(uIComponent, new Long(this.maximum)), MessageFactory.getLabel(facesContext, uIComponent)));
                    }
                    throw new ValidatorException(MessageFactory.getMessage(facesContext, MINIMUM_MESSAGE_ID, this.stringValue(uIComponent, new Long(this.minimum)), MessageFactory.getLabel(facesContext, uIComponent)));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ValidatorException(MessageFactory.getMessage(facesContext, TYPE_MESSAGE_ID, MessageFactory.getLabel(facesContext, uIComponent)));
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof LongRangeValidator)) {
            return false;
        }
        LongRangeValidator longRangeValidator = (LongRangeValidator)object;
        return this.maximum == longRangeValidator.maximum && this.minimum == longRangeValidator.minimum && this.maximumSet == longRangeValidator.maximumSet && this.minimumSet == longRangeValidator.minimumSet;
    }

    public int hashCode() {
        int n = new Long(this.minimum).hashCode() + new Long(this.maximum).hashCode() + Boolean.valueOf(this.minimumSet).hashCode() + Boolean.valueOf(this.maximumSet).hashCode();
        return n;
    }

    private long longValue(Object object) throws NumberFormatException {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return Long.parseLong(object.toString());
    }

    private String stringValue(UIComponent uIComponent, Long l) {
        String string = null;
        Converter converter = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        converter = facesContext.getApplication().createConverter("javax.faces.Number");
        string = converter.getAsString(facesContext, uIComponent, l);
        return string;
    }

    public Object saveState(FacesContext facesContext) {
        Object[] objectArray = new Object[]{new Long(this.maximum), this.maximumSet ? Boolean.TRUE : Boolean.FALSE, new Long(this.minimum), this.minimumSet ? Boolean.TRUE : Boolean.FALSE};
        return objectArray;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        Object[] objectArray = (Object[])object;
        this.maximum = (Long)objectArray[0];
        this.maximumSet = (Boolean)objectArray[1];
        this.minimum = (Long)objectArray[2];
        this.minimumSet = (Boolean)objectArray[3];
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean bl) {
        this.transientValue = bl;
    }
}

