/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.MessageFactory;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class LengthValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "javax.faces.Length";
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MINIMUM";
    private int maximum = 0;
    private boolean maximumSet = false;
    private int minimum = 0;
    private boolean minimumSet = false;
    private boolean transientValue = false;

    public LengthValidator() {
    }

    public LengthValidator(int n) {
        this.setMaximum(n);
    }

    public LengthValidator(int n, int n2) {
        this.setMaximum(n);
        this.setMinimum(n2);
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int n) {
        this.maximum = n;
        this.maximumSet = true;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int n) {
        this.minimum = n;
        this.minimumSet = true;
    }

    public void validate(FacesContext facesContext, UIComponent uIComponent, Object object) throws ValidatorException {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        if (object != null) {
            String string = this.stringValue(object);
            if (this.maximumSet && string.length() > this.maximum) {
                throw new ValidatorException(MessageFactory.getMessage(facesContext, MAXIMUM_MESSAGE_ID, this.integerToString(uIComponent, new Integer(this.maximum)), MessageFactory.getLabel(facesContext, uIComponent)));
            }
            if (this.minimumSet && string.length() < this.minimum) {
                throw new ValidatorException(MessageFactory.getMessage(facesContext, MINIMUM_MESSAGE_ID, this.integerToString(uIComponent, new Integer(this.minimum)), MessageFactory.getLabel(facesContext, uIComponent)));
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof LengthValidator)) {
            return false;
        }
        LengthValidator lengthValidator = (LengthValidator)object;
        return this.maximum == lengthValidator.maximum && this.minimum == lengthValidator.minimum && this.maximumSet == lengthValidator.maximumSet && this.minimumSet == lengthValidator.minimumSet;
    }

    public int hashCode() {
        int n = this.minimum + this.maximum + Boolean.valueOf(this.minimumSet).hashCode() + Boolean.valueOf(this.maximumSet).hashCode();
        return n;
    }

    private String stringValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    private String integerToString(UIComponent uIComponent, Integer n) {
        String string = null;
        Converter converter = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        converter = facesContext.getApplication().createConverter("javax.faces.Number");
        string = converter.getAsString(facesContext, uIComponent, n);
        return string;
    }

    public Object saveState(FacesContext facesContext) {
        Object[] objectArray = new Object[]{new Integer(this.maximum), this.maximumSet ? Boolean.TRUE : Boolean.FALSE, new Integer(this.minimum), this.minimumSet ? Boolean.TRUE : Boolean.FALSE};
        return objectArray;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        Object[] objectArray = (Object[])object;
        this.maximum = (Integer)objectArray[0];
        this.maximumSet = (Boolean)objectArray[1];
        this.minimum = (Integer)objectArray[2];
        this.minimumSet = (Boolean)objectArray[3];
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean bl) {
        this.transientValue = bl;
    }
}

