/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.MessageFactory;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class DoubleRangeValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "javax.faces.DoubleRange";
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.MINIMUM";
    public static final String NOT_IN_RANGE_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.NOT_IN_RANGE";
    public static final String TYPE_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.TYPE";
    private double maximum = Double.MAX_VALUE;
    private boolean maximumSet = false;
    private double minimum = Double.MIN_VALUE;
    private boolean minimumSet = false;
    private boolean transientValue = false;

    public DoubleRangeValidator() {
    }

    public DoubleRangeValidator(double d) {
        this.setMaximum(d);
    }

    public DoubleRangeValidator(double d, double d2) {
        this.setMaximum(d);
        this.setMinimum(d2);
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(double d) {
        this.maximum = d;
        this.maximumSet = true;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(double d) {
        this.minimum = d;
        this.minimumSet = true;
    }

    public void validate(FacesContext facesContext, UIComponent uIComponent, Object object) throws ValidatorException {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        if (object != null) {
            try {
                double d = this.doubleValue(object);
                if (this.maximumSet && d > this.maximum) {
                    if (this.minimumSet) {
                        throw new ValidatorException(MessageFactory.getMessage(facesContext, NOT_IN_RANGE_MESSAGE_ID, this.stringValue(uIComponent, new Double(this.minimum)), this.stringValue(uIComponent, new Double(this.maximum)), MessageFactory.getLabel(facesContext, uIComponent)));
                    }
                    throw new ValidatorException(MessageFactory.getMessage(facesContext, MAXIMUM_MESSAGE_ID, this.stringValue(uIComponent, new Double(this.maximum)), MessageFactory.getLabel(facesContext, uIComponent)));
                }
                if (this.minimumSet && d < this.minimum) {
                    if (this.maximumSet) {
                        throw new ValidatorException(MessageFactory.getMessage(facesContext, NOT_IN_RANGE_MESSAGE_ID, this.stringValue(uIComponent, new Double(this.minimum)), this.stringValue(uIComponent, new Double(this.maximum)), MessageFactory.getLabel(facesContext, uIComponent)));
                    }
                    throw new ValidatorException(MessageFactory.getMessage(facesContext, MINIMUM_MESSAGE_ID, this.stringValue(uIComponent, new Double(this.minimum)), MessageFactory.getLabel(facesContext, uIComponent)));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ValidatorException(MessageFactory.getMessage(facesContext, TYPE_MESSAGE_ID, MessageFactory.getLabel(facesContext, uIComponent)));
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DoubleRangeValidator)) {
            return false;
        }
        DoubleRangeValidator doubleRangeValidator = (DoubleRangeValidator)object;
        return this.maximum == doubleRangeValidator.maximum && this.minimum == doubleRangeValidator.minimum && this.maximumSet == doubleRangeValidator.maximumSet && this.minimumSet == doubleRangeValidator.minimumSet;
    }

    public int hashCode() {
        int n = new Double(this.minimum).hashCode() + new Double(this.maximum).hashCode() + Boolean.valueOf(this.minimumSet).hashCode() + Boolean.valueOf(this.maximumSet).hashCode();
        return n;
    }

    private double doubleValue(Object object) throws NumberFormatException {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return Double.parseDouble(object.toString());
    }

    private String stringValue(UIComponent uIComponent, Double d) {
        String string = null;
        Converter converter = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        converter = facesContext.getApplication().createConverter("javax.faces.Number");
        string = converter.getAsString(facesContext, uIComponent, d);
        return string;
    }

    public Object saveState(FacesContext facesContext) {
        Object[] objectArray = new Object[]{new Double(this.maximum), this.maximumSet ? Boolean.TRUE : Boolean.FALSE, new Double(this.minimum), this.minimumSet ? Boolean.TRUE : Boolean.FALSE};
        return objectArray;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        Object[] objectArray = (Object[])object;
        this.maximum = (Double)objectArray[0];
        this.maximumSet = (Boolean)objectArray[1];
        this.minimum = (Double)objectArray[2];
        this.minimumSet = (Boolean)objectArray[3];
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean bl) {
        this.transientValue = bl;
    }
}

