/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.faces.FacesException;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

public class ResultSetDataModel
extends DataModel {
    private int index = -1;
    private ResultSetMetaData metadata = null;
    private ResultSet resultSet = null;
    private boolean updated = false;

    public ResultSetDataModel() {
        this(null);
    }

    public ResultSetDataModel(ResultSet resultSet) {
        this.setWrappedData(resultSet);
    }

    public boolean isRowAvailable() {
        if (this.resultSet == null) {
            return false;
        }
        if (this.index < 0) {
            return false;
        }
        try {
            return this.resultSet.absolute(this.index + 1);
        }
        catch (SQLException sQLException) {
            throw new FacesException(sQLException);
        }
    }

    public int getRowCount() {
        return -1;
    }

    public Object getRowData() {
        if (this.resultSet == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        try {
            this.getMetaData();
            return new ResultSetMap(String.CASE_INSENSITIVE_ORDER);
        }
        catch (SQLException sQLException) {
            throw new FacesException(sQLException);
        }
    }

    public int getRowIndex() {
        return this.index;
    }

    public void setRowIndex(int n) {
        if (n < -1) {
            throw new IllegalArgumentException();
        }
        if (this.updated && this.resultSet != null) {
            try {
                if (!this.resultSet.rowDeleted()) {
                    this.resultSet.updateRow();
                }
                this.updated = false;
            }
            catch (SQLException sQLException) {
                throw new FacesException(sQLException);
            }
        }
        int n2 = this.index;
        this.index = n;
        if (this.resultSet == null) {
            return;
        }
        DataModelListener[] dataModelListenerArray = this.getDataModelListeners();
        if (n2 != this.index && dataModelListenerArray != null) {
            Object object = null;
            if (this.isRowAvailable()) {
                object = this.getRowData();
            }
            DataModelEvent dataModelEvent = new DataModelEvent(this, this.index, object);
            int n3 = dataModelListenerArray.length;
            for (int i = 0; i < n3; ++i) {
                if (null == dataModelListenerArray[i]) continue;
                dataModelListenerArray[i].rowSelected(dataModelEvent);
            }
        }
    }

    public Object getWrappedData() {
        return this.resultSet;
    }

    public void setWrappedData(Object object) {
        if (object == null) {
            this.metadata = null;
            this.resultSet = null;
            this.setRowIndex(-1);
        } else {
            this.metadata = null;
            this.resultSet = (ResultSet)object;
            this.index = -1;
            this.setRowIndex(0);
        }
    }

    private ResultSetMetaData getMetaData() {
        if (this.metadata == null) {
            try {
                this.metadata = this.resultSet.getMetaData();
            }
            catch (SQLException sQLException) {
                throw new FacesException(sQLException);
            }
        }
        return this.metadata;
    }

    private void updated() {
        this.updated = true;
    }

    private static class ResultSetEntries
    extends AbstractSet {
        private ResultSetMap map;

        public ResultSetEntries(ResultSetMap resultSetMap) {
            this.map = resultSetMap;
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (!this.map.containsKey(k)) {
                return false;
            }
            if (v == null) {
                return this.map.get(k) == null;
            }
            return v.equals(this.map.get(k));
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Iterator iterator() {
            return new ResultSetEntriesIterator(this.map);
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.map.size();
        }
    }

    private static class ResultSetEntriesIterator
    implements Iterator {
        private ResultSetMap map = null;
        private Iterator keys = null;

        public ResultSetEntriesIterator(ResultSetMap resultSetMap) {
            this.map = resultSetMap;
            this.keys = resultSetMap.keySet().iterator();
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            Object e = this.keys.next();
            return new ResultSetEntry(this.map, e);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ResultSetEntry
    implements Map.Entry {
        private ResultSetMap map;
        private Object key;

        public ResultSetEntry(ResultSetMap resultSetMap, Object object) {
            this.map = resultSetMap;
            this.key = object;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (this.key == null ? entry.getKey() != null : !this.key.equals(entry.getKey())) {
                return false;
            }
            Object object2 = this.map.get(this.key);
            return !(object2 == null ? entry.getValue() != null : !object2.equals(entry.getValue()));
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.map.get(this.key);
        }

        public int hashCode() {
            Object object = this.map.get(this.key);
            return (this.key == null ? 0 : this.key.hashCode()) ^ (object == null ? 0 : object.hashCode());
        }

        public Object setValue(Object object) {
            Object object2 = this.map.get(this.key);
            this.map.put(this.key, object);
            return object2;
        }
    }

    private static class ResultSetKeys
    extends AbstractSet {
        private ResultSetMap map;

        public ResultSetKeys(ResultSetMap resultSetMap) {
            this.map = resultSetMap;
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object object) {
            return this.map.containsKey(object);
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Iterator iterator() {
            return new ResultSetKeysIterator(this.map);
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.map.size();
        }
    }

    private static class ResultSetKeysIterator
    implements Iterator {
        private Iterator keys = null;

        public ResultSetKeysIterator(ResultSetMap resultSetMap) {
            this.keys = resultSetMap.realKeys();
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            return this.keys.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ResultSetMap
    extends TreeMap {
        private int index;

        public ResultSetMap(Comparator comparator) throws SQLException {
            super(comparator);
            this.index = ResultSetDataModel.this.index;
            ResultSetDataModel.this.resultSet.absolute(this.index + 1);
            int n = ResultSetDataModel.this.metadata.getColumnCount();
            for (int i = 1; i <= n; ++i) {
                super.put(ResultSetDataModel.this.metadata.getColumnName(i), ResultSetDataModel.this.metadata.getColumnName(i));
            }
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object object) {
            for (Map.Entry entry : this.entrySet()) {
                Object v = entry.getValue();
                if (!(object == null ? v == null : object.equals(v))) continue;
                return true;
            }
            return false;
        }

        public Set entrySet() {
            return new ResultSetEntries(this);
        }

        public Object get(Object object) {
            if (!this.containsKey(object)) {
                return null;
            }
            try {
                ResultSetDataModel.this.resultSet.absolute(this.index + 1);
                return ResultSetDataModel.this.resultSet.getObject((String)this.realKey(object));
            }
            catch (SQLException sQLException) {
                throw new FacesException(sQLException);
            }
        }

        public Set keySet() {
            return new ResultSetKeys(this);
        }

        public Object put(Object object, Object object2) {
            if (!this.containsKey(object)) {
                throw new IllegalArgumentException();
            }
            if (!(object instanceof String)) {
                throw new IllegalArgumentException();
            }
            try {
                ResultSetDataModel.this.resultSet.absolute(this.index + 1);
                Object object3 = ResultSetDataModel.this.resultSet.getObject((String)this.realKey(object));
                if (object3 == null && object2 == null) {
                    return object3;
                }
                if (object3 != null && object2 != null && object3.equals(object2)) {
                    return object3;
                }
                ResultSetDataModel.this.resultSet.updateObject((String)this.realKey(object), object2);
                ResultSetDataModel.this.updated();
                return object3;
            }
            catch (SQLException sQLException) {
                throw new FacesException(sQLException);
            }
        }

        public void putAll(Map map) {
            for (Map.Entry entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            return new ResultSetValues(this);
        }

        Object realKey(Object object) {
            return super.get(object);
        }

        Iterator realKeys() {
            return super.keySet().iterator();
        }
    }

    private static class ResultSetValues
    extends AbstractCollection {
        private ResultSetMap map;

        public ResultSetValues(ResultSetMap resultSetMap) {
            this.map = resultSetMap;
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object object) {
            return this.map.containsValue(object);
        }

        public Iterator iterator() {
            return new ResultSetValuesIterator(this.map);
        }

        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.map.size();
        }
    }

    private static class ResultSetValuesIterator
    implements Iterator {
        private ResultSetMap map;
        private Iterator keys;

        public ResultSetValuesIterator(ResultSetMap resultSetMap) {
            this.map = resultSetMap;
            this.keys = resultSetMap.keySet().iterator();
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            return this.map.get(this.keys.next());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

