/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

public class ArrayDataModel
extends DataModel {
    private Object[] array;
    private int index = -1;

    public ArrayDataModel() {
        this(null);
    }

    public ArrayDataModel(Object[] objectArray) {
        this.setWrappedData(objectArray);
    }

    public boolean isRowAvailable() {
        if (this.array == null) {
            return false;
        }
        return this.index >= 0 && this.index < this.array.length;
    }

    public int getRowCount() {
        if (this.array == null) {
            return -1;
        }
        return this.array.length;
    }

    public Object getRowData() {
        if (this.array == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        return this.array[this.index];
    }

    public int getRowIndex() {
        return this.index;
    }

    public void setRowIndex(int n) {
        if (n < -1) {
            throw new IllegalArgumentException();
        }
        int n2 = this.index;
        this.index = n;
        if (this.array == null) {
            return;
        }
        DataModelListener[] dataModelListenerArray = this.getDataModelListeners();
        if (n2 != this.index && dataModelListenerArray != null) {
            Object object = null;
            if (this.isRowAvailable()) {
                object = this.getRowData();
            }
            DataModelEvent dataModelEvent = new DataModelEvent(this, this.index, object);
            int n3 = dataModelListenerArray.length;
            for (int i = 0; i < n3; ++i) {
                if (null == dataModelListenerArray[i]) continue;
                dataModelListenerArray[i].rowSelected(dataModelEvent);
            }
        }
    }

    public Object getWrappedData() {
        return this.array;
    }

    public void setWrappedData(Object object) {
        if (object == null) {
            this.array = null;
            this.setRowIndex(-1);
        } else {
            this.array = (Object[])object;
            this.index = -1;
            this.setRowIndex(0);
        }
    }
}

