/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.MessageFactory;

public class NumberConverter
implements Converter,
StateHolder {
    public static final String CONVERTER_ID = "javax.faces.Number";
    public static final String CURRENCY_ID = "javax.faces.converter.NumberConverter.CURRENCY";
    public static final String NUMBER_ID = "javax.faces.converter.NumberConverter.NUMBER";
    public static final String PATTERN_ID = "javax.faces.converter.NumberConverter.PATTERN";
    public static final String PERCENT_ID = "javax.faces.converter.NumberConverter.PERCENT";
    public static final String STRING_ID = "javax.faces.converter.STRING";
    private String currencyCode = null;
    private String currencySymbol = null;
    private boolean groupingUsed = true;
    private boolean integerOnly = false;
    private int maxFractionDigits = 0;
    private boolean maxFractionDigitsSpecified = false;
    private int maxIntegerDigits = 0;
    private boolean maxIntegerDigitsSpecified = false;
    private int minFractionDigits = 0;
    private boolean minFractionDigitsSpecified = false;
    private int minIntegerDigits = 0;
    private boolean minIntegerDigitsSpecified = false;
    private Locale locale = null;
    private String pattern = null;
    private String type = "number";
    private static Class currencyClass;
    private static final Class[] GET_INSTANCE_PARAM_TYPES;
    private boolean transientFlag = false;

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String string) {
        this.currencyCode = string;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String string) {
        this.currencySymbol = string;
    }

    public boolean isGroupingUsed() {
        return this.groupingUsed;
    }

    public void setGroupingUsed(boolean bl) {
        this.groupingUsed = bl;
    }

    public boolean isIntegerOnly() {
        return this.integerOnly;
    }

    public void setIntegerOnly(boolean bl) {
        this.integerOnly = bl;
    }

    public int getMaxFractionDigits() {
        return this.maxFractionDigits;
    }

    public void setMaxFractionDigits(int n) {
        this.maxFractionDigits = n;
        this.maxFractionDigitsSpecified = true;
    }

    public int getMaxIntegerDigits() {
        return this.maxIntegerDigits;
    }

    public void setMaxIntegerDigits(int n) {
        this.maxIntegerDigits = n;
        this.maxIntegerDigitsSpecified = true;
    }

    public int getMinFractionDigits() {
        return this.minFractionDigits;
    }

    public void setMinFractionDigits(int n) {
        this.minFractionDigits = n;
        this.minFractionDigitsSpecified = true;
    }

    public int getMinIntegerDigits() {
        return this.minIntegerDigits;
    }

    public void setMinIntegerDigits(int n) {
        this.minIntegerDigits = n;
        this.minIntegerDigitsSpecified = true;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.getLocale(FacesContext.getCurrentInstance());
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public Object getAsObject(FacesContext facesContext, UIComponent uIComponent, String string) {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        Number number = null;
        NumberFormat numberFormat = null;
        try {
            if (string == null) {
                return null;
            }
            if ((string = string.trim()).length() < 1) {
                return null;
            }
            Locale locale = this.getLocale(facesContext);
            numberFormat = this.getNumberFormat(locale);
            if (this.pattern != null && !this.pattern.equals("") || "currency".equals(this.type)) {
                this.configureCurrency(numberFormat);
            }
            numberFormat.setParseIntegerOnly(this.isIntegerOnly());
            number = numberFormat.parse(string);
        }
        catch (ParseException parseException) {
            if (this.pattern != null) {
                throw new ConverterException(MessageFactory.getMessage(facesContext, PATTERN_ID, string, "#,##0.0#", MessageFactory.getLabel(facesContext, uIComponent)));
            }
            if (this.type.equals("currency")) {
                throw new ConverterException(MessageFactory.getMessage(facesContext, CURRENCY_ID, string, numberFormat.format(99.99), MessageFactory.getLabel(facesContext, uIComponent)));
            }
            if (this.type.equals("number")) {
                throw new ConverterException(MessageFactory.getMessage(facesContext, NUMBER_ID, string, numberFormat.format(99L), MessageFactory.getLabel(facesContext, uIComponent)));
            }
            if (this.type.equals("percent")) {
                throw new ConverterException(MessageFactory.getMessage(facesContext, PERCENT_ID, string, numberFormat.format(0.75), MessageFactory.getLabel(facesContext, uIComponent)));
            }
        }
        catch (ConverterException converterException) {
            throw converterException;
        }
        catch (Exception exception) {
            throw new ConverterException(exception.getCause());
        }
        return number;
    }

    public String getAsString(FacesContext facesContext, UIComponent uIComponent, Object object) {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        try {
            if (object == null) {
                return "";
            }
            if (object instanceof String) {
                return (String)object;
            }
            Locale locale = this.getLocale(facesContext);
            NumberFormat numberFormat = this.getNumberFormat(locale);
            if (this.pattern != null && !this.pattern.equals("") || "currency".equals(this.type)) {
                this.configureCurrency(numberFormat);
            }
            this.configureFormatter(numberFormat);
            return numberFormat.format(object);
        }
        catch (ConverterException converterException) {
            throw new ConverterException(MessageFactory.getMessage(facesContext, STRING_ID, object, MessageFactory.getLabel(facesContext, uIComponent)), (Throwable)converterException);
        }
        catch (Exception exception) {
            throw new ConverterException(MessageFactory.getMessage(facesContext, STRING_ID, object, MessageFactory.getLabel(facesContext, uIComponent)), (Throwable)exception);
        }
    }

    private void configureCurrency(NumberFormat numberFormat) throws Exception {
        String string = null;
        String string2 = null;
        if (this.currencyCode == null && this.currencySymbol == null) {
            return;
        }
        if (this.currencyCode != null && this.currencySymbol != null) {
            if (currencyClass != null) {
                string = this.currencyCode;
            } else {
                string2 = this.currencySymbol;
            }
        } else if (this.currencyCode == null) {
            string2 = this.currencySymbol;
        } else if (currencyClass != null) {
            string = this.currencyCode;
        } else {
            string2 = this.currencyCode;
        }
        if (string != null) {
            Object[] objectArray = new Object[1];
            Method method = currencyClass.getMethod("getInstance", GET_INSTANCE_PARAM_TYPES);
            objectArray[0] = string;
            Object object = method.invoke(null, objectArray);
            Class[] classArray = new Class[]{currencyClass};
            Class<?> clazz = Class.forName("java.text.NumberFormat");
            method = clazz.getMethod("setCurrency", classArray);
            objectArray[0] = object;
            method.invoke((Object)numberFormat, objectArray);
        } else {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setCurrencySymbol(string2);
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        }
    }

    private void configureFormatter(NumberFormat numberFormat) {
        numberFormat.setGroupingUsed(this.groupingUsed);
        if (this.maxIntegerDigitsSpecified) {
            numberFormat.setMaximumIntegerDigits(this.maxIntegerDigits);
        }
        if (this.minIntegerDigitsSpecified) {
            numberFormat.setMinimumIntegerDigits(this.minIntegerDigits);
        }
        if (this.maxFractionDigitsSpecified) {
            numberFormat.setMaximumFractionDigits(this.maxFractionDigits);
        }
        if (this.minFractionDigitsSpecified) {
            numberFormat.setMinimumFractionDigits(this.minFractionDigits);
        }
    }

    private Locale getLocale(FacesContext facesContext) {
        Locale locale = this.locale;
        if (locale == null) {
            locale = facesContext.getViewRoot().getLocale();
        }
        return locale;
    }

    private NumberFormat getNumberFormat(Locale locale) {
        if (this.pattern == null && this.type == null) {
            throw new IllegalArgumentException("Either pattern or type must be specified.");
        }
        if (this.pattern != null) {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
            return new DecimalFormat(this.pattern, decimalFormatSymbols);
        }
        if (this.type.equals("currency")) {
            return NumberFormat.getCurrencyInstance(locale);
        }
        if (this.type.equals("number")) {
            return NumberFormat.getNumberInstance(locale);
        }
        if (this.type.equals("percent")) {
            return NumberFormat.getPercentInstance(locale);
        }
        throw new ConverterException(new IllegalArgumentException(this.type));
    }

    public Object saveState(FacesContext facesContext) {
        Object[] objectArray = new Object[]{this.currencyCode, this.currencySymbol, this.isGroupingUsed() ? Boolean.TRUE : Boolean.FALSE, this.isIntegerOnly() ? Boolean.TRUE : Boolean.FALSE, new Integer(this.maxFractionDigits), this.maxFractionDigitsSpecified ? Boolean.TRUE : Boolean.FALSE, new Integer(this.maxIntegerDigits), this.maxIntegerDigitsSpecified ? Boolean.TRUE : Boolean.FALSE, new Integer(this.minFractionDigits), this.minFractionDigitsSpecified ? Boolean.TRUE : Boolean.FALSE, new Integer(this.minIntegerDigits), this.minIntegerDigitsSpecified ? Boolean.TRUE : Boolean.FALSE, this.locale, this.pattern, this.type};
        return objectArray;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        Object[] objectArray = (Object[])object;
        this.currencyCode = (String)objectArray[0];
        this.currencySymbol = (String)objectArray[1];
        this.groupingUsed = (Boolean)objectArray[2];
        this.integerOnly = (Boolean)objectArray[3];
        this.maxFractionDigits = (Integer)objectArray[4];
        this.maxFractionDigitsSpecified = (Boolean)objectArray[5];
        this.maxIntegerDigits = (Integer)objectArray[6];
        this.maxIntegerDigitsSpecified = (Boolean)objectArray[7];
        this.minFractionDigits = (Integer)objectArray[8];
        this.minFractionDigitsSpecified = (Boolean)objectArray[9];
        this.minIntegerDigits = (Integer)objectArray[10];
        this.minIntegerDigitsSpecified = (Boolean)objectArray[11];
        this.locale = (Locale)objectArray[12];
        this.pattern = (String)objectArray[13];
        this.type = (String)objectArray[14];
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean bl) {
        this.transientFlag = bl;
    }

    static {
        try {
            currencyClass = Class.forName("java.util.Currency");
        }
        catch (Exception exception) {
            // empty catch block
        }
        GET_INSTANCE_PARAM_TYPES = new Class[]{String.class};
    }
}

