/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.MessageFactory;

public class LongConverter
implements Converter {
    public static final String CONVERTER_ID = "javax.faces.Long";
    public static final String LONG_ID = "javax.faces.converter.LongConverter.LONG";
    public static final String STRING_ID = "javax.faces.converter.STRING";

    public Object getAsObject(FacesContext facesContext, UIComponent uIComponent, String string) {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() < 1) {
            return null;
        }
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConverterException(MessageFactory.getMessage(facesContext, LONG_ID, string, "98765432", MessageFactory.getLabel(facesContext, uIComponent)));
        }
        catch (Exception exception) {
            throw new ConverterException(exception);
        }
    }

    public String getAsString(FacesContext facesContext, UIComponent uIComponent, Object object) {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        try {
            return Long.toString((Long)object);
        }
        catch (Exception exception) {
            throw new ConverterException(MessageFactory.getMessage(facesContext, STRING_ID, object, MessageFactory.getLabel(facesContext, uIComponent)), (Throwable)exception);
        }
    }
}

