/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.MessageFactory;

public class IntegerConverter
implements Converter {
    public static final String CONVERTER_ID = "javax.faces.Integer";
    public static final String INTEGER_ID = "javax.faces.converter.IntegerConverter.INTEGER";
    public static final String STRING_ID = "javax.faces.converter.STRING";

    public Object getAsObject(FacesContext facesContext, UIComponent uIComponent, String string) {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() < 1) {
            return null;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConverterException(MessageFactory.getMessage(facesContext, INTEGER_ID, string, "9346", MessageFactory.getLabel(facesContext, uIComponent)));
        }
        catch (Exception exception) {
            throw new ConverterException(exception);
        }
    }

    public String getAsString(FacesContext facesContext, UIComponent uIComponent, Object object) {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        try {
            return Integer.toString((Integer)object);
        }
        catch (Exception exception) {
            throw new ConverterException(MessageFactory.getMessage(facesContext, STRING_ID, object, MessageFactory.getLabel(facesContext, uIComponent)), (Throwable)exception);
        }
    }
}

