/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.MessageFactory;

public class DateTimeConverter
implements Converter,
StateHolder {
    public static final String CONVERTER_ID = "javax.faces.DateTime";
    public static final String DATE_ID = "javax.faces.converter.DateTimeConverter.DATE";
    public static final String TIME_ID = "javax.faces.converter.DateTimeConverter.TIME";
    public static final String DATETIME_ID = "javax.faces.converter.DateTimeConverter.DATETIME";
    public static final String STRING_ID = "javax.faces.converter.STRING";
    private static final TimeZone DEFAULT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private String dateStyle = "default";
    private Locale locale = null;
    private String pattern = null;
    private String timeStyle = "default";
    private TimeZone timeZone = DEFAULT_TIME_ZONE;
    private String type = "date";
    private boolean transientFlag = false;

    public String getDateStyle() {
        return this.dateStyle;
    }

    public void setDateStyle(String string) {
        this.dateStyle = string;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.getLocale(FacesContext.getCurrentInstance());
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public String getTimeStyle() {
        return this.timeStyle;
    }

    public void setTimeStyle(String string) {
        this.timeStyle = string;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public Object getAsObject(FacesContext facesContext, UIComponent uIComponent, String string) {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        Date date = null;
        DateFormat dateFormat = null;
        try {
            if (string == null) {
                return null;
            }
            if ((string = string.trim()).length() < 1) {
                return null;
            }
            Locale locale = this.getLocale(facesContext);
            dateFormat = this.getDateFormat(facesContext, locale);
            if (null != this.timeZone) {
                dateFormat.setTimeZone(this.timeZone);
            }
            date = dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            if (this.type.equals("date")) {
                throw new ConverterException(MessageFactory.getMessage(facesContext, DATE_ID, string, dateFormat.format(new Date(System.currentTimeMillis())), MessageFactory.getLabel(facesContext, uIComponent)));
            }
            if (this.type.equals("time")) {
                throw new ConverterException(MessageFactory.getMessage(facesContext, TIME_ID, string, dateFormat.format(new Date(System.currentTimeMillis())), MessageFactory.getLabel(facesContext, uIComponent)));
            }
            if (this.type.equals("both")) {
                throw new ConverterException(MessageFactory.getMessage(facesContext, DATETIME_ID, string, dateFormat.format(new Date(System.currentTimeMillis())), MessageFactory.getLabel(facesContext, uIComponent)));
            }
        }
        catch (ConverterException converterException) {
            throw converterException;
        }
        catch (Exception exception) {
            throw new ConverterException(exception);
        }
        return date;
    }

    public String getAsString(FacesContext facesContext, UIComponent uIComponent, Object object) {
        if (facesContext == null || uIComponent == null) {
            throw new NullPointerException();
        }
        try {
            if (object == null) {
                return "";
            }
            if (object instanceof String) {
                return (String)object;
            }
            Locale locale = this.getLocale(facesContext);
            DateFormat dateFormat = this.getDateFormat(facesContext, locale);
            if (null != this.timeZone) {
                dateFormat.setTimeZone(this.timeZone);
            }
            return dateFormat.format(object);
        }
        catch (ConverterException converterException) {
            throw new ConverterException(MessageFactory.getMessage(facesContext, STRING_ID, object, MessageFactory.getLabel(facesContext, uIComponent)), (Throwable)converterException);
        }
        catch (Exception exception) {
            throw new ConverterException(MessageFactory.getMessage(facesContext, STRING_ID, object, MessageFactory.getLabel(facesContext, uIComponent)), (Throwable)exception);
        }
    }

    private DateFormat getDateFormat(FacesContext facesContext, Locale locale) {
        if (this.pattern == null && this.type == null) {
            throw new IllegalArgumentException("Either pattern or type must be specified.");
        }
        DateFormat dateFormat = null;
        if (this.pattern != null) {
            dateFormat = new SimpleDateFormat(this.pattern, locale);
        } else if (this.type.equals("both")) {
            dateFormat = DateFormat.getDateTimeInstance(this.getStyle(this.dateStyle), this.getStyle(this.timeStyle), locale);
        } else if (this.type.equals("date")) {
            dateFormat = DateFormat.getDateInstance(this.getStyle(this.dateStyle), locale);
        } else if (this.type.equals("time")) {
            dateFormat = DateFormat.getTimeInstance(this.getStyle(this.timeStyle), locale);
        } else {
            throw new IllegalArgumentException("Invalid type: " + this.type);
        }
        dateFormat.setLenient(false);
        return dateFormat;
    }

    private Locale getLocale(FacesContext facesContext) {
        Locale locale = this.locale;
        if (locale == null) {
            locale = facesContext.getViewRoot().getLocale();
        }
        return locale;
    }

    private int getStyle(String string) {
        if (string.equals("default")) {
            return 2;
        }
        if (string.equals("short")) {
            return 3;
        }
        if (string.equals("medium")) {
            return 2;
        }
        if (string.equals("long")) {
            return 1;
        }
        if (string.equals("full")) {
            return 0;
        }
        throw new ConverterException("Invalid style '" + string + "'");
    }

    public Object saveState(FacesContext facesContext) {
        Object[] objectArray = new Object[]{this.dateStyle, this.locale, this.pattern, this.timeStyle, this.timeZone, this.type};
        return objectArray;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        Object[] objectArray = (Object[])object;
        this.dateStyle = (String)objectArray[0];
        this.locale = (Locale)objectArray[1];
        this.pattern = (String)objectArray[2];
        this.timeStyle = (String)objectArray[3];
        this.timeZone = (TimeZone)objectArray[4];
        this.type = (String)objectArray[5];
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean bl) {
        this.transientFlag = bl;
    }
}

