/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

public class UIViewRoot
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "javax.faces.ViewRoot";
    public static final String COMPONENT_FAMILY = "javax.faces.ViewRoot";
    public static final String UNIQUE_ID_PREFIX = "j_id";
    private static Lifecycle lifecycle;
    private static final Logger LOGGER;
    private int lastId = 0;
    private boolean skipPhase;
    private String renderKitId = null;
    private String viewId = null;
    private MethodExpression beforePhase = null;
    private MethodExpression afterPhase = null;
    private List<PhaseListener> phaseListeners = null;
    private transient List[] events = null;
    private Locale locale = null;
    private Object[] values;

    public UIViewRoot() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "javax.faces.ViewRoot";
    }

    public String getRenderKitId() {
        String string = null;
        if (null != this.renderKitId) {
            string = this.renderKitId;
        } else {
            ValueExpression valueExpression = this.getValueExpression("renderKitId");
            FacesContext facesContext = this.getFacesContext();
            if (valueExpression != null) {
                try {
                    string = (String)valueExpression.getValue(facesContext.getELContext());
                }
                catch (ELException eLException) {
                    string = null;
                }
            } else {
                string = null;
            }
        }
        return string;
    }

    public void setRenderKitId(String string) {
        this.renderKitId = string;
    }

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String string) {
        this.viewId = string;
    }

    public MethodExpression getBeforePhaseListener() {
        return this.beforePhase;
    }

    public void setBeforePhaseListener(MethodExpression methodExpression) {
        this.beforePhase = methodExpression;
    }

    public MethodExpression getAfterPhaseListener() {
        return this.afterPhase;
    }

    public void setAfterPhaseListener(MethodExpression methodExpression) {
        this.afterPhase = methodExpression;
    }

    public void removePhaseListener(PhaseListener phaseListener) {
        if (null != this.phaseListeners) {
            this.phaseListeners.remove(phaseListener);
        }
    }

    public void addPhaseListener(PhaseListener phaseListener) {
        if (null == this.phaseListeners) {
            this.phaseListeners = new ArrayList<PhaseListener>();
        }
        this.phaseListeners.add(phaseListener);
    }

    public void queueEvent(FacesEvent facesEvent) {
        if (facesEvent == null) {
            throw new NullPointerException();
        }
        int n = 0;
        int n2 = 0;
        if (this.events == null) {
            n2 = PhaseId.VALUES.size();
            this.events = new List[n2];
            for (n = 0; n < n2; ++n) {
                this.events[n] = new ArrayList(5);
            }
        }
        this.events[facesEvent.getPhaseId().getOrdinal()].add(facesEvent);
    }

    private void broadcastEvents(FacesContext facesContext, PhaseId phaseId) {
        List list = null;
        if (null == this.events) {
            return;
        }
        boolean bl = true;
        boolean bl2 = true;
        list = this.events[PhaseId.ANY_PHASE.getOrdinal()];
        do {
            UIComponent uIComponent;
            FacesEvent facesEvent;
            int n;
            if (null != list) {
                n = 0;
                while (n < list.size()) {
                    block11: {
                        facesEvent = (FacesEvent)list.get(n);
                        uIComponent = facesEvent.getComponent();
                        try {
                            uIComponent.broadcast(facesEvent);
                        }
                        catch (AbortProcessingException abortProcessingException) {
                            if (!LOGGER.isLoggable(Level.SEVERE)) break block11;
                            UIComponent uIComponent2 = facesEvent.getComponent();
                            String string = "";
                            if (uIComponent2 != null && (string = uIComponent2.getId()) == null) {
                                string = uIComponent2.getClientId(facesContext);
                            }
                            LOGGER.log(Level.SEVERE, "error.component.abortprocessing_thrown", new Object[]{facesEvent.getClass().getName(), phaseId.toString(), string});
                            LOGGER.log(Level.SEVERE, abortProcessingException.toString(), abortProcessingException);
                        }
                    }
                    list.remove(n);
                }
            }
            if (null != (list = this.events[phaseId.getOrdinal()])) {
                n = 0;
                while (n < list.size()) {
                    facesEvent = (FacesEvent)list.get(n);
                    uIComponent = facesEvent.getComponent();
                    try {
                        uIComponent.broadcast(facesEvent);
                    }
                    catch (AbortProcessingException abortProcessingException) {
                        // empty catch block
                    }
                    list.remove(n);
                }
            }
            bl = null != (list = this.events[PhaseId.ANY_PHASE.getOrdinal()]) && list.size() > 0;
            boolean bl3 = bl2 = null != this.events[phaseId.getOrdinal()] && this.events[phaseId.getOrdinal()].size() > 0;
        } while (bl || bl2);
    }

    public void processDecodes(FacesContext facesContext) {
        this.skipPhase = false;
        if (null != this.beforePhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(facesContext, PhaseId.APPLY_REQUEST_VALUES, true);
        }
        if (!this.skipPhase) {
            super.processDecodes(facesContext);
            this.broadcastEvents(facesContext, PhaseId.APPLY_REQUEST_VALUES);
        }
        if ((facesContext.getRenderResponse() || facesContext.getResponseComplete()) && this.events != null) {
            for (int i = 0; i < PhaseId.VALUES.size(); ++i) {
                List list = this.events[i];
                if (list == null) continue;
                list.clear();
            }
            this.events = null;
        }
        if (null != this.beforePhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(facesContext, PhaseId.APPLY_REQUEST_VALUES, false);
        }
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        this.skipPhase = false;
        if (null != this.beforePhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(facesContext, PhaseId.RENDER_RESPONSE, true);
        }
        if (!this.skipPhase) {
            super.encodeBegin(facesContext);
        }
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        super.encodeEnd(facesContext);
        if (null != this.afterPhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(facesContext, PhaseId.RENDER_RESPONSE, false);
        }
    }

    private void notifyPhaseListeners(FacesContext facesContext, PhaseId phaseId, boolean bl) {
        MethodExpression methodExpression;
        PhaseEvent phaseEvent = this.createPhaseEvent(facesContext, phaseId);
        boolean bl2 = bl && null != this.beforePhase || !bl && null != this.afterPhase;
        MethodExpression methodExpression2 = methodExpression = bl ? this.beforePhase : this.afterPhase;
        if (bl2) {
            try {
                methodExpression.invoke(facesContext.getELContext(), new Object[]{phaseEvent});
                this.skipPhase = facesContext.getResponseComplete() || facesContext.getRenderResponse();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != this.phaseListeners) {
            Iterator<PhaseListener> iterator = this.phaseListeners.iterator();
            PhaseListener phaseListener = null;
            while (iterator.hasNext()) {
                phaseListener = iterator.next();
                if (phaseId != phaseListener.getPhaseId() && PhaseId.ANY_PHASE != phaseListener.getPhaseId()) continue;
                try {
                    if (bl) {
                        phaseListener.beforePhase(phaseEvent);
                    } else {
                        phaseListener.afterPhase(phaseEvent);
                    }
                    this.skipPhase = facesContext.getResponseComplete() || facesContext.getRenderResponse();
                }
                catch (Exception exception) {}
            }
        }
    }

    private PhaseEvent createPhaseEvent(FacesContext facesContext, PhaseId phaseId) throws FacesException {
        if (lifecycle == null) {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
            String string = facesContext.getExternalContext().getInitParameter("javax.faces.LIFECYCLE_ID");
            if (string == null) {
                string = "DEFAULT";
            }
            lifecycle = lifecycleFactory.getLifecycle(string);
        }
        return new PhaseEvent(facesContext, phaseId, lifecycle);
    }

    public void processValidators(FacesContext facesContext) {
        this.skipPhase = false;
        if (null != this.beforePhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(facesContext, PhaseId.PROCESS_VALIDATIONS, true);
        }
        if (!this.skipPhase) {
            super.processValidators(facesContext);
            this.broadcastEvents(facesContext, PhaseId.PROCESS_VALIDATIONS);
        }
        if ((facesContext.getRenderResponse() || facesContext.getResponseComplete()) && this.events != null) {
            for (int i = 0; i < PhaseId.VALUES.size(); ++i) {
                List list = this.events[i];
                if (list == null) continue;
                list.clear();
            }
            this.events = null;
        }
        if (null != this.beforePhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(facesContext, PhaseId.PROCESS_VALIDATIONS, false);
        }
    }

    public void processUpdates(FacesContext facesContext) {
        this.skipPhase = false;
        if (null != this.beforePhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(facesContext, PhaseId.UPDATE_MODEL_VALUES, true);
        }
        if (!this.skipPhase) {
            super.processUpdates(facesContext);
            this.broadcastEvents(facesContext, PhaseId.UPDATE_MODEL_VALUES);
        }
        if ((facesContext.getRenderResponse() || facesContext.getResponseComplete()) && this.events != null) {
            for (int i = 0; i < PhaseId.VALUES.size(); ++i) {
                List list = this.events[i];
                if (list == null) continue;
                list.clear();
            }
            this.events = null;
        }
        if (null != this.beforePhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(facesContext, PhaseId.UPDATE_MODEL_VALUES, false);
        }
    }

    public void processApplication(FacesContext facesContext) {
        this.skipPhase = false;
        if (null != this.beforePhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(facesContext, PhaseId.INVOKE_APPLICATION, true);
        }
        if (!this.skipPhase) {
            this.broadcastEvents(facesContext, PhaseId.INVOKE_APPLICATION);
        }
        if ((facesContext.getRenderResponse() || facesContext.getResponseComplete()) && this.events != null) {
            for (int i = 0; i < PhaseId.VALUES.size(); ++i) {
                List list = this.events[i];
                if (list == null) continue;
                list.clear();
            }
            this.events = null;
        }
        if (null != this.beforePhase || null != this.phaseListeners) {
            this.notifyPhaseListeners(facesContext, PhaseId.INVOKE_APPLICATION, false);
        }
    }

    public String createUniqueId() {
        return UNIQUE_ID_PREFIX + this.lastId++;
    }

    public Locale getLocale() {
        Locale locale = null;
        if (null != this.locale) {
            locale = this.locale;
        } else {
            ValueExpression valueExpression = this.getValueExpression("locale");
            FacesContext facesContext = this.getFacesContext();
            if (valueExpression != null) {
                Object object = null;
                try {
                    object = valueExpression.getValue(facesContext.getELContext());
                }
                catch (ELException eLException) {
                    // empty catch block
                }
                if (null == object) {
                    locale = facesContext.getApplication().getViewHandler().calculateLocale(facesContext);
                } else if (object instanceof Locale) {
                    locale = (Locale)object;
                } else if (object instanceof String) {
                    locale = this.getLocaleFromString((String)object);
                }
            } else {
                locale = facesContext.getApplication().getViewHandler().calculateLocale(facesContext);
            }
        }
        return locale;
    }

    private Locale getLocaleFromString(String string) {
        Locale locale = Locale.getDefault();
        if (string.indexOf("_") == -1 || string.indexOf("-") == -1) {
            if (string.length() == 2) {
                locale = new Locale(string, "");
            }
        } else if (string.length() == 5) {
            String string2 = string.substring(0, 1);
            String string3 = string.substring(3, 4);
            locale = new Locale(string2, string3);
        }
        return locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        FacesContext.getCurrentInstance().getELContext().setLocale(locale);
    }

    public Object saveState(FacesContext facesContext) {
        if (this.values == null) {
            this.values = new Object[8];
        }
        this.values[0] = super.saveState(facesContext);
        this.values[1] = this.renderKitId;
        this.values[2] = this.viewId;
        this.values[3] = this.locale;
        this.values[4] = new Integer(this.lastId);
        this.values[5] = UIViewRoot.saveAttachedState(facesContext, this.beforePhase);
        this.values[6] = UIViewRoot.saveAttachedState(facesContext, this.afterPhase);
        this.values[7] = UIViewRoot.saveAttachedState(facesContext, this.phaseListeners);
        return this.values;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        this.values = (Object[])object;
        super.restoreState(facesContext, this.values[0]);
        this.renderKitId = (String)this.values[1];
        this.viewId = (String)this.values[2];
        this.locale = (Locale)this.values[3];
        this.lastId = (Integer)this.values[4];
        this.beforePhase = (MethodExpression)UIViewRoot.restoreAttachedState(facesContext, this.values[5]);
        this.afterPhase = (MethodExpression)UIViewRoot.restoreAttachedState(facesContext, this.values[6]);
        this.phaseListeners = (List)UIViewRoot.restoreAttachedState(facesContext, this.values[7]);
    }

    static {
        LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");
    }
}

