/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.MessageFactory;
import javax.faces.component.MethodBindingValidator;
import javax.faces.component.MethodBindingValueChangeListener;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.MethodBinding;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class UIInput
extends UIOutput
implements EditableValueHolder {
    public static final String COMPONENT_TYPE = "javax.faces.Input";
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    public static final String CONVERSION_MESSAGE_ID = "javax.faces.component.UIInput.CONVERSION";
    public static final String REQUIRED_MESSAGE_ID = "javax.faces.component.UIInput.REQUIRED";
    public static final String UPDATE_MESSAGE_ID = "javax.faces.component.UIInput.UPDATE";
    private Object submittedValue = null;
    private boolean localValueSet;
    private boolean required = false;
    private boolean requiredSet = false;
    private String requiredMessage = null;
    private boolean requiredMessageSet = false;
    private String converterMessage = null;
    private boolean converterMessageSet = false;
    private String validatorMessage = null;
    private boolean validatorMessageSet = false;
    private boolean valid = true;
    private boolean immediate = false;
    private boolean immediateSet = false;
    List<Validator> validators = null;
    private Object[] values;

    public UIInput() {
        this.setRendererType("javax.faces.Text");
    }

    public String getFamily() {
        return "javax.faces.Input";
    }

    public Object getSubmittedValue() {
        return this.submittedValue;
    }

    public void setSubmittedValue(Object object) {
        this.submittedValue = object;
    }

    public void setValue(Object object) {
        super.setValue(object);
        this.setLocalValueSet(true);
    }

    public void resetValue() {
        this.setValue(null);
        this.setSubmittedValue(null);
        this.setLocalValueSet(false);
        this.setValid(true);
    }

    public boolean isLocalValueSet() {
        return this.localValueSet;
    }

    public void setLocalValueSet(boolean bl) {
        this.localValueSet = bl;
    }

    public boolean isRequired() {
        if (this.requiredSet) {
            return this.required;
        }
        ValueExpression valueExpression = this.getValueExpression("required");
        if (valueExpression != null) {
            try {
                return Boolean.TRUE.equals(valueExpression.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException eLException) {
                throw new FacesException(eLException);
            }
        }
        return this.required;
    }

    public String getRequiredMessage() {
        if (this.requiredMessageSet) {
            return this.requiredMessage;
        }
        ValueExpression valueExpression = this.getValueExpression("requiredMessage");
        if (valueExpression != null) {
            try {
                return (String)valueExpression.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException eLException) {
                throw new FacesException(eLException);
            }
        }
        return this.requiredMessage;
    }

    public void setRequiredMessage(String string) {
        this.requiredMessageSet = true;
        this.requiredMessage = string;
    }

    public String getConverterMessage() {
        if (this.converterMessageSet) {
            return this.converterMessage;
        }
        ValueExpression valueExpression = this.getValueExpression("converterMessage");
        if (valueExpression != null) {
            try {
                return (String)valueExpression.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException eLException) {
                throw new FacesException(eLException);
            }
        }
        return this.converterMessage;
    }

    public void setConverterMessage(String string) {
        this.converterMessageSet = true;
        this.converterMessage = string;
    }

    public String getValidatorMessage() {
        if (this.validatorMessageSet) {
            return this.validatorMessage;
        }
        ValueExpression valueExpression = this.getValueExpression("validatorMessage");
        if (valueExpression != null) {
            try {
                return (String)valueExpression.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException eLException) {
                throw new FacesException(eLException);
            }
        }
        return this.validatorMessage;
    }

    public void setValidatorMessage(String string) {
        this.validatorMessageSet = true;
        this.validatorMessage = string;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean bl) {
        this.valid = bl;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
        this.requiredSet = true;
    }

    public boolean isImmediate() {
        if (this.immediateSet) {
            return this.immediate;
        }
        ValueExpression valueExpression = this.getValueExpression("immediate");
        if (valueExpression != null) {
            try {
                return Boolean.TRUE.equals(valueExpression.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException eLException) {
                throw new FacesException(eLException);
            }
        }
        return this.immediate;
    }

    public void setImmediate(boolean bl) {
        if (bl != this.immediate) {
            this.immediate = bl;
        }
        this.immediateSet = true;
    }

    public MethodBinding getValidator() {
        MethodBinding methodBinding = null;
        Validator[] validatorArray = this.getValidators();
        if (null != validatorArray) {
            for (int i = 0; i < validatorArray.length; ++i) {
                if (MethodBindingValidator.class != validatorArray[i].getClass()) continue;
                methodBinding = ((MethodBindingValidator)validatorArray[i]).getWrapped();
                break;
            }
        }
        return methodBinding;
    }

    public void setValidator(MethodBinding methodBinding) {
        Validator[] validatorArray = this.getValidators();
        if (null != validatorArray) {
            for (int i = 0; i < validatorArray.length; ++i) {
                if (null == methodBinding) {
                    if (MethodBindingValidator.class != validatorArray[i].getClass()) continue;
                    this.removeValidator(validatorArray[i]);
                    return;
                }
                if (methodBinding != validatorArray[i]) continue;
                this.removeValidator(validatorArray[i]);
                break;
            }
        }
        this.addValidator(new MethodBindingValidator(methodBinding));
    }

    public MethodBinding getValueChangeListener() {
        MethodBinding methodBinding = null;
        ValueChangeListener[] valueChangeListenerArray = this.getValueChangeListeners();
        if (null != valueChangeListenerArray) {
            for (int i = 0; i < valueChangeListenerArray.length; ++i) {
                if (MethodBindingValueChangeListener.class != valueChangeListenerArray[i].getClass()) continue;
                methodBinding = ((MethodBindingValueChangeListener)valueChangeListenerArray[i]).getWrapped();
                break;
            }
        }
        return methodBinding;
    }

    public void setValueChangeListener(MethodBinding methodBinding) {
        ValueChangeListener[] valueChangeListenerArray = this.getValueChangeListeners();
        if (null != valueChangeListenerArray) {
            for (int i = 0; i < valueChangeListenerArray.length; ++i) {
                if (null == methodBinding) {
                    if (MethodBindingValueChangeListener.class != valueChangeListenerArray[i].getClass()) continue;
                    this.removeFacesListener(valueChangeListenerArray[i]);
                    return;
                }
                if (methodBinding != valueChangeListenerArray[i]) continue;
                this.removeFacesListener(valueChangeListenerArray[i]);
                break;
            }
        }
        this.addValueChangeListener(new MethodBindingValueChangeListener(methodBinding));
    }

    public void processDecodes(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processDecodes(facesContext);
        if (this.isImmediate()) {
            this.executeValidate(facesContext);
        }
    }

    public void processValidators(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processValidators(facesContext);
        if (!this.isImmediate()) {
            this.executeValidate(facesContext);
        }
    }

    public void processUpdates(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(facesContext);
        try {
            this.updateModel(facesContext);
        }
        catch (RuntimeException runtimeException) {
            facesContext.renderResponse();
            throw runtimeException;
        }
        if (!this.isValid()) {
            facesContext.renderResponse();
        }
    }

    public void decode(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        this.setValid(true);
        super.decode(facesContext);
    }

    public void updateModel(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueExpression valueExpression = this.getValueExpression("value");
        if (valueExpression != null) {
            try {
                valueExpression.setValue(facesContext.getELContext(), this.getLocalValue());
                this.setValue(null);
                this.setLocalValueSet(false);
                return;
            }
            catch (ELException eLException) {
                String string = eLException.getMessage();
                for (Throwable throwable = eLException.getCause(); null != throwable && throwable.getClass().isAssignableFrom(ELException.class); throwable = throwable.getCause()) {
                    string = throwable.getMessage();
                }
                FacesMessage facesMessage = null;
                facesMessage = null == string ? MessageFactory.getMessage(facesContext, UPDATE_MESSAGE_ID, MessageFactory.getLabel(facesContext, this)) : new FacesMessage(string);
                facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
                facesContext.addMessage(this.getClientId(facesContext), facesMessage);
                this.setValid(false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FacesMessage facesMessage = MessageFactory.getMessage(facesContext, UPDATE_MESSAGE_ID, MessageFactory.getLabel(facesContext, this));
                facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
                facesContext.addMessage(this.getClientId(facesContext), facesMessage);
                this.setValid(false);
            }
            catch (Exception exception) {
                FacesMessage facesMessage = MessageFactory.getMessage(facesContext, UPDATE_MESSAGE_ID, MessageFactory.getLabel(facesContext, this));
                facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
                facesContext.addMessage(this.getClientId(facesContext), facesMessage);
                this.setValid(false);
            }
        }
    }

    public void validate(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        Object object = this.getSubmittedValue();
        if (object == null) {
            return;
        }
        Object object2 = null;
        try {
            object2 = this.getConvertedValue(facesContext, object);
        }
        catch (ConverterException converterException) {
            this.addConversionErrorMessage(facesContext, converterException, object);
            this.setValid(false);
        }
        this.validateValue(facesContext, object2);
        if (this.isValid()) {
            Object object3 = this.getValue();
            this.setValue(object2);
            this.setSubmittedValue(null);
            if (this.compareValues(object3, object2)) {
                this.queueEvent(new ValueChangeEvent(this, object3, object2));
            }
        }
    }

    protected Object getConvertedValue(FacesContext facesContext, Object object) throws ConverterException {
        Converter converter;
        Renderer renderer = this.getRenderer(facesContext);
        Object object2 = null;
        object2 = renderer != null ? renderer.getConvertedValue(facesContext, this, object) : (object instanceof String ? ((converter = this.getConverterWithType(facesContext)) != null ? converter.getAsObject(facesContext, this, (String)object) : object) : object);
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    protected void validateValue(FacesContext facesContext, Object object) {
        if (this.isValid() && this.isRequired() && this.isEmpty(object)) {
            void var4_7;
            String string = this.getRequiredMessage();
            Object object2 = null;
            if (null != string) {
                FacesMessage facesMessage = new FacesMessage(string, string);
            } else {
                FacesMessage facesMessage = MessageFactory.getMessage(facesContext, REQUIRED_MESSAGE_ID, MessageFactory.getLabel(facesContext, this));
            }
            var4_7.setSeverity(FacesMessage.SEVERITY_ERROR);
            facesContext.addMessage(this.getClientId(facesContext), (FacesMessage)var4_7);
            this.setValid(false);
        }
        if (this.isValid() && !this.isEmpty(object) && this.validators != null) {
            for (Validator validator : this.validators) {
                try {
                    validator.validate(facesContext, this, object);
                }
                catch (ValidatorException validatorException) {
                    this.setValid(false);
                    FacesMessage facesMessage = null;
                    String string = this.getValidatorMessage();
                    facesMessage = null != string ? new FacesMessage(string, string) : validatorException.getFacesMessage();
                    if (facesMessage == null) continue;
                    facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
                    facesContext.addMessage(this.getClientId(facesContext), facesMessage);
                }
            }
        }
    }

    protected boolean compareValues(Object object, Object object2) {
        if (object == null) {
            return object2 != null;
        }
        if (object2 == null) {
            return true;
        }
        return !object.equals(object2);
    }

    private void executeValidate(FacesContext facesContext) {
        try {
            this.validate(facesContext);
        }
        catch (RuntimeException runtimeException) {
            facesContext.renderResponse();
            throw runtimeException;
        }
        if (!this.isValid()) {
            facesContext.renderResponse();
        }
    }

    private boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String && ((String)object).length() < 1) {
            return true;
        }
        return object.getClass().isArray() ? 0 == Array.getLength(object) : object instanceof List && 0 == ((List)object).size();
    }

    public void addValidator(Validator validator) {
        if (validator == null) {
            throw new NullPointerException();
        }
        if (this.validators == null) {
            this.validators = new ArrayList<Validator>();
        }
        this.validators.add(validator);
    }

    public Validator[] getValidators() {
        if (this.validators == null) {
            return new Validator[0];
        }
        return this.validators.toArray(new Validator[this.validators.size()]);
    }

    public void removeValidator(Validator validator) {
        if (this.validators != null) {
            this.validators.remove(validator);
        }
    }

    public void addValueChangeListener(ValueChangeListener valueChangeListener) {
        this.addFacesListener(valueChangeListener);
    }

    public ValueChangeListener[] getValueChangeListeners() {
        return (ValueChangeListener[])this.getFacesListeners(ValueChangeListener.class);
    }

    public void removeValueChangeListener(ValueChangeListener valueChangeListener) {
        this.removeFacesListener(valueChangeListener);
    }

    public Object saveState(FacesContext facesContext) {
        if (this.values == null) {
            this.values = new Object[14];
        }
        this.values[0] = super.saveState(facesContext);
        this.values[1] = this.localValueSet ? Boolean.TRUE : Boolean.FALSE;
        this.values[2] = this.required ? Boolean.TRUE : Boolean.FALSE;
        this.values[3] = this.requiredSet ? Boolean.TRUE : Boolean.FALSE;
        this.values[4] = this.requiredMessage;
        this.values[5] = this.requiredMessageSet ? Boolean.TRUE : Boolean.FALSE;
        this.values[6] = this.converterMessage;
        this.values[7] = this.converterMessageSet ? Boolean.TRUE : Boolean.FALSE;
        this.values[8] = this.validatorMessage;
        this.values[9] = this.validatorMessageSet ? Boolean.TRUE : Boolean.FALSE;
        this.values[10] = this.valid ? Boolean.TRUE : Boolean.FALSE;
        this.values[11] = this.immediate ? Boolean.TRUE : Boolean.FALSE;
        this.values[12] = this.immediateSet ? Boolean.TRUE : Boolean.FALSE;
        this.values[13] = UIInput.saveAttachedState(facesContext, this.validators);
        return this.values;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        this.values = (Object[])object;
        super.restoreState(facesContext, this.values[0]);
        this.localValueSet = (Boolean)this.values[1];
        this.required = (Boolean)this.values[2];
        this.requiredSet = (Boolean)this.values[3];
        this.requiredMessage = (String)this.values[4];
        this.requiredMessageSet = (Boolean)this.values[5];
        this.converterMessage = (String)this.values[6];
        this.converterMessageSet = (Boolean)this.values[7];
        this.validatorMessage = (String)this.values[8];
        this.validatorMessageSet = (Boolean)this.values[9];
        this.valid = (Boolean)this.values[10];
        this.immediate = (Boolean)this.values[11];
        this.immediateSet = (Boolean)this.values[12];
        List list = null;
        Iterator iterator = null;
        list = (List)UIInput.restoreAttachedState(facesContext, this.values[13]);
        if (null != list) {
            if (null != this.validators) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.validators.add((Validator)iterator.next());
                }
            } else {
                this.validators = list;
            }
        }
    }

    private Converter getConverterWithType(FacesContext facesContext) {
        Converter converter = this.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression valueExpression = this.getValueExpression("value");
        if (valueExpression == null) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = valueExpression.getType(facesContext.getELContext());
        }
        catch (ELException eLException) {
            throw new FacesException(eLException);
        }
        if (clazz == null || clazz == String.class || clazz == Object.class) {
            return null;
        }
        try {
            Application application = facesContext.getApplication();
            return application.createConverter(clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void addConversionErrorMessage(FacesContext facesContext, ConverterException converterException, Object object) {
        FacesMessage facesMessage = null;
        String string = this.getConverterMessage();
        if (null != string) {
            facesMessage = new FacesMessage(string, string);
        } else {
            facesMessage = converterException.getFacesMessage();
            if (facesMessage == null && (facesMessage = MessageFactory.getMessage(facesContext, CONVERSION_MESSAGE_ID, new Object[0])).getDetail() == null) {
                facesMessage.setDetail(converterException.getMessage());
            }
        }
        facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
        facesContext.addMessage(this.getClientId(facesContext), facesMessage);
    }
}

