/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import javax.faces.component.MethodBindingAdapterBase;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;

class MethodBindingValueChangeListener
extends MethodBindingAdapterBase
implements ValueChangeListener,
StateHolder {
    private MethodBinding methodBinding = null;
    private boolean tranzient = false;

    public MethodBindingValueChangeListener() {
    }

    public MethodBindingValueChangeListener(MethodBinding methodBinding) {
        this.methodBinding = methodBinding;
    }

    public MethodBinding getWrapped() {
        return this.methodBinding;
    }

    public void processValueChange(ValueChangeEvent valueChangeEvent) throws AbortProcessingException {
        if (valueChangeEvent == null) {
            throw new NullPointerException();
        }
        try {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            this.methodBinding.invoke(facesContext, new Object[]{valueChangeEvent});
        }
        catch (EvaluationException evaluationException) {
            Throwable throwable = this.getExpectedCause(AbortProcessingException.class, evaluationException);
            if (throwable instanceof AbortProcessingException) {
                throw (AbortProcessingException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new IllegalStateException(evaluationException.getMessage());
        }
    }

    public Object saveState(FacesContext facesContext) {
        Object[] objectArray = null;
        if (!this.tranzient) {
            if (this.methodBinding instanceof StateHolder) {
                Object[] objectArray2 = new Object[]{((StateHolder)((Object)this.methodBinding)).saveState(facesContext), this.methodBinding.getClass().getName()};
                objectArray = objectArray2;
            } else {
                objectArray = this.methodBinding;
            }
        }
        return objectArray;
    }

    public void restoreState(FacesContext facesContext, Object object) {
        if (null == object) {
            return;
        }
        if (!(object instanceof MethodBinding)) {
            Object[] objectArray = (Object[])object;
            Object object2 = objectArray[0];
            String string = objectArray[1].toString();
            MethodBinding methodBinding = null;
            Class clazz = null;
            if (null != string) {
                try {
                    clazz = MethodBindingValueChangeListener.loadClass(string, this);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalStateException(classNotFoundException.getMessage());
                }
                if (null != clazz) {
                    try {
                        methodBinding = (MethodBinding)clazz.newInstance();
                    }
                    catch (InstantiationException instantiationException) {
                        throw new IllegalStateException(instantiationException.getMessage());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new IllegalStateException(illegalAccessException.getMessage());
                    }
                }
                if (null != methodBinding && null != object2) {
                    ((StateHolder)((Object)methodBinding)).restoreState(facesContext, object2);
                }
                this.methodBinding = methodBinding;
            }
        } else {
            this.methodBinding = (MethodBinding)object;
        }
    }

    public boolean isTransient() {
        return this.tranzient;
    }

    public void setTransient(boolean bl) {
        this.tranzient = bl;
    }

    private static Class loadClass(String string, Object object) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = object.getClass().getClassLoader();
        }
        return Class.forName(string, false, classLoader);
    }
}

