/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;

public final class FactoryFinder {
    public static final String APPLICATION_FACTORY = "javax.faces.application.ApplicationFactory";
    public static final String FACES_CONTEXT_FACTORY = "javax.faces.context.FacesContextFactory";
    public static final String LIFECYCLE_FACTORY = "javax.faces.lifecycle.LifecycleFactory";
    public static final String RENDER_KIT_FACTORY = "javax.faces.render.RenderKitFactory";
    private static HashMap applicationMaps = new HashMap();
    private static String[] factoryNames = new String[]{"javax.faces.application.ApplicationFactory", "javax.faces.context.FacesContextFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.render.RenderKitFactory"};
    private static Map factoryClasses = null;
    private static final Logger LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");

    FactoryFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFactory(String string) throws FacesException {
        FactoryFinder.validateFactoryName(string);
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        HashMap hashMap = applicationMaps;
        synchronized (hashMap) {
            Map map = FactoryFinder.getApplicationMap();
            Object object = null;
            Object v = map.get(string);
            if (v != null && !(v instanceof List)) {
                return v;
            }
            object = FactoryFinder.getImplementationInstance(classLoader, string, (List)v);
            if (null == object) {
                ResourceBundle resourceBundle = LOGGER.getResourceBundle();
                String string2 = resourceBundle.getString("severe.no_factory");
                string2 = MessageFormat.format(string2, string);
                throw new IllegalStateException(string2);
            }
            map.put(string, object);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFactory(String string, String string2) {
        FactoryFinder.validateFactoryName(string);
        ArrayList arrayList = null;
        Map map = null;
        HashMap hashMap = applicationMaps;
        synchronized (hashMap) {
            map = FactoryFinder.getApplicationMap();
            Object v = map.get(string);
            arrayList = (ArrayList)v;
            if (null != v) {
                if (!(arrayList instanceof List)) {
                    return;
                }
            } else {
                arrayList = new ArrayList();
                map.put(string, arrayList);
            }
            ((List)arrayList).add(0, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseFactories() throws FacesException {
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        HashMap hashMap = applicationMaps;
        synchronized (hashMap) {
            HashMap hashMap2 = (HashMap)applicationMaps.get(classLoader);
            if (hashMap2 != null) {
                hashMap2.clear();
                applicationMaps.remove(classLoader);
            }
        }
    }

    private static ClassLoader getClassLoader() throws FacesException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            throw new FacesException("getContextClassLoader");
        }
        return classLoader;
    }

    private static Object getImplementationInstance(ClassLoader classLoader, String string, List list) throws FacesException {
        Object object = null;
        String string2 = null;
        int n = 0;
        boolean bl = false;
        if (null != list && (1 < (n = list.size()) || 1 == n)) {
            string2 = (String)list.remove(n - 1);
            object = FactoryFinder.getImplGivenPreviousImpl(classLoader, string, string2, null);
        }
        if (null != (string2 = FactoryFinder.getImplNameFromServices(classLoader, string))) {
            object = FactoryFinder.getImplGivenPreviousImpl(classLoader, string, string2, object);
        }
        if (null != list) {
            for (n = list.size() - 1; 0 <= n; --n) {
                string2 = (String)list.remove(n);
                object = FactoryFinder.getImplGivenPreviousImpl(classLoader, string, string2, object);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getImplNameFromServices(ClassLoader classLoader, String string) {
        String string2;
        block27: {
            string2 = null;
            BufferedReader bufferedReader = null;
            String string3 = "META-INF/services/" + string;
            Object var5_5 = null;
            InputStream inputStream = null;
            try {
                inputStream = classLoader.getResourceAsStream(string3);
                if (inputStream == null) break block27;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                }
                string2 = bufferedReader.readLine();
                bufferedReader.close();
                bufferedReader = null;
                inputStream = null;
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable) {}
                    bufferedReader = null;
                    inputStream = null;
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {}
                    inputStream = null;
                }
            }
        }
        return string2;
    }

    private static Object getImplGivenPreviousImpl(ClassLoader classLoader, String string, String string2, Object object) {
        Class<?> clazz = null;
        Class clazz2 = null;
        Class[] classArray = null;
        Object[] objectArray = new Object[1];
        Constructor<?> constructor = null;
        Object var9_9 = null;
        if (null != object && null != (clazz2 = FactoryFinder.getFactoryClass(classLoader, string))) {
            try {
                clazz = Class.forName(string2, false, classLoader);
                classArray = new Class[]{clazz2};
                constructor = clazz.getConstructor(classArray);
                objectArray[0] = object;
                var9_9 = constructor.newInstance(objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz2 = null;
            }
            catch (Exception exception) {
                throw new FacesException(string2, exception);
            }
        }
        if (null == object || null == clazz2) {
            try {
                clazz = Class.forName(string2, false, classLoader);
                var9_9 = clazz.newInstance();
            }
            catch (Exception exception) {
                throw new FacesException(string2, exception);
            }
        }
        return var9_9;
    }

    private static Class getFactoryClass(ClassLoader classLoader, String string) {
        if (null == factoryClasses) {
            factoryClasses = new HashMap(factoryNames.length);
            factoryClasses.put(APPLICATION_FACTORY, ApplicationFactory.class);
            factoryClasses.put(FACES_CONTEXT_FACTORY, FacesContextFactory.class);
            factoryClasses.put(LIFECYCLE_FACTORY, LifecycleFactory.class);
            factoryClasses.put(RENDER_KIT_FACTORY, RenderKitFactory.class);
        }
        return (Class)factoryClasses.get(string);
    }

    private static Map getApplicationMap() {
        ClassLoader classLoader = FactoryFinder.getClassLoader();
        HashMap hashMap = null;
        hashMap = (HashMap)applicationMaps.get(classLoader);
        if (hashMap == null) {
            hashMap = new HashMap();
            applicationMaps.put(classLoader, hashMap);
        }
        return hashMap;
    }

    private static void validateFactoryName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        for (int i = 0; i < factoryNames.length; ++i) {
            if (!string.equals(factoryNames[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException(string);
        }
    }
}

