/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListELResolver
extends ELResolver {
    private static Class<?> theUnmodifiableListClass = Collections.unmodifiableList(new ArrayList()).getClass();
    private boolean isReadOnly;

    public ListELResolver() {
        this.isReadOnly = false;
    }

    public ListELResolver(boolean bl) {
        this.isReadOnly = bl;
    }

    @Override
    public Class<?> getType(ELContext eLContext, Object object, Object object2) {
        if (eLContext == null) {
            throw new NullPointerException();
        }
        if (object != null && object instanceof List) {
            eLContext.setPropertyResolved(true);
            List list = (List)object;
            int n = this.toInteger(object2);
            if (n < 0 || n >= list.size()) {
                throw new PropertyNotFoundException();
            }
            return Object.class;
        }
        return null;
    }

    @Override
    public Object getValue(ELContext eLContext, Object object, Object object2) {
        if (eLContext == null) {
            throw new NullPointerException();
        }
        if (object != null && object instanceof List) {
            eLContext.setPropertyResolved(true);
            List list = (List)object;
            int n = this.toInteger(object2);
            if (n < 0 || n >= list.size()) {
                return null;
            }
            return list.get(n);
        }
        return null;
    }

    @Override
    public void setValue(ELContext eLContext, Object object, Object object2, Object object3) {
        if (eLContext == null) {
            throw new NullPointerException();
        }
        if (object != null && object instanceof List) {
            eLContext.setPropertyResolved(true);
            List list = (List)object;
            int n = this.toInteger(object2);
            if (this.isReadOnly) {
                throw new PropertyNotWritableException();
            }
            try {
                list.set(n, object3);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw new PropertyNotWritableException();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new PropertyNotFoundException();
            }
            catch (ClassCastException classCastException) {
                throw classCastException;
            }
            catch (NullPointerException nullPointerException) {
                throw nullPointerException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
        }
    }

    @Override
    public boolean isReadOnly(ELContext eLContext, Object object, Object object2) {
        if (eLContext == null) {
            throw new NullPointerException();
        }
        if (object != null && object instanceof List) {
            eLContext.setPropertyResolved(true);
            List list = (List)object;
            int n = this.toInteger(object2);
            if (n < 0 || n >= list.size()) {
                throw new PropertyNotFoundException();
            }
            return list.getClass() == theUnmodifiableListClass || this.isReadOnly;
        }
        return false;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext eLContext, Object object) {
        return null;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext eLContext, Object object) {
        if (object != null && object instanceof List) {
            return Integer.class;
        }
        return null;
    }

    private int toInteger(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        throw new IllegalArgumentException();
    }
}

