/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class ToCanonical {
    static Configuration config = Configuration.getDefaultConfiguration();

    public static void main(String[] stringArray) {
        config.setWhitespaceStripping(false);
        if (stringArray.length == 0) {
            ToCanonical.usage();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            if (!file.exists()) {
                System.err.println("File " + file + " doesn't exist.");
            }
            try {
                ToCanonical.convertFile(file);
                continue;
            }
            catch (Exception exception) {
                System.err.println("Error converting file: " + file);
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void convertFile(File file) throws IOException {
        File file2 = file.getAbsoluteFile();
        File file3 = file2.getParentFile();
        String string = file2.getName();
        File file4 = new File(file3, string + ".canonical");
        config.setDirectoryForTemplateLoading(file3);
        Template template = config.getTemplate(string);
        FileWriter fileWriter = new FileWriter(file4);
        try {
            template.dump(fileWriter);
        }
        finally {
            fileWriter.close();
        }
    }

    static void usage() {
        System.err.println("Usage: java freemarker.template.utility.ToCanonical <filename(s)>");
    }
}

