/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.core.Environment;
import freemarker.core.ParseException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class StringUtil {
    private static final char[] ESCAPES = StringUtil.createEscapes();

    public static String HTMLEnc(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '<' && c != '>' && c != '&' && c != '\"') continue;
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, i));
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                }
            }
            int n2 = ++i;
            while (i < n) {
                c = string.charAt(i);
                if (c == '<' || c == '>' || c == '&' || c == '\"') {
                    stringBuffer.append(string.substring(n2, i));
                    switch (c) {
                        case '<': {
                            stringBuffer.append("&lt;");
                            break;
                        }
                        case '>': {
                            stringBuffer.append("&gt;");
                            break;
                        }
                        case '&': {
                            stringBuffer.append("&amp;");
                            break;
                        }
                        case '\"': {
                            stringBuffer.append("&quot;");
                        }
                    }
                    n2 = i + 1;
                }
                ++i;
            }
            if (n2 < n) {
                stringBuffer.append(string.substring(n2));
            }
            string = stringBuffer.toString();
            break;
        }
        return string;
    }

    public static String XMLEnc(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '<' && c != '>' && c != '&' && c != '\"' && c != '\'') continue;
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, i));
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                }
            }
            int n2 = ++i;
            while (i < n) {
                c = string.charAt(i);
                if (c == '<' || c == '>' || c == '&' || c == '\"' || c == '\'') {
                    stringBuffer.append(string.substring(n2, i));
                    switch (c) {
                        case '<': {
                            stringBuffer.append("&lt;");
                            break;
                        }
                        case '>': {
                            stringBuffer.append("&gt;");
                            break;
                        }
                        case '&': {
                            stringBuffer.append("&amp;");
                            break;
                        }
                        case '\"': {
                            stringBuffer.append("&quot;");
                            break;
                        }
                        case '\'': {
                            stringBuffer.append("&apos;");
                        }
                    }
                    n2 = i + 1;
                }
                ++i;
            }
            if (n2 < n) {
                stringBuffer.append(string.substring(n2));
            }
            string = stringBuffer.toString();
            break;
        }
        return string;
    }

    public static String XMLEncNA(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '<' && c != '>' && c != '&' && c != '\"') continue;
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, i));
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                }
            }
            int n2 = ++i;
            while (i < n) {
                c = string.charAt(i);
                if (c == '<' || c == '>' || c == '&' || c == '\"') {
                    stringBuffer.append(string.substring(n2, i));
                    switch (c) {
                        case '<': {
                            stringBuffer.append("&lt;");
                            break;
                        }
                        case '>': {
                            stringBuffer.append("&gt;");
                            break;
                        }
                        case '&': {
                            stringBuffer.append("&amp;");
                            break;
                        }
                        case '\"': {
                            stringBuffer.append("&quot;");
                        }
                    }
                    n2 = i + 1;
                }
                ++i;
            }
            if (n2 < n) {
                stringBuffer.append(string.substring(n2));
            }
            string = stringBuffer.toString();
            break;
        }
        return string;
    }

    public static String XMLEncQAttr(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '<' && c != '&' && c != '\"') continue;
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, i));
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                }
            }
            int n2 = ++i;
            while (i < n) {
                c = string.charAt(i);
                if (c == '<' || c == '&' || c == '\"') {
                    stringBuffer.append(string.substring(n2, i));
                    switch (c) {
                        case '<': {
                            stringBuffer.append("&lt;");
                            break;
                        }
                        case '&': {
                            stringBuffer.append("&amp;");
                            break;
                        }
                        case '\"': {
                            stringBuffer.append("&quot;");
                        }
                    }
                    n2 = i + 1;
                }
                ++i;
            }
            if (n2 < n) {
                stringBuffer.append(string.substring(n2));
            }
            string = stringBuffer.toString();
            break;
        }
        return string;
    }

    public static String XMLEncNQG(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '<' && c != '&') continue;
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, i));
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                }
            }
            int n2 = ++i;
            while (i < n) {
                c = string.charAt(i);
                if (c == '<' || c == '&') {
                    stringBuffer.append(string.substring(n2, i));
                    switch (c) {
                        case '<': {
                            stringBuffer.append("&lt;");
                            break;
                        }
                        case '&': {
                            stringBuffer.append("&amp;");
                        }
                    }
                    n2 = i + 1;
                }
                ++i;
            }
            if (n2 < n) {
                stringBuffer.append(string.substring(n2));
            }
            string = stringBuffer.toString();
            break;
        }
        return string;
    }

    public static String RTFEnc(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '\\' && c != '{' && c != '}') continue;
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, i));
            switch (c) {
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '{': {
                    stringBuffer.append("\\{");
                    break;
                }
                case '}': {
                    stringBuffer.append("\\}");
                }
            }
            int n2 = ++i;
            while (i < n) {
                c = string.charAt(i);
                if (c == '\\' || c == '{' || c == '}') {
                    stringBuffer.append(string.substring(n2, i));
                    switch (c) {
                        case '\\': {
                            stringBuffer.append("\\\\");
                            break;
                        }
                        case '{': {
                            stringBuffer.append("\\{");
                            break;
                        }
                        case '}': {
                            stringBuffer.append("\\}");
                        }
                    }
                    n2 = i + 1;
                }
                ++i;
            }
            if (n2 < n) {
                stringBuffer.append(string.substring(n2));
            }
            string = stringBuffer.toString();
            break;
        }
        return string;
    }

    public static String URLEnc(String string, String string2) throws UnsupportedEncodingException {
        int n;
        int n2;
        int n3;
        char c;
        int n4;
        int n5 = string.length();
        for (n4 = 0; n4 < n5 && ((c = string.charAt(n4)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-' || c == '.' || c == '!' || c == '~' || c >= '\'' && c <= '*'); ++n4) {
        }
        if (n4 == n5) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n5 + n5 / 3 + 2);
        stringBuffer.append(string.substring(0, n4));
        int n6 = n4++;
        while (n4 < n5) {
            char c2 = string.charAt(n4);
            if (c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '_' || c2 == '-' || c2 == '.' || c2 == '!' || c2 == '~' || c2 >= '\'' && c2 <= '*') {
                if (n6 != -1) {
                    byte[] byArray = string.substring(n6, n4).getBytes(string2);
                    for (n3 = 0; n3 < byArray.length; ++n3) {
                        stringBuffer.append('%');
                        n2 = byArray[n3];
                        n = n2 & 0xF;
                        int n7 = n2 >> 4 & 0xF;
                        stringBuffer.append((char)(n7 < 10 ? n7 + 48 : n7 - 10 + 65));
                        stringBuffer.append((char)(n < 10 ? n + 48 : n - 10 + 65));
                    }
                    n6 = -1;
                }
                stringBuffer.append(c2);
            } else if (n6 == -1) {
                n6 = n4;
            }
            ++n4;
        }
        if (n6 != -1) {
            byte[] byArray = string.substring(n6, n4).getBytes(string2);
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append('%');
                n3 = byArray[i];
                n2 = n3 & 0xF;
                n = n3 >> 4 & 0xF;
                stringBuffer.append((char)(n < 10 ? n + 48 : n - 10 + 65));
                stringBuffer.append((char)(n2 < 10 ? n2 + 48 : n2 - 10 + 65));
            }
        }
        return stringBuffer.toString();
    }

    private static char[] createEscapes() {
        char[] cArray = new char[93];
        for (int i = 0; i < 32; ++i) {
            cArray[i] = '\u0001';
        }
        cArray[92] = 92;
        cArray[39] = 39;
        cArray[34] = 34;
        cArray[60] = 108;
        cArray[62] = 103;
        cArray[38] = 97;
        cArray[8] = 98;
        cArray[9] = 116;
        cArray[10] = 110;
        cArray[12] = 102;
        cArray[13] = 114;
        cArray[36] = 36;
        return cArray;
    }

    public static String FTLStringLiteralEnc(String string) {
        StringBuffer stringBuffer = null;
        int n = string.length();
        int n2 = ESCAPES.length;
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < n2) {
                char c2 = ESCAPES[c];
                switch (c2) {
                    case '\u0000': {
                        if (stringBuffer == null) continue block4;
                        stringBuffer.append(c);
                        break;
                    }
                    case '\u0001': {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer(string.length() + 3);
                            stringBuffer.append(string.substring(0, i));
                        }
                        stringBuffer.append("\\x00");
                        int n3 = c >> 4 & 0xF;
                        c = (char)(c & 0xF);
                        stringBuffer.append((char)(n3 < 10 ? n3 + 48 : n3 - 10 + 65));
                        stringBuffer.append((char)(c < '\n' ? c + 48 : c - 10 + 65));
                        break;
                    }
                    default: {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer(string.length() + 2);
                            stringBuffer.append(string.substring(0, i));
                        }
                        stringBuffer.append('\\');
                        stringBuffer.append(c2);
                        break;
                    }
                }
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    public static String FTLStringLiteralDec(String string) throws ParseException {
        int n = string.indexOf(92);
        if (n == -1) {
            return string;
        }
        int n2 = string.length() - 1;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(n2);
        do {
            stringBuffer.append(string.substring(n3, n));
            if (n >= n2) {
                throw new ParseException("The last character of string literal is backslash", 0, 0);
            }
            char c = string.charAt(n + 1);
            switch (c) {
                case '\"': {
                    stringBuffer.append('\"');
                    n3 = n + 2;
                    break;
                }
                case '\'': {
                    stringBuffer.append('\'');
                    n3 = n + 2;
                    break;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    n3 = n + 2;
                    break;
                }
                case 'n': {
                    stringBuffer.append('\n');
                    n3 = n + 2;
                    break;
                }
                case 'r': {
                    stringBuffer.append('\r');
                    n3 = n + 2;
                    break;
                }
                case 't': {
                    stringBuffer.append('\t');
                    n3 = n + 2;
                    break;
                }
                case 'f': {
                    stringBuffer.append('\f');
                    n3 = n + 2;
                    break;
                }
                case 'b': {
                    stringBuffer.append('\b');
                    n3 = n + 2;
                    break;
                }
                case 'g': {
                    stringBuffer.append('>');
                    n3 = n + 2;
                    break;
                }
                case 'l': {
                    stringBuffer.append('<');
                    n3 = n + 2;
                    break;
                }
                case 'a': {
                    stringBuffer.append('&');
                    n3 = n + 2;
                    break;
                }
                case '{': {
                    stringBuffer.append('{');
                    n3 = n + 2;
                    break;
                }
                case 'x': {
                    int n4;
                    int n5 = n += 2;
                    int n6 = 0;
                    int n7 = n4 = n2 > n + 3 ? n + 3 : n2;
                    while (n <= n4) {
                        char c2 = string.charAt(n);
                        if (c2 >= '0' && c2 <= '9') {
                            n6 <<= 4;
                            n6 += c2 - 48;
                        } else if (c2 >= 'a' && c2 <= 'f') {
                            n6 <<= 4;
                            n6 += c2 - 97 + 10;
                        } else {
                            if (c2 < 'A' || c2 > 'F') break;
                            n6 <<= 4;
                            n6 += c2 - 65 + 10;
                        }
                        ++n;
                    }
                    if (n5 >= n) {
                        throw new ParseException("Invalid \\x escape in a string literal", 0, 0);
                    }
                    stringBuffer.append((char)n6);
                    n3 = n;
                    break;
                }
                default: {
                    throw new ParseException("Invalid escape sequence (\\" + c + ") in a string literal", 0, 0);
                }
            }
        } while ((n = string.indexOf(92, n3)) != -1);
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    public static Locale deduceLocale(String string) {
        Locale locale = Locale.getDefault();
        if (string.charAt(0) == '\"') {
            string = string.substring(1, string.length() - 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",_ ");
        String string2 = "";
        String string3 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        locale = !stringTokenizer.hasMoreTokens() ? new Locale(string2, string3) : new Locale(string2, string3, stringTokenizer.nextToken());
        return locale;
    }

    public static String capitalize(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n", true);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2.substring(0, 1).toUpperCase());
            stringBuffer.append(string2.substring(1).toLowerCase());
        }
        return stringBuffer.toString();
    }

    public static boolean getYesNo(String string) {
        if (string.startsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (string.equalsIgnoreCase("n") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("f") || string.equalsIgnoreCase("false")) {
            return false;
        }
        if (string.equalsIgnoreCase("y") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("t") || string.equalsIgnoreCase("true")) {
            return true;
        }
        throw new IllegalArgumentException("Illegal boolean value: " + string);
    }

    public static String[] split(String string, char c) {
        int n = string.length();
        int n2 = 0;
        int n3 = 1;
        while ((n2 = string.indexOf(c, n2)) != -1) {
            ++n3;
            ++n2;
        }
        String[] stringArray = new String[n3];
        n2 = 0;
        int n4 = 0;
        while (n4 <= n) {
            int n5 = string.indexOf(c, n4);
            if (n5 == -1) {
                n5 = n;
            }
            stringArray[n2++] = string.substring(n4, n5);
            n4 = n5 + 1;
        }
        return stringArray;
    }

    public static String[] split(String string, String string2, boolean bl) {
        String string3 = bl ? string2.toLowerCase() : string2;
        String string4 = bl ? string.toLowerCase() : string;
        int n = string.length();
        int n2 = string2.length();
        if (n2 == 0) {
            throw new IllegalArgumentException("The separator string has 0 length");
        }
        int n3 = 0;
        int n4 = 1;
        while ((n3 = string4.indexOf(string3, n3)) != -1) {
            ++n4;
            n3 += n2;
        }
        String[] stringArray = new String[n4];
        n3 = 0;
        int n5 = 0;
        while (n5 <= n) {
            int n6 = string4.indexOf(string3, n5);
            if (n6 == -1) {
                n6 = n;
            }
            stringArray[n3++] = string.substring(n5, n6);
            n5 = n6 + n2;
        }
        return stringArray;
    }

    public static String replace(String string, String string2, String string3, boolean bl, boolean bl2) {
        int n = string2.length();
        if (n == 0) {
            int n2 = string3.length();
            if (n2 == 0) {
                return string;
            }
            if (bl2) {
                return string3 + string;
            }
            int n3 = string.length();
            StringBuffer stringBuffer = new StringBuffer(n3 + (n3 + 1) * n2);
            stringBuffer.append(string3);
            for (int i = 0; i < n3; ++i) {
                stringBuffer.append(string.charAt(i));
                stringBuffer.append(string3);
            }
            return stringBuffer.toString();
        }
        String string4 = bl ? string.toLowerCase() : string;
        int n4 = string4.indexOf(string2 = bl ? string2.toLowerCase() : string2);
        if (n4 == -1) {
            return string;
        }
        int n5 = 0;
        int n6 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n6 + Math.max(string3.length() - n, 0) * 3);
        do {
            stringBuffer.append(string.substring(n5, n4));
            stringBuffer.append(string3);
        } while ((n4 = string4.indexOf(string2, n5 = n4 + n)) != -1 && !bl2);
        stringBuffer.append(string.substring(n5));
        return stringBuffer.toString();
    }

    public static String chomp(String string) {
        if (string.endsWith("\r\n")) {
            return string.substring(0, string.length() - 2);
        }
        if (string.endsWith("\r") || string.endsWith("\n")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String jQuote(String string) {
        if (string == null) {
            return "null";
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 4);
        stringBuffer.append('\"');
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append("\\\"");
                continue;
            }
            if (c == '\\') {
                stringBuffer.append("\\\\");
                continue;
            }
            if (c < ' ') {
                if (c == '\n') {
                    stringBuffer.append("\\n");
                    continue;
                }
                if (c == '\r') {
                    stringBuffer.append("\\r");
                    continue;
                }
                if (c == '\f') {
                    stringBuffer.append("\\f");
                    continue;
                }
                if (c == '\b') {
                    stringBuffer.append("\\b");
                    continue;
                }
                if (c == '\t') {
                    stringBuffer.append("\\t");
                    continue;
                }
                stringBuffer.append("\\u00");
                int n2 = c / 16;
                stringBuffer.append((char)(n2 < 10 ? n2 + 48 : n2 - 10 + 65));
                n2 = c & 0xF;
                stringBuffer.append((char)(n2 < 10 ? n2 + 48 : n2 - 10 + 65));
                continue;
            }
            stringBuffer.append(c);
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public static String javaStringEnc(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '\"' && c != '\\' && c >= ' ') continue;
            StringBuffer stringBuffer = new StringBuffer(n + 4);
            stringBuffer.append(string.substring(0, i));
            while (true) {
                if (c == '\"') {
                    stringBuffer.append("\\\"");
                } else if (c == '\\') {
                    stringBuffer.append("\\\\");
                } else if (c < ' ') {
                    if (c == '\n') {
                        stringBuffer.append("\\n");
                    } else if (c == '\r') {
                        stringBuffer.append("\\r");
                    } else if (c == '\f') {
                        stringBuffer.append("\\f");
                    } else if (c == '\b') {
                        stringBuffer.append("\\b");
                    } else if (c == '\t') {
                        stringBuffer.append("\\t");
                    } else {
                        stringBuffer.append("\\u00");
                        int n2 = c / 16;
                        stringBuffer.append((char)(n2 < 10 ? n2 + 48 : n2 - 10 + 97));
                        n2 = c & 0xF;
                        stringBuffer.append((char)(n2 < 10 ? n2 + 48 : n2 - 10 + 97));
                    }
                } else {
                    stringBuffer.append(c);
                }
                if (++i >= n) {
                    return stringBuffer.toString();
                }
                c = string.charAt(i);
            }
        }
        return string;
    }

    public static String javaScriptStringEnc(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '\"' && c != '\'' && c != '\\' && c != '>' && c >= ' ') continue;
            StringBuffer stringBuffer = new StringBuffer(n + 4);
            stringBuffer.append(string.substring(0, i));
            while (true) {
                if (c == '\"') {
                    stringBuffer.append("\\\"");
                } else if (c == '\'') {
                    stringBuffer.append("\\'");
                } else if (c == '\\') {
                    stringBuffer.append("\\\\");
                } else if (c == '>') {
                    stringBuffer.append("\\>");
                } else if (c < ' ') {
                    if (c == '\n') {
                        stringBuffer.append("\\n");
                    } else if (c == '\r') {
                        stringBuffer.append("\\r");
                    } else if (c == '\f') {
                        stringBuffer.append("\\f");
                    } else if (c == '\b') {
                        stringBuffer.append("\\b");
                    } else if (c == '\t') {
                        stringBuffer.append("\\t");
                    } else {
                        stringBuffer.append("\\x");
                        int n2 = c / 16;
                        stringBuffer.append((char)(n2 < 10 ? n2 + 48 : n2 - 10 + 65));
                        n2 = c & 0xF;
                        stringBuffer.append((char)(n2 < 10 ? n2 + 48 : n2 - 10 + 65));
                    }
                } else {
                    stringBuffer.append(c);
                }
                if (++i >= n) {
                    return stringBuffer.toString();
                }
                c = string.charAt(i);
            }
        }
        return string;
    }

    public static Map parseNameValuePairList(String string, String string2) throws java.text.ParseException {
        HashMap<String, String> hashMap;
        block18: {
            String string3;
            int n;
            hashMap = new HashMap<String, String>();
            char c = ' ';
            int n2 = string.length();
            int n3 = 0;
            while (true) {
                String string4;
                if (n3 < n2 && Character.isWhitespace(c = (char)string.charAt(n3))) {
                    ++n3;
                    continue;
                }
                if (n3 == n2) break block18;
                n = n3;
                while (n3 < n2 && (Character.isLetterOrDigit(c = string.charAt(n3)) || c == '_')) {
                    ++n3;
                }
                if (n == n3) {
                    throw new java.text.ParseException("Expecting letter, digit or \"_\" here, (the first character of the key) but found " + StringUtil.jQuote(String.valueOf(c)) + " at position " + n3 + ".", n3);
                }
                string3 = string.substring(n, n3);
                while (n3 < n2 && Character.isWhitespace(c = string.charAt(n3))) {
                    ++n3;
                }
                if (n3 == n2) {
                    if (string2 == null) {
                        throw new java.text.ParseException("Expecting \":\", but reached the end of the string  at position " + n3 + ".", n3);
                    }
                    string4 = string2;
                } else if (c != ':') {
                    if (string2 == null || c != ',') {
                        throw new java.text.ParseException("Expecting \":\" here, but found " + StringUtil.jQuote(String.valueOf(c)) + " at position " + n3 + ".", n3);
                    }
                    ++n3;
                    string4 = string2;
                } else {
                    ++n3;
                    while (n3 < n2 && Character.isWhitespace(c = string.charAt(n3))) {
                        ++n3;
                    }
                    if (n3 == n2) {
                        throw new java.text.ParseException("Expecting the value of the key here, but reached the end of the string  at position " + n3 + ".", n3);
                    }
                    int n4 = n3;
                    while (n3 < n2 && (Character.isLetterOrDigit(c = string.charAt(n3)) || c == '_')) {
                        ++n3;
                    }
                    if (n4 == n3) {
                        throw new java.text.ParseException("Expecting letter, digit or \"_\" here, (the first character of the value) but found " + StringUtil.jQuote(String.valueOf(c)) + " at position " + n3 + ".", n3);
                    }
                    string4 = string.substring(n4, n3);
                    while (n3 < n2 && Character.isWhitespace(c = string.charAt(n3))) {
                        ++n3;
                    }
                    if (n3 < n2) {
                        if (c != ',') {
                            throw new java.text.ParseException("Excpecting \",\" or the end of the string here, but found " + StringUtil.jQuote(String.valueOf(c)) + " at position " + n3 + ".", n3);
                        }
                        ++n3;
                    }
                }
                if (hashMap.put(string3, string4) != null) break;
            }
            throw new java.text.ParseException("Dublicated key: " + StringUtil.jQuote(string3), n);
        }
        return hashMap;
    }

    public static boolean isXMLID(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i == 0 && (c == '-' || c == '.' || Character.isDigit(c))) {
                return false;
            }
            if (Character.isLetterOrDigit(c) || c == ':' || c == '_' || c == '-' || c == '.') continue;
            return false;
        }
        return true;
    }

    public static boolean matchesName(String string, String string2, String string3, Environment environment) {
        String string4 = environment.getDefaultNS();
        if (string4 != null && string4.equals(string3)) {
            return string.equals(string2) || string.equals("D:" + string2);
        }
        if ("".equals(string3)) {
            if (string4 != null) {
                return string.equals("N:" + string2);
            }
            return string.equals(string2) || string.equals("N:" + string2);
        }
        String string5 = environment.getPrefixForNamespace(string3);
        if (string5 == null) {
            return false;
        }
        return string.equals(string5 + ":" + string2);
    }

    public static String leftPad(String string, int n) {
        return StringUtil.leftPad(string, n, ' ');
    }

    public static String leftPad(String string, int n, char c) {
        int n2 = string.length();
        if (n <= n2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n3 = n - n2;
        for (int i = 0; i < n3; ++i) {
            stringBuffer.append(c);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String leftPad(String string, int n, String string2) {
        int n2;
        int n3 = string.length();
        if (n <= n3) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        int n4 = n - n3;
        int n5 = string2.length();
        if (n5 == 0) {
            throw new IllegalArgumentException("The \"filling\" argument can't be 0 length string.");
        }
        int n6 = n4 / n5;
        for (n2 = 0; n2 < n6; ++n2) {
            stringBuffer.append(string2);
        }
        n6 = n4 % n5;
        for (n2 = 0; n2 < n6; ++n2) {
            stringBuffer.append(string2.charAt(n2));
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String rightPad(String string, int n) {
        return StringUtil.rightPad(string, n, ' ');
    }

    public static String rightPad(String string, int n, char c) {
        int n2 = string.length();
        if (n <= n2) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string);
        int n3 = n - n2;
        for (int i = 0; i < n3; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String rightPad(String string, int n, String string2) {
        int n2;
        int n3;
        int n4 = string.length();
        if (n <= n4) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string);
        int n5 = n - n4;
        int n6 = string2.length();
        if (n6 == 0) {
            throw new IllegalArgumentException("The \"filling\" argument can't be 0 length string.");
        }
        int n7 = n4 % n6;
        int n8 = n6 - n7 <= n5 ? n6 : n7 + n5;
        for (n3 = n7; n3 < n8; ++n3) {
            stringBuffer.append(string2.charAt(n3));
        }
        n3 = (n5 -= n8 - n7) / n6;
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append(string2);
        }
        n3 = n5 % n6;
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append(string2.charAt(n2));
        }
        return stringBuffer.toString();
    }
}

