/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.log.Logger;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class SecurityUtilities {
    private static final Logger logger = Logger.getLogger("freemarker.security");

    private SecurityUtilities() {
    }

    public static String getSystemProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    public static String getSystemProperty(final String string, final String string2) {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(string, string2);
                }
            });
        }
        catch (AccessControlException accessControlException) {
            logger.warn("Insufficient permissions to read system property '" + string + "', using default value '" + string2 + "'");
            return string2;
        }
    }

    public static Integer getSystemProperty(final String string, final int n) {
        try {
            return (Integer)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Integer.getInteger(string, n);
                }
            });
        }
        catch (AccessControlException accessControlException) {
            logger.warn("Insufficient permissions to read system property '" + string + "', using default value " + n + "");
            return new Integer(n);
        }
    }
}

