/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.template.utility.Collections12;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OptimizerUtil {
    private static final BigInteger INTEGER_MIN = new BigInteger(Integer.toString(Integer.MIN_VALUE));
    private static final BigInteger INTEGER_MAX = new BigInteger(Integer.toString(Integer.MAX_VALUE));
    private static final BigInteger LONG_MIN = new BigInteger(Long.toString(Long.MIN_VALUE));
    private static final BigInteger LONG_MAX = new BigInteger(Long.toString(Long.MAX_VALUE));

    private OptimizerUtil() {
    }

    public static List optimizeListStorage(List list) {
        switch (list.size()) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                return Collections12.singletonList(list.get(0));
            }
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return list;
    }

    public static Number optimizeNumberRepresentation(Number number) {
        Number number2;
        if (number instanceof BigDecimal) {
            number2 = (BigDecimal)number;
            if (((BigDecimal)number2).scale() == 0) {
                number = ((BigDecimal)number2).unscaledValue();
            } else {
                double d = ((BigDecimal)number2).doubleValue();
                if (d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY) {
                    return new Double(d);
                }
            }
        }
        if (number instanceof BigInteger) {
            number2 = (BigInteger)number;
            if (((BigInteger)number2).compareTo(INTEGER_MAX) <= 0 && ((BigInteger)number2).compareTo(INTEGER_MIN) >= 0) {
                return new Integer(((BigInteger)number2).intValue());
            }
            if (((BigInteger)number2).compareTo(LONG_MAX) <= 0 && ((BigInteger)number2).compareTo(LONG_MIN) >= 0) {
                return new Long(((BigInteger)number2).longValue());
            }
        }
        return number;
    }
}

