/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class HtmlEscape
implements TemplateTransformModel {
    private static final char[] LT = "&lt;".toCharArray();
    private static final char[] GT = "&gt;".toCharArray();
    private static final char[] AMP = "&amp;".toCharArray();
    private static final char[] QUOT = "&quot;".toCharArray();

    public Writer getWriter(final Writer writer, Map map) {
        return new Writer(){

            public void write(char c) throws IOException {
                switch (c) {
                    case '<': {
                        writer.write(LT, 0, 4);
                        break;
                    }
                    case '>': {
                        writer.write(GT, 0, 4);
                        break;
                    }
                    case '&': {
                        writer.write(AMP, 0, 5);
                        break;
                    }
                    case '\"': {
                        writer.write(QUOT, 0, 6);
                        break;
                    }
                    default: {
                        writer.write(c);
                    }
                }
            }

            public void write(char[] cArray, int n, int n2) throws IOException {
                int n3;
                int n4 = n;
                int n5 = n + n2;
                block6: for (n3 = n; n3 < n5; ++n3) {
                    switch (cArray[n3]) {
                        case '<': {
                            writer.write(cArray, n4, n3 - n4);
                            writer.write(LT, 0, 4);
                            n4 = n3 + 1;
                            continue block6;
                        }
                        case '>': {
                            writer.write(cArray, n4, n3 - n4);
                            writer.write(GT, 0, 4);
                            n4 = n3 + 1;
                            continue block6;
                        }
                        case '&': {
                            writer.write(cArray, n4, n3 - n4);
                            writer.write(AMP, 0, 5);
                            n4 = n3 + 1;
                            continue block6;
                        }
                        case '\"': {
                            writer.write(cArray, n4, n3 - n4);
                            writer.write(QUOT, 0, 6);
                            n4 = n3 + 1;
                        }
                    }
                }
                n3 = n5 - n4;
                if (n3 > 0) {
                    writer.write(cArray, n4, n3);
                }
            }

            public void flush() throws IOException {
                writer.flush();
            }

            public void close() {
            }
        };
    }
}

