/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.ext.util.WrapperTemplateModel;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.util.ArrayList;
import java.util.HashMap;

public class DeepUnwrap {
    private static final Class OBJECT_CLASS = class$java$lang$Object == null ? (class$java$lang$Object = DeepUnwrap.class$("java.lang.Object")) : class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Object;

    public static Object unwrap(TemplateModel templateModel) throws TemplateModelException {
        return DeepUnwrap.unwrap(templateModel, false);
    }

    public static Object premissiveUnwrap(TemplateModel templateModel) throws TemplateModelException {
        return DeepUnwrap.unwrap(templateModel, true);
    }

    private static Object unwrap(TemplateModel templateModel, boolean bl) throws TemplateModelException {
        if (templateModel instanceof AdapterTemplateModel) {
            return ((AdapterTemplateModel)templateModel).getAdaptedObject(OBJECT_CLASS);
        }
        if (templateModel instanceof WrapperTemplateModel) {
            return ((WrapperTemplateModel)templateModel).getWrappedObject();
        }
        if (templateModel instanceof TemplateScalarModel) {
            return ((TemplateScalarModel)templateModel).getAsString();
        }
        if (templateModel instanceof TemplateNumberModel) {
            return ((TemplateNumberModel)templateModel).getAsNumber();
        }
        if (templateModel instanceof TemplateDateModel) {
            return ((TemplateDateModel)templateModel).getAsDate();
        }
        if (templateModel instanceof TemplateBooleanModel) {
            return ((TemplateBooleanModel)templateModel).getAsBoolean() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (templateModel instanceof TemplateSequenceModel) {
            TemplateSequenceModel templateSequenceModel = (TemplateSequenceModel)templateModel;
            ArrayList<Object> arrayList = new ArrayList<Object>(templateSequenceModel.size());
            for (int i = 0; i < templateSequenceModel.size(); ++i) {
                arrayList.add(DeepUnwrap.unwrap(templateSequenceModel.get(i)));
            }
            return arrayList;
        }
        if (templateModel instanceof TemplateCollectionModel) {
            TemplateCollectionModel templateCollectionModel = (TemplateCollectionModel)templateModel;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            TemplateModelIterator templateModelIterator = templateCollectionModel.iterator();
            while (templateModelIterator.hasNext()) {
                arrayList.add(DeepUnwrap.unwrap(templateModelIterator.next()));
            }
            return arrayList;
        }
        if (templateModel instanceof TemplateHashModelEx) {
            TemplateHashModelEx templateHashModelEx = (TemplateHashModelEx)templateModel;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            TemplateModelIterator templateModelIterator = templateHashModelEx.keys().iterator();
            while (templateModelIterator.hasNext()) {
                String string = (String)DeepUnwrap.unwrap(templateModelIterator.next());
                hashMap.put(string, DeepUnwrap.unwrap(templateHashModelEx.get(string)));
            }
            return hashMap;
        }
        if (bl) {
            return templateModel;
        }
        throw new TemplateModelException("Cannot deep-unwrap model of type " + templateModel.getClass().getName());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

