/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.template.SimpleHash;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateSequenceModel;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMNodeModel
implements TemplateHashModel {
    private static HashMap equivalenceTable = new HashMap();
    private Node node;
    private HashMap cache = new HashMap();

    public DOMNodeModel(Node node) {
        this.node = node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TemplateModel get(String string) throws TemplateModelException {
        TemplateModel templateModel = null;
        if (equivalenceTable.containsKey(string)) {
            string = (String)equivalenceTable.get(string);
        }
        if (this.cache.containsKey(string)) {
            templateModel = (TemplateModel)this.cache.get(string);
        }
        if (templateModel != null) return templateModel;
        if ("attributes".equals(string)) {
            NamedNodeMap namedNodeMap = this.node.getAttributes();
            if (namedNodeMap != null) {
                SimpleHash simpleHash = new SimpleHash();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    simpleHash.put(attr.getName(), attr.getValue());
                }
                templateModel = simpleHash;
            }
        } else if (string.charAt(0) == '@') {
            if (!(this.node instanceof Element)) throw new TemplateModelException("Trying to get an attribute value for a non-element node");
            String string2 = ((Element)this.node).getAttribute(string.substring(1));
            templateModel = new SimpleScalar(string2);
        } else if ("is_element".equals(string)) {
            templateModel = this.node instanceof Element ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        } else if ("is_text".equals(string)) {
            templateModel = this.node instanceof Text ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        } else if ("name".equals(string)) {
            templateModel = new SimpleScalar(this.node.getNodeName());
        } else if ("children".equals(string)) {
            templateModel = new NodeListTM(this.node.getChildNodes());
        } else if ("parent".equals(string)) {
            Node node = this.node.getParentNode();
            templateModel = node == null ? null : new DOMNodeModel(node);
        } else if ("ancestorByName".equals(string)) {
            templateModel = new AncestorByName();
        } else if ("nextSibling".equals(string)) {
            Node node = this.node.getNextSibling();
            templateModel = node == null ? null : new DOMNodeModel(node);
        } else if ("previousSibling".equals(string)) {
            Node node = this.node.getPreviousSibling();
            templateModel = node == null ? null : new DOMNodeModel(node);
        } else if ("nextSiblingElement".equals(string)) {
            Element element = DOMNodeModel.nextSiblingElement(this.node);
            templateModel = element == null ? null : new DOMNodeModel(element);
        } else if ("previousSiblingElement".equals(string)) {
            Element element = DOMNodeModel.previousSiblingElement(this.node);
            templateModel = element == null ? null : new DOMNodeModel(element);
        } else if ("nextElement".equals(string)) {
            Element element = DOMNodeModel.nextElement(this.node);
            templateModel = element == null ? null : new DOMNodeModel(element);
        } else if ("previousElement".equals(string)) {
            Element element = DOMNodeModel.previousElement(this.node);
            templateModel = element == null ? null : new DOMNodeModel(element);
        } else if ("text".equals(string)) {
            templateModel = new SimpleScalar(DOMNodeModel.getText(this.node));
        }
        this.cache.put(string, templateModel);
        return templateModel;
    }

    public boolean isEmpty() {
        return false;
    }

    private static String getText(Node node) {
        String string = "";
        if (node instanceof Text) {
            string = ((Text)node).getData();
        } else if (node instanceof Element) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                string = string + DOMNodeModel.getText(nodeList.item(i));
            }
        }
        return string;
    }

    private static Element nextSiblingElement(Node node) {
        Node node2 = node;
        while (node2 != null) {
            if (!((node2 = node2.getNextSibling()) instanceof Element)) continue;
            return (Element)node2;
        }
        return null;
    }

    private static Element previousSiblingElement(Node node) {
        Node node2 = node;
        while (node2 != null) {
            if (!((node2 = node2.getPreviousSibling()) instanceof Element)) continue;
            return (Element)node2;
        }
        return null;
    }

    private static Element nextElement(Node node) {
        Node node2;
        Object object;
        if (node.hasChildNodes()) {
            object = node.getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                node2 = object.item(i);
                if (!(node2 instanceof Element)) continue;
                return (Element)node2;
            }
        }
        if ((object = DOMNodeModel.nextSiblingElement(node)) != null) {
            return object;
        }
        Node node3 = node.getParentNode();
        while (node3 instanceof Element) {
            node2 = DOMNodeModel.nextSiblingElement(node3);
            if (node2 != null) {
                return node2;
            }
            node3 = node3.getParentNode();
        }
        return null;
    }

    private static Element previousElement(Node node) {
        Element element = DOMNodeModel.previousSiblingElement(node);
        if (element != null) {
            return element;
        }
        Node node2 = node.getParentNode();
        if (node2 instanceof Element) {
            return (Element)node2;
        }
        return null;
    }

    void setParent(DOMNodeModel dOMNodeModel) {
        if (dOMNodeModel != null) {
            this.cache.put("parent", dOMNodeModel);
        }
    }

    String getNodeName() {
        return this.node.getNodeName();
    }

    static {
        equivalenceTable.put("*", "children");
        equivalenceTable.put("@*", "attributes");
    }

    class AncestorByName
    implements TemplateMethodModel {
        AncestorByName() {
        }

        public Object exec(List list) throws TemplateModelException {
            if (list.size() != 1) {
                throw new TemplateModelException("Expecting exactly one string argument here");
            }
            String string = (String)list.get(0);
            for (DOMNodeModel dOMNodeModel = (DOMNodeModel)DOMNodeModel.this.get("parent"); dOMNodeModel != null; dOMNodeModel = (DOMNodeModel)dOMNodeModel.get("parent")) {
                if (!string.equals(dOMNodeModel.getNodeName())) continue;
                return dOMNodeModel;
            }
            return null;
        }
    }

    class NodeListTM
    implements TemplateSequenceModel,
    TemplateMethodModel {
        private NodeList nodeList;
        private TemplateModel[] nodes;

        NodeListTM(NodeList nodeList) {
            this.nodeList = nodeList;
            this.nodes = new TemplateModel[nodeList.getLength()];
        }

        public TemplateModel get(int n) {
            DOMNodeModel dOMNodeModel = (DOMNodeModel)this.nodes[n];
            if (dOMNodeModel == null) {
                dOMNodeModel = new DOMNodeModel(this.nodeList.item(n));
                this.nodes[n] = dOMNodeModel;
                dOMNodeModel.setParent(DOMNodeModel.this);
            }
            return dOMNodeModel;
        }

        public int size() {
            return this.nodes.length;
        }

        public Object exec(List list) throws TemplateModelException {
            if (list.size() != 1) {
                throw new TemplateModelException("Expecting exactly one string argument here");
            }
            if (!(DOMNodeModel.this.node instanceof Element)) {
                throw new TemplateModelException("Expecting element here.");
            }
            Element element = (Element)DOMNodeModel.this.node;
            return new NodeListTM(element.getElementsByTagName((String)list.get(0)));
        }
    }
}

